/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.interpreter;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.errors.DynamicErrorException;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class XDMSequenceWriterStream
implements IAppendableStream {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Cursor fSequenceBuffer = null;
    protected CursorFactory fSimpleCursorFactory = null;

    @Override
    public void append(Object o, Type bindingType) {
        assert (bindingType != null);
        if (o == null) {
            return;
        }
        if (o instanceof Cursor) {
            Cursor c = (Cursor)o;
            boolean onlyOne = bindingType instanceof XDMItemType;
            this.append(c, onlyOne);
        } else if (o instanceof Cursor[]) {
            Cursor[] c_ary = (Cursor[])o;
            int length2 = c_ary.length;
            if (length2 > 0) {
                int index2 = 0;
                if (this.fSequenceBuffer == null) {
                    this.fSequenceBuffer = c_ary[index2++];
                }
                while (index2 < length2) {
                    Cursor c = c_ary[index2++];
                    Cursor.Profile newLimit = this.fSequenceBuffer.futureProfile().intersect(c.futureProfile());
                    this.fSequenceBuffer = this.fSequenceBuffer.sequenceConcat(c, Cursor.Profile.RANDOM_ACCESS, newLimit, false, false, true, false);
                }
            }
        } else {
            throw new DynamicErrorException("Unimplemented: " + this.getClass().getSimpleName() + " attempting to append " + o.getClass().getName());
        }
    }

    protected CursorFactory getFactory() {
        if (null == this.fSimpleCursorFactory) {
            this.fSimpleCursorFactory = SessionContext.getStaticSimpleDataFactory();
        }
        return this.fSimpleCursorFactory;
    }

    public void append(Cursor c, boolean onlyOne) {
        if (this.fSequenceBuffer == null) {
            if (onlyOne) {
                this.fSequenceBuffer = c.fork(true);
                this.fSequenceBuffer.toSelf();
            } else {
                this.fSequenceBuffer = c.fork(false);
            }
        } else {
            Cursor.Profile newLimit = this.fSequenceBuffer.futureProfile().intersect(c.futureProfile());
            this.fSequenceBuffer = this.fSequenceBuffer.sequenceConcat(c, Cursor.Profile.SEQUENCE, newLimit, false, onlyOne, true, false);
        }
    }

    public void append(VolatileCData val, boolean onlyOne) {
        this.fSequenceBuffer = this.fSequenceBuffer == null ? val.toCursor() : this.fSequenceBuffer.sequenceConcat(val, Cursor.Profile.SEQUENCE, this.fSequenceBuffer.futureProfile(), false, onlyOne, true);
    }

    public void append(boolean val, XSSimpleTypeDefinition type2) {
        this.fSequenceBuffer = this.fSequenceBuffer == null ? this.getFactory().sequence(val, type2, false) : this.fSequenceBuffer.sequenceConcat(val, type2, Cursor.Profile.SEQUENCE, this.fSequenceBuffer.futureProfile(), false, true);
    }

    public void append(int val, XSSimpleTypeDefinition type2) {
        this.fSequenceBuffer = this.fSequenceBuffer == null ? this.getFactory().sequence(val, type2, false) : this.fSequenceBuffer.sequenceConcat(val, type2, Cursor.Profile.SEQUENCE, this.fSequenceBuffer.futureProfile(), false, true);
    }

    public void append(CharSequence val, XSSimpleTypeDefinition type2) {
        this.fSequenceBuffer = this.fSequenceBuffer == null ? this.getFactory().sequence(val, type2, false) : this.fSequenceBuffer.sequenceConcat(val, type2, Cursor.Profile.SEQUENCE, this.fSequenceBuffer.futureProfile(), false, true);
    }

    public void append(char[] val, XSSimpleTypeDefinition type2) {
        this.fSequenceBuffer = this.fSequenceBuffer == null ? this.getFactory().sequence(val, type2, false) : this.fSequenceBuffer.sequenceConcat(val, type2, Cursor.Profile.SEQUENCE, this.fSequenceBuffer.futureProfile(), false, true);
    }

    public void append(QName val, XSSimpleTypeDefinition type2) {
        this.fSequenceBuffer = this.fSequenceBuffer == null ? this.getFactory().sequence(val, type2, false) : this.fSequenceBuffer.sequenceConcat(val, type2, Cursor.Profile.SEQUENCE, this.fSequenceBuffer.futureProfile(), false, true);
    }

    public void append(double val, XSSimpleTypeDefinition type2) {
        this.fSequenceBuffer = this.fSequenceBuffer == null ? this.getFactory().sequence(val, type2, false) : this.fSequenceBuffer.sequenceConcat(val, type2, Cursor.Profile.SEQUENCE, this.fSequenceBuffer.futureProfile(), false, true);
    }

    public void append(float val, XSSimpleTypeDefinition type2) {
        this.fSequenceBuffer = this.fSequenceBuffer == null ? this.getFactory().sequence(val, type2, false) : this.fSequenceBuffer.sequenceConcat(val, type2, Cursor.Profile.SEQUENCE, this.fSequenceBuffer.futureProfile(), false, true);
    }

    @Override
    public Object get(int i) {
        throw new DynamicErrorException("Unimplemented: " + this.getClass().getSimpleName() + " doesn't support get(i); sequences are not streams.");
    }

    @Override
    public Iterator<Object> iterator() {
        throw new DynamicErrorException("Unimplemented: " + this.getClass().getSimpleName() + " doesn't support iterator(); sequences are not streams.");
    }

    @Override
    public int size() {
        throw new DynamicErrorException("Unimplemented: " + this.getClass().getSimpleName() + " doesn't support size(); sequences are not streams.");
    }

    @Override
    public char[] toCharArray() {
        throw new DynamicErrorException("Unimplemented: " + this.getClass().getSimpleName() + " doesn't support toCharArray(); sequences are not streams.");
    }

    public Cursor getBuiltSequence() {
        return this.fSequenceBuffer;
    }
}

