/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XSLTPartialEvaluationOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XSLTPartialEvaluationSettings;
import com.ibm.xltxe.rnm1.xylem.BindingDependencyInfo;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.TailRecursiveOptimizer;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.AutomatonFunctionCallEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.EvaluatorDiscoveringPartialInformationCollector;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutomatonFunctionCallExtractionOptimizer
extends TailRecursiveOptimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(AutomatonFunctionCallExtractionOptimizer.class);
    private static final String s_className = AutomatonFunctionCallExtractionOptimizer.class.getName();
    HashMap m_functionInfo = new HashMap();
    HashSet m_affectedFunctions = new HashSet();

    public static final BindingDependencyInfo skipPastLets(BindingDependencyInfo bdi, Map deps) {
        while (bdi.m_parent instanceof LetInstruction && bdi.m_parentIndex == 0) {
            IBinding b = ((LetInstruction)bdi.m_parent).getBinding();
            List list = (List)deps.get(b);
            if (list == null) {
                return null;
            }
            if (list.size() != 1) {
                return null;
            }
            bdi = (BindingDependencyInfo)list.get(0);
        }
        return bdi;
    }

    @Override
    protected Instruction optimizeStep2(Instruction n2) {
        if (n2 instanceof FunctionCallInstruction) {
            FunctionCallInstruction fci = (FunctionCallInstruction)n2;
            Function f1 = this.getCurrentFunction().getTypeEnvironment().getModule().getFunction(fci.getFunction());
            Object x = this.m_functionInfo.get(f1);
            if (x != null) {
                Info info = (Info)x;
                Function f2 = f1.lookupDerivative(this);
                FunctionCallInstruction fci2 = (FunctionCallInstruction)fci.cloneReduced();
                ArrayList<LetInstruction> list = new ArrayList<LetInstruction>();
                for (int i = 0; i < info.m_fcis.length; ++i) {
                    if (info.m_fcis[i] == null) continue;
                    Integer ident = ReductionHelper.generateIntermediateIdentifier2();
                    FunctionCallInstruction fci3 = (FunctionCallInstruction)info.m_fcis[i].cloneReduced();
                    fci3.setChildInstruction(0, fci2.getChildInstruction(i));
                    list.add(new LetInstruction(ident, fci3, null));
                    fci2.setChildInstruction(i, new IdentifierInstruction(ident));
                }
                fci2.setFunction(f2.getName());
                ChooseInstruction ci = new ChooseInstruction(new ChooseInstruction.Case[]{new ChooseInstruction.Case(LiteralInstruction.booleanTrueLiteral(), OptimizerUtilities.reconstructLets(fci2, list))}, null);
                ((Instruction)ci).typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList<Function>());
                this.m_affectedFunctions.add(this.getCurrentFunction().getName());
                return ci;
            }
        }
        return n2;
    }

    @Override
    public void optimizeFunction(Function f2) {
        if (f2.hasBeenTypeChecked()) {
            super.optimizeFunction(f2);
        }
    }

    void doAnalysisPhase(Module p) {
        p.optimize(new Analyzer());
    }

    public static void doOptimization(Module p, Set entryPoints, IntegerSettings is2) {
        final PartialInformationCollector[] m_pic = new PartialInformationCollector[1];
        final HashSet<String> initialFunctionNames = new HashSet<String>(p.getFunctionNames());
        for (int i = 0; i < 10; ++i) {
            XSLTPartialEvaluationSettings pes;
            AutomatonFunctionCallExtractionOptimizer afceo = new AutomatonFunctionCallExtractionOptimizer();
            afceo.doAnalysisPhase(p);
            if (afceo.m_functionInfo.isEmpty()) {
                if (i > 0) {
                    pes = new XSLTPartialEvaluationSettings(is2);
                    p.optimize(new XSLTPartialEvaluationOptimizer(entryPoints, pes));
                }
                return;
            }
            p.optimize(afceo);
            pes = new XSLTPartialEvaluationSettings(is2);
            p.optimize(new XSLTPartialEvaluationOptimizer(afceo.m_affectedFunctions, pes){

                @Override
                public void optimizeFunction(Function f2) {
                    if (this.m_entryPoints.contains(f2.getName())) {
                        if (m_pic[0] == null) {
                            m_pic[0] = new EvaluatorDiscoveringPartialInformationCollector(f2.getBody(), this.m_evaluators, f2, this.m_settings.getIntegerSettings());
                            m_pic[0].m_completedFunctions.addAll(initialFunctionNames);
                        }
                        m_pic[0].m_completedFunctions.remove(f2.getName());
                        m_pic[0].partiallyEvaluateFunction(f2);
                    }
                }
            });
            p.removeDeadFunctions();
        }
    }

    class Analyzer
    extends Optimizer {
        Info m_info;

        Analyzer() {
        }

        @Override
        public void optimizeFunction(Function f2) {
            if (f2.getBindingEnvironment() == null) {
                return;
            }
            this.m_currentFunction = f2;
            HashMap deps = new HashMap();
            f2.determineDataDependencies(f2.m_parameters, deps);
            int c = f2.m_parameters.length;
            FunctionCallInstruction[] info = new FunctionCallInstruction[c];
            boolean hit = false;
            for (int i = 0; i < c; ++i) {
                BindingDependencyInfo bdi;
                List uses = (List)deps.get(f2.m_parameters[i]);
                if (uses == null || uses.size() != 1 || (bdi = AutomatonFunctionCallExtractionOptimizer.skipPastLets((BindingDependencyInfo)uses.get(0), deps)) == null || !(bdi.m_parent instanceof FunctionCallInstruction)) continue;
                FunctionCallInstruction fci = (FunctionCallInstruction)bdi.m_parent;
                Function f22 = f2.getTypeEnvironment().getModule().getFunction(fci.getFunction());
                if (fci.getChildInstructionCount() != 2 || !AutomatonFunctionCallEvaluator.isAutomatonFunctionAugmented(f22)) continue;
                if (fci.getChildInstruction(1).isStatic(f2.getBindingEnvironment())) {
                    info[i] = fci;
                    hit = true;
                    continue;
                }
                if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINEST)) continue;
                s_logger.logp(Level.FINEST, s_className, "optimizeFunction", "Missed opportunity to extract automaton call: " + f2.getName());
            }
            if (hit) {
                Function f23 = f2.cloneFunctionForFixup(AutomatonFunctionCallExtractionOptimizer.this, true, true, true);
                for (int i = 0; i < c; ++i) {
                    if (info[i] == null) continue;
                    Type t = this.resolveType(info[i]);
                    f23.m_parameters[i].setType(t);
                }
                f2.getTypeEnvironment().getModule().addFunction(f23);
                Info realInfo = new Info(info, f2, f23);
                AutomatonFunctionCallExtractionOptimizer.this.m_functionInfo.put(f2, realInfo);
                this.m_info = realInfo;
                this.m_currentFunction = f23;
                f23.setBody(this.optimize(f23.getBody()));
                this.m_info = null;
            }
        }

        @Override
        protected Instruction optimizeStep(Instruction n2, Instruction parent2, int parentIndex) {
            if (n2 instanceof FunctionCallInstruction) {
                for (int i = 0; i < this.m_info.m_fcis.length; ++i) {
                    if (this.m_info.m_fcis[i] == null || !this.m_info.m_originals[i].toString().equals(n2.toString())) continue;
                    return new IdentifierInstruction(this.m_currentFunction.m_parameters[i].getName());
                }
            }
            return super.optimizeStep(n2, parent2, parentIndex);
        }
    }

    static class Info {
        FunctionCallInstruction[] m_originals;
        FunctionCallInstruction[] m_fcis;
        Type[] m_types;
        Function m_newFunction;

        Info(FunctionCallInstruction[] originals, Function originalFunction, Function newFunction) {
            this.m_originals = originals;
            this.m_fcis = new FunctionCallInstruction[originals.length];
            this.m_types = new Type[originals.length];
            this.m_newFunction = newFunction;
            for (int i = 0; i < originals.length; ++i) {
                FunctionCallInstruction fci = originals[i];
                if (fci == null) continue;
                this.m_fcis[i] = (FunctionCallInstruction)fci.cloneReduced();
                TypeEnvironment tenv = originalFunction.getTypeEnvironment();
                BindingEnvironment benv = originalFunction.getBindingEnvironment();
                this.m_fcis[i].setChildInstruction(1, NavigationUtilities.resolveReducedIdentifier(fci.getChildInstruction(1), benv).cloneReduced());
                this.m_types[i] = fci.getType(tenv, benv).resolveType(tenv);
            }
        }
    }
}

