/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.DeconstructMatchXDMItemInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.MatchXDMItemInstruction;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import java.util.HashSet;

public class DeadDeconstructionEliminatorOptimizer
extends Optimizer {
    public Instruction optimize(Instruction n2, Function f2) {
        this.m_currentFunction = f2;
        Instruction x = this.optimize(n2);
        this.m_currentFunction = null;
        return x;
    }

    @Override
    public Instruction optimize(Instruction n2) {
        if (this.getCurrentFunction().getBindingEnvironment() == null) {
            return n2;
        }
        n2 = super.optimize(n2);
        return n2;
    }

    @Override
    protected Instruction optimizeStep(Instruction n2, Instruction parent2, int parentIndex) {
        if (n2 instanceof MatchXDMItemInstruction) {
            MatchXDMItemInstruction mxii = (MatchXDMItemInstruction)n2;
            this.optimize(mxii.getToMatch());
            DeconstructMatchXDMItemInstruction[] matches2 = mxii.getMatches();
            int i = matches2.length;
            while (--i >= 0) {
                DeconstructMatchXDMItemInstruction dm = matches2[i];
                this.optimize(dm.getHandler());
                HashSet freeBindings = new HashSet();
                dm.getHandler().accumulateFreeBindings(freeBindings, this.getCurrentFunction().getBindingEnvironment());
                Binding[] bindings = dm.getBindings();
                if (bindings == null) continue;
                int j = bindings.length;
                while (--j >= 0) {
                    Binding b = bindings[j];
                    if (freeBindings.contains(b)) {
                        freeBindings.remove(b);
                        continue;
                    }
                    if ("_".equals(b.getName())) continue;
                    b.setName("_");
                }
            }
            return null;
        }
        this.optimizeChildren(n2);
        return null;
    }

    public static void eliminateDeadDeconstructions(Module prog) {
        prog.optimize(new DeadDeconstructionEliminatorOptimizer());
    }

    public static Instruction eliminateDeadDeconstructionss(Instruction n2, Function f2) {
        DeadDeconstructionEliminatorOptimizer dleo = new DeadDeconstructionEliminatorOptimizer();
        dleo.m_currentFunction = f2;
        return dleo.optimize(n2);
    }
}

