/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.EqualityInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.GetLastInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.IsEmptyInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.IsSingletonInstruction;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NotInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.OrInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveArithmeticInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.types.PrimitiveNumericalType;
import java.util.HashMap;
import java.util.LinkedList;

public class GetLastOptimizer
extends Optimizer {
    HashMap<Object, Object> map = new HashMap();

    @Override
    public void optimizeFunction(Function f2) {
        super.optimizeFunction(f2);
        this.map.clear();
    }

    @Override
    protected Instruction optimizeStep(Instruction n2) {
        if (n2 instanceof GetLastInstruction) {
            return super.optimizeStep(n2);
        }
        if (n2 instanceof LetInstruction) {
            LetInstruction li = (LetInstruction)n2;
            if (li.getValue() instanceof GetLastInstruction) {
                this.map.put(li.getVariable(), ((IdentifierInstruction)li.getValue().getChildInstruction(0)).getVariable());
            }
        } else {
            if (n2 instanceof PrimitiveArithmeticInstruction) {
                int value2;
                Object gciseq;
                int op2;
                if (n2 instanceof PrimitiveArithmeticInstruction) {
                    PrimitiveArithmeticInstruction pai = (PrimitiveArithmeticInstruction)n2;
                    op2 = pai.getOperation();
                    if (!PrimitiveNumericalType.isComparisonOperator(op2)) {
                        return super.optimizeStep(n2);
                    }
                } else {
                    EqualityInstruction ei = (EqualityInstruction)n2;
                    op2 = ei.isTestingInequality() ? -1 : 9;
                }
                Instruction c0 = n2.getChildInstruction(0);
                Instruction c1 = n2.getChildInstruction(1);
                boolean litIsRight = false;
                if (c0 instanceof LiteralInstruction && c1 instanceof IdentifierInstruction && null != (gciseq = this.map.get(((IdentifierInstruction)c1).getVariable()))) {
                    value2 = LiteralInstruction.getInteger(c0);
                } else if (c1 instanceof LiteralInstruction && c0 instanceof IdentifierInstruction && null != (gciseq = this.map.get(((IdentifierInstruction)c0).getVariable()))) {
                    value2 = LiteralInstruction.getInteger(c1);
                    litIsRight = true;
                } else {
                    return super.optimizeStep(n2);
                }
                switch (value2) {
                    case 0: {
                        if (litIsRight) {
                            switch (op2) {
                                case 8: 
                                case 9: {
                                    return new IsEmptyInstruction(new IdentifierInstruction(gciseq));
                                }
                                case 7: {
                                    return LiteralInstruction.booleanFalseLiteral();
                                }
                                case -1: 
                                case 5: {
                                    return new NotInstruction(new IsEmptyInstruction(new IdentifierInstruction(gciseq)));
                                }
                                case 6: {
                                    return LiteralInstruction.booleanTrueLiteral();
                                }
                            }
                            return super.optimizeStep(n2);
                        }
                        switch (op2) {
                            case 6: 
                            case 9: {
                                return new IsEmptyInstruction(new IdentifierInstruction(gciseq));
                            }
                            case -1: 
                            case 7: {
                                return new NotInstruction(new IsEmptyInstruction(new IdentifierInstruction(gciseq)));
                            }
                            case 8: {
                                return LiteralInstruction.booleanTrueLiteral();
                            }
                            case 5: {
                                return LiteralInstruction.booleanFalseLiteral();
                            }
                        }
                        return super.optimizeStep(n2);
                    }
                    case 1: {
                        if (litIsRight) {
                            switch (op2) {
                                case 9: {
                                    return new IsSingletonInstruction(new IdentifierInstruction(gciseq));
                                }
                                case -1: {
                                    return new NotInstruction(new IsSingletonInstruction(new IdentifierInstruction(gciseq)));
                                }
                                case 8: {
                                    return new OrInstruction(new IsEmptyInstruction(new IdentifierInstruction(gciseq)), new IsSingletonInstruction(new IdentifierInstruction(gciseq)));
                                }
                                case 7: {
                                    return new IsEmptyInstruction(new IdentifierInstruction(gciseq));
                                }
                                case 6: {
                                    return new NotInstruction(new IsEmptyInstruction(new IdentifierInstruction(gciseq)));
                                }
                                case 5: {
                                    return new NotInstruction(new OrInstruction(new IsEmptyInstruction(new IdentifierInstruction(gciseq)), new IsSingletonInstruction(new IdentifierInstruction(gciseq))));
                                }
                            }
                            return super.optimizeStep(n2);
                        }
                        switch (op2) {
                            case 9: {
                                return new IsSingletonInstruction(new IdentifierInstruction(gciseq));
                            }
                            case -1: {
                                return new NotInstruction(new IsSingletonInstruction(new IdentifierInstruction(gciseq)));
                            }
                            case 6: {
                                return new OrInstruction(new IsEmptyInstruction(new IdentifierInstruction(gciseq)), new IsSingletonInstruction(new IdentifierInstruction(gciseq)));
                            }
                            case 7: {
                                return new NotInstruction(new OrInstruction(new IsEmptyInstruction(new IdentifierInstruction(gciseq)), new IsSingletonInstruction(new IdentifierInstruction(gciseq))));
                            }
                            case 8: {
                                return new NotInstruction(new IsEmptyInstruction(new IdentifierInstruction(gciseq)));
                            }
                            case 5: {
                                return new IsEmptyInstruction(new IdentifierInstruction(gciseq));
                            }
                        }
                        return super.optimizeStep(n2);
                    }
                }
                if (value2 > 0) {
                    if (litIsRight) {
                        switch (op2) {
                            case 7: {
                                return new OrInstruction(new IsEmptyInstruction(new IdentifierInstruction(gciseq)), new IsSingletonInstruction(new IdentifierInstruction(gciseq)));
                            }
                        }
                        return super.optimizeStep(n2);
                    }
                    switch (op2) {
                        case 5: {
                            return new OrInstruction(new IsEmptyInstruction(new IdentifierInstruction(gciseq)), new IsSingletonInstruction(new IdentifierInstruction(gciseq)));
                        }
                    }
                    return super.optimizeStep(n2);
                }
                if (value2 < 0) {
                    if (litIsRight) {
                        switch (op2) {
                            case 5: 
                            case 6: {
                                return LiteralInstruction.booleanTrueLiteral();
                            }
                            case 7: 
                            case 8: 
                            case 9: {
                                return LiteralInstruction.booleanFalseLiteral();
                            }
                        }
                        return super.optimizeStep(n2);
                    }
                    switch (op2) {
                        case 7: 
                        case 8: {
                            return LiteralInstruction.booleanTrueLiteral();
                        }
                        case 5: 
                        case 6: 
                        case 9: {
                            return LiteralInstruction.booleanFalseLiteral();
                        }
                    }
                    return super.optimizeStep(n2);
                }
                return super.optimizeStep(n2);
            }
            if (n2 instanceof MatchInstruction) {
                Object gciseq;
                MatchInstruction mi = (MatchInstruction)n2;
                Instruction source = mi.getToMatch();
                if (source instanceof IdentifierInstruction && null != (gciseq = this.map.get(((IdentifierInstruction)source).getVariable()))) {
                    MatchInstruction.Match[] matches2 = mi.getMatches();
                    for (int i = matches2.length - 1; i >= 0; --i) {
                        if (!(matches2[i] instanceof MatchInstruction.LiteralMatch)) {
                            return super.optimizeStep(n2);
                        }
                        int matchvalue = LiteralInstruction.getInteger(((MatchInstruction.LiteralMatch)matches2[i]).getLiteral());
                        if (matchvalue <= 1) continue;
                        return super.optimizeStep(n2);
                    }
                    String emptyVar = null;
                    String singletonVar = null;
                    Instruction optimized = this.optimize(mi.getDefault());
                    for (int i = matches2.length - 1; i >= 0; --i) {
                        MatchInstruction.LiteralMatch match = (MatchInstruction.LiteralMatch)matches2[i];
                        int matchvalue = LiteralInstruction.getInteger(match.getLiteral());
                        Instruction handler = match.getHandler();
                        if (matchvalue < 0) {
                            optimized = new ChooseInstruction(LiteralInstruction.booleanFalseLiteral(), handler, optimized);
                            continue;
                        }
                        if (matchvalue == 0) {
                            if (emptyVar == null) {
                                emptyVar = OptimizerUtilities.generateIntermediateIdentifier();
                            }
                            optimized = new ChooseInstruction(new IdentifierInstruction(emptyVar), handler, optimized);
                            continue;
                        }
                        if (matchvalue != 1) continue;
                        if (singletonVar == null) {
                            singletonVar = OptimizerUtilities.generateIntermediateIdentifier();
                        }
                        optimized = new ChooseInstruction(new IdentifierInstruction(singletonVar), handler, optimized);
                    }
                    if (null != singletonVar) {
                        optimized = new LetInstruction(singletonVar, new IsSingletonInstruction(new IdentifierInstruction(gciseq)), optimized);
                    }
                    if (null != emptyVar) {
                        optimized = new LetInstruction(emptyVar, new IsEmptyInstruction(new IdentifierInstruction(gciseq)), optimized);
                    }
                    optimized.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList<Function>());
                    return optimized;
                }
                return super.optimizeStep(n2);
            }
        }
        return super.optimizeStep(n2);
    }
}

