/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.RuntimeError;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.EmptyItemInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.EqualityInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.IsEmptyInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.TestXDMSequenceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.XDMSequenceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.IShallowImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.IteratorInstruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.PostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.OrInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TestStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.optimizers.ReducedForm;
import com.ibm.xltxe.rnm1.xylem.types.IForkReleaseManaged;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;

public class LoopInvariantOptimizer
extends PostOrderOptimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(LoopInvariantOptimizer.class);
    private static final String s_className = LoopInvariantOptimizer.class.getName();

    @Override
    protected Instruction optimizeStep(Instruction nn) {
        Instruction emptyResult;
        if (!(nn instanceof LetInstruction)) {
            return nn;
        }
        LetInstruction stepLet = (LetInstruction)nn;
        Instruction n2 = stepLet.getValue();
        if (!(n2 instanceof IteratorInstruction)) {
            return stepLet;
        }
        IteratorInstruction ii = (IteratorInstruction)n2;
        BindingEnvironment benv = this.getCurrentFunction().getBindingEnvironment();
        TypeEnvironment tenv = this.getCurrentFunction().getTypeEnvironment();
        Instruction[] sources = ii.getSources();
        boolean zeroOrOneType = true;
        for (int i = sources.length - 1; i >= 0; --i) {
            Type sourceType;
            IBinding source = benv.getVariableBinding(((IdentifierInstruction)sources[i]).getVariable());
            Type type2 = sourceType = source == null ? null : source.getBindingType();
            if (sourceType instanceof XDMItemType && ((XDMItemType)sourceType).getXType().isSubtype(XType.s_itemQuestion) || sourceType instanceof XDMSequenceType && ((XDMSequenceType)sourceType).getXType().isSubtype(XType.s_itemQuestion)) continue;
            zeroOrOneType = false;
            break;
        }
        if (zeroOrOneType) {
            return nn;
        }
        Instruction iterationBody = ii.getBody();
        Set iterDependencies = NavigationUtilities.resolveFreeBindingsForReducedExpression(stepLet, stepLet, benv);
        Instruction currentLet = iterationBody;
        boolean stillReduced = true;
        ArrayList<LetInstruction> toKeep = new ArrayList<LetInstruction>();
        ArrayList<LetInstruction> moveOutside = new ArrayList<LetInstruction>();
        while (currentLet instanceof LetInstruction) {
            LetInstruction let = (LetInstruction)currentLet;
            Type valueType = let.getValue().getCachedType();
            if (let.getValue() instanceof IImperativeInstruction) {
                toKeep.add(let);
            } else if (let.getValue().isStatic(benv)) {
                moveOutside.add(let);
                if (let.getValue() instanceof LiteralInstruction) {
                    toKeep.add(let);
                    stillReduced = false;
                }
            } else if (valueType instanceof XDMItemType && !((XDMItemType)valueType).getXType().isSubtype(XType.s_atomicStar) || valueType instanceof XDMSequenceType && !((XDMSequenceType)valueType).getXType().isSubtype(XType.s_atomicStar)) {
                toKeep.add(let);
            } else if (valueType instanceof IForkReleaseManaged && ((IForkReleaseManaged)((Object)valueType)).mustForkAndRelease() || let.getValue() instanceof IImperativeInstruction || let.getValue() instanceof IShallowImperativeInstruction) {
                toKeep.add(let);
            } else {
                Set freeBindings = NavigationUtilities.resolveFreeBindingsForReducedExpression(let.getValue(), ii, benv);
                int c = freeBindings.size();
                IBinding[] ll = ii.getChildInstructionBindings(this.findBodyIndex(ii));
                for (int i = ll.length - 1; i >= 0; --i) {
                    freeBindings.remove(ll[i]);
                }
                ArrayList toKeepOnly = (ArrayList)toKeep.clone();
                toKeepOnly.removeAll(moveOutside);
                freeBindings.removeAll(toKeepOnly);
                if (freeBindings.size() == c) {
                    moveOutside.add(let);
                } else {
                    toKeep.add(let);
                }
            }
            currentLet = let.getBody();
        }
        if (moveOutside.size() == 0) {
            return stepLet;
        }
        ii.setChildInstruction(this.findBodyIndex(ii), OptimizerUtilities.reconstructLets(currentLet, toKeep, false));
        if (!stillReduced) {
            ii = (IteratorInstruction)ii.cloneWithNewNames();
        }
        Instruction replacement = OptimizerUtilities.reconstructLets(ii, moveOutside, false);
        if (!stillReduced) {
            replacement = ReducedForm.reduceFragment(replacement);
            replacement.typeCheckReduced(tenv, benv, new LinkedList<Function>());
        }
        ArrayList<Instruction> tests = new ArrayList<Instruction>();
        for (int i = sources.length - 1; i >= 0; --i) {
            Instruction c = sources[i];
            Type ct = c.getCachedType();
            if (ct == null) {
                ct = c.getType(tenv, benv);
            }
            if (ct instanceof StreamType || ct instanceof XDMSequenceType) {
                tests.add(new IsEmptyInstruction(c.cloneWithoutTypeInformation()));
                continue;
            }
            if (ct instanceof XDMItemType) {
                tests.add(new EqualityInstruction(c.cloneWithoutTypeInformation(), new EmptyItemInstruction(), false));
                continue;
            }
            throw new RuntimeError("JJK DEBUG: UNEXPECTED SOURCE TYPE " + ct + '\n' + ii);
        }
        Instruction isEmpty = tests.size() == 1 ? (Instruction)tests.get(0) : new OrInstruction(tests);
        replacement = (LetInstruction)ReducedForm.reduceFragment(replacement);
        Type ct = ii.getCachedType();
        if (ct == null) {
            ct = ii.getType(tenv, benv);
        }
        if (ct instanceof StreamType) {
            emptyResult = new StreamInstruction(((StreamType)ct).getElementType());
        } else if (ct instanceof XDMSequenceType) {
            emptyResult = new XDMSequenceInstruction();
        } else if (ii instanceof TestStreamInstruction) {
            emptyResult = ((TestStreamInstruction)ii).getHint().cloneWithoutTypeInformation();
        } else if (ii instanceof TestXDMSequenceInstruction) {
            emptyResult = ((TestXDMSequenceInstruction)ii).getHint().cloneWithoutTypeInformation();
        } else {
            throw new RuntimeError("JJK DEBUG: UNEXPECTED RESULT TYPE " + ct + '\n' + ii);
        }
        Integer isEmptyName = ReductionHelper.generateIntermediateIdentifier2();
        Integer emptyResultName = ReductionHelper.generateIntermediateIdentifier2();
        replacement = new ChooseInstruction(new IdentifierInstruction(isEmptyName), (Instruction)new IdentifierInstruction(emptyResultName), replacement);
        stepLet.setValue(replacement);
        replacement = new LetInstruction(isEmptyName, isEmpty, stepLet);
        replacement = new LetInstruction(emptyResultName, emptyResult, replacement);
        replacement.typeCheckReduced(tenv, benv, new LinkedList<Function>());
        return replacement;
    }

    int findBodyIndex(Instruction ii) {
        int findBody = ii.getChildInstructionCount();
        ISpecialForm isfview = (ISpecialForm)((Object)ii);
        while (!isfview.isChildInstructionBody(--findBody)) {
        }
        return findBody;
    }

    @Override
    public void optimizeFunction(Function f2) {
        if (f2.getName().contains("template$dot$0")) {
            try {
                BindingEnvironment benv = f2.getBindingEnvironment();
                TypeEnvironment tenv = f2.getTypeEnvironment();
                f2.getBody().typeCheckReduced(tenv, benv, new LinkedList<Function>());
                super.optimizeFunction(f2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

