/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.SimpleUnflattenOptimizer;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import java.util.LinkedList;

public class SimpleUnflattenStreamOptimizer
extends SimpleUnflattenOptimizer {
    @Override
    protected Instruction optimizeStep(Instruction n2) {
        if (n2 instanceof StreamInstruction) {
            StreamInstruction si = (StreamInstruction)n2;
            if (si.isStoredAsString()) {
                return null;
            }
            int size = n2.getChildInstructionCount();
            int c = si.getChildInstructionCount();
            if (size >= 200) {
                StreamInstruction si2 = (StreamInstruction)si.cloneWithoutTypeInformation();
                Double num = new Double(Math.ceil((double)size / 100.0));
                int part2 = size / num.intValue();
                si2.split(part2);
                LetChainBuilder lcb = new LetChainBuilder();
                int si2Size = si2.getChildInstructionCount();
                StreamInstruction si3 = (StreamInstruction)si2.cloneWithoutTypeInformation();
                for (int i = 0; i < si2Size; ++i) {
                    si3.setChildInstruction(i, lcb.bind(si2.getChildInstruction(i)));
                }
                n2 = lcb.packageUp(si3);
                n2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList<Function>());
                this.isSplitting = true;
            }
        }
        return n2;
    }
}

