/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.GetAxisCursorInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.GetTypedAxisCursorInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.DeconstructMatchXDMItemInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.MatchXDMItemInstruction;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LoopInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MixedModeModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.FindFreeVariables;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class StackFrameAnalyzer
extends Optimizer {
    private ArrayList<Function> functionQueue = new ArrayList();
    private int variableCount = 0;
    private BindingEnvironment lambdaFreeBindings = null;
    private static final boolean LOG = HiddenOptions.optionValueIs("stackFrameAnalyzerLog", "on");
    private int paramPushDepth = 0;
    private boolean isParamPush = false;
    private int nestCount = 0;
    private static PrintStream log = System.out;
    private static final String INDENTSTRING = "  ";

    public StackFrameAnalyzer(Module m) {
        Iterator<Function> exportedFunctions = m.exportedFunctionsIterator();
        while (exportedFunctions.hasNext()) {
            this.enqueueFunction(exportedFunctions.next());
        }
    }

    private void enqueueFunction(Function f2) {
        this.functionQueue.add(f2);
    }

    public void analyze() {
        int i = 0;
        while (i < this.functionQueue.size()) {
            this.optimizeFunction(this.functionQueue.get(i++));
        }
    }

    private final void log(String s) {
        log.print(s);
    }

    private final void logln(String s) {
        log.println(s);
    }

    private final void logIndent() {
        int i;
        for (i = 0; i < this.nestCount; ++i) {
            this.log(INDENTSTRING);
        }
        if (this.isParamPush) {
            for (i = 0; i < this.paramPushDepth; ++i) {
                this.log("*");
            }
            this.log("->");
            this.isParamPush = false;
        }
    }

    @Override
    public void optimizeFunction(Function f2) {
        if (LOG) {
            this.logIndent();
            this.logln("function declaration: " + f2.getName() + "@" + f2.getReturnType());
            ++this.nestCount;
        }
        BindingEnvironment savedLambdaFreeBindings = this.lambdaFreeBindings;
        int savedVariableCount = this.variableCount;
        this.lambdaFreeBindings = null;
        Binding[] params = f2.getParameters();
        if (null != params) {
            int count2 = params.length;
            for (int i = 0; i < count2; ++i) {
                Binding binding = params[i];
                binding.setStackFramePos(i);
                if (!LOG) continue;
                this.logIndent();
                this.logln("->argument declaration: " + binding.getClass().getSimpleName() + ": " + binding.getName() + " - StackFramePos: " + binding.getStackFramePos());
            }
            this.variableCount = params.length;
        } else {
            this.variableCount = 0;
        }
        super.optimizeFunction(f2);
        f2.setStackFrameSize(this.variableCount);
        this.lambdaFreeBindings = savedLambdaFreeBindings;
        this.variableCount = savedVariableCount;
        if (LOG) {
            --this.nestCount;
            this.logIndent();
            this.logln("leaving optimizeFunction: " + f2.getName() + " - stackFrameSize: " + f2.getStackFrameSize() + " (bindingsEnvSize: " + f2.getBindingEnvironment().getSize() + ")");
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction n2) {
        if (LOG) {
            this.logIndent();
        }
        n2 = n2 instanceof FunctionCallInstruction ? this.processFunctionCallInstruction((FunctionCallInstruction)n2) : (n2 instanceof ModuleFunctionCallInstruction ? this.processModuleFunctionCallInstruction((ModuleFunctionCallInstruction)n2) : (n2 instanceof IdentifierInstruction ? this.processIdentifierInstruction((IdentifierInstruction)n2) : (n2 instanceof LoopInstruction ? this.processLoopInstruction((LoopInstruction)n2) : (n2 instanceof IBinding ? this.processIBinding(n2) : (n2 instanceof MatchXDMItemInstruction ? this.processMatchXDMItemInstruction((MatchXDMItemInstruction)n2) : (n2 instanceof MatchInstruction ? this.processMatchInstruction((MatchInstruction)n2) : (n2 instanceof LambdaInstruction ? this.processLambdaInstruction((LambdaInstruction)n2) : (n2 instanceof ISpecialForm ? this.processSpecialForms(n2) : this.processOtherInstruction(n2)))))))));
        return n2;
    }

    @Override
    protected void optimizeChildren(Instruction n2) {
        if (LOG) {
            ++this.nestCount;
        }
        super.optimizeChildren(n2);
        if (LOG) {
            --this.nestCount;
        }
    }

    private Instruction processFunctionCallInstruction(FunctionCallInstruction fci) {
        int savedParamPushDepth;
        TypeEnvironment tenv = this.m_currentFunction.getTypeEnvironment();
        Function called = tenv.getModule().getFunction(fci.getFunction());
        if (LOG) {
            savedParamPushDepth = this.paramPushDepth;
            this.logln(fci.getClass().getSimpleName() + this.getTypeString(fci) + ": " + called.getName());
            this.paramPushDepth = 1;
        } else {
            savedParamPushDepth = 0;
        }
        this.processParams(fci.getParameters());
        if (LOG) {
            --this.paramPushDepth;
        }
        if (!this.functionQueue.contains(called)) {
            this.enqueueFunction(called);
        }
        if (LOG) {
            this.paramPushDepth = savedParamPushDepth;
        }
        return null;
    }

    private Instruction processModuleFunctionCallInstruction(ModuleFunctionCallInstruction mfci) {
        Function f2 = this.m_currentFunction;
        TypeEnvironment tenv = f2.getTypeEnvironment();
        Module m = tenv.getModule().getProgram().getModule(mfci.getModule());
        Function called = this.resolveFunction(tenv, mfci);
        if (LOG) {
            this.logln(mfci.getClass().getSimpleName() + this.getTypeString(mfci) + ": " + (m != null ? m.getName() : null) + ":" + (called != null ? called.getName() : null));
            ++this.paramPushDepth;
        }
        this.processParams(mfci.getParameters());
        if (LOG) {
            --this.paramPushDepth;
        }
        if (null == called && mfci instanceof MixedModeModuleFunctionCallInstruction) {
            if (LOG) {
                this.logln("Found mixed mode call: " + mfci.getFunction() + " ...skipping");
            }
        } else if (!this.functionQueue.contains(called)) {
            this.enqueueFunction(called);
        }
        return null;
    }

    private Instruction processIdentifierInstruction(IdentifierInstruction ident) {
        Object varID;
        Function f2 = this.m_currentFunction;
        IBinding binding = null;
        if (null != this.lambdaFreeBindings && (binding = this.lambdaFreeBindings.getVariableBinding(varID = ident.getVariable())) != null) {
            ident.setBinding(binding);
        }
        if (binding == null && (binding = ident.getBinding()) == null) {
            BindingEnvironment benv = f2.getBindingEnvironment();
            assert (benv != null);
            Object varID2 = ident.getVariable();
            binding = benv.getVariableBinding(varID2);
            ident.setBinding(binding);
        }
        if (LOG) {
            if (binding != null) {
                this.log(ident.getClass().getSimpleName() + ": " + binding.getName());
                this.logIBindingType(binding, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment());
                this.logln(" - StackFramePos: " + binding.getStackFramePos());
            } else {
                this.logln("optimizeStep (Can't find IBinding): " + ident.getClass().getSimpleName() + ": " + ident.getVariable());
            }
        }
        return null;
    }

    private Instruction processLoopInstruction(LoopInstruction li) {
        int savedParamPushDepth;
        IBinding[] internalBindings;
        if (LOG) {
            this.log("LOOP: ");
            ++this.nestCount;
        }
        li.setStackFramePos(this.variableCount);
        ++this.variableCount;
        int childCount = li.getChildInstructionCount();
        for (int i = 1; i < childCount; ++i) {
            this.optimizeStep(li.getChildInstruction(i));
        }
        if (LOG) {
            --this.nestCount;
        }
        BindingEnvironment benv = this.getBindingEnvironment(li);
        Function currentFunc = this.m_currentFunction;
        Set<IBinding> freeBindings = FindFreeVariables.findFreeBindings(li, benv);
        freeBindings.add(li);
        li.setFreeBindings(freeBindings, currentFunc);
        BindingEnvironment benv2 = new BindingEnvironment();
        for (IBinding binding : internalBindings = li.getClosureInternalBindings()) {
            benv2.setVariableBinding(binding);
        }
        TypeEnvironment tenv = currentFunc.getTypeEnvironment();
        if (LOG) {
            this.logIndent();
            this.log("@" + li.getType(tenv, benv));
            ++this.nestCount;
        }
        BindingEnvironment savedLambdaFreeBindings = this.lambdaFreeBindings;
        if (LOG) {
            savedParamPushDepth = this.paramPushDepth;
            this.paramPushDepth = 0;
        } else {
            savedParamPushDepth = 0;
        }
        this.lambdaFreeBindings = benv2;
        if (LOG) {
            this.logln(": freeBindings.size=" + freeBindings.size());
        }
        int savedVariableCount = this.variableCount;
        Binding[] params = li.getParameters();
        if (LOG) {
            this.logln(": params.length=" + params.length);
        }
        if (null != params) {
            for (int i = 0; i < params.length; ++i) {
                Binding binding = params[i];
                binding.setStackFramePos(i);
                if (!LOG) continue;
                this.logIndent();
                this.logln("->argument declaration: " + binding.getClass().getSimpleName() + ": " + binding.getName() + " - StackFramePos: " + binding.getStackFramePos());
            }
            this.variableCount = params.length + freeBindings.size();
        } else {
            this.variableCount = freeBindings.size();
        }
        if (LOG) {
            ++this.nestCount;
        }
        this.optimize(li.getBody());
        li.setStackFrameSize(this.variableCount);
        this.variableCount = savedVariableCount;
        this.lambdaFreeBindings = savedLambdaFreeBindings;
        if (LOG) {
            --this.nestCount;
            --this.nestCount;
            this.logIndent();
            this.logln("leaving LOOP:  - stackFrameSize: " + li.getStackFrameSize());
            this.paramPushDepth = savedParamPushDepth;
        }
        return null;
    }

    private Instruction processOtherInstruction(Instruction n2) {
        if (LOG) {
            GetAxisCursorInstruction gtaci;
            this.log(n2.getClass().getSimpleName());
            this.logType(n2);
            if (n2 instanceof GetTypedAxisCursorInstruction) {
                this.log(" - ");
                gtaci = (GetTypedAxisCursorInstruction)n2;
                this.log(((GetTypedAxisCursorInstruction)gtaci).getAxis().toString());
                this.log("::" + ((GetTypedAxisCursorInstruction)gtaci).getNodeTest().toString());
            } else if (n2 instanceof GetAxisCursorInstruction) {
                this.log(" - ");
                gtaci = (GetAxisCursorInstruction)n2;
                this.log(gtaci.getAxis().toString());
                this.log("::node()");
            }
            if (n2.getChildInstructionCount() == 0) {
                this.log(": " + n2.toString().trim());
            }
            this.getBindingEnvironment(n2);
            this.logln("");
            ++this.paramPushDepth;
            ++this.nestCount;
        }
        if (LOG) {
            int count2 = n2.getChildInstructionCount();
            for (int i = 0; i < count2; ++i) {
                this.isParamPush = true;
                this.optimize(n2.getChildInstruction(i));
            }
            --this.nestCount;
            --this.paramPushDepth;
            return null;
        }
        return n2;
    }

    private final boolean logType(Instruction n2) {
        if (LOG) {
            this.log("@");
            Type type2 = this.extractType(n2);
            if (null != type2) {
                this.log(type2.toString());
            } else {
                this.log("??");
            }
        }
        return true;
    }

    private String getTypeString(Instruction n2) {
        StringBuffer sb = new StringBuffer();
        sb.append("@");
        Type type2 = this.extractType(n2);
        if (null != type2) {
            sb.append(type2.toString());
        } else {
            sb.append("??");
        }
        return sb.toString();
    }

    private Type extractType(Instruction n2) {
        Type type2 = n2.getCachedType();
        if (type2 == null) {
            BindingEnvironment be = n2.getBindingEnvironment();
            if (be == null) {
                be = this.m_currentFunction.getBindingEnvironment();
            }
            assert (be != null);
            TypeEnvironment te = this.m_currentFunction.getTypeEnvironment();
            assert (te != null);
            type2 = n2.getType(te, be);
        }
        return type2;
    }

    private Instruction processMatchXDMItemInstruction(MatchXDMItemInstruction matchi) {
        if (LOG) {
            this.logln(matchi.getClass().getSimpleName());
            ++this.nestCount;
            this.logIndent();
            this.logln("toMatch: ");
        }
        this.optimize(matchi.getToMatch());
        for (DeconstructMatchXDMItemInstruction dm : matchi.getMatches()) {
            Binding[] bindings = dm.getBindings();
            if (LOG) {
                this.log("case ");
                this.log(dm.getItemKind().getName());
            }
            for (int j = 0; j < bindings.length; ++j) {
                Binding binding = bindings[j];
                if (LOG) {
                    this.log(" binding: " + binding.getName() + "@" + binding.getBindingType() + " - StackFramePos: " + this.variableCount);
                }
                binding.setStackFramePos(this.variableCount);
                ++this.variableCount;
            }
            if (LOG) {
                this.logln(":");
                ++this.nestCount;
            }
            this.optimize(dm.getHandler());
            if (!LOG) continue;
            --this.nestCount;
        }
        Instruction child2 = matchi.getDefault();
        if (null != child2) {
            if (LOG) {
                ++this.nestCount;
                this.logIndent();
                this.logln("otherwise:");
            }
            this.optimize(child2);
            if (LOG) {
                --this.nestCount;
            }
        }
        if (LOG) {
            --this.nestCount;
        }
        return null;
    }

    private Instruction processMatchInstruction(MatchInstruction matchi) {
        if (LOG) {
            this.logln(matchi.getClass().getSimpleName());
            ++this.nestCount;
            this.logIndent();
            this.logln("toMatch: ");
        }
        this.optimize(matchi.getToMatch());
        MatchInstruction.Match[] matches2 = matchi.getMatches();
        int count2 = matches2.length;
        for (int i = 0; i < count2; ++i) {
            if (matches2[i] instanceof MatchInstruction.DeconstructionMatch) {
                MatchInstruction.DeconstructionMatch dm = (MatchInstruction.DeconstructionMatch)matches2[i];
                if (LOG) {
                    this.log("case ");
                    this.log(dm.m_constructorName);
                }
                for (Binding binding : dm.getBindings()) {
                    if (LOG) {
                        this.log(" binding: " + binding.getName() + "@" + binding.getBindingType() + " - StackFramePos: " + this.variableCount);
                    }
                    binding.setStackFramePos(this.variableCount);
                    ++this.variableCount;
                }
                if (LOG) {
                    this.logln(":");
                    ++this.nestCount;
                }
                this.optimize(dm.getHandler());
                if (!LOG) continue;
                --this.nestCount;
                continue;
            }
            MatchInstruction.LiteralMatch lm = (MatchInstruction.LiteralMatch)matches2[i];
            if (LOG) {
                this.log("case ");
                this.log(lm.getLiteral().toString());
                this.logln(":");
                ++this.nestCount;
            }
            this.optimize(lm.getHandler());
            if (!LOG) continue;
            --this.nestCount;
        }
        Instruction child2 = matchi.getDefault();
        if (null != child2) {
            if (LOG) {
                ++this.nestCount;
                this.logIndent();
                this.logln("otherwise:");
            }
            this.optimize(child2);
            if (LOG) {
                --this.nestCount;
            }
        }
        if (LOG) {
            --this.nestCount;
        }
        return null;
    }

    private Instruction processIBinding(Instruction n2) {
        IBinding binding = (IBinding)((Object)n2);
        if (LOG) {
            this.log(n2.getClass().getSimpleName() + ": " + binding.getName());
            this.logIBindingType(binding, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment());
            this.logln(" - StackFramePos: " + this.variableCount);
        }
        binding.setStackFramePos(this.variableCount);
        ++this.variableCount;
        return n2;
    }

    private BindingEnvironment getBindingEnvironment(Instruction n2) {
        BindingEnvironment benv = n2.getBindingEnvironment();
        if (benv != null) {
            if (LOG) {
                this.log("  bindingsEnvSize: " + benv.getSize());
                this.log("  bindingsEnv: " + benv.toString());
            }
        } else {
            if (LOG) {
                this.log("  null binding environment");
            }
            if (benv == null) {
                benv = n2.evaluateBindingEnvironment(this.m_currentFunction);
            }
            if (LOG && benv != null) {
                this.log("  using current function binding env");
            }
        }
        return benv;
    }

    private Instruction processSpecialForms(Instruction n2) {
        if (LOG) {
            this.log(n2.getClass().getSimpleName());
            this.logType(n2);
            if (n2.getChildInstructionCount() == 0) {
                this.log(": " + n2.toString().trim());
            }
            this.getBindingEnvironment(n2);
            this.logln("");
            ++this.nestCount;
        }
        int count2 = n2.getChildInstructionCount();
        for (int i = 0; i < count2; ++i) {
            IBinding[] bindings;
            if (((ISpecialForm)((Object)n2)).isChildInstructionBody(i) && null != (bindings = ((ISpecialForm)((Object)n2)).getChildInstructionBindings(i))) {
                for (int j = 0; j < bindings.length; ++j) {
                    IBinding binding2 = bindings[j];
                    if (LOG) {
                        this.logIndent();
                        this.logln("ISpecialForm binding: " + binding2.getName() + this.getTypeString(n2) + " - StackFramePos: " + this.variableCount);
                    }
                    binding2.setStackFramePos(this.variableCount);
                    ++this.variableCount;
                }
            }
            if (!LOG) continue;
            this.optimize(n2.getChildInstruction(i));
        }
        if (LOG) {
            --this.nestCount;
            return null;
        }
        return n2;
    }

    private final boolean logIBindingType(IBinding binding, TypeEnvironment tenv, BindingEnvironment benv) {
        if (LOG) {
            this.log("@");
            Type type2 = binding.getBindingType();
            if (type2 != null) {
                this.log(type2.toString());
            } else {
                type2 = binding.getBindingType(tenv, benv);
                if (type2 != null) {
                    this.log(type2.toString());
                } else {
                    this.log("??");
                }
            }
        }
        return true;
    }

    private Instruction processLambdaInstruction(LambdaInstruction li) {
        int savedParamPushDepth;
        IBinding[] internalBindings;
        if (LOG) {
            this.log("LAMBDA: ");
        }
        BindingEnvironment benv = this.getBindingEnvironment(li);
        Function currentFunc = this.m_currentFunction;
        Set<IBinding> freeBindings = FindFreeVariables.findFreeBindings(li, benv);
        li.setFreeBindings(freeBindings, currentFunc);
        BindingEnvironment benv2 = new BindingEnvironment();
        for (IBinding binding : internalBindings = li.getClosureInternalBindings()) {
            benv2.setVariableBinding(binding);
        }
        if (LOG) {
            this.logIndent();
            TypeEnvironment tenv = currentFunc.getTypeEnvironment();
            this.log("@" + li.getType(tenv, benv));
            ++this.nestCount;
        }
        BindingEnvironment savedLambdaFreeBindings = this.lambdaFreeBindings;
        int savedVariableCount = this.variableCount;
        if (LOG) {
            savedParamPushDepth = this.paramPushDepth;
            this.paramPushDepth = 0;
        } else {
            savedParamPushDepth = 0;
        }
        this.lambdaFreeBindings = benv2;
        if (LOG) {
            this.logln(": freeBindings.size=" + freeBindings.size());
        }
        Binding[] params = li.getParameters();
        if (LOG) {
            this.logln(": params.length=" + params.length);
        }
        if (null != params) {
            for (int i = 0; i < params.length; ++i) {
                Binding binding = params[i];
                binding.setStackFramePos(i);
                if (!LOG) continue;
                this.logIndent();
                this.logln("->argument declaration: " + binding.getClass().getSimpleName() + ": " + binding.getName() + " - StackFramePos: " + binding.getStackFramePos());
            }
            this.variableCount = params.length + freeBindings.size();
        } else {
            this.variableCount = freeBindings.size();
        }
        this.optimizeChildren(li);
        li.setStackFrameSize(this.variableCount);
        this.variableCount = savedVariableCount;
        this.lambdaFreeBindings = savedLambdaFreeBindings;
        if (LOG) {
            this.paramPushDepth = savedParamPushDepth;
            --this.nestCount;
            this.logIndent();
            this.logln("leaving LAMBDA:  - stackFrameSize: " + li.getStackFrameSize());
        }
        return null;
    }

    private void processParams(Instruction[] params) {
        int count2 = params.length;
        for (int i = 0; i < count2; ++i) {
            if (LOG) {
                this.isParamPush = true;
            }
            this.optimize(params[i]);
        }
    }

    private Function resolveFunction(TypeEnvironment tenv, ModuleFunctionCallInstruction mfci) {
        Module m = tenv.getModule().getProgram().getModule(mfci.getModule());
        if (m == null) {
            return null;
        }
        return m.getPublicFunction(mfci.getFunction());
    }
}

