/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.EqualityInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.GetStringValueInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.ForEachXDMSequenceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.IdentityHashMap;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.DeepEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LengthInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TestStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;

public class StringEqualityOptimizer
extends Optimizer {
    protected HashMap m_checks;

    @Override
    public void optimizeFunction(Function f2) {
        this.m_checks = new HashMap();
        super.optimizeFunction(f2);
        if (this.m_checks.isEmpty()) {
            return;
        }
        BindingEnvironment benv = f2.getBindingEnvironment();
        TypeEnvironment tenv = f2.getTypeEnvironment();
        for (Map.Entry me : this.m_checks.entrySet()) {
            Object var = me.getKey();
            ArrayList info = (ArrayList)me.getValue();
            if (info.size() < 3) continue;
            IBinding binding = benv.getVariableBinding(var);
            TreeSet<Object> set2 = new TreeSet<Object>(new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    int len1;
                    String s0 = (String)arg0;
                    String s1 = (String)arg1;
                    int len0 = s0.length();
                    if (len0 == (len1 = s1.length())) {
                        return s0.compareTo(s1);
                    }
                    return len0 - len1;
                }
            });
            for (Object[] x : info) {
                set2.add(x[1]);
            }
            ArrayList strings2 = new ArrayList(set2);
            IdentifierInstruction ii = new IdentifierInstruction(var);
            Integer newArrayVar = ReductionHelper.generateIntermediateIdentifier2();
            Integer elementVar = ReductionHelper.generateIntermediateIdentifier2();
            Integer bodyVar = ReductionHelper.generateIntermediateIdentifier2();
            Integer stringVar = ReductionHelper.generateIntermediateIdentifier2();
            IdentifierInstruction stringII = new IdentifierInstruction(stringVar);
            Integer stringLenVar = ReductionHelper.generateIntermediateIdentifier2();
            ForEachXDMSequenceInstruction body = new ForEachXDMSequenceInstruction(ii, elementVar, new LetInstruction(stringVar, new GetStringValueInstruction(new IdentifierInstruction(elementVar)), new LetInstruction(stringLenVar, new LengthInstruction(stringII), new LetInstruction(bodyVar, this.makeStringDetector(strings2, info, stringII, new IdentifierInstruction(stringLenVar)), new StreamInstruction((Type)IntType.s_intType, new IdentifierInstruction(bodyVar))))));
            LetInstruction leti = new LetInstruction(newArrayVar, body, null);
            if (binding.getLet() != null) {
                leti.setBody(binding.getLet().getBody());
                binding.getLet().setBody(leti);
            } else if (binding.getOrigin() != null) {
                ISpecialForm sf = binding.getOrigin();
                Instruction sf0 = (Instruction)((Object)sf);
                int targetChild = -1;
                block2: for (int m = 0; m < sf0.getChildInstructionCount(); ++m) {
                    IBinding[] bindings = sf.getChildInstructionBindings(m);
                    if (bindings == null) continue;
                    for (int n2 = 0; n2 < bindings.length; ++n2) {
                        if (bindings[n2] != binding) continue;
                        if (targetChild != -1) {
                            targetChild = -1;
                            break block2;
                        }
                        targetChild = n2;
                        continue block2;
                    }
                }
                if (targetChild == -1) continue;
                leti.setBody(sf0.getChildInstruction(targetChild));
                sf0.setChildInstruction(targetChild, leti);
            } else {
                boolean success = false;
                for (int m = 0; m < f2.m_parameters.length; ++m) {
                    if (f2.m_parameters[m] != binding) continue;
                    leti.setBody(f2.getBody());
                    f2.setBody(leti);
                    success = true;
                    break;
                }
                if (!success) continue;
            }
            ((Instruction)body).typeCheckReduced(tenv, benv, new LinkedList<Function>());
            benv.setVariableBinding(leti);
            IdentifierInstruction newArrayII = new IdentifierInstruction(newArrayVar);
            for (Object[] x : info) {
                Instruction parent2 = (Instruction)x[2];
                Integer index2 = (Integer)x[3];
                String s = (String)x[1];
                Integer elementVar2 = ReductionHelper.generateIntermediateIdentifier2();
                Integer hintVar = ReductionHelper.generateIntermediateIdentifier2();
                IdentifierInstruction hintII = new IdentifierInstruction(hintVar);
                TestStreamInstruction tsi = new TestStreamInstruction(newArrayII, LiteralInstruction.booleanFalseLiteral(), elementVar2, hintVar, null, new ChooseInstruction(hintII, (Instruction)hintII, new PrimitiveEqualityInstruction(new IdentifierInstruction(elementVar2), LiteralInstruction.integerLiteral(strings2.indexOf(s)))));
                ((Instruction)tsi).typeCheckReduced(tenv, benv, new LinkedList<Function>());
                parent2.setChildInstruction(index2, tsi);
            }
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction n2, Instruction parent2, int parentIndex) {
        block5: {
            ArrayList<Object[]> map2;
            IdentifierInstruction ii;
            StreamInstruction si;
            block7: {
                EqualityInstruction ei;
                BindingEnvironment benv;
                TypeEnvironment tenv;
                block6: {
                    if (!(n2 instanceof EqualityInstruction)) break block5;
                    tenv = this.getCurrentFunction().getTypeEnvironment();
                    benv = this.getCurrentFunction().getBindingEnvironment();
                    ei = (EqualityInstruction)n2;
                    if (ei.isTestingInequality() || ei.getOperand1() instanceof LiteralInstruction || ei.getOperand2() instanceof LiteralInstruction) break block5;
                    Instruction i1 = NavigationUtilities.resolveReducedIdentifier(ei.getOperand1(), benv);
                    if (i1 instanceof StreamInstruction && (si = (StreamInstruction)i1).isString()) break block6;
                    Instruction i2 = NavigationUtilities.resolveReducedIdentifier(ei.getOperand2(), benv);
                    if (!(i2 instanceof StreamInstruction) || !(si = (StreamInstruction)i2).isString()) break block5;
                    ii = (IdentifierInstruction)ei.getOperand1();
                    if (ei.getOperand1().getType(tenv, benv).resolveType(tenv) instanceof XDMSequenceType) break block7;
                    break block5;
                }
                ii = (IdentifierInstruction)ei.getOperand2();
                if (!(ei.getOperand2().getType(tenv, benv).resolveType(tenv) instanceof XDMSequenceType)) break block5;
            }
            if ((map2 = (ArrayList<Object[]>)this.m_checks.get(ii.getVariable())) == null) {
                map2 = new ArrayList<Object[]>();
                this.m_checks.put(ii.getVariable(), map2);
            }
            map2.add(new Object[]{n2, si.getStringContent(), parent2, new Integer(parentIndex)});
        }
        return super.optimizeStep(n2, parent2, parentIndex);
    }

    protected Instruction makeStringDetector(ArrayList strings2, ArrayList info, IdentifierInstruction string2, IdentifierInstruction length2) {
        LiteralInstruction fail = LiteralInstruction.integerLiteral(-1);
        Iterator i = strings2.iterator();
        IdentityHashMap matches2 = new IdentityHashMap();
        MatchInstruction.LiteralMatch match = null;
        ArrayList list = null;
        int lastLength = -1;
        while (i.hasNext()) {
            String x = (String)i.next();
            if (lastLength != x.length()) {
                lastLength = x.length();
                match = new MatchInstruction.LiteralMatch(LiteralInstruction.integerLiteral(lastLength), fail);
                list = new ArrayList();
                matches2.put(match, list);
            }
            list.add(x);
        }
        MatchInstruction.Match[] m = new MatchInstruction.Match[matches2.size()];
        matches2.keySet().toArray(m);
        MatchInstruction mi = new MatchInstruction((Instruction)length2, m, (Instruction)fail);
        for (int j = 0; j < m.length; ++j) {
            list = (ArrayList)matches2.get(m[j]);
            String x0 = (String)list.get(0);
            if (list.size() == 1) {
                LetChainBuilder lcb2 = new LetChainBuilder();
                Instruction y = lcb2.bind(StreamInstruction.charStreamLiteral(x0));
                m[j].setHandler(lcb2.packageUp(new ChooseInstruction(lcb2.bind(new DeepEqualityInstruction(y, string2)), (Instruction)LiteralInstruction.integerLiteral(strings2.indexOf(x0)), fail)));
                continue;
            }
            MatchInstruction.Match m0 = m[j];
            for (int k = 0; k < x0.length(); ++k) {
                Instruction outer = fail;
                for (String s : list) {
                    LetChainBuilder lcb2 = new LetChainBuilder();
                    Instruction y = lcb2.bind(StreamInstruction.charStreamLiteral(s));
                    outer = lcb2.packageUp(new ChooseInstruction(lcb2.bind(new DeepEqualityInstruction(y, string2)), (Instruction)LiteralInstruction.integerLiteral(strings2.indexOf(s)), outer));
                }
                m[j].setHandler(outer);
            }
        }
        return mi;
    }
}

