/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.ContextIsNodeOnlyInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.GetAxisCursorInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.GetLastInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.GetTypedAxisCursorInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.IsEmptyInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.XPathDataTypeLiteralInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.XPathStepInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.nodeconstructors.CreateTextInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.AtomizationToStringInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.ConstructXDMItemAtomInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.ConstructXDMItemNodeInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.ContextItemInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.DeconstructMatchXDMItemInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.DocOrderInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.GetStringValueXDMItemInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.ItemKind;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.MatchXDMItemInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.XDMSequenceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.NamedXTypeConstants;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.IteratorInstruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NotInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveArithmeticInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.xci.exec.Axis;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class XDMSequenceOptimizer
extends Optimizer {
    public static final String XTYPEOPT_OPTION = "xtypeopt";
    public static final boolean sXTypeOpt = !HiddenOptions.optionValueIs("xtypeopt", "off");
    private BindingEnvironment lambdaFreeBindings = null;
    private static final boolean LOG = HiddenOptions.optionValueIs("CursorAnalyzerLog", "on");
    private static final boolean REWRITELOG = HiddenOptions.optionValueIs("XTypeRewritesLog", "on");
    private int paramPushDepth = 0;
    private boolean isParamPush = false;
    private int nestCount = 0;
    private static PrintStream log = System.out;
    private static final String INDENTSTRING = "  ";
    private Module fCurrentModule;
    private HashSet<Function> fFoundFunctions = new HashSet();
    private LinkedList<Function> fFunctionsToProcess = new LinkedList();

    public XDMSequenceOptimizer() {
        this.isTypeReparing = true;
    }

    private final void log(String s) {
        log.print(s);
    }

    private final void logln(String s) {
        log.println(s);
    }

    private final void logxtypeln(String s) {
        log.println(s);
    }

    private final void logIndent() {
        int i;
        for (i = 0; i < this.nestCount; ++i) {
            this.log(INDENTSTRING);
        }
        if (this.isParamPush) {
            for (i = 0; i < this.paramPushDepth; ++i) {
                this.log("*");
            }
            this.log("->");
            this.isParamPush = false;
        }
    }

    public void optimizeModule(Module m) {
        this.fCurrentModule = m;
        Iterator<Function> exportedFunctions = m.exportedFunctionsIterator();
        while (exportedFunctions.hasNext()) {
            this.enqueueFunction(exportedFunctions.next());
        }
        while (!this.fFunctionsToProcess.isEmpty()) {
            Function nextFunction = this.fFunctionsToProcess.removeFirst();
            this.optimizeFunction(nextFunction);
        }
    }

    @Override
    public void optimizeFunction(Function f2) {
        String funcName = f2.getName();
        Module m = f2.getModule();
        if (LOG) {
            this.logIndent();
            this.logln("function declaration: " + funcName + "@" + f2.getReturnType());
            ++this.nestCount;
        }
        BindingEnvironment savedLambdaFreeBindings = this.lambdaFreeBindings;
        this.lambdaFreeBindings = null;
        super.optimizeFunction(f2);
        this.lambdaFreeBindings = savedLambdaFreeBindings;
        if (LOG) {
            --this.nestCount;
            this.logIndent();
            this.logln("leaving optimizeFunction: " + funcName + " - stackFrameSize: " + f2.getStackFrameSize() + " (bindingsEnvSize: " + f2.getBindingEnvironment().getSize() + ")");
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction n2) {
        if (LOG) {
            this.logIndent();
        }
        n2 = n2 instanceof FunctionCallInstruction ? this.processFunctionCallInstruction((FunctionCallInstruction)n2) : (n2 instanceof GetLastInstruction ? this.processGetLastInstruction(n2) : (n2 instanceof ModuleFunctionCallInstruction ? this.processModuleFunctionCallInstruction((ModuleFunctionCallInstruction)n2) : (n2 instanceof IdentifierInstruction ? this.processIdentifierInstruction(n2) : (n2 instanceof IBinding ? this.processIBinding(n2) : (n2 instanceof MatchXDMItemInstruction ? this.processMatchXDMItemInstruction((MatchXDMItemInstruction)n2) : (n2 instanceof MatchInstruction ? this.processMatchInstruction((MatchInstruction)n2) : (n2 instanceof ConstructXDMItemNodeInstruction ? n2.getChildInstruction(0) : (n2 instanceof AtomizationToStringInstruction ? this.processAtomizationToStringInstruction(n2) : (n2 instanceof ContextIsNodeOnlyInstruction ? this.processContextIsNodeOnlyInstruction(n2) : (n2 instanceof DocOrderInstruction ? this.processDocOrderInstruction(n2) : (n2 instanceof ISpecialForm ? this.processSpecialForms(n2) : this.processOtherInstruction(n2))))))))))));
        return n2;
    }

    private Instruction processOtherInstruction(Instruction n2) {
        if (LOG) {
            GetAxisCursorInstruction gtaci;
            this.log(n2.getClass().getSimpleName());
            this.logType(n2);
            if (n2 instanceof GetTypedAxisCursorInstruction) {
                this.log(" - ");
                gtaci = (GetTypedAxisCursorInstruction)n2;
                this.log(gtaci.toString());
            } else if (n2 instanceof GetAxisCursorInstruction) {
                this.log(" - ");
                gtaci = (GetAxisCursorInstruction)n2;
                this.log(gtaci.toString());
            }
            if (n2.getChildInstructionCount() == 0) {
                this.log(": " + n2.toString().trim());
            }
            this.getBindingEnvironment(n2);
            this.logln("");
            ++this.paramPushDepth;
            ++this.nestCount;
        }
        if (LOG) {
            int count2 = n2.getChildInstructionCount();
            for (int i = 0; i < count2; ++i) {
                this.isParamPush = true;
                this.optimize(n2.getChildInstruction(i));
            }
            --this.nestCount;
            --this.paramPushDepth;
            return null;
        }
        return n2;
    }

    private final void logType(Instruction n2) {
        this.log("@");
        Type type2 = this.extractType(n2);
        if (null != type2) {
            this.log(type2.toString());
        } else {
            this.log("??");
        }
    }

    private String getTypeString(Instruction n2) {
        StringBuffer sb = new StringBuffer();
        sb.append("@");
        Type type2 = this.extractType(n2);
        if (null != type2) {
            sb.append(type2.toString());
        } else {
            sb.append("??");
        }
        return sb.toString();
    }

    private Type extractType(Instruction n2) {
        Type type2 = n2.getCachedType();
        if (type2 == null) {
            BindingEnvironment be = n2.getBindingEnvironment();
            if (be == null) {
                be = this.m_currentFunction.getBindingEnvironment();
            }
            if (be == null) {
                return null;
            }
            assert (be != null);
            TypeEnvironment te = this.m_currentFunction.getTypeEnvironment();
            assert (te != null);
            type2 = n2.getType(te, be);
        }
        return type2;
    }

    private Instruction processMatchXDMItemInstruction(MatchXDMItemInstruction matchi) {
        if (LOG) {
            this.logln(matchi.getClass().getSimpleName());
            ++this.nestCount;
            this.logIndent();
            this.logln("toMatch: ");
        }
        this.optimize(matchi.getToMatch());
        for (DeconstructMatchXDMItemInstruction dm : matchi.getMatches()) {
            Binding[] bindings = dm.getBindings();
            if (LOG) {
                this.log("case ");
                this.log(dm.getItemKind().getName());
            }
            for (int j = 0; j < bindings.length; ++j) {
                Binding binding = bindings[j];
                if (!LOG) continue;
                this.log(" binding: " + binding.getName() + "@" + binding.getBindingType());
            }
            if (LOG) {
                this.logln(":");
                ++this.nestCount;
            }
            this.optimize(dm.getHandler());
            if (!LOG) continue;
            --this.nestCount;
        }
        Instruction child2 = matchi.getDefault();
        if (null != child2) {
            if (LOG) {
                ++this.nestCount;
                this.logIndent();
                this.logln("otherwise:");
            }
            this.optimize(child2);
            if (LOG) {
                --this.nestCount;
            }
        }
        if (LOG) {
            --this.nestCount;
        }
        return null;
    }

    private Instruction processMatchInstruction(MatchInstruction matchi) {
        if (LOG) {
            this.logln(matchi.getClass().getSimpleName());
            ++this.nestCount;
            this.logIndent();
            this.logln("toMatch: ");
        }
        this.optimize(matchi.getToMatch());
        MatchInstruction.Match[] matches2 = matchi.getMatches();
        int count2 = matches2.length;
        for (int i = 0; i < count2; ++i) {
            if (matches2[i] instanceof MatchInstruction.DeconstructionMatch) {
                MatchInstruction.DeconstructionMatch dm = (MatchInstruction.DeconstructionMatch)matches2[i];
                if (LOG) {
                    this.log("case ");
                    this.log(dm.m_constructorName);
                }
                for (Binding binding : dm.getBindings()) {
                    if (!LOG) continue;
                    this.log(" binding: " + binding.getName() + "@" + binding.getBindingType());
                }
                if (LOG) {
                    this.logln(":");
                    ++this.nestCount;
                }
                this.optimize(dm.getHandler());
                if (!LOG) continue;
                --this.nestCount;
                continue;
            }
            MatchInstruction.LiteralMatch lm = (MatchInstruction.LiteralMatch)matches2[i];
            if (LOG) {
                this.log("case ");
                this.log(lm.getLiteral().toString());
                this.logln(":");
                ++this.nestCount;
            }
            this.optimize(lm.getHandler());
            if (!LOG) continue;
            --this.nestCount;
        }
        Instruction child2 = matchi.getDefault();
        if (null != child2) {
            if (LOG) {
                ++this.nestCount;
                this.logIndent();
                this.logln("otherwise:");
            }
            this.optimize(child2);
            if (LOG) {
                --this.nestCount;
            }
        }
        if (LOG) {
            --this.nestCount;
        }
        return null;
    }

    private Instruction processIBinding(Instruction n2) {
        boolean LOGMETHOD = false;
        IBinding binding = (IBinding)((Object)n2);
        LetInstruction letInstruction = binding.getLet();
        if (letInstruction != null) {
            Type innerType1;
            Instruction arg2;
            IBinding innerBinding1;
            Instruction xdmSequenceInstruction;
            int nChildren;
            Instruction value2 = letInstruction.getValue();
            if (value2 instanceof ContextItemInstruction) {
                IBinding innerBinding12;
                ContextItemInstruction contextItemInstruction = (ContextItemInstruction)value2;
                Instruction arg3 = contextItemInstruction.getChildInstruction(0);
                if (arg3 instanceof IdentifierInstruction && null != (innerBinding12 = this.getBindingFromIdentifier((IdentifierInstruction)arg3))) {
                    LetInstruction innerBinding2Let;
                    Type innerType2;
                    IBinding innerBinding2;
                    Instruction arg22;
                    XDMSequenceInstruction xdmSequenceInstruction2;
                    int nChildren2;
                    Instruction value22;
                    LetInstruction letInstruction1;
                    Type innerType12 = this.getBindingType(innerBinding12, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment());
                    if (innerType12 instanceof XDMItemType) {
                        letInstruction.setValue(arg3);
                    } else if (innerType12 instanceof XDMSequenceType && (letInstruction1 = innerBinding12.getLet()) != null && (value22 = letInstruction1.getValue()) instanceof XDMSequenceInstruction && (nChildren2 = (xdmSequenceInstruction2 = (XDMSequenceInstruction)value22).getChildInstructionCount()) == 1 && (arg22 = xdmSequenceInstruction2.getChildInstruction(0)) instanceof IdentifierInstruction && (innerBinding2 = this.getBindingFromIdentifier((IdentifierInstruction)arg22)) != null && (innerType2 = this.getBindingType(innerBinding2, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment())) instanceof XDMItemType && (innerBinding2Let = innerBinding2.getLet()) != null) {
                        Instruction value3 = innerBinding2Let.getValue();
                        if (binding instanceof LetInstruction && innerBinding2 instanceof LetInstruction) {
                            Instruction innerValue3Instruction = value3;
                            LetInstruction letBinding = (LetInstruction)((LetInstruction)binding).cloneReduced();
                            Instruction newValueClone = innerValue3Instruction.cloneReduced();
                            letBinding.setValue(newValueClone);
                            n2 = letBinding;
                            this.setFunctionNeedsTypecheck(true);
                        }
                    }
                }
            } else if (value2 instanceof XDMSequenceInstruction && (nChildren = (xdmSequenceInstruction = value2).getChildInstructionCount()) == 1 && null != (innerBinding1 = this.getBindingFromIdentifier((IdentifierInstruction)(arg2 = xdmSequenceInstruction.getChildInstruction(0)))) && (innerType1 = this.getBindingType(innerBinding1, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment())) instanceof XDMSequenceType) {
                letInstruction.setValue(arg2);
            }
        }
        if (LOG) {
            this.log(n2.getClass().getSimpleName() + ": " + binding.getName());
            this.logIBindingType(binding, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment());
            this.logln("");
        }
        return n2;
    }

    private BindingEnvironment getBindingEnvironment(Instruction n2) {
        BindingEnvironment benv = n2.getBindingEnvironment();
        if (benv != null) {
            if (LOG) {
                this.log("  bindingsEnvSize: " + benv.getSize());
                this.log("  bindingsEnv: " + benv.toString());
            }
        } else {
            if (LOG) {
                this.log("  null binding environment");
            }
            if (benv == null) {
                benv = n2.evaluateBindingEnvironment(this.m_currentFunction);
            }
            if (LOG && benv != null) {
                this.log("  using current function binding env");
            }
        }
        return benv;
    }

    private Instruction processSpecialForms(Instruction n2) {
        if (LOG) {
            this.log(n2.getClass().getSimpleName());
            this.logType(n2);
            if (n2.getChildInstructionCount() == 0) {
                this.log(": " + n2.toString().trim());
            }
            this.getBindingEnvironment(n2);
            this.logln("");
            ++this.nestCount;
            int count2 = n2.getChildInstructionCount();
            for (int i = 0; i < count2; ++i) {
                IBinding[] bindings;
                if (((ISpecialForm)((Object)n2)).isChildInstructionBody(i) && null != (bindings = ((ISpecialForm)((Object)n2)).getChildInstructionBindings(i))) {
                    for (int j = 0; j < bindings.length; ++j) {
                        IBinding binding2 = bindings[j];
                        this.logIndent();
                        this.logln("ISpecialForm binding: " + binding2.getName() + this.getTypeString(n2));
                    }
                }
                this.optimize(n2.getChildInstruction(i));
            }
            --this.nestCount;
            return null;
        }
        return n2;
    }

    private Instruction processIdentifierInstruction(Instruction n2) {
        boolean LOGMETHOD = false;
        IdentifierInstruction ident = (IdentifierInstruction)n2;
        IBinding binding = this.getBindingFromIdentifier(ident);
        if (binding != null) {
            if (LOG) {
                this.log(n2.getClass().getSimpleName() + ": " + binding.getName());
                this.logIBindingType(binding, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment());
                this.logln("");
            }
        } else if (LOG) {
            this.logln("optimizeStep (Can't find IBinding): " + n2.getClass().getSimpleName() + ": " + ident.getVariable());
        }
        return n2;
    }

    private IBinding getBindingFromIdentifier(IdentifierInstruction ident) {
        Function f2 = this.m_currentFunction;
        IBinding binding = null;
        if (null != this.lambdaFreeBindings) {
            Object varID = ident.getVariable();
            binding = this.lambdaFreeBindings.getVariableBinding(varID);
        }
        if (binding == null && (binding = ident.getBinding()) == null) {
            BindingEnvironment benv = f2.getBindingEnvironment();
            if (benv == null) {
                return null;
            }
            assert (benv != null);
            Object varID = ident.getVariable();
            binding = benv.getVariableBinding(varID);
        }
        return binding;
    }

    private Type getBindingType(IBinding binding, TypeEnvironment tenv, BindingEnvironment benv) {
        Type type2 = binding.getBindingType();
        if (type2 == null) {
            type2 = binding.getBindingType(tenv, benv);
        }
        return type2;
    }

    private final boolean logIBindingType(IBinding binding, TypeEnvironment tenv, BindingEnvironment benv) {
        this.log("@");
        Type type2 = binding.getBindingType();
        if (type2 != null) {
            this.log(type2.toString());
        } else {
            Type type3 = type2 = tenv != null ? binding.getBindingType(tenv, benv) : null;
            if (type2 != null) {
                this.log(type2.toString());
            } else {
                this.log("??");
            }
        }
        return true;
    }

    private Instruction processModuleFunctionCallInstruction(ModuleFunctionCallInstruction mfci) {
        Instruction newFunctionCall;
        Function f2 = this.m_currentFunction;
        TypeEnvironment tenv = f2.getTypeEnvironment();
        Module m = tenv.getModule().getProgram().getModule(mfci.getModule());
        Function called = this.resolveFunction(tenv, mfci);
        this.enqueueFunction(called);
        if (LOG) {
            this.logln(mfci.getClass().getSimpleName() + this.getTypeString(mfci) + ": " + (m != null ? m.getName() : null) + ":" + (called != null ? called.getName() : null));
            ++this.paramPushDepth;
        }
        Instruction[] params = mfci.getParameters();
        this.processParams(params);
        if (LOG) {
            --this.paramPushDepth;
        }
        if ((newFunctionCall = this.optimizeFunctionCallForSequenceParams(mfci, f2, called, m, params)) != mfci) {
            mfci = (ModuleFunctionCallInstruction)newFunctionCall;
            params = mfci.getParameters();
            called = this.resolveFunction(tenv, mfci);
            mfci.typeCheckReduced(tenv, f2.getBindingEnvironment(), new LinkedList<Function>());
            this.setFunctionNeedsTypecheck(true);
        }
        if ((newFunctionCall = this.optimizeFunctionCallForSepParams(mfci, f2, called, tenv.getModule(), params)) != mfci) {
            mfci = (ModuleFunctionCallInstruction)newFunctionCall;
            called = this.resolveFunction(tenv, mfci);
            mfci.typeCheckReduced(tenv, f2.getBindingEnvironment(), new LinkedList<Function>());
            this.setFunctionNeedsTypecheck(true);
        }
        if ("create-string-item".equals(mfci.getFunction())) {
            return this.processCreateStringItemCall(mfci);
        }
        return mfci;
    }

    private Instruction processFunctionCallInstruction(FunctionCallInstruction fci) {
        Instruction newFunctionCall;
        int savedParamPushDepth;
        Function f2 = this.m_currentFunction;
        TypeEnvironment tenv = this.m_currentFunction.getTypeEnvironment();
        if (tenv == null) {
            return fci;
        }
        Function called = tenv.getModule().getFunction(fci.getFunction());
        this.enqueueFunction(called);
        if (LOG) {
            savedParamPushDepth = this.paramPushDepth;
            this.logln(fci.getClass().getSimpleName() + this.getTypeString(fci) + ": " + called.getName());
            this.paramPushDepth = 1;
        } else {
            savedParamPushDepth = 0;
        }
        Instruction[] params = fci.getParameters();
        this.processParams(params);
        if (LOG) {
            --this.paramPushDepth;
        }
        if ((newFunctionCall = this.optimizeFunctionCallForSequenceParams(fci, f2, called, tenv.getModule(), params)) != fci) {
            fci = (FunctionCallInstruction)newFunctionCall;
            params = fci.getParameters();
            called = tenv.getModule().getFunction(fci.getFunction());
            fci.typeCheckReduced(tenv, f2.getBindingEnvironment(), new LinkedList<Function>());
            this.setFunctionNeedsTypecheck(true);
        }
        if ((newFunctionCall = this.optimizeFunctionCallForSepParams(fci, f2, called, tenv.getModule(), params)) != fci) {
            fci = (FunctionCallInstruction)newFunctionCall;
            called = tenv.getModule().getFunction(fci.getFunction());
            fci.typeCheckReduced(tenv, f2.getBindingEnvironment(), new LinkedList<Function>());
            this.setFunctionNeedsTypecheck(true);
        }
        String funcname = fci.getFunction();
        boolean mightHaveChanged = false;
        Instruction n2 = null;
        if (funcname.equals("xslt2$create-string-item")) {
            n2 = this.processCreateStringItemCall(fci);
            mightHaveChanged = true;
        } else if (funcname.equals("xslt2$fn:data-1") || funcname.equals("xslt2$fn:data-1-item")) {
            n2 = this.processFnData1Call(fci, f2);
            mightHaveChanged = true;
        } else if (funcname.equals("xslt2$effective-boolean-value")) {
            n2 = this.processFnEffectiveBooleanValueCall(fci, f2);
            mightHaveChanged = true;
        } else if (funcname.equals("xslt2$checkSequenceToOneItemOrEmptyForOperator")) {
            n2 = this.processCheckSequenceToOneItemOrEmptyForOperatorCall(fci, f2);
            mightHaveChanged = true;
        } else if (funcname.equals("xslt2$do-check-final-step-result")) {
            n2 = this.processDoCheckFinalStepResult(fci, f2);
            mightHaveChanged = true;
        } else if (funcname.equals("xslt2$do-check-inner-path-nodes-only")) {
            n2 = this.processDoCheckInnerPathNodesOnly(fci, f2);
            mightHaveChanged = true;
        } else if (funcname.equals("xslt2$do-check-context-is-node")) {
            n2 = this.processDoCheckContextIsNode(fci, f2);
            mightHaveChanged = true;
        } else if (funcname.equals("xslt2$fn:string-1")) {
            n2 = this.processFnString1Call(fci);
            mightHaveChanged = true;
        } else if (funcname.equals("xslt2$fn:string-0")) {
            n2 = this.processFnString02Call(fci);
            mightHaveChanged = true;
        } else if (funcname.equals("xslt2$fn:string-2")) {
            n2 = this.processFnString02Call(fci);
            mightHaveChanged = true;
        } else if (funcname.equals("xslt2$value-of-bc-item")) {
            n2 = this.processValueOfBCItemCall(fci);
            mightHaveChanged = true;
        } else if (funcname.equals("xslt2$context-item-expression")) {
            n2 = this.processContextItemExpressionCall(fci);
            mightHaveChanged = true;
        } else if (funcname.equals("xslt2$do-check-final-step-result-item-result")) {
            n2 = this.processDoCheckFinalStepResultItemResultCall(fci);
            mightHaveChanged = true;
        } else if (funcname.equals("xslt2$do-check-nodes-only")) {
            n2 = this.processDoCheckNodesOnlyCall(fci);
            mightHaveChanged = true;
        }
        if (LOG) {
            this.paramPushDepth = savedParamPushDepth;
        }
        if (mightHaveChanged) {
            n2.typeCheckReduced(tenv, f2.getBindingEnvironment(), new LinkedList<Function>());
            this.setFunctionNeedsTypecheck(true);
            return n2;
        }
        return fci;
    }

    private Instruction processAtomizationToStringInstruction(Instruction a2s) {
        FunctionCallInstruction fns1;
        FunctionCallInstruction vobi;
        Instruction arg2 = this.findValueSource(a2s.getChildInstruction(0));
        if (arg2 instanceof FunctionCallInstruction && (vobi = (FunctionCallInstruction)arg2).getFunction().equals("xslt2$value-of-bc-item") && (arg2 = this.findValueSource(vobi.getChildInstruction(0))) instanceof FunctionCallInstruction && (fns1 = (FunctionCallInstruction)arg2).getFunction().equals("xslt2$fn:string-1")) {
            a2s.setChildInstruction(0, fns1.getChildInstruction(0));
            this.setFunctionNeedsTypecheck(true);
        }
        return a2s;
    }

    private Instruction processGetLastInstruction(Instruction gl) {
        XType xtype;
        Type ctype;
        Instruction value2 = gl.getChildInstruction(0);
        Instruction returned = gl;
        if (sXTypeOpt && (ctype = value2.getCachedType()) instanceof XDMSequenceType && (xtype = ((XDMSequenceType)ctype).getXType()).isSubtype(XType.s_item)) {
            returned = LiteralInstruction.integerLiteral(1);
            if (REWRITELOG) {
                this.logxtypeln("[FIL][get-last]Rewriting from: " + gl + " to: " + returned);
            }
        }
        return returned;
    }

    private Instruction processContextItemExpressionCall(Instruction fci) {
        PrimitiveArithmeticInstruction ai;
        Instruction test2 = this.findValueSource(fci.getChildInstruction(1));
        if (test2 instanceof PrimitiveArithmeticInstruction && (ai = (PrimitiveArithmeticInstruction)test2).getOperation() == 0) {
            boolean valueOK = true;
            for (int i = 0; i < 2; ++i) {
                Instruction param = ai.getChildInstruction(i);
                Instruction operand2 = this.findValueSource(param);
                if (operand2 instanceof LiteralInstruction) {
                    LiteralInstruction li = (LiteralInstruction)operand2;
                    if (li.getType() == IntType.s_intType && (Integer)li.getValue() >= 0) continue;
                    valueOK = false;
                    continue;
                }
                if (operand2 instanceof IteratorInstruction && param instanceof IdentifierInstruction) {
                    Object varname;
                    IteratorInstruction ii = (IteratorInstruction)operand2;
                    Object indexname = ii.getIndexVar();
                    if (indexname.equals(varname = ((IdentifierInstruction)param).getVariable())) continue;
                    valueOK = false;
                    continue;
                }
                valueOK = false;
            }
            if (valueOK) {
                fci = fci.getChildInstruction(0);
            }
        }
        return fci.cloneReduced();
    }

    private Instruction processContextIsNodeOnlyInstruction(Instruction cinoi) {
        return null;
    }

    private Instruction processDoCheckNodesOnlyCall(Instruction fci) {
        Instruction test2 = fci.getChildInstruction(0);
        Instruction testsource = this.findValueSource(test2);
        if (testsource instanceof GetAxisCursorInstruction) {
            if (((GetAxisCursorInstruction)testsource).isDocumentOrdered()) {
                return test2;
            }
            return new DocOrderInstruction(test2);
        }
        Type testtype = test2.getCachedType();
        XType xt = ((XDMSequenceType)testtype).getXType();
        if (testtype instanceof XDMItemType) {
            if (xt.isSubtype(XType.s_nodeStar)) {
                return test2;
            }
            return fci;
        }
        if (xt.isSubtype(XType.s_node)) {
            return test2;
        }
        if (xt.isSubtype(XType.s_nodeStar)) {
            return new DocOrderInstruction(test2);
        }
        return fci;
    }

    private Instruction processDocOrderInstruction(Instruction doi) {
        Instruction test2 = doi.getChildInstruction(0);
        Instruction testsource = this.findValueSource(test2);
        Type testtype = test2.getCachedType();
        if (testsource instanceof XPathStepInstruction) {
            return test2;
        }
        if (testtype != null) {
            XType xt = ((XDMSequenceType)testtype).getXType();
            if (xt.isSubtype(XType.s_node)) {
                return test2;
            }
        } else {
            if (testsource instanceof GetAxisCursorInstruction) {
                Axis axis = ((GetAxisCursorInstruction)testsource).getAxis();
                if (axis != Axis.FILTEREDLIST) {
                    return test2;
                }
                return new DocOrderInstruction(test2);
            }
            Type testsourceType = testsource == null ? null : testsource.getCachedType();
            return doi;
        }
        return doi;
    }

    private Instruction processValueOfBCItemCall(Instruction fci) {
        ConstructXDMItemAtomInstruction cxi;
        Instruction value2 = this.findValueSource(fci.getChildInstruction(0));
        if (value2 instanceof ConstructXDMItemAtomInstruction && (cxi = (ConstructXDMItemAtomInstruction)value2).getItemKind() == ItemKind.String) {
            fci = new CreateTextInstruction(cxi.getChildInstruction(0));
        }
        return fci.cloneReduced();
    }

    private Instruction processFnString02Call(Instruction fci) {
        PrimitiveArithmeticInstruction ai;
        Instruction testsource = this.findValueSource(fci.getChildInstruction(1));
        if (testsource instanceof PrimitiveArithmeticInstruction && (ai = (PrimitiveArithmeticInstruction)testsource).getOperation() == 0) {
            boolean valueOK = true;
            for (int i = 0; i < 2; ++i) {
                Instruction param = ai.getChildInstruction(i);
                Instruction operand2 = this.findValueSource(param);
                if (operand2 instanceof LiteralInstruction) {
                    LiteralInstruction li = (LiteralInstruction)operand2;
                    if (li.getType() == IntType.s_intType && (Integer)li.getValue() >= 0) continue;
                    valueOK = false;
                    continue;
                }
                if (operand2 instanceof IteratorInstruction && param instanceof IdentifierInstruction) {
                    Object varname;
                    IteratorInstruction ii = (IteratorInstruction)operand2;
                    Object indexname = ii.getIndexVar();
                    if (indexname.equals(varname = ((IdentifierInstruction)param).getVariable())) continue;
                    valueOK = false;
                    continue;
                }
                valueOK = false;
            }
            if (valueOK) {
                fci = new GetStringValueXDMItemInstruction(fci.getChildInstruction(0));
            }
        }
        return fci.cloneReduced();
    }

    private Instruction processFnString1Call(Instruction fci) {
        ConstructXDMItemAtomInstruction cxi;
        Instruction value2 = this.findValueSource(fci.getChildInstruction(0));
        if (value2 instanceof ConstructXDMItemAtomInstruction && (cxi = (ConstructXDMItemAtomInstruction)value2).getItemKind() == ItemKind.String) {
            cxi = (ConstructXDMItemAtomInstruction)cxi.cloneReduced();
            Integer xsstringvar = ReductionHelper.generateIntermediateIdentifier2();
            Integer typvar = ReductionHelper.generateIntermediateIdentifier2();
            cxi.setChildInstruction(1, new IdentifierInstruction(typvar));
            fci = new LetInstruction(typvar, new XPathDataTypeLiteralInstruction(new IdentifierInstruction(xsstringvar)), cxi);
            fci = new LetInstruction(xsstringvar, new StreamInstruction("xs:string"), fci);
            fci = new ChooseInstruction(new ChooseInstruction.Case[]{new ChooseInstruction.Case(LiteralInstruction.booleanTrueLiteral(), fci)}, null);
            this.setFunctionNeedsTypecheck(true);
        }
        return fci;
    }

    private Instruction processFnData1Call(Instruction fci, Function f2) {
        Instruction value2 = fci.getChildInstruction(0);
        if (sXTypeOpt) {
            XType xtype;
            Type ctype = value2.getCachedType();
            if (ctype instanceof XDMSequenceType) {
                XType xtype2 = ((XDMSequenceType)ctype).getXType();
                if (xtype2.isSubtype(XType.s_atomicStar)) {
                    Instruction origvalue = this.findValueSource(value2);
                    Instruction origfci = fci;
                    if (origvalue != null) {
                        fci = origvalue.cloneReduced();
                    }
                    if (REWRITELOG) {
                        this.logxtypeln("[FIL][fn:data]Rewriting from: " + origfci + " to: " + fci);
                    }
                }
            } else if (ctype instanceof XDMItemType && (xtype = ((XDMItemType)ctype).getXType()).isSubtype(XType.s_atomic)) {
                Instruction origfci = fci;
                fci = new XDMSequenceInstruction(value2.cloneReduced());
                if (REWRITELOG) {
                    this.logxtypeln("[FIL][fn:data-item-1]Rewriting from: " + origfci + " to: " + fci);
                }
            }
        }
        return fci;
    }

    private Instruction processFnEffectiveBooleanValueCall(Instruction fci, Function f2) {
        Type ctype;
        Instruction value2 = fci.getChildInstruction(0);
        if (sXTypeOpt && this.functionStillAlive(f2, "xslt2$effective-boolean-value-of-boolean") && (ctype = value2.getCachedType()) instanceof XDMSequenceType) {
            XType xtype = ((XDMSequenceType)ctype).getXType();
            if (xtype.isSubtype(NamedXTypeConstants.s_xsBoolean)) {
                Instruction origvalue = this.findValueSource(value2);
                Instruction origfci = fci;
                if (origvalue != null) {
                    fci = this.genFunctionCall(this.fCurrentModule.getFunction("xslt2$effective-boolean-value-of-boolean"), new Instruction[]{value2.cloneReduced()}, fci.getType(f2.getTypeEnvironment(), f2.getBindingEnvironment()));
                }
                if (REWRITELOG) {
                    this.logxtypeln("[FIL][fn:effective-boolean-value]Rewriting from: " + origfci + " to: " + fci);
                }
            } else if (xtype.isSubtype(XType.s_nodeStar)) {
                Instruction origvalue = this.findValueSource(value2);
                Instruction origfci = fci;
                if (origvalue != null) {
                    Integer isempty = ReductionHelper.generateIntermediateIdentifier2();
                    Integer isnotempty = ReductionHelper.generateIntermediateIdentifier2();
                    ChooseInstruction inei = new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), (Instruction)new LetInstruction(isempty, new IsEmptyInstruction(value2), new LetInstruction(isnotempty, new NotInstruction(new IdentifierInstruction(isempty)), new IdentifierInstruction(isnotempty))), null);
                    if (REWRITELOG) {
                        this.logxtypeln("[FIL][fn:effective-boolean-value]Rewriting from: " + origfci + " to: " + inei);
                    }
                    return inei;
                }
            }
        }
        return fci;
    }

    private void enqueueFunction(Function registrant) {
        if (LOG) {
            this.logln("Adding function " + registrant.getName() + " to set of functions to process");
        }
        if (!this.fFoundFunctions.contains(registrant)) {
            this.fFunctionsToProcess.add(registrant);
            this.fFoundFunctions.add(registrant);
        }
    }

    private FunctionCallInstruction genFunctionCall(Function func, Instruction[] params, Type resultType) {
        this.enqueueFunction(func);
        return new FunctionCallInstruction(func.getName(), params, resultType);
    }

    private ModuleFunctionCallInstruction genModuleFunctionCall(Function func, Instruction[] params) {
        this.enqueueFunction(func);
        return new ModuleFunctionCallInstruction(func.getModule().getName(), func.getName(), params);
    }

    private boolean functionStillAlive(Function f2, String functionName) {
        return f2.getTypeEnvironment().getModule().getFunction(functionName) != null;
    }

    private Instruction processCheckSequenceToOneItemOrEmptyForOperatorCall(Instruction fci, Function f2) {
        XType xtype;
        Type ctype;
        Instruction value2 = fci.getChildInstruction(0);
        if (sXTypeOpt && (ctype = value2.getCachedType()) instanceof XDMSequenceType && (xtype = ((XDMSequenceType)ctype).getXType()).isSubtype(XType.s_item)) {
            Instruction origfci = fci;
            fci = new ContextItemInstruction(value2.cloneReduced());
            if (REWRITELOG) {
                this.logxtypeln("[FIL][checkSequenceToOneItemOrEmptyForOperator]Rewriting from: " + origfci + " to: " + fci);
            }
        }
        return fci;
    }

    private Instruction processDoCheckFinalStepResult(Instruction fci, Function f2) {
        XType xtype;
        Type ctype;
        Instruction value2 = fci.getChildInstruction(0);
        if (sXTypeOpt && (ctype = value2.getCachedType()) instanceof XDMSequenceType && (xtype = ((XDMSequenceType)ctype).getXType()).isSubtype(XType.s_nodeStar)) {
            Instruction origfci = fci;
            fci = new DocOrderInstruction(value2.cloneReduced());
            if (REWRITELOG) {
                this.logxtypeln("[FIL][do-check-final-step]Rewriting from: " + origfci + " to: " + fci);
            }
        }
        return fci;
    }

    private Instruction processDoCheckInnerPathNodesOnly(Instruction fci, Function f2) {
        XType xtype;
        Type ctype;
        Instruction value2 = fci.getChildInstruction(0);
        if (sXTypeOpt && (ctype = value2.getCachedType()) instanceof XDMSequenceType && (xtype = ((XDMSequenceType)ctype).getXType()).isSubtype(XType.s_nodeStar)) {
            Instruction origfci = fci;
            fci = new DocOrderInstruction(value2.cloneReduced());
            if (REWRITELOG) {
                this.logxtypeln("[FIL][do-check-inner-path]Rewriting from: " + origfci + " to: " + fci);
            }
        }
        return fci;
    }

    private Instruction processDoCheckContextIsNode(Instruction fci, Function f2) {
        XType xtype;
        Type ctype;
        Instruction value2 = fci.getChildInstruction(0);
        if (sXTypeOpt && (ctype = value2.getCachedType()) instanceof XDMItemType && (xtype = ((XDMItemType)ctype).getXType()).isSubtype(XType.s_unstable_node)) {
            Instruction origfci = fci;
            fci = value2.cloneReduced();
            if (REWRITELOG) {
                this.logxtypeln("[FIL][do-check-context-is-node]Rewriting from: " + origfci + " to: " + fci);
            }
        }
        return fci;
    }

    private Instruction processDoCheckFinalStepResultItemResultCall(Instruction fci) {
        IdentifierInstruction maybeItemID;
        IBinding innerBinding1;
        Type innerType1;
        Instruction value2 = this.findValueSource(fci.getChildInstruction(0));
        if (value2 instanceof XDMSequenceInstruction && value2.getChildInstructionCount() == 1 && (innerType1 = this.getBindingType(innerBinding1 = this.getBindingFromIdentifier(maybeItemID = (IdentifierInstruction)value2.getChildInstruction(0)), this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment())) instanceof XDMItemType) {
            fci = maybeItemID;
        }
        return fci.cloneReduced();
    }

    private Instruction processCreateStringItemCall(Instruction fci) {
        Instruction separator;
        FunctionCallInstruction vobi;
        Instruction value2 = this.findValueSource(fci.getChildInstruction(0));
        if (value2 instanceof FunctionCallInstruction && "xslt2$value-of-bc-item".equals((vobi = (FunctionCallInstruction)value2).getFunction()) && this.isLiteralEmptyStringItem(separator = this.findValueSource(fci.getChildInstruction(1)))) {
            Instruction emptyCharStream = separator.getChildInstruction(0);
            fci = new AtomizationToStringInstruction(fci.getChildInstruction(0), emptyCharStream);
            Function f2 = this.m_currentFunction;
            fci.typeCheckReduced(f2.getTypeEnvironment(), f2.getBindingEnvironment(), new LinkedList<Function>());
            this.setFunctionNeedsTypecheck(true);
        }
        return fci;
    }

    boolean isLiteralEmptyStringItem(Instruction i) {
        Instruction value2;
        return i instanceof ConstructXDMItemAtomInstruction && (value2 = this.findValueSource(i.getChildInstruction(0))) instanceof StreamInstruction && 0 == value2.getChildInstructionCount() && CharType.s_charType == ((StreamInstruction)value2).getElementType();
    }

    private Instruction findValueSource(Instruction i) {
        Object o = i;
        while (o instanceof IdentifierInstruction) {
            if ((o = this.getBindingFromIdentifier((IdentifierInstruction)o)) instanceof LetInstruction) {
                o = ((Instruction)o).getChildInstruction(0);
                continue;
            }
            if (o instanceof IBinding) {
                o = ((IBinding)o).getOrigin();
                continue;
            }
            o = null;
        }
        return o;
    }

    private Instruction optimizeFunctionCallForSepParams(Instruction functionCallInstruction, Function f2, Function called, Module m, Instruction[] params) {
        Binding[] bindingsVarient;
        String fNameItemVarient;
        Function fItemVarient;
        String fName;
        Binding[] bindings = called.getParameters();
        boolean LOGMETHOD = false;
        boolean LOGSUCCESS = false;
        if (null != f2 && !(fName = called.getName()).endsWith("-default-sep") && (fItemVarient = m.getFunction(fNameItemVarient = fName + "-default-sep")) != null && (bindingsVarient = fItemVarient.getParameters()).length == params.length - 1) {
            Instruction[] refactoredParamValueInstructions = new Instruction[bindingsVarient.length];
            boolean canRemap = false;
            int refactoredParamValueInstructionsPos = 0;
            for (int i = 0; i < bindings.length; ++i) {
                LetInstruction letInstrForBindingForParamValueInstruction;
                Instruction paramValueInstructionGeneric = params[i];
                if (refactoredParamValueInstructionsPos < refactoredParamValueInstructions.length) {
                    refactoredParamValueInstructions[refactoredParamValueInstructionsPos] = paramValueInstructionGeneric;
                }
                ++refactoredParamValueInstructionsPos;
                Binding binding = bindings[i];
                Type paramType = this.getBindingType(binding, f2.getTypeEnvironment(), f2.getBindingEnvironment());
                if (!(paramType instanceof XDMItemType)) continue;
                if (false | LOG) {
                    this.logln("*** Testing to see if we can call: " + fItemVarient.getName());
                }
                Binding varientBinding = bindingsVarient[i];
                Type vBindType = this.getBindingType(varientBinding, f2.getTypeEnvironment(), f2.getBindingEnvironment());
                if (!(paramValueInstructionGeneric instanceof IdentifierInstruction)) continue;
                IdentifierInstruction paramValueInstruction = (IdentifierInstruction)params[i];
                IBinding bindingForParamValueInstruction = this.getBindingFromIdentifier(paramValueInstruction);
                if (bindingForParamValueInstruction == null) {
                    if (false | LOG) {
                        this.logln("*** !!No binding for parm " + i + " for: " + fItemVarient.getName());
                    }
                    canRemap = false;
                    break;
                }
                Type vParamInstrType = this.getBindingType(bindingForParamValueInstruction, f2.getTypeEnvironment(), f2.getBindingEnvironment());
                if (vBindType.equals(vParamInstrType) || !(vParamInstrType instanceof XDMItemType)) continue;
                if (false | LOG) {
                    this.logln("*** Trying to map parm " + i + " for: " + fItemVarient.getName());
                }
                if (null == (letInstrForBindingForParamValueInstruction = bindingForParamValueInstruction.getLet())) {
                    canRemap = false;
                    break;
                }
                Instruction value2 = letInstrForBindingForParamValueInstruction.getValue();
                if (value2 instanceof ConstructXDMItemAtomInstruction) {
                    ConstructXDMItemAtomInstruction constructXDMItemAtomInstruction = (ConstructXDMItemAtomInstruction)value2;
                    int nChildren = constructXDMItemAtomInstruction.getChildInstructionCount();
                    if (nChildren == 2) {
                        Instruction identifierToCharStreamMaybe = constructXDMItemAtomInstruction.getChildInstruction(0);
                        if (identifierToCharStreamMaybe instanceof IdentifierInstruction) {
                            IBinding innerBinding2 = this.getBindingFromIdentifier((IdentifierInstruction)identifierToCharStreamMaybe);
                            Type innerType2 = this.getBindingType(innerBinding2, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment());
                            if (innerType2 instanceof StreamType && ((StreamType)innerType2).getElementType().equals(CharType.s_charType, f2.getTypeEnvironment())) {
                                LetInstruction innerLet2;
                                if (false | LOG) {
                                    this.logln("*** Success map parm " + i + " for: " + fItemVarient.getName());
                                }
                                if ((innerLet2 = innerBinding2.getLet()) == null) {
                                    canRemap = false;
                                    break;
                                }
                                Instruction value3 = innerLet2.getValue();
                                if (value3 instanceof StreamInstruction) {
                                    StreamInstruction stringStreamMaybe = (StreamInstruction)value3;
                                    if (stringStreamMaybe.getElementType().equals(CharType.s_charType)) {
                                        String stringContent = stringStreamMaybe.getStringContent();
                                        if (stringContent != null && stringContent.equals(" ")) {
                                            canRemap = true;
                                            --refactoredParamValueInstructionsPos;
                                            continue;
                                        }
                                        canRemap = false;
                                        break;
                                    }
                                    canRemap = false;
                                    break;
                                }
                                canRemap = false;
                                break;
                            }
                            canRemap = false;
                            break;
                        }
                        canRemap = false;
                        break;
                    }
                    canRemap = false;
                    break;
                }
                canRemap = false;
                break;
            }
            if (canRemap) {
                if (false | LOG) {
                    this.logln("*** Success specialized call to: " + fItemVarient.getName());
                }
                if (functionCallInstruction instanceof ModuleFunctionCallInstruction) {
                    functionCallInstruction = this.genModuleFunctionCall(fItemVarient, refactoredParamValueInstructions);
                } else {
                    FunctionCallInstruction fci = (FunctionCallInstruction)functionCallInstruction;
                    functionCallInstruction = this.genFunctionCall(fItemVarient, refactoredParamValueInstructions, fci.getType(f2.getTypeEnvironment(), f2.getBindingEnvironment()));
                }
            } else if (false | LOG) {
                this.logln("*** Can't do specialized call to: " + fName);
            }
        }
        return functionCallInstruction;
    }

    private Instruction optimizeFunctionCallForSequenceParams(Instruction functionCallInstruction, Function f2, Function called, Module m, Instruction[] params) {
        Binding[] bindings = called.getParameters();
        boolean LOGMETHOD = false;
        return functionCallInstruction;
    }

    private void processParams(Instruction[] params) {
        for (int i = 0; i < params.length; ++i) {
            this.isParamPush = true;
            Instruction instruction2 = params[i];
            this.optimize(instruction2);
        }
    }

    private Function resolveFunction(TypeEnvironment tenv, ModuleFunctionCallInstruction mfci) {
        Module m = tenv.getModule().getProgram().getModule(mfci.getModule());
        if (m == null) {
            return null;
        }
        return m.getPublicFunction(mfci.getFunction());
    }

    @Override
    protected void optimizeChildren(Instruction n2) {
        ++this.nestCount;
        super.optimizeChildren(n2);
        --this.nestCount;
    }
}

