/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.GetAxisCursorInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.GetTypedAxisCursorInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.IsEmptyInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.IsSingletonInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.XPathStepInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.DeconstructMatchXDMItemInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.ForEachXDMSequenceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.MatchXDMItemInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.UnboxXDMItemInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSeqBaseType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.dataflow.ForkInformation;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetBaseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NotInstruction;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.exec.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Logger;

public class XPathStepOptimizer
extends Optimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(XPathStepOptimizer.class);
    private static final String s_className = XPathStepOptimizer.class.getName();
    public static final String OPTIMIZE_MATCH_OPTION = "optimizeMatch";
    public static final boolean sOptimizeMatch = !HiddenOptions.wasSpecified("optimizeMatch") || !HiddenOptions.optionValueIs("optimizeMatch", "off");
    public static final String OPTIMIZE_CHOOSE_OPTION = "optimizeChoose";
    public static final boolean sOptimizeChoose = !HiddenOptions.wasSpecified("optimizeChoose") || !HiddenOptions.optionValueIs("optimizeChoose", "off");
    public static final String OPTIMIZE_SHOWMATCH_OPTION = "showOptimizeMatchOptimizations";
    public static final boolean showOptimizations = HiddenOptions.wasSpecified("showOptimizeMatchOptimizations") && !HiddenOptions.optionValueIs("showOptimizeMatchOptimizations", "off");
    int nestCount = 0;
    private static final boolean LOG = HiddenOptions.optionValueIs("CursorAnalyzerLog", "on");
    int paramPushDepth = 0;
    boolean isParamPush = false;
    static final String INDENTSTRING = "  ";
    BindingEnvironment lambdaFreeBindings = null;

    public XPathStepOptimizer() {
        this.isTypeReparing = true;
    }

    private final boolean log(String s) {
        System.out.print(s);
        return true;
    }

    private final boolean logln(String s) {
        System.out.println(s);
        return true;
    }

    private final boolean logIndent() {
        if (LOG) {
            int i;
            for (i = 0; i < this.nestCount; ++i) {
                this.log(INDENTSTRING);
            }
            if (this.isParamPush) {
                for (i = 0; i < this.paramPushDepth; ++i) {
                    this.log("*");
                }
                this.log("->");
                this.isParamPush = false;
            }
        }
        return true;
    }

    @Override
    public Instruction optimize(Instruction n2) {
        return super.optimize(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optimizeFunction(Function f2) {
        BindingEnvironment savedLambdaFreeBindings = this.lambdaFreeBindings;
        try {
            this.lambdaFreeBindings = null;
            if (LOG) {
                this.logIndent();
            }
            if (LOG) {
                this.logln("function declaration: " + f2.getName() + "@" + f2.getReturnType());
            }
            ++this.nestCount;
            super.optimizeFunction(f2);
            --this.nestCount;
            if (LOG) {
                this.logIndent();
            }
            if (LOG) {
                this.logln("leaving optimizeFunction: " + f2.getName() + " - stackFrameSize: " + f2.getStackFrameSize() + " (bindingsEnvSize: " + f2.getBindingEnvironment().getSize());
            }
        }
        finally {
            this.lambdaFreeBindings = savedLambdaFreeBindings;
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction n2) {
        if (LOG) {
            this.logIndent();
        }
        if (n2 instanceof ForEachXDMSequenceInstruction) {
            Instruction n22 = this.tryToOptimizeSimpleStep((ForEachXDMSequenceInstruction)n2);
            if (n22 != n2) {
                return n22;
            }
        } else {
            if (n2 instanceof ChooseInstruction && sOptimizeChoose) {
                ChooseInstruction choose = (ChooseInstruction)n2;
                Instruction defaultHandler = choose.getDefaultHandler();
                ChooseInstruction.Case[] cases = choose.getCases();
                int nCases = cases.length;
                ArrayList<ChooseInstruction.Case> newCases = new ArrayList<ChooseInstruction.Case>();
                boolean testedIsEmpty = false;
                for (int i = 0; i < nCases; ++i) {
                    ChooseInstruction.Case casex = cases[i];
                    boolean keepCase = true;
                    Instruction test2 = casex.getTest();
                    if (test2 instanceof IdentifierInstruction) {
                        Instruction resolvedInnerTestIdent;
                        NotInstruction notInstruction;
                        Instruction innerTestIdent;
                        Instruction resolvedTest = this.resolveIdentifier(test2);
                        if (resolvedTest instanceof IsEmptyInstruction) {
                            IsEmptyInstruction isEmptyTest = (IsEmptyInstruction)resolvedTest;
                            keepCase = this.canBeEmpty(isEmptyTest);
                            testedIsEmpty = true;
                        } else if (resolvedTest instanceof IsSingletonInstruction) {
                            boolean mustBeSingletonOrEmpty;
                            IsSingletonInstruction isSingletonInstruction = (IsSingletonInstruction)resolvedTest;
                            boolean mustBeSingleton = this.mustBeSingleton(isSingletonInstruction);
                            if (mustBeSingleton && i + 1 == nCases) {
                                defaultHandler = null;
                            } else if (testedIsEmpty && (mustBeSingletonOrEmpty = this.mustBeSingletonOrEmpty(isSingletonInstruction)) && i + 1 == nCases) {
                                defaultHandler = null;
                            }
                        } else if (resolvedTest instanceof NotInstruction && (innerTestIdent = (notInstruction = (NotInstruction)resolvedTest).getOperand()) instanceof IdentifierInstruction && (resolvedInnerTestIdent = this.resolveIdentifier(innerTestIdent)) instanceof IsEmptyInstruction) {
                            boolean cantBeEmpty;
                            IsEmptyInstruction isEmptyTest = (IsEmptyInstruction)resolvedInnerTestIdent;
                            boolean bl = cantBeEmpty = !this.canBeEmpty(isEmptyTest);
                            if (cantBeEmpty && i + 1 == nCases) {
                                defaultHandler = null;
                            }
                        }
                    }
                    if (!keepCase) continue;
                    newCases.add(casex);
                }
                boolean didChange = false;
                int origSize = choose.getChildInstructionCount();
                Instruction replacement = choose;
                int newCasesSz = newCases.size();
                if (newCasesSz == 0) {
                    if (defaultHandler != null) {
                        replacement = defaultHandler;
                        didChange = true;
                        if (showOptimizations) {
                            System.out.println("DEBUG: choose: unwrap to default handler, " + this.getClass().getName());
                        }
                    }
                } else if (newCases.size() == 1 && defaultHandler == null) {
                    replacement = ((ChooseInstruction.Case)newCases.get(0)).getHandler();
                    didChange = true;
                    if (showOptimizations) {
                        System.out.println("DEBUG: choose: unwrap to single inner case, " + this.getClass().getName());
                    }
                } else if (newCases.size() < cases.length) {
                    ChooseInstruction.Case[] casesRedux = new ChooseInstruction.Case[newCases.size()];
                    newCases.toArray(casesRedux);
                    choose.setCases(casesRedux);
                    choose.setDefaultHandler(defaultHandler);
                    didChange = true;
                    if (showOptimizations) {
                        System.out.println("DEBUG: choose: reducing number of cases from " + origSize + " to " + replacement.getChildInstructionCount() + ", " + this.getClass().getName());
                    }
                } else if (choose.getDefaultHandler() != defaultHandler) {
                    didChange = true;
                    choose.setDefaultHandler(defaultHandler);
                    if (showOptimizations) {
                        System.out.println("DEBUG: choose: changing the default handler to: " + (defaultHandler == null ? "null" : defaultHandler.getClass().getSimpleName()) + ", " + this.getClass().getName());
                    }
                }
                if (didChange) {
                    this.setFunctionNeedsTypecheck(true);
                }
                return replacement;
            }
            if (n2 instanceof MatchXDMItemInstruction && sOptimizeMatch) {
                MatchXDMItemInstruction mxi = (MatchXDMItemInstruction)n2;
                if (mxi.getCachedType() == null) {
                    return n2;
                }
                Instruction defaultHandler = mxi.getDefault();
                XType toMatchXType = mxi.getToMatchXType();
                if (toMatchXType != XDMItemType.s_itemType.getXType()) {
                    boolean needsDefaultHandler;
                    toMatchXType = toMatchXType.factor();
                    assert (toMatchXType != null);
                    DeconstructMatchXDMItemInstruction[] matches2 = mxi.getMatches();
                    ArrayList<DeconstructMatchXDMItemInstruction> reconstructedMatches = new ArrayList<DeconstructMatchXDMItemInstruction>();
                    ArrayList<XType> typesThatCanMatch = new ArrayList<XType>();
                    for (int i = 0; i < matches2.length; ++i) {
                        DeconstructMatchXDMItemInstruction match = matches2[i];
                        XType matchXType = match.getXTypeFromMatch();
                        assert (matchXType != null);
                        if (!toMatchXType.canMatchWith(matchXType)) continue;
                        reconstructedMatches.add(match);
                        typesThatCanMatch.add(matchXType);
                    }
                    int numberPossibleMatches = reconstructedMatches.size();
                    if (numberPossibleMatches == 0) {
                        if (defaultHandler == null) {
                            if (showOptimizations) {
                                System.out.println("WARNING: No default case when input can't match! " + this.getClass().getName());
                            }
                            return n2;
                        }
                        this.setFunctionNeedsTypecheck(true);
                        if (showOptimizations) {
                            System.out.println("DEBUG: reducing to default handler... " + this.getClass().getName());
                        }
                        return defaultHandler;
                    }
                    boolean bl = needsDefaultHandler = !toMatchXType.canMatchOnly(typesThatCanMatch);
                    if (!needsDefaultHandler && numberPossibleMatches == 1) {
                        UnboxXDMItemInstruction uxi = new UnboxXDMItemInstruction(mxi.getToMatch(), (DeconstructMatchXDMItemInstruction)reconstructedMatches.get(0));
                        this.setFunctionNeedsTypecheck(true);
                        if (showOptimizations) {
                            System.out.println("DEBUG: reducing to unbox... " + this.getClass().getName());
                        }
                        mxi.setToMatch(null);
                        mxi.clearCachedType();
                        mxi.setDefault(null);
                        mxi.setMatches(null);
                        return uxi;
                    }
                    if (needsDefaultHandler && numberPossibleMatches == matches2.length) {
                        return n2;
                    }
                    if (!needsDefaultHandler) {
                        if (showOptimizations) {
                            System.out.println("DEBUG: removing default handler... " + this.getClass().getName());
                        }
                        mxi.setDefault(null);
                    }
                    if (showOptimizations) {
                        System.out.println("DEBUG: reducing number of cases from " + matches2.length + " to " + numberPossibleMatches + ", " + this.getClass().getName());
                    }
                    DeconstructMatchXDMItemInstruction[] dmxa = new DeconstructMatchXDMItemInstruction[numberPossibleMatches];
                    for (int i = 0; i < numberPossibleMatches; ++i) {
                        dmxa[i] = (DeconstructMatchXDMItemInstruction)reconstructedMatches.get(i);
                    }
                    mxi.setMatches(dmxa);
                    this.setFunctionNeedsTypecheck(true);
                    return mxi;
                }
            }
        }
        return n2 != null ? super.optimizeStep(n2) : n2;
    }

    private boolean canBeEmpty(IsEmptyInstruction isEmptyTest) {
        Instruction sourceToEmptyTest = isEmptyTest.getOperand();
        boolean canBeEmpty = this.sourceCanBeEmpty(sourceToEmptyTest);
        return canBeEmpty;
    }

    private boolean sourceCanBeEmpty(Instruction sourceToEmptyTest) {
        boolean canBeEmpty;
        Type sourceTypeGeneric = sourceToEmptyTest.getCachedType();
        if (!((sourceTypeGeneric = sourceTypeGeneric.resolveType(this.getCurrentFunction().getTypeEnvironment())) instanceof TypeVariable)) {
            XDMSeqBaseType sourceType = (XDMSeqBaseType)sourceTypeGeneric;
            if (null != sourceType) {
                XType xtype = sourceType.getXType();
                int quantifier = xtype.quantifier();
                switch (quantifier) {
                    case -2: 
                    case 0: {
                        canBeEmpty = false;
                        break;
                    }
                    case -3: 
                    case -1: {
                        canBeEmpty = true;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Programming error: case should never occur!");
                    }
                }
            } else {
                canBeEmpty = true;
            }
        } else {
            canBeEmpty = true;
        }
        return canBeEmpty;
    }

    private boolean mustBeSingleton(IsSingletonInstruction isSingleton) {
        boolean mustBeSingleton;
        Instruction sourceToIsSingleton = isSingleton.getOperand();
        Type sourceTypeGeneric = sourceToIsSingleton.getCachedType();
        if (!((sourceTypeGeneric = sourceTypeGeneric.resolveType(this.getCurrentFunction().getTypeEnvironment())) instanceof TypeVariable)) {
            XDMSeqBaseType sourceType = (XDMSeqBaseType)sourceTypeGeneric;
            if (null != sourceType) {
                XType xtype = sourceType.getXType();
                int quantifier = xtype.quantifier();
                switch (quantifier) {
                    case -3: 
                    case -2: 
                    case -1: {
                        mustBeSingleton = false;
                        break;
                    }
                    case 0: {
                        mustBeSingleton = true;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Programming error: case should never occur!");
                    }
                }
            } else {
                mustBeSingleton = false;
            }
        } else {
            mustBeSingleton = false;
        }
        return mustBeSingleton;
    }

    private boolean mustBeSingletonOrEmpty(IsSingletonInstruction isSingleton) {
        boolean mustBeSingleton;
        Instruction sourceToIsSingleton = isSingleton.getOperand();
        Type sourceTypeGeneric = sourceToIsSingleton.getCachedType();
        if (!((sourceTypeGeneric = sourceTypeGeneric.resolveType(this.getCurrentFunction().getTypeEnvironment())) instanceof TypeVariable)) {
            XDMSeqBaseType sourceType = (XDMSeqBaseType)sourceTypeGeneric;
            if (null != sourceType) {
                XType xtype = sourceType.getXType();
                int quantifier = xtype.quantifier();
                switch (quantifier) {
                    case -3: 
                    case -2: {
                        mustBeSingleton = false;
                        break;
                    }
                    case -1: 
                    case 0: {
                        mustBeSingleton = true;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Programming error: case should never occur!");
                    }
                }
            } else {
                mustBeSingleton = false;
            }
        } else {
            mustBeSingleton = false;
        }
        return mustBeSingleton;
    }

    private Instruction tryToOptimizeSimpleStep(ForEachXDMSequenceInstruction fexsi) {
        XPathStepInstruction xpathStepInstruction;
        GetAxisCursorInstruction gaci;
        Instruction source;
        Instruction sourceGeneric = fexsi.getSource();
        if (!(sourceGeneric instanceof IdentifierInstruction)) {
            return fexsi;
        }
        IdentifierInstruction sourceID = (IdentifierInstruction)sourceGeneric;
        IBinding binding = this.getBindingFromIdentifier(sourceID);
        LetInstruction letInstr = binding != null ? binding.getLet() : null;
        Instruction instruction2 = source = letInstr != null ? letInstr.getValue() : null;
        if (source == null) {
            return fexsi;
        }
        Instruction body = fexsi.getBody();
        if (!(body instanceof LetBaseInstruction)) {
            return fexsi;
        }
        LetBaseInstruction lbi = (LetBaseInstruction)body;
        if (!this.bodyIsSelf(lbi)) {
            return fexsi;
        }
        Instruction inner2 = lbi.getValue();
        if (inner2 instanceof GetTypedAxisCursorInstruction) {
            GetTypedAxisCursorInstruction gtvi = (GetTypedAxisCursorInstruction)inner2;
            gaci = gtvi;
            xpathStepInstruction = new XPathStepInstruction(gaci.getAxis(), gtvi.getNodeTest(), sourceID);
            boolean isKnownOrderedUnique = this.isPathOrderedAndUnique(xpathStepInstruction);
            xpathStepInstruction.setIsOrderedUnique(isKnownOrderedUnique);
        } else if (inner2 instanceof GetAxisCursorInstruction) {
            gaci = (GetAxisCursorInstruction)inner2;
            xpathStepInstruction = new XPathStepInstruction(gaci.getAxis(), null, sourceID);
            boolean isKnownOrderedUnique = this.isPathOrderedAndUnique(xpathStepInstruction);
            xpathStepInstruction.setIsOrderedUnique(isKnownOrderedUnique);
        } else {
            return fexsi;
        }
        assert (gaci.getCachedType() != null);
        assert (fexsi.getCachedType() != null);
        xpathStepInstruction.setInnerType((XDMSequenceType)gaci.getCachedType());
        xpathStepInstruction.setCachedType(fexsi.getCachedType());
        return xpathStepInstruction;
    }

    private boolean isPathOrderedAndUnique(GetAxisCursorInstruction gaci) {
        CumulativeAxis cumulativeAxis;
        ArrayList<GetAxisCursorInstruction> stack = new ArrayList<GetAxisCursorInstruction>();
        GetAxisCursorInstruction currentStep = gaci;
        Instruction root2 = null;
        do {
            stack.add(currentStep);
            Instruction previousStep = this.findValueSource(currentStep.getOperand());
            if (previousStep instanceof XPathStepInstruction) {
                currentStep = (GetAxisCursorInstruction)previousStep;
                continue;
            }
            root2 = previousStep;
        } while (root2 == null);
        int stepCount = stack.size();
        Type rootType = root2.getCachedType();
        if (root2 instanceof GetAxisCursorInstruction) {
            Axis firstAxis = ((GetAxisCursorInstruction)root2).getAxis();
            cumulativeAxis = CumulativeAxis.translateAxisToCumulative(firstAxis);
        } else {
            cumulativeAxis = rootType instanceof XDMSequenceType ? (((XDMSequenceType)rootType).getXType().isSubtype(XType.s_nodeQuestion) ? CumulativeAxis.SELF : CumulativeAxis.MISMATCH) : (rootType instanceof XDMItemType ? (((XDMItemType)rootType).getXType().isSubtype(XType.s_nodeQuestion) ? CumulativeAxis.SELF : CumulativeAxis.MISMATCH) : CumulativeAxis.MISMATCH);
        }
        for (int i = stepCount - 1; cumulativeAxis.isKnownForwardUnique() && i >= 0; --i) {
            Axis rightAxis = ((GetAxisCursorInstruction)stack.get(i)).getAxis();
            if (rightAxis == Axis.ATTRIBUTE) {
                cumulativeAxis = CumulativeAxis.ATTR;
                continue;
            }
            if (rightAxis == Axis.NAMESPACE) {
                cumulativeAxis = CumulativeAxis.NAMESPACE;
                continue;
            }
            if (rightAxis == Axis.SELF) continue;
            if (cumulativeAxis == CumulativeAxis.FOLLOWING_SIBLING || cumulativeAxis == CumulativeAxis.PRECEDING_SIBLING) {
                if (rightAxis == Axis.CHILD) continue;
                if (rightAxis == Axis.DESCENDANT || rightAxis == Axis.DESCENDANTORSELF) {
                    if (cumulativeAxis == CumulativeAxis.FOLLOWING_SIBLING) {
                        cumulativeAxis = CumulativeAxis.FOLLOWING_SIBLING_DESCENDANTS;
                        continue;
                    }
                    cumulativeAxis = CumulativeAxis.PRECEDING_SIBLING_DESCENDANTS;
                    continue;
                }
                cumulativeAxis = CumulativeAxis.MISMATCH;
                continue;
            }
            if (cumulativeAxis == CumulativeAxis.SELF || cumulativeAxis == CumulativeAxis.PARENT) {
                cumulativeAxis = CumulativeAxis.translateAxisToCumulative(rightAxis);
                continue;
            }
            if (cumulativeAxis == CumulativeAxis.CHILD) {
                if (rightAxis == Axis.CHILD || rightAxis == Axis.DESCENDANT || rightAxis == Axis.DESCENDANTORSELF) {
                    cumulativeAxis = CumulativeAxis.translateAxisToCumulative(rightAxis);
                    continue;
                }
                cumulativeAxis = CumulativeAxis.MISMATCH;
                continue;
            }
            cumulativeAxis = CumulativeAxis.MISMATCH;
        }
        return cumulativeAxis.isKnownForwardUnique();
    }

    private boolean bodyIsSelf(LetBaseInstruction lbi) {
        Instruction lbiBody = lbi.getBody();
        return lbiBody instanceof IdentifierInstruction && ((IdentifierInstruction)lbiBody).getVariable().equals(lbi.getVariable());
    }

    private Instruction resolveIdentifier(Instruction sourceGeneric) {
        IdentifierInstruction sourceID = (IdentifierInstruction)sourceGeneric;
        IBinding binding = this.getBindingFromIdentifier(sourceID);
        LetInstruction letInstr = binding != null ? binding.getLet() : null;
        Instruction source = letInstr != null ? letInstr.getValue() : null;
        return source;
    }

    private final boolean logType(Instruction n2) {
        if (LOG) {
            this.log("@");
            Type type2 = this.extractType(n2);
            if (null != type2) {
                this.log(type2.toString());
            } else {
                this.log("??");
            }
        }
        return true;
    }

    private String getTypeString(Instruction n2) {
        StringBuffer sb = new StringBuffer();
        sb.append("@");
        Type type2 = this.extractType(n2);
        if (null != type2) {
            sb.append(type2.toString());
        } else {
            sb.append("??");
        }
        return sb.toString();
    }

    private Type extractType(Instruction n2) {
        Type type2 = n2.getCachedType();
        if (type2 == null) {
            BindingEnvironment be = n2.getBindingEnvironment();
            if (be == null) {
                be = this.m_currentFunction.getBindingEnvironment();
            }
            if (be == null) {
                return null;
            }
            assert (be != null);
            TypeEnvironment te = this.m_currentFunction.getTypeEnvironment();
            assert (te != null);
            type2 = n2.getType(te, be);
        }
        return type2;
    }

    private BindingEnvironment getAndLogBindingEnvironment(Instruction n2) {
        BindingEnvironment benv = n2.getBindingEnvironment();
        if (benv != null) {
            if (LOG) {
                this.log("  bindingsEnvSize: " + benv.getSize());
            }
            if (LOG) {
                this.log("  bindingsEnv: " + benv.toString());
            }
        } else {
            if (LOG) {
                this.log("  null binding environment");
            }
            if (benv == null) {
                benv = n2.evaluateBindingEnvironment(this.m_currentFunction);
            }
            if (LOG && benv != null) {
                this.log("  using current function binding env");
            }
        }
        return benv;
    }

    private void processSpecialForms(Instruction n2) {
        ISpecialForm ispecial = (ISpecialForm)((Object)n2);
        ++this.nestCount;
        boolean takesXDMSequence = false;
        for (int i = 0; i < n2.getChildInstructionCount(); ++i) {
            if (ispecial.isChildInstructionBody(i)) {
                this.processISpecialFormMaybe(n2);
            }
            Instruction child2 = n2.getChildInstruction(i);
            this.optimize(child2);
        }
        --this.nestCount;
    }

    private Instruction processIdentifierInstruction(Instruction n2) {
        boolean LOGMETHOD = false;
        IdentifierInstruction ident = (IdentifierInstruction)n2;
        IBinding binding = this.getBindingFromIdentifier(ident);
        if (binding != null) {
            int prevusage = binding.getVariableUse();
            if (LOG) {
                this.log(n2.getClass().getSimpleName() + ": " + binding.getName());
            }
            if (LOG) {
                this.logIBindingType(binding, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment());
            }
            if (LOG) {
                this.logln(" - VariableUsage: " + prevusage + " -> " + binding.getVariableUse());
            }
        } else if (LOG) {
            this.logln("optimizeStep (Can't find IBinding): " + n2.getClass().getSimpleName() + ": " + ident.getVariable());
        }
        return n2;
    }

    private IBinding getBindingFromIdentifier(IdentifierInstruction ident) {
        Function f2 = this.getCurrentFunction();
        IBinding binding = null;
        if (null != this.lambdaFreeBindings) {
            Object varID = ident.getVariable();
            binding = this.lambdaFreeBindings.getVariableBinding(varID);
        }
        if (binding == null && (binding = ident.getBinding()) == null) {
            BindingEnvironment benv = f2.getBindingEnvironment();
            if (benv == null) {
                return null;
            }
            assert (benv != null);
            Object varID = ident.getVariable();
            binding = benv.getVariableBinding(varID);
        }
        return binding;
    }

    private Type getBindingType(IBinding binding, TypeEnvironment tenv, BindingEnvironment benv) {
        Type type2 = binding.getBindingType();
        if (type2 == null) {
            type2 = binding.getBindingType(tenv, benv);
        }
        return type2;
    }

    private final boolean logIBindingType(IBinding binding, TypeEnvironment tenv, BindingEnvironment benv) {
        this.log("@");
        Type type2 = binding.getBindingType();
        if (type2 != null) {
            this.log(type2.toString());
        } else {
            type2 = binding.getBindingType(tenv, benv);
            if (type2 != null) {
                this.log(type2.toString());
            } else {
                this.log("??");
            }
        }
        return true;
    }

    private Instruction findValueSource(Instruction i) {
        Object o = i;
        while (o instanceof IdentifierInstruction) {
            if ((o = this.getBindingFromIdentifier((IdentifierInstruction)o)) instanceof LetInstruction) {
                o = ((Instruction)o).getChildInstruction(0);
                continue;
            }
            if (o instanceof IBinding) {
                o = ((IBinding)o).getOrigin();
                continue;
            }
            o = null;
        }
        return o;
    }

    private void reTypecheckFunction(Function f2, Module m) {
        f2.clearTypeInformation();
        try {
            f2.typeCheck(m, null, new LinkedList<Function>());
            f2.typeCheckReduced(m, new LinkedList());
        }
        catch (TypeCheckException e) {
            e.printStackTrace();
        }
    }

    private void processParams(Instruction[] params) {
        for (int i = 0; i < params.length; ++i) {
            this.isParamPush = true;
            Instruction instruction2 = params[i];
            this.optimize(instruction2);
        }
    }

    private Function resolveFunction(TypeEnvironment tenv, ModuleFunctionCallInstruction mfci) {
        Module m = tenv.getModule().getProgram().getModule(mfci.getModule());
        if (m == null) {
            return null;
        }
        return m.getPublicFunction(mfci.getFunction());
    }

    @Override
    protected void optimizeChildren(Instruction n2) {
        ++this.nestCount;
        super.optimizeChildren(n2);
        --this.nestCount;
    }

    private void processISpecialFormMaybe(Instruction n2) {
        if (n2 instanceof ISpecialForm) {
            int childCount = n2.getChildInstructionCount();
            for (int i = 0; i < childCount; ++i) {
                IBinding[] bindings = ((ISpecialForm)((Object)n2)).getChildInstructionBindings(i + 1);
                if (null == bindings) continue;
                for (int j = 0; j < bindings.length; ++j) {
                    IBinding binding2 = bindings[j];
                    if (LOG) {
                        this.logIndent();
                    }
                    if (!LOG) continue;
                    this.logln("ISpecialForm binding: " + binding2.getName() + this.getTypeString(n2));
                }
                break;
            }
        }
    }

    public static void doOptimization(Module prog) {
        prog.optimize(new XPathStepOptimizer());
    }

    private static enum CumulativeAxis {
        MISMATCH,
        SELF{

            @Override
            public boolean isKnownForwardUnique() {
                return true;
            }
        }
        ,
        CHILD{

            @Override
            public boolean isKnownForwardUnique() {
                return true;
            }
        }
        ,
        FOLLOWING_SIBLING{

            @Override
            public boolean isKnownForwardUnique() {
                return true;
            }
        }
        ,
        FOLLOWING_SIBLING_DESCENDANTS{

            @Override
            public boolean isKnownForwardUnique() {
                return true;
            }
        }
        ,
        PRECEDING_SIBLING,
        PRECEDING_SIBLING_DESCENDANTS,
        PARENT,
        DESCENDANT{

            @Override
            public boolean isKnownForwardUnique() {
                return true;
            }
        }
        ,
        DESCENDANT_OR_SELF{

            @Override
            public boolean isKnownForwardUnique() {
                return true;
            }
        }
        ,
        ATTR{

            @Override
            public boolean isKnownForwardUnique() {
                return true;
            }
        }
        ,
        NAMESPACE{

            @Override
            public boolean isKnownForwardUnique() {
                return true;
            }
        }
        ,
        ATTR_OR_CHILD{

            @Override
            public boolean isKnownForwardUnique() {
                return true;
            }
        };

        private static HashMap<Axis, CumulativeAxis> fAxisMap;

        public boolean isKnownForwardUnique() {
            return false;
        }

        public static CumulativeAxis translateAxisToCumulative(Axis axis) {
            CumulativeAxis translatedAxis = fAxisMap.get(axis);
            return translatedAxis != null ? translatedAxis : MISMATCH;
        }

        static {
            fAxisMap = new HashMap();
            fAxisMap.put(Axis.ATTRIBUTE, ATTR);
            fAxisMap.put(Axis.SELF, SELF);
            fAxisMap.put(Axis.NAMESPACE, NAMESPACE);
            fAxisMap.put(Axis.FOLLOWINGSIBLING, FOLLOWING_SIBLING);
            fAxisMap.put(Axis.PRECEDINGSIBLING, PRECEDING_SIBLING);
            fAxisMap.put(Axis.PARENT, PARENT);
            fAxisMap.put(Axis.DESCENDANT, DESCENDANT);
            fAxisMap.put(Axis.DESCENDANTORSELF, DESCENDANT_OR_SELF);
            fAxisMap.put(Axis.CHILD, CHILD);
        }
    }

    class InstructionEntryModel
    extends EntryModel {
        Instruction instruction;

        InstructionEntryModel() {
        }
    }

    class FunctionEntryModel
    extends EntryModel {
        Function function;

        FunctionEntryModel() {
        }
    }

    class EntryModel {
        ForkInformation[] argumentModels;

        EntryModel() {
        }
    }
}

