/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.ForEachXDMSequenceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.XDMSequenceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xml.xci.type.SequenceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ForEachXDMSequenceEvaluator
extends PartialEvaluator {
    public static final int s_loopUnrollThreshold = 10;

    protected static boolean checkInstruction(PartialInformationCollector pic, Instruction n2) {
        if (n2 instanceof ChooseInstruction) {
            return ForEachXDMSequenceEvaluator.checkChooseInstruction(pic, (ChooseInstruction)n2);
        }
        if (n2 instanceof MatchInstruction) {
            return ForEachXDMSequenceEvaluator.checkMatchInstruction(pic, (MatchInstruction)n2);
        }
        if (n2 instanceof XDMSequenceInstruction) {
            return ForEachXDMSequenceEvaluator.checkXDMSequenceInstruction(pic, (XDMSequenceInstruction)n2);
        }
        return false;
    }

    protected static boolean checkXDMSequenceInstruction(PartialInformationCollector pic, XDMSequenceInstruction si) {
        int c = si.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            Instruction x = si.getChildInstruction(i);
            if (!(pic.resolveType(x) instanceof SequenceType)) continue;
            return false;
        }
        return true;
    }

    protected static boolean checkChooseInstruction(PartialInformationCollector pic, ChooseInstruction ci) {
        BindingEnvironment benv = pic.getCurrentBindingEnvironment();
        for (ChooseInstruction.Case cic : ci.m_cases) {
            Instruction innerBody = NavigationUtilities.resolveReducedIdentifier(NavigationUtilities.skipLets(cic.getHandler()), benv);
            if (ForEachXDMSequenceEvaluator.checkInstruction(pic, innerBody)) continue;
            return false;
        }
        Instruction def = ci.getDefaultHandler();
        if (def != null) {
            Instruction innerBody = NavigationUtilities.resolveReducedIdentifier(NavigationUtilities.skipLets(def), benv);
            return ForEachXDMSequenceEvaluator.checkInstruction(pic, innerBody);
        }
        return true;
    }

    protected static boolean checkMatchInstruction(PartialInformationCollector pic, MatchInstruction ci) {
        BindingEnvironment benv = pic.getCurrentBindingEnvironment();
        int c = ci.getMatches().length;
        for (int i = 0; i < c; ++i) {
            MatchInstruction.Match cic = ci.getMatches()[i];
            Instruction innerBody = NavigationUtilities.resolveReducedIdentifier(NavigationUtilities.skipLets(cic.getHandler()), benv);
            if (ForEachXDMSequenceEvaluator.checkInstruction(pic, innerBody)) continue;
            return false;
        }
        Instruction def = ci.getDefault();
        if (def != null) {
            Instruction innerBody = NavigationUtilities.resolveReducedIdentifier(NavigationUtilities.skipLets(def), benv);
            return ForEachXDMSequenceEvaluator.checkInstruction(pic, innerBody);
        }
        return true;
    }

    protected static void implantForEach(ForEachXDMSequenceInstruction fei2, Instruction x, int child2, HashMap bindings) {
        Instruction y = x.getChildInstruction(child2);
        if (y instanceof LetInstruction) {
            LetInstruction leti = (LetInstruction)y;
            bindings.put(leti.getVariable(), leti);
            ForEachXDMSequenceEvaluator.implantForEach(fei2, y, 1, bindings);
        } else if (y instanceof IdentifierInstruction) {
            IdentifierInstruction ii = (IdentifierInstruction)y;
            LetInstruction leti = (LetInstruction)bindings.get(ii.getVariable());
            if (leti != null) {
                x.setChildInstruction(child2, leti.getValue().cloneReduced());
                ForEachXDMSequenceEvaluator.implantForEach(fei2, x, child2, bindings);
            } else {
                ForEachXDMSequenceInstruction fei3 = (ForEachXDMSequenceInstruction)fei2.cloneWithNewNames();
                Object ident = fei3.getVarName();
                x.setChildInstruction(child2, new LetInstruction(ident, ii, fei3.getBody()));
            }
        } else if (y instanceof ChooseInstruction) {
            ChooseInstruction ci = (ChooseInstruction)y;
            int c = ci.m_cases.length;
            Instruction def = ci.getDefaultHandler();
            int j = 1;
            if (def != null) {
                ++j;
                ForEachXDMSequenceEvaluator.implantForEach(fei2, ci, 0, bindings);
            }
            for (int i = 0; i < c; ++i) {
                ForEachXDMSequenceEvaluator.implantForEach(fei2, ci, j, bindings);
                j += 2;
            }
        } else if (y instanceof MatchInstruction) {
            MatchInstruction ci = (MatchInstruction)y;
            int c = ci.getMatches().length;
            Instruction def = ci.getDefault();
            int j = 1;
            if (def != null) {
                ++j;
                ForEachXDMSequenceEvaluator.implantForEach(fei2, ci, 0, bindings);
            }
            for (int i = 0; i < c; ++i) {
                ForEachXDMSequenceEvaluator.implantForEach(fei2, ci, j, bindings);
                ++j;
            }
        } else if (y instanceof XDMSequenceInstruction) {
            XDMSequenceInstruction si = (XDMSequenceInstruction)y;
            ForEachXDMSequenceInstruction fei3 = (ForEachXDMSequenceInstruction)fei2.cloneWithNewNames();
            Integer ident = ReductionHelper.generateIntermediateIdentifier2();
            fei3.setSource(new IdentifierInstruction(ident));
            x.setChildInstruction(child2, new LetInstruction(ident, si, fei3));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected static void unrollLoop(PartialInformationCollector pic, Instruction body, String loopvar, XDMSequenceInstruction source, LetInstruction before2, LetChainManager lcm, ArrayList results) {
        int c = source.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            Instruction x = source.getChildInstruction(i);
            if (pic.resolveType(x) instanceof SequenceType) {
                ForEachXDMSequenceEvaluator.unrollLoop(pic, body, loopvar, (XDMSequenceInstruction)lcm.lookupBinding(x), before2, lcm, results);
                continue;
            }
            HashMap<String, IdentifierInstruction> map2 = new HashMap<String, IdentifierInstruction>();
            IdentifierInstruction newloopvar = lcm.insertBody(x.cloneWithNewNames(), before2);
            map2.put(loopvar, newloopvar);
            Instruction body2 = body.assignNewNames(map2);
            results.add(lcm.insertBody(body2, before2));
        }
    }

    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        PartialEvaluationResult per;
        ForEachXDMSequenceInstruction fei;
        block9: {
            TypeEnvironment tenv;
            BindingEnvironment benv;
            Instruction src;
            block10: {
                Set freeBindings;
                fei = (ForEachXDMSequenceInstruction)x;
                pic.partiallyEvaluate(fei.getSource(), lcm);
                src = lcm.lookupBinding(fei.getSource());
                if (fei.getIndexVar() != null && !(freeBindings = fei.getBody().accumulateFreeBindingsInOrder(pic.getCurrentBindingEnvironment())).contains(fei.getIndexBinding())) {
                    fei.setIndexVar(null);
                }
                benv = pic.getCurrentBindingEnvironment();
                tenv = pic.getCurrentTypeEnvironment();
                if (!(src instanceof XDMSequenceInstruction) || src.getChildInstructionCount() >= 10 || !(src.getType(tenv, benv).resolveType(tenv) instanceof SequenceType)) break block9;
                if (fei.getIndexVar() == null) break block10;
                HashSet set2 = new HashSet();
                fei.getBody().accumulateFreeBindings(set2, benv);
                if (set2.contains(fei.getIndexBinding())) break block9;
            }
            XDMSequenceInstruction si = (XDMSequenceInstruction)src;
            ArrayList<IdentifierInstruction> list = new ArrayList<IdentifierInstruction>();
            ArrayList list2 = new ArrayList();
            ForEachXDMSequenceEvaluator.accumulateSequence(si, list2, pic, lcm);
            XDMItemType elementType = XDMItemType.s_itemType;
            if (list2.size() == 0) {
                return new PartialEvaluationResult(new XDMSequenceInstruction());
            }
            for (Instruction y : list2) {
                if (y.getType(tenv, benv).resolveType(tenv) instanceof SequenceType) {
                    if (list2.size() == 1) {
                        fei.setSource(y);
                        return new PartialEvaluationResult(null, true);
                    }
                    ForEachXDMSequenceInstruction fei2 = (ForEachXDMSequenceInstruction)fei.cloneWithNewNames();
                    fei2.setBody(fei2.getBody().cloneReduced());
                    fei2.setSource(y);
                    list.add(lcm.insertBody(fei2, before2));
                    continue;
                }
                Instruction body2 = fei.getBody();
                HashMap<Object, Instruction> map2 = new HashMap<Object, Instruction>();
                map2.put(fei.getVarName(), y);
                list.add(lcm.insertBody(body2.assignNewNames(map2), before2));
            }
            return new PartialEvaluationResult((Instruction)new XDMSequenceInstruction(list), true);
        }
        if ((per = pic.partiallyEvaluateBody(fei.getBody(), fei, 1, lcm)).getReplacement() != null) {
            fei.setBody(per.getReplacement());
        }
        return PartialEvaluationResult.s_emptyResult;
    }

    public static final void accumulateSequence(XDMSequenceInstruction si, List list, PartialInformationCollector pic, LetChainManager lcm) {
        int c = si.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            Instruction n2 = si.getChildInstruction(i);
            pic.partiallyEvaluate(n2, lcm);
            Instruction y = lcm.lookupBinding(n2);
            if (y instanceof XDMSequenceInstruction) {
                ForEachXDMSequenceEvaluator.accumulateSequence((XDMSequenceInstruction)y, list, pic, lcm);
                continue;
            }
            list.add(NavigationUtilities.resolveIdentifierAliases(n2, pic.getCurrentBindingEnvironment()));
        }
    }
}

