/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.parser;

import com.ibm.xltxe.rnm1.xylem.parser.ParserException;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.util.SimpleKindTest;
import com.ibm.xml.xci.util.SimpleNameTest;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public class NodeTestHelper {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NodeTest simpleParseForAxesNodeTest(String nodeTestString) throws ParserException {
        StringTokenizer tokenizer = new StringTokenizer(nodeTestString, "{}():,", true);
        if (!tokenizer.hasMoreTokens()) {
            throw new ParserException("Empty NodeTest in get-typed-axis-cursor!");
        }
        NodeTest nodetest = null;
        if (!tokenizer.hasMoreTokens()) return nodetest;
        String t1 = tokenizer.nextToken();
        if (t1.equals("*")) {
            if (!tokenizer.hasMoreTokens()) return SimpleKindTest.ELEMENT;
            return NodeTestHelper.parseColonNCNameOrWildCard(tokenizer, null);
        }
        if (t1.equals("{")) {
            String t2;
            StringBuilder sb = new StringBuilder();
            while (tokenizer.hasMoreTokens() && !(t2 = tokenizer.nextToken()).equals("}")) {
                sb.append(t2);
            }
            String namespace2 = sb.toString();
            if (!tokenizer.hasMoreTokens()) throw new ParserException("NodeTest syntax in get-typed-axis-cursor: no token following '}'");
            return NodeTestHelper.parseColonNCNameOrWildCard(tokenizer, namespace2);
        }
        if (!tokenizer.hasMoreTokens()) return SimpleNameTest.element("", t1);
        String t2 = tokenizer.nextToken();
        if (t2.equals(":")) {
            nodetest = NodeTestHelper.parseNCNameOrWildcard(tokenizer, t1);
        } else if (!t2.equals("(")) {
            throw new ParserException("NodeTest syntax in get-typed-axis-cursor: unknown token: " + t2);
        }
        if (t1.equals("node")) {
            NodeTestHelper.swallowExpectedParen(tokenizer);
            return SimpleKindTest.NODE;
        }
        if (t1.equals("text")) {
            NodeTestHelper.swallowExpectedParen(tokenizer);
            return SimpleKindTest.TEXT;
        }
        if (t1.equals("element")) {
            String localName2;
            String namespace3;
            if (!tokenizer.hasMoreTokens()) throw new ParserException("NodeTest syntax in get-typed-axis-cursor: Expected more tokens");
            String t3 = tokenizer.nextToken();
            if (t3.equals(")")) {
                return SimpleKindTest.ELEMENT;
            }
            if (t3.equals("*")) {
                namespace3 = null;
                localName2 = null;
            } else {
                QName qname2 = NodeTestHelper.getQName(tokenizer, t3);
                namespace3 = qname2.getNamespaceURI();
                localName2 = qname2.getLocalPart();
            }
            if (!tokenizer.hasMoreTokens()) throw new ParserException("NodeTest syntax in get-typed-axis-cursor: Unexpected end");
            String t4 = tokenizer.nextToken();
            if (t4.equals(",")) {
                throw new ParserException("NodeTest syntax in get-typed-axis-cursor: TypeName in element test not handled yet!");
            }
            if (!t4.equals(")")) throw new ParserException("NodeTest syntax in get-typed-axis-cursor: Expected close paren!");
            return SimpleNameTest.element(namespace3, localName2);
        }
        if (t1.equals("attribute")) {
            String localName3;
            String namespace4;
            if (!tokenizer.hasMoreTokens()) throw new ParserException("NodeTest syntax in get-typed-axis-cursor: Expected more tokens");
            String t3 = tokenizer.nextToken();
            if (t3.equals(")")) {
                return SimpleKindTest.ATTRIBUTE;
            }
            if (t3.equals("*")) {
                namespace4 = null;
                localName3 = null;
            } else {
                QName qname3 = NodeTestHelper.getQName(tokenizer, t3);
                namespace4 = qname3.getNamespaceURI();
                localName3 = qname3.getLocalPart();
            }
            if (!tokenizer.hasMoreTokens()) throw new ParserException("NodeTest syntax in get-typed-axis-cursor: Unexpected end");
            String t4 = tokenizer.nextToken();
            if (t4.equals(",")) {
                throw new ParserException("NodeTest syntax in get-typed-axis-cursor: TypeName in attribute test not handled yet!");
            }
            if (!t4.equals(")")) throw new ParserException("NodeTest syntax in get-typed-axis-cursor: Expected close paren!");
            return SimpleNameTest.attribute(namespace4, localName3);
        }
        if (t1.equals("processing-instruction")) {
            if (!tokenizer.hasMoreTokens()) throw new ParserException("NodeTest syntax in get-typed-axis-cursor: Expected more tokens");
            String t3 = tokenizer.nextToken();
            if (t3.equals(")")) {
                return SimpleKindTest.PROCESSING_INSTRUCTION;
            }
            NodeTestHelper.swallowExpectedParen(tokenizer);
            return SimpleNameTest.processingInstruction(t3);
        }
        if (!t1.equals("document-node")) return nodetest;
        if (!tokenizer.hasMoreTokens()) throw new ParserException("NodeTest syntax in get-typed-axis-cursor: Expected more tokens");
        String t3 = tokenizer.nextToken();
        if (t3.equals(")")) {
            return SimpleKindTest.DOCUMENT;
        }
        if (t3.equals("element")) {
            if ($assertionsDisabled) throw new ParserException("NodeTest syntax in get-typed-axis-cursor: NOT IMPLEMENTED YET!");
            throw new AssertionError((Object)"NOT IMPLEMENTED YET!");
        }
        if (!t3.equals("schema-element")) throw new ParserException("NodeTest syntax in get-typed-axis-cursor: unknown token: " + t3);
        if ($assertionsDisabled) throw new ParserException("NodeTest syntax in get-typed-axis-cursor: NOT IMPLEMENTED YET!");
        throw new AssertionError((Object)"NOT IMPLEMENTED YET!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static QName getQName(StringTokenizer tokenizer, String t1) throws ParserException {
        String t2;
        if (!t1.equals("{")) return new QName(t1);
        StringBuilder sb = new StringBuilder();
        while (tokenizer.hasMoreTokens() && !(t2 = tokenizer.nextToken()).equals("}")) {
            sb.append(t2);
        }
        String namespace2 = sb.toString();
        if (!tokenizer.hasMoreTokens()) throw new ParserException("NodeTest syntax in get-typed-axis-cursor: no token following '}'");
        String t22 = tokenizer.nextToken();
        if (!t22.equals(":")) throw new ParserException("NodeTest syntax in get-typed-axis-cursor: no colon following namespace");
        if (!tokenizer.hasMoreTokens()) throw new ParserException("NodeTest syntax in get-typed-axis-cursor: no token following colon!");
        String t3 = tokenizer.nextToken();
        return new QName(namespace2, t3);
    }

    private static void swallowExpectedParen(StringTokenizer tokenizer) throws ParserException {
        if (tokenizer.hasMoreTokens()) {
            String t3 = tokenizer.nextToken();
            if (!t3.equals(")")) {
                throw new ParserException("NodeTest syntax in get-typed-axis-cursor: unknown token: " + t3);
            }
        } else {
            throw new ParserException("NodeTest syntax in get-typed-axis-cursor: Expected closing paren");
        }
    }

    private static NodeTest parseColonNCNameOrWildCard(StringTokenizer tokenizer, String namespace2) throws ParserException {
        String t2 = tokenizer.nextToken();
        if (!t2.equals(":")) {
            throw new ParserException("NodeTest syntax in get-typed-axis-cursor: unknown token: " + t2);
        }
        NodeTest nodetest = NodeTestHelper.parseNCNameOrWildcard(tokenizer, namespace2);
        return nodetest;
    }

    private static NodeTest parseNCNameOrWildcard(StringTokenizer tokenizer, String namespace2) throws ParserException {
        NodeTest nodetest;
        if (!tokenizer.hasMoreTokens()) {
            throw new ParserException("NodeTest syntax in get-typed-axis-cursor: no token following ':'");
        }
        String t3 = tokenizer.nextToken();
        if (t3.equals("*")) {
            nodetest = SimpleNameTest.element(namespace2, null);
        } else if (!tokenizer.hasMoreTokens()) {
            nodetest = SimpleNameTest.element(namespace2, t3);
        } else {
            throw new ParserException("NodeTest syntax in get-typed-axis-cursor: unknown token: " + tokenizer.nextToken());
        }
        return nodetest;
    }

    public static void main(String[] args) throws ParserException {
        NodeTestHelper.testNodeTestString("element({http://java.sun.com/j2se/1.5.0/docs/api/javax/xml/namespace/QName.html}:thisIsAnElementTest)");
        NodeTestHelper.testNodeTestString("element(thisIsAnElementTest)");
        NodeTestHelper.testNodeTestString("attribute(thisIsAnAttributeTest)");
        NodeTestHelper.testNodeTestString("attribute({http://java.sun.com/j2se/1.5.0/docs/api/javax/xml/namespace/QName.html}:thisIsAnAttributeTest)");
        NodeTestHelper.testNodeTestString("foo");
        NodeTestHelper.testNodeTestString("attribute()");
        NodeTestHelper.testNodeTestString("element()");
        NodeTestHelper.testNodeTestString("attribute");
        NodeTestHelper.testNodeTestString("node");
        NodeTestHelper.testNodeTestString("element");
        NodeTestHelper.testNodeTestString("*");
        NodeTestHelper.testNodeTestString("*:foo");
        NodeTestHelper.testNodeTestString("{http://example.com}:*");
        NodeTestHelper.testNodeTestString("{http://www.w3.org/TR/xpath20/#prod-xpath-SchemaElementTest}:*");
        NodeTestHelper.testNodeTestString("{http://www.math.com/school/subject2/lessons/S2U4L3GL.html}:fooo.baz");
        NodeTestHelper.testNodeTestString("node()");
        NodeTestHelper.testNodeTestString("text()");
    }

    private static void testNodeTestString(String testArg) throws ParserException {
        System.out.println("=========");
        System.out.println("Testing: " + testArg);
        NodeTest nodeTest = NodeTestHelper.simpleParseForAxesNodeTest(testArg);
        System.out.println("RESULT: " + nodeTest);
    }
}

