/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.partialeval;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.ArithmeticInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveArithmeticInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;

public class ArithmeticEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        ArithmeticInstruction pei = (ArithmeticInstruction)x;
        Instruction param1 = pei.getOperand1();
        Instruction param2 = pei.getOperand2();
        Type t1 = pic.resolveType(param1);
        Type t2 = pic.resolveType(param2);
        if (!(t1 instanceof INumericalType)) {
            t1 = DoubleType.s_doubleType;
            param1 = lcm.insertBody2(new CoerceInstruction(param1, t1), before2);
            pei.setChildInstruction(0, param1);
        }
        if (!(t2 instanceof INumericalType)) {
            t2 = DoubleType.s_doubleType;
            param2 = lcm.insertBody2(new CoerceInstruction(param2, t2), before2);
            pei.setChildInstruction(1, param2);
        }
        if (IntType.s_intType.equals(t1) && IntType.s_intType.equals(t2) || DoubleType.s_doubleType.equals(t1) && DoubleType.s_doubleType.equals(t2)) {
            int op2 = 0;
            switch (pei.getOperation()) {
                case 4: {
                    op2 = 0;
                    break;
                }
                case 5: {
                    op2 = 1;
                    break;
                }
                case 30: {
                    op2 = 2;
                    break;
                }
                case 31: {
                    op2 = 3;
                    break;
                }
                case 33: {
                    op2 = 4;
                }
            }
            return new PartialEvaluationResult((Instruction)new PrimitiveArithmeticInstruction(param1, param2, op2), true);
        }
        pic.partiallyEvaluate(param1, lcm);
        pic.partiallyEvaluate(param2, lcm);
        return PartialEvaluationResult.s_emptyResult;
    }
}

