/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.partialeval;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.GetStringValueInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LengthInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NotInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveToStringInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import java.util.Set;

public class CoerceEvaluator
extends PartialEvaluator {
    private boolean m_isDebug = false;
    private final Type s_ftdRefType = new NamedType("FTD");

    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        if (this.m_isDebug) {
            System.out.println("CoerceEvaluator called.");
        }
        CoerceInstruction ci = (CoerceInstruction)x;
        Instruction param = ci.getOperand();
        Set info = pic.partiallyEvaluate(param, lcm);
        Type from2 = pic.resolveType(param);
        Type to2 = pic.resolveType(ci);
        if (from2 == null || to2 == null) {
            throw new RuntimeException();
        }
        Instruction paramValue = lcm.lookupBinding(param);
        Module p = pic.getCurrentModule();
        if (from2.equals(to2)) {
            return new PartialEvaluationResult(param, info);
        }
        if (paramValue instanceof FunctionCallInstruction) {
            FunctionCallInstruction fci = (FunctionCallInstruction)paramValue;
            Function f2 = lcm.getCurrentFunction().getTypeEnvironment().getModule().getFunction(fci.getFunction());
            int i = 0;
            if (i < f2.m_parameters.length) {
                CoersionDerivative cd = new CoersionDerivative(to2);
                Function f22 = f2.lookupDerivative(cd);
                if (f22 == null) {
                    f22 = f2.cloneFunctionForFixup(cd, true, true, true);
                    f22.setMemoizeResult(f2.getMemoizeResult());
                    String ident = OptimizerUtilities.generateIntermediateIdentifier();
                    f22.setBody(CoerceEvaluator.moveToBottom(f22.getBody(), ident, new CoerceInstruction(new IdentifierInstruction(ident), to2)));
                    p.addFunction(f22);
                }
                fci = (FunctionCallInstruction)fci.cloneReduced();
                fci.setFunction(f22.getName());
                return new PartialEvaluationResult((Instruction)fci, true);
            }
        }
        if (from2.equals(IntType.s_intType) && to2.equals(CharType.s_charType.getStreamType())) {
            return new PartialEvaluationResult((Instruction)new PrimitiveToStringInstruction(param), true);
        }
        if (from2 instanceof XDMItemType && to2.equals(CharType.s_charType.getStreamType())) {
            GetStringValueInstruction i = new GetStringValueInstruction(param);
            Instruction.propagateInfo(x, i);
            return new PartialEvaluationResult((Instruction)i, true);
        }
        Object paramVal = CoerceEvaluator.extractLiteralValue(pic, param, lcm);
        if (paramVal != null) {
            if (from2.equals(IntType.s_intType) && to2.equals(BooleanType.s_booleanType)) {
                return new PartialEvaluationResult((Integer)paramVal == 0 ? LiteralInstruction.booleanFalseLiteral() : LiteralInstruction.booleanTrueLiteral());
            }
            if (from2.equals(IntType.s_intType) && to2.equals(DoubleType.s_doubleType)) {
                return new PartialEvaluationResult(LiteralInstruction.doubleLiteral(((Integer)paramVal).intValue()));
            }
            if (from2.equals(DoubleType.s_doubleType) && to2.equals(IntType.s_intType)) {
                return new PartialEvaluationResult(LiteralInstruction.integerLiteral(((Double)paramVal).intValue()));
            }
        }
        if (from2.equals(CharType.s_charType.getStreamType()) && to2.equals(BooleanType.s_booleanType)) {
            IdentifierInstruction len = lcm.insertBody(new LengthInstruction(param), before2);
            IdentifierInstruction eq0 = lcm.insertBody(new PrimitiveEqualityInstruction(LiteralInstruction.integerLiteral(0), len), before2);
            return new PartialEvaluationResult((Instruction)new NotInstruction(eq0), true);
        }
        return PartialEvaluationResult.s_emptyResult;
    }

    static final class CoersionDerivative {
        Type m_type;

        CoersionDerivative(Type type2) {
            this.m_type = type2;
        }

        public int hashCode() {
            return this.m_type.hashCode();
        }

        public boolean equals(Object arg0) {
            if (arg0 == null) {
                return false;
            }
            if (arg0 instanceof CoersionDerivative) {
                return ((CoersionDerivative)arg0).m_type.equals(this.m_type);
            }
            return false;
        }
    }
}

