/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.partialeval;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.EqualityInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.instructions.DeepEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NotInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;

public class EqualityEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        EqualityInstruction ci = (EqualityInstruction)x;
        Instruction param1 = ci.getOperand1();
        Instruction param2 = ci.getOperand2();
        pic.partiallyEvaluate(param1, lcm);
        pic.partiallyEvaluate(param2, lcm);
        Type t1 = pic.resolveType(param1);
        Type t2 = pic.resolveType(param2);
        if (t1 instanceof XDMSequenceType && t2 instanceof XDMSequenceType) {
            return PartialEvaluationResult.s_emptyResult;
        }
        if (t1 instanceof INumericalType && t2 instanceof INumericalType || t1 instanceof BooleanType && t2 instanceof BooleanType) {
            if (t1.equals(t2)) {
                if (ci.isTestingInequality()) {
                    IdentifierInstruction ii = lcm.insertBody(new PrimitiveEqualityInstruction(param1, param2), before2);
                    return new PartialEvaluationResult((Instruction)new NotInstruction(ii), true);
                }
                return new PartialEvaluationResult((Instruction)new PrimitiveEqualityInstruction(param1, param2), true);
            }
            return PartialEvaluationResult.s_emptyResult;
        }
        if (t1 instanceof XDMItemType && t2.equals(CharType.s_charType.getStreamType())) {
            return PartialEvaluationResult.s_emptyResult;
        }
        if (t2 instanceof XDMItemType && t1.equals(CharType.s_charType.getStreamType())) {
            return PartialEvaluationResult.s_emptyResult;
        }
        if (t1 instanceof XDMItemType && t2 instanceof INumericalType) {
            return PartialEvaluationResult.s_emptyResult;
        }
        if (t2 instanceof XDMItemType && t1 instanceof INumericalType) {
            return PartialEvaluationResult.s_emptyResult;
        }
        if (t2.equals(CharType.s_charType.getStreamType()) && t1.equals(CharType.s_charType.getStreamType())) {
            if (ci.isTestingInequality()) {
                IdentifierInstruction ii = lcm.insertBody(new DeepEqualityInstruction(param1, param2), before2);
                return new PartialEvaluationResult((Instruction)new NotInstruction(ii), true);
            }
            return new PartialEvaluationResult((Instruction)new DeepEqualityInstruction(param1, param2), true);
        }
        if (t1.equals(BooleanType.s_booleanType)) {
            IdentifierInstruction ii0 = lcm.insertBody(new CoerceInstruction(param2, t1), before2);
            if (ci.isTestingInequality()) {
                IdentifierInstruction ii = lcm.insertBody(new PrimitiveEqualityInstruction(param1, ii0), before2);
                return new PartialEvaluationResult((Instruction)new NotInstruction(ii), true);
            }
            return new PartialEvaluationResult((Instruction)new PrimitiveEqualityInstruction(param1, ii0), true);
        }
        if (t2.equals(BooleanType.s_booleanType)) {
            IdentifierInstruction ii0 = lcm.insertBody(new CoerceInstruction(param1, t2), before2);
            if (ci.isTestingInequality()) {
                IdentifierInstruction ii = lcm.insertBody(new PrimitiveEqualityInstruction(param2, ii0), before2);
                return new PartialEvaluationResult((Instruction)new NotInstruction(ii), true);
            }
            return new PartialEvaluationResult((Instruction)new PrimitiveEqualityInstruction(param2, ii0), true);
        }
        if (t1 instanceof INumericalType) {
            IdentifierInstruction ii0 = lcm.insertBody(new CoerceInstruction(param2, DoubleType.s_doubleType), before2);
            return new PartialEvaluationResult((Instruction)new EqualityInstruction(param1, ii0, ci.isTestingInequality()), true);
        }
        if (t2 instanceof INumericalType) {
            IdentifierInstruction ii0 = lcm.insertBody(new CoerceInstruction(param1, DoubleType.s_doubleType), before2);
            return new PartialEvaluationResult((Instruction)new EqualityInstruction(param2, ii0, ci.isTestingInequality()), true);
        }
        IdentifierInstruction ii1 = lcm.insertBody(new CoerceInstruction(param1, CharType.s_charType.getStreamType()), before2);
        IdentifierInstruction ii2 = lcm.insertBody(new CoerceInstruction(param2, CharType.s_charType.getStreamType()), before2);
        if (ci.isTestingInequality()) {
            IdentifierInstruction ii = lcm.insertBody(new DeepEqualityInstruction(ii1, ii2), before2);
            return new PartialEvaluationResult((Instruction)new NotInstruction(ii), true);
        }
        return new PartialEvaluationResult((Instruction)new DeepEqualityInstruction(ii1, ii2), true);
    }
}

