/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.partialeval;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.TranslateStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NumericalComparisonInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamElementInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;

public class TranslateStreamEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        TranslateStreamInstruction tsi = (TranslateStreamInstruction)x;
        Instruction opInput = tsi.getChildInstruction(0);
        Instruction opFrom = tsi.getChildInstruction(1);
        Instruction opTo = tsi.getChildInstruction(2);
        pic.partiallyEvaluate(opFrom, lcm);
        pic.partiallyEvaluate(opTo, lcm);
        Type inputType = pic.resolveType(opInput);
        LiteralInstruction.KnownValue kvFrom = PartialEvaluator.extractKnownValue(pic, opFrom, lcm);
        LiteralInstruction.KnownValue kvTo = PartialEvaluator.extractKnownValue(pic, opTo, lcm);
        PartialEvaluationResult evaluationResult = PartialEvaluationResult.s_emptyResult;
        if (inputType != null && inputType.equals(CharType.s_charType.getStreamType()) && kvFrom != null && kvTo != null) {
            String fromString = kvFrom.getStringValue();
            String toString = kvTo.getStringValue();
            boolean partiallyEvaluate = true;
            if (fromString != null && toString != null) {
                int MAX_CHAR = 128;
                char[] mapping = new char[128];
                boolean[] droppedCharacter = new boolean[128];
                for (int c = 0; c < 128; c = (int)((char)(c + 1))) {
                    mapping[c] = c;
                }
                for (int i = fromString.length() - 1; i >= 0; --i) {
                    char fromChar = fromString.charAt(i);
                    if (fromChar >= '\u0080') {
                        partiallyEvaluate = false;
                        break;
                    }
                    boolean bl = droppedCharacter[fromChar] = i >= toString.length();
                    if (droppedCharacter[fromChar]) continue;
                    mapping[fromChar] = toString.charAt(i);
                }
                if (partiallyEvaluate) {
                    LetChainBuilder lcbRangeTest = new LetChainBuilder();
                    LetChainBuilder lcbMapping = new LetChainBuilder();
                    IdentifierInstruction mappingIdent = lcm.insertBody(new StreamInstruction(new String(mapping)), before2);
                    IdentifierInstruction droppedIdent = null;
                    boolean someDropped = false;
                    for (int i = 0; i < 128 && !someDropped; ++i) {
                        someDropped = someDropped || droppedCharacter[i];
                    }
                    Integer inputCharVar = ReductionHelper.generateIntermediateIdentifier2();
                    IdentifierInstruction inputCharRef1 = new IdentifierInstruction(inputCharVar);
                    IdentifierInstruction inputCharRef2 = new IdentifierInstruction(inputCharVar);
                    Instruction inputCharRef3 = lcbMapping.bind(new CoerceInstruction(new IdentifierInstruction(inputCharVar), IntType.s_intType));
                    LiteralInstruction maxCharLit = LiteralInstruction.charLiteral('\u0080');
                    Instruction isCharOutOfRange = lcbRangeTest.bind(new NumericalComparisonInstruction(inputCharRef1, maxCharLit, 6));
                    StreamInstruction outOfRangeIdentityMapping = new StreamInstruction((Type)CharType.s_charType, inputCharRef2);
                    Instruction mapCharInst = lcbMapping.bind(new StreamElementInstruction(mappingIdent, inputCharRef3));
                    Instruction mapCharStream = lcbMapping.packageUp(new StreamInstruction((Type)CharType.s_charType, mapCharInst));
                    Instruction inRangeMapping = null;
                    if (someDropped) {
                        LetChainBuilder lcbDropTest = new LetChainBuilder();
                        Instruction[] droppedLiterals = new Instruction[droppedCharacter.length];
                        for (int i = 0; i < droppedCharacter.length; ++i) {
                            droppedLiterals[i] = LiteralInstruction.booleanLiteral(droppedCharacter[i]);
                        }
                        droppedIdent = lcm.insertBody(new StreamInstruction((Type)BooleanType.s_booleanType, droppedLiterals), before2);
                        Instruction inputCharRef4 = lcbDropTest.bind(new CoerceInstruction(new IdentifierInstruction(inputCharVar), IntType.s_intType));
                        Instruction droppedCharTest = lcbDropTest.bind(new StreamElementInstruction(droppedIdent, inputCharRef4));
                        inRangeMapping = lcbDropTest.packageUp(new ChooseInstruction(droppedCharTest, (Instruction)new StreamInstruction(CharType.s_charType), mapCharStream));
                    } else {
                        inRangeMapping = mapCharStream;
                    }
                    ForEachInstruction loop = new ForEachInstruction(opInput, inputCharVar, lcbRangeTest.packageUp(new ChooseInstruction(isCharOutOfRange, (Instruction)outOfRangeIdentityMapping, inRangeMapping)));
                    evaluationResult = new PartialEvaluationResult(loop);
                }
            }
        }
        return evaluationResult;
    }
}

