/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.analysis;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.XPathDataTypeLiteralInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.analysis.Annotation;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.EmptyXType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.FunctionDeclaration;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.SequenceXType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XTypeStore;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.ConversionEngine;
import com.ibm.xltxe.rnm1.xylem.annot.FunctionCallSpec;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotator;
import com.ibm.xltxe.rnm1.xylem.annot.IConverter;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import java.util.Collections;
import java.util.List;

public class Analyzer
implements IAnnotator {
    protected XTypeStore m_typeStore;
    private static final NamedType s_xdtType = new NamedType("XPath20Datum");
    private static final StreamType s_xdtStream = new StreamType(s_xdtType);

    public Analyzer(XTypeStore xts) {
        this.m_typeStore = xts;
    }

    @Override
    public IAnnotation analyzeExpression(AnnotationEnvironment env, Instruction expr, Object var) {
        BindingEnvironment benv;
        TypeEnvironment tenv = env.getTypeEnvironment();
        Type type2 = expr.getType(tenv, benv = env.getBindingEnvironment()).resolveType(tenv);
        if (type2.equals(s_xdtStream)) {
            if (expr instanceof StreamInstruction) {
                StreamInstruction si = (StreamInstruction)expr;
                XType xtype = EmptyXType.s_emptyXType;
                for (int i = 0; i < si.getChildInstructionCount(); ++i) {
                    Instruction x = si.getChildInstruction(i);
                    Annotation y = (Annotation)env.get(x);
                    if (y == null || y.getXType() == null) {
                        return null;
                    }
                    xtype = xtype instanceof EmptyXType ? y.getXType() : new SequenceXType(xtype, y.getXType());
                }
                return new Annotation(xtype);
            }
            if (expr instanceof ApplyInstruction) {
                ApplyInstruction ai = (ApplyInstruction)expr;
            } else if (expr instanceof IdentifierInstruction) {
                IAnnotation ann = env.get(expr);
                return ann;
            }
        } else if (type2.equals(s_xdtType) && expr instanceof ConstructorInstantiationInstruction) {
            ConstructorInstantiationInstruction cii = (ConstructorInstantiationInstruction)expr;
            XPathDataTypeLiteralInstruction xpdtli = (XPathDataTypeLiteralInstruction)NavigationUtilities.resolveReducedIdentifier(cii.m_parameters[cii.m_parameters.length - 1], benv);
            return new Annotation(xpdtli.getXType());
        }
        return null;
    }

    @Override
    public IAnnotation unionValues(AnnotationEnvironment env, List valueAnnotations) {
        return null;
    }

    @Override
    public IAnnotation interceptFunctionCall(AnnotationEnvironment env, FunctionCallInstruction fci) {
        FunctionDeclaration fd;
        BindingEnvironment benv;
        TypeEnvironment tenv = env.getTypeEnvironment();
        Type type2 = fci.getType(tenv, benv = env.getBindingEnvironment()).resolveType(tenv);
        if (type2.equals(s_xdtStream) && (fd = this.m_typeStore.lookupFunction(fci.getFunction())) != null) {
            return new Annotation(fd.getReturnType());
        }
        return null;
    }

    @Override
    public void preAnalysis(Program p) {
    }

    @Override
    public IConverter getConverter() {
        return new IConverter(){

            @Override
            public Instruction convert(Instruction expr, AnnotationEnvironment env, ConversionEngine ce) {
                return expr;
            }

            @Override
            public List getBindingList(Object var, IAnnotation a, ConversionEngine ce) {
                return null;
            }

            public List getIdentifierList(Object var, IAnnotation a, ConversionEngine ce) {
                return Collections.singletonList(new IdentifierInstruction(var));
            }

            @Override
            public void insertAnnotationOperation(IAnnotation ia, AnnotationEnvironment environment, ConversionEngine engine) {
            }

            @Override
            public void addConversionSupport(Module m) {
            }

            @Override
            public void preConversion(Program prog) {
            }

            @Override
            public Type getValueType(IAnnotation a, ConversionEngine ce) {
                return null;
            }

            @Override
            public void insertLoopBinding(IAnnotation source, IAnnotation element2, AnnotationEnvironment env, ConversionEngine ce) {
            }

            @Override
            public void insertValueDecomposition(Object valueVar, IAnnotation ia, AnnotationEnvironment env, ConversionEngine ce) {
            }
        };
    }

    @Override
    public boolean isFunctionReturnNotAnnotated(FunctionCallSpec spec) {
        return false;
    }
}

