/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.FactoredXType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.ItemXType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XType;
import com.ibm.xltxe.rnm1.xylem.parser.TypeParser;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public abstract class CompositeXType
extends XType {
    protected List<XType> m_pieces = new ArrayList<XType>();

    @Override
    public int quantifier() {
        return 0;
    }

    public CompositeXType(XType piece1, XType piece2) {
        this.m_pieces.add(piece1);
        this.m_pieces.add(piece2);
    }

    public CompositeXType(List<XType> pieces) {
        this.m_pieces.addAll(pieces);
    }

    @Override
    public void primeComponentsInternal(List<ItemXType> mylist) {
        ListIterator<XType> iter = this.m_pieces.listIterator();
        while (iter.hasNext()) {
            iter.next().primeComponentsInternal(mylist);
        }
    }

    @Override
    public int countComponents() {
        int count2 = 0;
        ListIterator<XType> iter = this.m_pieces.listIterator();
        while (iter.hasNext()) {
            count2 += iter.next().countComponents();
        }
        return count2;
    }

    @Override
    public void prettyPrint(PrettyPrinter pp) {
        if (!(this.m_stable || this != XType.s_item && this != XType.s_node && this != XType.s_atomic)) {
            pp.printToken(TypeParser.XMLTYPE_UNSTABLE_STRING);
        }
        if (this == XType.s_item) {
            pp.printToken("item");
        } else if (this == XType.s_node) {
            pp.printToken("node");
        } else if (this == XType.s_atomic) {
            pp.printToken("atomic");
        } else {
            boolean binary2;
            ListIterator<XType> iter = this.m_pieces.listIterator();
            if (!iter.hasNext()) {
                return;
            }
            XType current1 = null;
            XType current2 = iter.next();
            pp.printToken(this.getOperatorString());
            while (iter.hasNext()) {
                if (current1 == null) {
                    current1 = current2;
                    current2 = null;
                    continue;
                }
                if (current2 == null) {
                    current2 = iter.next();
                    continue;
                }
                this.prettyPrintPair(pp, current1, current2);
                current1 = current2;
                current2 = iter.next();
            }
            boolean bl = binary2 = current1 != null && current2 != null || this.isBinaryInner(current1) || this.isBinaryInner(current2);
            if (binary2) {
                this.prettyPrintPair(pp, current1, current2);
            } else if (current1 != null) {
                this.prettyPrintOperand(pp, current1);
            } else if (current2 != null) {
                this.prettyPrintOperand(pp, current2);
            }
        }
    }

    private boolean isBinaryInner(XType operand2) {
        return operand2 != null && this.isConsistentClassWithThis(operand2);
    }

    private void prettyPrintPair(PrettyPrinter pp, XType rhs, XType lhs) {
        this.prettyPrintItem(pp, rhs);
        this.prettyPrintItem(pp, lhs);
    }

    private void prettyPrintItem(PrettyPrinter pp, XType operand2) {
        if (operand2 != null) {
            if (this.isConsistentClassWithThis(operand2)) {
                if (operand2 == XType.s_item) {
                    pp.printToken(TypeParser.XMLTYPE_OPEN_STRING);
                    pp.printToken("item");
                    pp.printToken(TypeParser.XMLTYPE_CLOSE_STRING);
                } else if (operand2 == XType.s_node) {
                    pp.printToken(TypeParser.XMLTYPE_OPEN_STRING);
                    pp.printToken("node");
                    pp.printToken(TypeParser.XMLTYPE_CLOSE_STRING);
                } else if (operand2 == XType.s_atomic) {
                    pp.printToken(TypeParser.XMLTYPE_OPEN_STRING);
                    pp.printToken("atomic");
                    pp.printToken(TypeParser.XMLTYPE_CLOSE_STRING);
                } else {
                    CompositeXType operandC = (CompositeXType)operand2;
                    operandC.prettyPrint(pp);
                }
            } else {
                pp.printToken(TypeParser.XMLTYPE_OPEN_STRING);
                this.prettyPrintOperand(pp, operand2);
                pp.printToken(TypeParser.XMLTYPE_CLOSE_STRING);
            }
        }
    }

    protected static List<XType> cloneXTypes(List<XType> xtypes, boolean forked) {
        ListIterator<XType> i = xtypes.listIterator();
        ArrayList<XType> newxtypes = new ArrayList<XType>();
        while (i.hasNext()) {
            newxtypes.add(i.next().cloneXType(forked));
        }
        return newxtypes;
    }

    @Override
    public boolean isAtomicType() {
        ListIterator<XType> i = this.m_pieces.listIterator();
        while (i.hasNext()) {
            if (i.next().isAtomicType()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNodeType() {
        ListIterator<XType> i = this.m_pieces.listIterator();
        while (i.hasNext()) {
            if (i.next().isNodeType()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isStableType() {
        if (!this.m_stable) {
            return false;
        }
        ListIterator<XType> i = this.m_pieces.listIterator();
        while (i.hasNext()) {
            if (i.next().isStableType()) continue;
            return false;
        }
        return true;
    }

    private boolean isConsistentClassWithThis(XType operand2) {
        return operand2.getClass().isAssignableFrom(this.getClass());
    }

    protected abstract String getOperatorString();

    @Override
    public XType factor() {
        FactoredXType factored = new FactoredXType(this);
        return factored;
    }

    @Override
    protected boolean isSimple() {
        return false;
    }

    @Override
    protected boolean canMatchWithNonReflective(XType moreSpecific) {
        XType factored = this.factor();
        return moreSpecific.canMatchWith(factored);
    }
}

