/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.ItemXType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.NamedXType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.NodeXType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.Utilities;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XType;
import com.ibm.xltxe.rnm1.xylem.parser.TypeParser;
import javax.xml.namespace.QName;

public final class ElementXType
extends NodeXType {
    protected QName m_elementName;
    protected NamedXType m_contentType;

    public ElementXType(QName elementName, NamedXType contentType) {
        this.m_elementName = elementName;
        this.m_contentType = contentType;
    }

    public ElementXType(QName elementName, NamedXType contentType, boolean stable) {
        super(stable);
        this.m_elementName = elementName;
        this.m_contentType = contentType;
    }

    public ElementXType(QName elementName, NamedXType contentType, boolean stable, boolean isStatic) {
        super(stable, isStatic);
        this.m_elementName = elementName;
        this.m_contentType = contentType;
    }

    public ElementXType(QName elementName) {
        this.m_elementName = elementName;
        this.m_contentType = null;
    }

    public ElementXType() {
        this.m_elementName = null;
        this.m_contentType = null;
    }

    @Override
    public XType cloneXType(boolean stable) {
        ElementXType nxtype = new ElementXType(this.m_elementName, this.m_contentType);
        nxtype.propagate(this);
        if (stable) {
            nxtype.setStable();
        } else {
            nxtype.setUnstable();
        }
        return nxtype;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ElementXType)) {
            return false;
        }
        ElementXType ext = (ElementXType)obj;
        return Utilities.equalsOrSameNull(ext.m_elementName, this.m_elementName) && Utilities.equalsOrSameNull(ext.m_contentType, this.m_contentType);
    }

    public int hashCode() {
        return this.m_contentType == null ? 0 : this.m_contentType.hashCode();
    }

    public QName getElementName() {
        return this.m_elementName;
    }

    public NamedXType getContentType() {
        return this.m_contentType;
    }

    @Override
    public void prettyPrint(PrettyPrinter pp) {
        if (!this.m_stable) {
            pp.printToken(TypeParser.XMLTYPE_UNSTABLE_STRING);
        }
        pp.printToken("element");
        if (this.m_elementName != null) {
            pp.printQName(this.m_elementName);
        } else {
            pp.printToken("*");
        }
        if (this.m_contentType != null) {
            pp.printTokenNoSpace(" ");
            pp.printTokenNoSpace("@");
            if (this.m_contentType instanceof NamedXType) {
                pp.printTokenNoSpace(this.m_contentType.toString());
            } else {
                this.m_contentType.prettyPrint(pp);
            }
        }
    }

    @Override
    protected boolean semanticallyEqualsInternal(XType o, boolean approximateSequenceType) {
        if (o instanceof ElementXType && super.semanticallyEqualsInternal(o, approximateSequenceType)) {
            ElementXType elementXType2 = (ElementXType)o;
            if (this.exactlyEquals(elementXType2.m_elementName, this.m_elementName) && this.semanticallyEquals(elementXType2.m_contentType, this.m_contentType, approximateSequenceType)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected int compItemXType(ItemXType xtype) {
        ElementXType extype = (ElementXType)xtype;
        if (this.m_elementName == null) {
            if (extype.getElementName() == null) {
                if (this.m_contentType == null) {
                    if (extype.getContentType() == null) {
                        return s_isEquivalent;
                    }
                    return s_isSupertype;
                }
                if (extype.getContentType() == null) {
                    return s_isSubtype;
                }
                int compContentType = this.m_contentType.compItemXType(extype.getContentType());
                if (compContentType == s_isEquivalent) {
                    return s_isEquivalent;
                }
                if (compContentType == s_isSubtype) {
                    return s_isSubtype;
                }
                if (compContentType == s_isSupertype) {
                    return s_isSupertype;
                }
                return compContentType;
            }
            if (this.m_contentType == null) {
                return s_isSupertype;
            }
            if (extype.getContentType() == null) {
                return s_isIncomparableBigger;
            }
            int compContentType = this.m_contentType.compItemXType(extype.getContentType());
            if (compContentType == s_isEquivalent) {
                return s_isSupertype;
            }
            if (compContentType == s_isSupertype) {
                return s_isSupertype;
            }
            return s_isIncomparableBigger;
        }
        if (extype.getElementName() == null) {
            if (this.m_contentType == null) {
                if (extype.getContentType() == null) {
                    return s_isSubtype;
                }
                return s_isIncomparableSmaller;
            }
            NamedXType exContentType = extype.getContentType();
            if (exContentType == null) {
                return s_isSubtype;
            }
            int compContentType = this.m_contentType.compItemXType(exContentType);
            if (compContentType == s_isEquivalent) {
                return s_isSubtype;
            }
            if (compContentType == s_isSubtype) {
                return s_isSubtype;
            }
            return s_isIncomparableSmaller;
        }
        int encomp = this.m_elementName.toString().compareTo(extype.getElementName().toString());
        if (encomp == 0) {
            if (this.m_contentType == null) {
                if (extype.getContentType() == null) {
                    return s_isEquivalent;
                }
                return s_isSupertype;
            }
            if (extype.getContentType() == null) {
                return s_isSubtype;
            }
            return this.m_contentType.compItemXType(extype.getContentType());
        }
        if (encomp < 0) {
            return s_isDisjointSmaller;
        }
        return s_isDisjointBigger;
    }

    @Override
    protected int getOrder() {
        return 5;
    }
}

