/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.ItemXType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.OccurrenceXType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XType;
import com.ibm.xltxe.rnm1.xylem.parser.TypeParser;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;

public class FactoredXType
extends XType {
    protected List<ItemXType> m_pieces;
    protected int m_occurrence;
    private static Comparator<ItemXType> s_item_comp = new Comparator<ItemXType>(){

        @Override
        public int compare(ItemXType xtype1, ItemXType xtype2) {
            int rawComp = ItemXType.compItemXTypes(xtype1, xtype2);
            assert (rawComp == -ItemXType.compItemXTypes(xtype2, xtype1)) : "Type comparison is not symmetric for " + xtype1 + "," + xtype2;
            int sortingComp = rawComp == XType.s_isDisjointSmaller || rawComp == XType.s_isIncomparableSmaller || rawComp == XType.s_isSubtype ? -1 : (rawComp == XType.s_isDisjointBigger || rawComp == XType.s_isIncomparableBigger || rawComp == XType.s_isSupertype ? 1 : 0);
            return sortingComp;
        }
    };

    public FactoredXType(XType xtype) {
        this.m_pieces = xtype.primeComponents();
        this.m_occurrence = xtype.quantifier();
        if (xtype.isStableType()) {
            this.setStable();
        } else {
            this.setUnstable();
        }
        this.consolidatePieces();
    }

    public FactoredXType(XType xtype, int occ) {
        this.m_pieces = xtype.primeComponents();
        this.m_occurrence = occ;
        this.consolidatePieces();
    }

    protected static XType makeSafeFactoredXType(XType t) {
        if (t instanceof ItemXType) {
            return new FactoredXType(t);
        }
        return t;
    }

    public FactoredXType(List<ItemXType> pieces, int occ) {
        this.m_pieces = pieces;
        this.m_occurrence = occ;
    }

    @Override
    public XType factor() {
        if (this.m_occurrence == 0 && this.m_pieces.size() == 1) {
            return this.m_pieces.get(0);
        }
        return this;
    }

    @Override
    public XType cloneXType(boolean stable) {
        ListIterator<ItemXType> i = this.m_pieces.listIterator();
        ArrayList newpieces = this.m_pieces instanceof OrderedList ? new OrderedList() : new ArrayList();
        while (i.hasNext()) {
            newpieces.add((ItemXType)i.next().cloneXType(stable));
        }
        FactoredXType nxtype = new FactoredXType(newpieces, this.m_occurrence);
        nxtype.propagate(this);
        if (stable) {
            nxtype.setStable();
        } else {
            nxtype.setUnstable();
        }
        return nxtype;
    }

    @Override
    public boolean isAtomicType() {
        ListIterator<ItemXType> i = this.m_pieces.listIterator();
        while (i.hasNext()) {
            if (i.next().isAtomicType()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNodeType() {
        ListIterator<ItemXType> i = this.m_pieces.listIterator();
        while (i.hasNext()) {
            if (i.next().isNodeType()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isStableType() {
        if (!this.m_stable) {
            return false;
        }
        ListIterator<ItemXType> i = this.m_pieces.listIterator();
        while (i.hasNext()) {
            if (i.next().isStableType()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ItemXType> primeComponents() {
        ArrayList newpieces = this.m_pieces instanceof OrderedList ? new OrderedList() : new ArrayList();
        this.primeComponentsInternal(newpieces);
        return newpieces;
    }

    @Override
    public void primeComponentsInternal(List<ItemXType> mylist) {
        mylist.addAll(this.m_pieces);
    }

    @Override
    public int countComponents() {
        return this.m_pieces.size();
    }

    @Override
    public void collectComponentList(List<XType> components, XType.ListType listType) {
        if (listType == XType.ListType.UNION) {
            components.addAll(this.m_pieces);
        } else {
            components.add(this);
        }
    }

    @Override
    public int quantifier() {
        return this.m_occurrence;
    }

    private XType rebuildXType() {
        return new OccurrenceXType(this.prime(), this.quantifier());
    }

    private void consolidatePieces() {
        if (this.m_pieces instanceof OrderedList) {
            return;
        }
        switch (this.m_pieces.size()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                ItemXType firstType = this.m_pieces.get(0);
                ItemXType secondType = this.m_pieces.get(1);
                if (s_item_comp.compare(firstType, secondType) <= 0) break;
                this.m_pieces.set(0, secondType);
                this.m_pieces.set(1, firstType);
                break;
            }
            default: {
                List<ItemXType> thelist = this.m_pieces;
                TreeSet<ItemXType> theset = new TreeSet<ItemXType>(s_item_comp);
                theset.addAll(thelist);
                this.m_pieces = new OrderedList(theset);
                break;
            }
        }
    }

    @Override
    public void prettyPrint(PrettyPrinter pp) {
        boolean isInsideOccurence;
        switch (this.m_occurrence) {
            case 0: {
                isInsideOccurence = false;
                break;
            }
            case -1: {
                pp.printTokenNoSpace("?");
                isInsideOccurence = true;
                break;
            }
            case -2: {
                pp.printTokenNoSpace("+");
                isInsideOccurence = true;
                break;
            }
            default: {
                pp.printTokenNoSpace("*");
                isInsideOccurence = true;
            }
        }
        if (!this.m_stable) {
            pp.printToken(TypeParser.XMLTYPE_UNSTABLE_STRING);
        }
        if (isInsideOccurence) {
            pp.printTokenNoSpace(TypeParser.XMLTYPE_OPEN_STRING);
        }
        pp.printTokenNoSpace("|");
        for (ItemXType item2 : this.m_pieces) {
            pp.printTokenNoSpace(TypeParser.XMLTYPE_OPEN_STRING);
            this.prettyPrintOperand(pp, item2);
            pp.printTokenNoSpace(TypeParser.XMLTYPE_CLOSE_STRING);
        }
        if (isInsideOccurence) {
            pp.printTokenNoSpace(TypeParser.XMLTYPE_CLOSE_STRING);
        }
    }

    @Override
    protected boolean semanticallyEqualsInternal(XType o, boolean approximateSequenceType) {
        if (o == null) {
            return false;
        }
        this.consolidatePieces();
        if (o instanceof FactoredXType) {
            FactoredXType type2 = (FactoredXType)o;
            type2.consolidatePieces();
            int sz1 = this.m_pieces.size();
            int sz2 = type2.m_pieces.size();
            if (sz1 == sz2) {
                for (int i = 0; i < sz1; ++i) {
                    ItemXType t2;
                    ItemXType t1 = this.m_pieces.get(i);
                    if (t1.semanticallyEqualsInternal(t2 = type2.m_pieces.get(i), approximateSequenceType)) continue;
                    return false;
                }
                return true;
            }
        } else if (this.m_pieces.size() == 1) {
            return this.m_pieces.get(0).semanticallyEqualsInternal(o, approximateSequenceType);
        }
        return false;
    }

    @Override
    public boolean canMatchWithNonReflective(XType moreSpecific) {
        if ((moreSpecific = moreSpecific.factor()) instanceof FactoredXType) {
            FactoredXType fftMoreSpecific = (FactoredXType)moreSpecific;
            if (fftMoreSpecific.m_pieces.size() == 1) {
                moreSpecific = fftMoreSpecific.m_pieces.get(0);
            } else {
                for (ItemXType moreSpecificItem : fftMoreSpecific.m_pieces) {
                    for (ItemXType moreGeneralItem : this.m_pieces) {
                        if (!moreGeneralItem.canMatchWith(moreSpecificItem)) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        if (moreSpecific instanceof ItemXType) {
            for (ItemXType itemXType : this.m_pieces) {
                if (!itemXType.canMatchWith(moreSpecific)) continue;
                return true;
            }
        }
        return false;
    }

    protected int diffPrimes(FactoredXType t2) {
        FactoredXType t1 = this;
        t1.consolidatePieces();
        t2.consolidatePieces();
        ListIterator<ItemXType> iter1 = t1.m_pieces.listIterator();
        ListIterator<ItemXType> iter2 = t2.m_pieces.listIterator();
        if (!iter2.hasNext()) {
            if (!iter1.hasNext()) {
                return 0;
            }
            return -1;
        }
        if (!iter1.hasNext()) {
            return 1;
        }
        ItemXType current1 = iter1.next();
        ItemXType current2 = iter2.next();
        while (true) {
            int comp_items;
            if ((comp_items = ItemXType.compItemXTypes(current1, current2)) == s_isDisjointSmaller) {
                return -1;
            }
            if (comp_items == s_isIncomparableBigger || comp_items == s_isIncomparableSmaller || comp_items == s_isSupertype) {
                return -1;
            }
            if (comp_items == s_isDisjointBigger) {
                if (!iter2.hasNext()) {
                    return -1;
                }
                current2 = iter2.next();
                continue;
            }
            if (comp_items != s_isSubtype && comp_items != s_isEquivalent) continue;
            if (!iter1.hasNext()) break;
            current1 = iter1.next();
        }
        if (iter1.hasNext()) {
            return -1;
        }
        return 1;
    }

    protected boolean isFactoredSubtype(FactoredXType t1) {
        if (!OccurrenceXType.isSubOccurrence(this.m_occurrence, t1.m_occurrence)) {
            return false;
        }
        int diff = this.diffPrimes(t1);
        return diff != -1;
    }

    @Override
    protected boolean isSimple() {
        return false;
    }

    private static class OrderedList
    extends ArrayList {
        public OrderedList() {
        }

        public OrderedList(TreeSet<ItemXType> theset) {
            super(theset);
        }
    }
}

