/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem;

import java.io.PrintWriter;
import java.util.HashMap;
import javax.xml.namespace.QName;

public class PrettyPrinter {
    protected HashMap m_prefixes = new HashMap();
    protected PrintWriter m_pw;
    protected int m_indent = 0;
    protected int m_lineMax = 100;
    protected int m_pos = 0;
    protected int m_uniquePrefixCount = 0;
    public boolean m_suppressNewlines = false;

    public PrettyPrinter(PrintWriter pw) {
        this.m_pw = pw;
    }

    public String generateUniquePrefix() {
        String s;
        while (this.m_prefixes.containsKey(s = "ns" + ++this.m_uniquePrefixCount)) {
        }
        return s;
    }

    public void printQName(QName qn) {
        String nsURI = qn.getNamespaceURI();
        if (nsURI == null || nsURI.length() == 0) {
            this.printToken(qn.getLocalPart());
            return;
        }
        String prefix2 = qn.getPrefix();
        if (prefix2 == null || prefix2.length() == 0) {
            prefix2 = this.generateUniquePrefix();
        }
        if (!this.m_prefixes.containsKey(prefix2)) {
            this.m_prefixes.put(prefix2, nsURI);
        } else if (!this.m_prefixes.get(prefix2).equals(nsURI)) {
            prefix2 = this.generateUniquePrefix();
            this.m_prefixes.put(prefix2, nsURI);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(prefix2);
        sb.append(':');
        sb.append(qn.getLocalPart());
        this.printToken(sb.toString());
    }

    public void printToken(String s) {
        int len = s.length() + 1;
        if (len + this.m_pos > this.m_lineMax) {
            this.newline();
        }
        this.m_pw.print(s);
        this.m_pw.print(' ');
        this.m_pos += len;
    }

    public void printTokenNoSpace(String s) {
        int len = s.length();
        if (len + this.m_pos > this.m_lineMax) {
            this.newline();
        }
        this.m_pw.print(s);
        this.m_pos += len;
    }

    public void indent() {
        ++this.m_indent;
    }

    public void outdent() {
        --this.m_indent;
    }

    public void newline() {
        if (this.m_suppressNewlines || this.m_pos == this.m_indent * 2) {
            return;
        }
        this.m_pw.println();
        this.m_pos = 0;
        for (int i = 0; i < this.m_indent; ++i) {
            this.m_pw.print("  ");
            this.m_pos += 2;
        }
    }

    public String generatePrefixes() {
        StringBuffer sb = new StringBuffer();
        for (Object x : this.m_prefixes.keySet()) {
            if (x.equals("xs") || x.equals("xdt")) continue;
            Object y = this.m_prefixes.get(x);
            sb.append("namespace ");
            sb.append(x);
            sb.append(" = \"");
            sb.append(y);
            sb.append('\"');
            if (!this.m_suppressNewlines) {
                sb.append('\n');
                continue;
            }
            sb.append(' ');
        }
        return sb.toString();
    }
}

