/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.CompositeXType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XType;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class SequenceXType
extends CompositeXType {
    public SequenceXType(XType piece1, XType piece2) {
        super(piece1, piece2);
    }

    public SequenceXType(List<XType> pieces) {
        super(pieces);
    }

    @Override
    public XType cloneXType(boolean forked) {
        List<XType> newpieces = CompositeXType.cloneXTypes(this.m_pieces, forked);
        SequenceXType nxtype = new SequenceXType(newpieces);
        nxtype.propagate(this);
        if (forked) {
            nxtype.setStable();
        } else {
            nxtype.setUnstable();
        }
        return nxtype;
    }

    @Override
    public int quantifier() {
        ListIterator iter = this.m_pieces.listIterator();
        if (!iter.hasNext()) {
            return 0;
        }
        int current2 = ((XType)iter.next()).quantifier();
        if (!iter.hasNext()) {
            return current2;
        }
        while (iter.hasNext()) {
            current2 = this.commaOccurrence(current2, ((XType)iter.next()).quantifier());
        }
        return current2;
    }

    @Override
    protected String getOperatorString() {
        return ",";
    }

    private static boolean isOptional(int quantifier) {
        return quantifier == -3 || quantifier == -1;
    }

    @Override
    public void collectComponentList(List<XType> components, XType.ListType listType) {
        if (listType == XType.ListType.SEQUENCE) {
            ListIterator iter = this.m_pieces.listIterator();
            while (iter.hasNext()) {
                ((XType)iter.next()).collectComponentList(components, listType);
            }
        } else {
            components.add(this);
        }
    }

    static List<XType> consolidate(List<XType> list, boolean approximateSequenceType) {
        ArrayList<XType> resultList = new ArrayList<XType>();
        for (XType xType1 : list) {
            int resultListSz = resultList.size();
            if (resultListSz > 1) {
                XType xTypePrev = (XType)resultList.get(resultListSz - 1);
                int quantifier1 = xType1.quantifier();
                int quantifierPrev = xTypePrev.quantifier();
                if (SequenceXType.isOptional(quantifier1) && SequenceXType.isOptional(quantifierPrev) && xTypePrev.semanticallyEqualsInternal(xType1, approximateSequenceType)) continue;
            }
            resultList.add(xType1);
        }
        return resultList;
    }

    List<XType> getConsolodatedList(boolean approximateSequenceType) {
        ArrayList<XType> components = new ArrayList<XType>();
        this.collectComponentList(components, XType.ListType.SEQUENCE);
        List<XType> consolidated1 = SequenceXType.consolidate(components, approximateSequenceType);
        return consolidated1;
    }

    @Override
    protected boolean semanticallyEqualsInternal(XType o, boolean approximateSequenceType) {
        if (o instanceof SequenceXType) {
            int quantifier2;
            SequenceXType sequenceXType2 = (SequenceXType)o;
            int quantifier1 = this.quantifier();
            if (quantifier1 != (quantifier2 = sequenceXType2.quantifier())) {
                return false;
            }
            if (approximateSequenceType) {
                List<XType> consolidated1 = this.getConsolodatedList(approximateSequenceType);
                List<XType> consolidated2 = sequenceXType2.getConsolodatedList(approximateSequenceType);
                int sz1 = consolidated1.size();
                if (sz1 != consolidated2.size()) {
                    return false;
                }
                for (int i = 0; i < sz1; ++i) {
                    XType xtype2;
                    XType xtype1 = consolidated1.get(i);
                    if (xtype1.semanticallyEqualsInternal(xtype2 = consolidated2.get(i), approximateSequenceType)) continue;
                    return false;
                }
                return true;
            }
            if (sequenceXType2.m_pieces.size() == this.m_pieces.size()) {
                ListIterator iter1 = this.m_pieces.listIterator();
                ListIterator iter2 = sequenceXType2.m_pieces.listIterator();
                while (iter1.hasNext()) {
                    if (this.semanticallyEquals((XType)iter1.next(), (XType)iter2.next(), approximateSequenceType)) continue;
                    return false;
                }
            }
        }
        return false;
    }
}

