/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.CompositeXType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XType;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class UnionXType
extends CompositeXType {
    public UnionXType(XType piece1, XType piece2) {
        super(piece1, piece2);
        assert (piece1 != null);
        assert (piece2 != null);
    }

    public UnionXType(List<XType> pieces) {
        super(pieces);
    }

    @Override
    public XType cloneXType(boolean forked) {
        List<XType> newpieces = CompositeXType.cloneXTypes(this.m_pieces, forked);
        UnionXType nxtype = new UnionXType(newpieces);
        nxtype.propagate(this);
        if (forked) {
            nxtype.setStable();
        } else {
            nxtype.setUnstable();
        }
        return nxtype;
    }

    @Override
    public int quantifier() {
        ListIterator iter = this.m_pieces.listIterator();
        if (!iter.hasNext()) {
            return 0;
        }
        int current2 = ((XType)iter.next()).quantifier();
        if (!iter.hasNext()) {
            return current2;
        }
        while (iter.hasNext()) {
            current2 = this.unionOccurrence(current2, ((XType)iter.next()).quantifier());
        }
        return current2;
    }

    @Override
    protected String getOperatorString() {
        return "|";
    }

    @Override
    public void collectComponentList(List<XType> components, XType.ListType listType) {
        if (listType == XType.ListType.UNION) {
            ListIterator iter = this.m_pieces.listIterator();
            while (iter.hasNext()) {
                ((XType)iter.next()).collectComponentList(components, listType);
            }
        } else {
            components.add(this);
        }
    }

    static List<XType> consolidate(List<XType> list, boolean approximateSequenceType) {
        ArrayList<XType> resultList = new ArrayList<XType>();
        int sz = list.size();
        for (int i = 0; i < sz; ++i) {
            XType xType2;
            int j;
            XType xType1 = list.get(i);
            int sz2 = resultList.size();
            for (j = 0; j < sz2 && !(xType2 = (XType)resultList.get(j)).semanticallyEqualsInternal(xType1, approximateSequenceType); ++j) {
            }
            if (j != sz2) continue;
            resultList.add(xType1);
        }
        return resultList;
    }

    List<XType> getConsolodatedList(boolean approximateSequenceType) {
        ArrayList<XType> components = new ArrayList<XType>();
        this.collectComponentList(components, XType.ListType.UNION);
        List<XType> consolidated = UnionXType.consolidate(components, approximateSequenceType);
        return consolidated;
    }

    private boolean compareOrderIndependent(List<XType> t1list, List<XType> t2list, boolean approximateSequenceType) {
        int sz = t1list.size();
        if (sz != t2list.size()) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            int j;
            XType t1 = t1list.get(i);
            for (j = 0; j < sz; ++j) {
                XType t2 = t2list.get(j);
                if (t2 == null || !t2.semanticallyEqualsInternal(t1, approximateSequenceType)) continue;
                t2list.set(j, null);
                break;
            }
            if (j != sz) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean semanticallyEqualsInternal(XType o, boolean approximateSequenceType) {
        if (o instanceof UnionXType) {
            UnionXType unionXType2 = (UnionXType)o;
            List<XType> t1list = this.getConsolodatedList(approximateSequenceType);
            List<XType> t2list = unionXType2.getConsolodatedList(approximateSequenceType);
            return this.compareOrderIndependent(t1list, t2list, approximateSequenceType);
        }
        return false;
    }
}

