/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataTypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.ClassType;
import com.ibm.xltxe.rnm1.xylem.types.CompoundType;
import com.ibm.xltxe.rnm1.xylem.types.ConstructorDataType;
import com.ibm.xltxe.rnm1.xylem.types.TypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AbstractTypeStore
implements ITypeStore {
    private static final Logger s_logger = LoggerUtil.getLogger(AbstractTypeStore.class);
    private static final String s_className = AbstractTypeStore.class.getName();
    protected HashMap m_classes = new HashMap();
    protected HashMap m_compoundTypes = new HashMap();
    protected HashMap m_constructors = new HashMap();
    protected HashMap m_adts = new HashMap();
    protected HashMap m_typeAliases = new HashMap();
    protected ArrayList m_adtDefinitions = new ArrayList();
    protected HashMap m_genericADTs = new HashMap();
    protected HashMap m_typeLambdas = new HashMap();
    protected String m_name = "";
    Comparator m_comp = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            return ((AbstractDataType)arg0).getName().compareTo(((AbstractDataType)arg1).getName());
        }
    };

    @Override
    public final void addAbstractDataType(AbstractDataType s) {
        int insert2 = Collections.binarySearch(this.m_adtDefinitions, s, this.m_comp);
        if (insert2 >= 0) {
            this.m_adtDefinitions.set(insert2, s);
        } else {
            this.m_adtDefinitions.add(-insert2 - 1, s);
        }
        this.m_adts.put(s.getName(), s);
        this.m_compoundTypes.put(s.getName(), s);
        for (int i = 0; i < s.m_constructors.length; ++i) {
            this.m_constructors.put(s.m_constructors[i].getName(), s.m_constructors[i]);
        }
        s.setTypeStore(this);
    }

    @Override
    public AbstractDataType.Constructor getConstructor(String name2) {
        return (AbstractDataType.Constructor)this.m_constructors.get(name2);
    }

    @Override
    public CompoundType lookupCompoundType(String typeName) {
        return (CompoundType)this.m_compoundTypes.get(typeName);
    }

    @Override
    public AbstractDataType getAbstractDataType(String name2) {
        for (AbstractDataType a : this.getAbstractDataTypes()) {
            if (!a.getName().equals(name2)) continue;
            return a;
        }
        return null;
    }

    @Override
    public final Iterator getAbstractDataTypesIterator() {
        return this.m_adtDefinitions.iterator();
    }

    public final List getAbstractDataTypes() {
        return Collections.unmodifiableList(this.m_adtDefinitions);
    }

    @Override
    public int getAbstractDataTypesCount() {
        return this.m_adtDefinitions.size();
    }

    @Override
    public void addTypeAlias(String aliasName, Type existingType) {
        if (this.m_typeAliases.containsKey(aliasName)) {
            this.m_typeAliases.remove(aliasName);
        }
        this.m_typeAliases.put(aliasName, existingType);
    }

    @Override
    public Type lookupTypeAlias(String aliasName) {
        return (Type)this.m_typeAliases.get(aliasName);
    }

    public Collection getTypeAliases() {
        return this.m_typeAliases.values();
    }

    public Set getTypeAliasNames() {
        return this.m_typeAliases.keySet();
    }

    @Override
    public void addClass(ClassType ct) {
        this.m_classes.put(ct.getName(), ct);
        this.m_compoundTypes.put(ct.getName(), ct);
        ct.setTypeStore(this);
    }

    @Override
    public int getClassesCount() {
        return this.m_classes.size();
    }

    @Override
    public Iterator getClassesIterator() {
        return this.m_classes.values().iterator();
    }

    public static void readTypes(ITypeStore ts, ReadObjectFileHelper rofh) throws Exception {
        CompoundType cdt;
        int i;
        int c = rofh.readInt();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "readTypes", "There are " + c + " ADTs");
        }
        for (i = 0; i < c; ++i) {
            cdt = new ConstructorDataType();
            ((ConstructorDataType)cdt).read(rofh);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "readTypes", "Adding a CDT: " + cdt);
            }
            ts.addAbstractDataType((AbstractDataType)cdt);
        }
        c = rofh.readInt();
        for (i = 0; i < c; ++i) {
            cdt = new ClassType();
            ((ClassType)cdt).read(rofh);
            ts.addClass((ClassType)cdt);
        }
        int numlams = rofh.readInt();
        for (int k = 0; k < numlams; ++k) {
            String name2 = rofh.readString();
            TypeLambda t = rofh.readTypeLambda();
            ts.addTypeLambda(name2, t);
        }
        c = rofh.readInt();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "readTypes", "There are " + c + " generic ADTs");
        }
        for (int i2 = 0; i2 < c; ++i2) {
            AbstractDataTypeLambda lam = AbstractDataTypeLambda.read_static(ts.getName(), rofh);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "readTypes", "Adding a generic ADT: " + lam);
            }
            ts.addGenericAbstractDataType(lam.getName(), lam.getTypeParameters(), lam.m_constructors);
        }
    }

    public static void writeTypes(ITypeStore ts, WriteObjectFileHelper wofh) throws IOException {
        CompoundType adt;
        Iterator i = ts.getAbstractDataTypesIterator();
        wofh.writeInt(ts.getAbstractDataTypesCount());
        while (i.hasNext()) {
            adt = (AbstractDataType)i.next();
            adt.write(wofh);
        }
        i = ts.getClassesIterator();
        wofh.writeInt(ts.getClassesCount());
        while (i.hasNext()) {
            adt = (ClassType)i.next();
            ((ClassType)adt).write(wofh);
        }
        Iterator it = ts.getTypeLambdaNamesIterator();
        wofh.writeInt(ts.getTypeLambdasCount());
        while (it.hasNext()) {
            String name2 = (String)it.next();
            wofh.writeString(name2);
            TypeLambda t = ts.lookupTypeLambda(name2);
            wofh.writeTypeLambda(t);
        }
        Iterator j = ts.getGenericAbstractDataTypesIterator();
        wofh.writeInt(ts.getGenericAbstractDataTypesCount());
        while (j.hasNext()) {
            AbstractDataTypeLambda adt2 = ts.getGenericADT((String)j.next());
            adt2.write(wofh);
        }
    }

    @Override
    public TypeLambda lookupTypeLambda(String name2) {
        return (TypeLambda)this.m_typeLambdas.get(name2);
    }

    @Override
    public void addTypeLambda(String name2, TypeLambda lam) {
        this.m_typeLambdas.put(name2, lam);
    }

    @Override
    public int getTypeLambdasCount() {
        return this.m_typeLambdas.size();
    }

    @Override
    public Iterator getTypeLambdaNamesIterator() {
        return this.m_typeLambdas.keySet().iterator();
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String name2) {
        this.m_name = name2;
    }

    public boolean matchesName(String name2) {
        return name2 == null || name2.length() == 0 || name2.equals(this.m_name);
    }

    @Override
    public void addGenericAbstractDataType(String name2, TypeVariable[] parms, AbstractDataType.Constructor[] constructors) {
        if (this.m_genericADTs.containsKey(name2)) {
            throw new XylemError("ERR_SYSTEM", "Tried to redefine generic abstract data type " + name2 + " in type store " + this.getName());
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "addGenericAbstractDataType", "Hashcode: " + this.hashCode() + " (" + this.getClass().toString() + ")");
            s_logger.logp(Level.FINEST, s_className, "addGenericAbstractDataType", "Adding generic ADT " + name2 + " to type store " + this.getName());
        }
        AbstractDataTypeLambda lam = new AbstractDataTypeLambda(this.getName(), name2, parms, constructors);
        this.m_genericADTs.put(name2, lam);
        lam.setTypeStore(this);
        for (int i = 0; i < constructors.length; ++i) {
            if (this.m_constructors.get(constructors[i].getName()) != null && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "addGenericAbstractDataType", "WARNING: variant type " + constructors[i].getName() + " shadows a previous definition!");
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "addGenericAbstractDataType", "Adding generic constructor " + constructors[i].getName());
            }
            this.m_constructors.put(constructors[i].getName(), constructors[i]);
        }
    }

    @Override
    public AbstractDataTypeLambda getGenericADT(String name2) {
        return (AbstractDataTypeLambda)this.m_genericADTs.get(name2);
    }

    public AbstractDataType instantiateGenericADT(String name2, Type[] args) {
        AbstractDataTypeLambda genericADT = this.getGenericADT(name2);
        if (genericADT == null) {
            throw new RuntimeException("Tried to instantiate a non-existant generic ADT: " + name2);
        }
        return this.instantiateGenericADT(genericADT, args);
    }

    public AbstractDataType instantiateGenericADT(AbstractDataTypeLambda genericADT, Type[] args) {
        if (genericADT == null) {
            throw new XylemError("ERR_SYSTEM", "generic adt was null");
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "instantiateGenericADT", "Instantiating generic ADT " + genericADT.getName() + " in type store " + this.getName());
        }
        AbstractDataType adt = genericADT.applyADT(this, args);
        this.addAbstractDataType(adt);
        return adt;
    }

    @Override
    public Iterator getGenericAbstractDataTypesIterator() {
        return this.m_genericADTs.keySet().iterator();
    }

    @Override
    public int getGenericAbstractDataTypesCount() {
        return this.m_genericADTs.size();
    }

    protected void clearADTs() {
        this.m_adts.clear();
        this.m_adtDefinitions.clear();
        this.m_constructors.clear();
    }
}

