/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.AbstractTypeStore;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataTypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.ConstructorDataType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class BaseDesugarer
extends Optimizer {
    protected Module m_prog;

    public BaseDesugarer(Module prog) {
        this.m_prog = prog;
    }

    protected void convertADTs() {
        boolean worked;
        HashSet<AbstractDataType> done = new HashSet<AbstractDataType>();
        do {
            Iterator i = new ArrayList(this.m_prog.getAbstractDataTypes()).iterator();
            worked = false;
            while (i.hasNext()) {
                AbstractDataType adt = (AbstractDataType)i.next();
                if (done.contains(adt)) continue;
                for (int j = 0; j < adt.m_constructors.length; ++j) {
                    AbstractDataType.Constructor c = adt.m_constructors[j];
                    for (int k = 0; k < c.m_parameters.length; ++k) {
                        Binding b = c.m_parameters[k];
                        b.setType(this.convertType(b.getBindingType()));
                    }
                }
                done.add(adt);
                worked = true;
            }
        } while (worked);
    }

    protected void convertFunctionSignatures() {
        Iterator<Function> i = this.m_prog.m_functions.values().iterator();
        while (i.hasNext()) {
            Function f2;
            this.m_currentFunction = f2 = i.next();
            FunctionSignature fs = this.m_prog.getFunctionSignature(this.m_currentFunction.getName());
            for (int k = 0; k < f2.m_parameters.length; ++k) {
                Binding b = f2.m_parameters[k];
                Type newType = this.convertType(b.getBindingType());
                b.setType(newType);
                if (fs == null) continue;
                fs.setParameterType(k, newType);
            }
            f2.setReturnType(this.convertType(f2.getReturnType()));
            if (fs != null) {
                fs.m_returnType = f2.getReturnType();
            }
            this.m_currentFunction = null;
        }
    }

    public void desugar() {
        this.convertADTs();
        this.convertFunctionSignatures();
        this.m_prog.optimize(this);
        this.m_prog.clearTypeInformation(true);
        try {
            this.m_prog.typeCheckReduced();
        }
        catch (TypeCheckException e) {
            throw new RuntimeException(e);
        }
    }

    public static String generateTypeName(Type[] types2, String name2) {
        StringBuffer sb = new StringBuffer(name2);
        for (int i = 0; i < types2.length; ++i) {
            sb.append("_");
            sb.append(types2[i].toString());
        }
        return sb.toString().replace('[', 'Z').replace(']', 'Z').replace('.', '_').replace(' ', '_').replace('-', '_').replace('>', '_').replace('(', 'Z').replace(')', 'Z').replace(',', '_').replace('/', '_');
    }

    public static Type generateType(Module p, Type[] types2, String tname) {
        String name2 = BaseDesugarer.generateTypeName(types2, tname);
        AbstractDataType adt = (AbstractDataType)p.lookupCompoundType(name2);
        if (adt == null) {
            Binding[] bindings = new Binding[types2.length];
            for (int i = 0; i < types2.length; ++i) {
                bindings[i] = new Binding((Object)("x" + i), types2[i]);
            }
            AbstractDataType.Constructor c = new AbstractDataType.Constructor(name2, bindings);
            adt = new ConstructorDataType(name2, new AbstractDataType.Constructor[]{c});
            p.addAbstractDataType(adt);
        }
        return new NamedType(adt.getName());
    }

    public static Type generateUnionType(Module p, Type[] types2, String uname) {
        String name2 = BaseDesugarer.generateTypeName(types2, uname);
        AbstractDataType adt = (AbstractDataType)p.lookupCompoundType(name2);
        if (adt != null) {
            return new NamedType(adt.getName());
        }
        AbstractDataType.Constructor[] ctors = new AbstractDataType.Constructor[types2.length];
        for (int i = 0; i < types2.length; ++i) {
            Binding binding = new Binding((Object)("x" + i), types2[i]);
            ctors[i] = new AbstractDataType.Constructor(name2 + "_" + i, new Binding[]{binding});
        }
        adt = new ConstructorDataType(name2, ctors);
        p.addAbstractDataType(adt);
        return new NamedType(adt.getName());
    }

    public Type[] convertTypes(Type[] ts) {
        Type[] newTs = new Type[ts.length];
        for (int i = 0; i < ts.length; ++i) {
            newTs[i] = this.convertType(ts[i]);
        }
        return newTs;
    }

    public Type convertType(Type t) {
        Type type2;
        if (t == null) {
            throw new RuntimeException();
        }
        Type type3 = type2 = this.getCurrentFunction() == null ? t : t.resolveType(this.getCurrentFunction().getTypeEnvironment());
        if (type2 instanceof NamedType) {
            Module store;
            AbstractDataTypeLambda adtl;
            NamedType nt = (NamedType)type2;
            if (nt.getTypeParameters() != null && (adtl = ((AbstractTypeStore)(store = this.m_prog)).getGenericADT(nt.getName())) != null) {
                return adtl.applyADT(store, this.convertTypes(nt.getTypeParameters())).getNamedType();
            }
            return type2;
        }
        if (type2 == null) {
            String msg = "Couldn't figure out a type in function " + this.m_currentFunction.getName();
            throw new XylemError("ERR_SYSTEM", msg);
        }
        int c = type2.getChildTypeCount();
        for (int i = 0; i < c; ++i) {
            type2.setChildType(i, this.convertType(type2.getChildType(i)));
        }
        return type2;
    }

    @Override
    public Instruction optimize(Instruction n2) {
        Instruction n22;
        if (!(n2 instanceof LetInstruction)) {
            this.optimizeChildren(n2);
        }
        if ((n22 = this.optimizeStep(n2, null, -1)) == null) {
            return n2;
        }
        return n22;
    }

    @Override
    protected void optimizeChildren(Instruction n2) {
        if (n2 instanceof LetInstruction) {
            this.optimizeStep(n2, null, -1);
        } else {
            int c = n2.getChildInstructionCount();
            for (int i = 0; i < c; ++i) {
                Instruction n4;
                Instruction n3 = n2.getChildInstruction(i);
                this.optimizeChildren(n3);
                if (n3 instanceof LetInstruction || (n4 = this.optimizeStep(n3, n2, i)) == null || n4 == n3) continue;
                n2.setChildInstruction(i, n4);
                n3.m_bindingEnvironment = null;
            }
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction n2, Instruction parent2, int parentIndex) {
        Instruction body;
        if (!(n2 instanceof LetInstruction)) {
            return this.optimizeStep2(n2);
        }
        Instruction blankReturn = null;
        LetInstruction let = (LetInstruction)n2;
        while (true) {
            Instruction value2 = let.getValue();
            this.optimizeChildren(value2);
            Instruction value22 = this.optimizeStep2(value2);
            let.setValue(value22);
            body = let.getBody();
            if (!(body instanceof LetInstruction)) break;
            parent2 = let;
            parentIndex = 1;
            let = (LetInstruction)body;
        }
        this.optimizeChildren(body);
        let.setBody(this.optimizeStep2(body));
        return blankReturn;
    }

    public Instruction optimizeStep2(Instruction n2) {
        if (n2 instanceof LambdaInstruction) {
            LambdaInstruction li = (LambdaInstruction)n2;
            Binding[] bindings = (Binding[])li.getChildInstructionBindings(0);
            int c = bindings.length;
            for (int i = 0; i < c; ++i) {
                bindings[i].setType(this.convertType(bindings[i].getBindingType()));
            }
        } else {
            int c = n2.getTypeParameterCount();
            for (int i = 0; i < c; ++i) {
                if (n2.getTypeParameter(i) == null) {
                    throw new RuntimeException("Instruction " + n2 + " parameter " + i + " (" + n2.getChildInstruction(i) + ") is null");
                }
                n2.setTypeParameter(i, this.convertType(n2.getTypeParameter(i)));
            }
        }
        return n2;
    }

    public static void main(String[] args) {
        Module module = new Module(args[0], null);
        BaseDesugarer desugarer = new BaseDesugarer(module);
        desugarer.desugar();
    }
}

