/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGeneration;
import com.ibm.xltxe.rnm1.xylem.dataflow.ForkInformation;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.Serializable;

public final class Binding
implements IBinding,
Serializable {
    private static final long serialVersionUID = -6921253073966497695L;
    protected Object m_name;
    protected Type m_type;
    protected TypeEnvironment m_typeEnvironment;
    protected ISpecialForm m_origin;
    private int m_stackFramePos;
    private int m_useCount;
    private ForkInformation _forkInformation;

    public Binding(Object name2, Type type2, ISpecialForm origin) {
        this.m_type = type2;
        this.m_origin = origin;
        this.setName(name2);
        this.m_useCount = 0;
        assert (this.initBogusStackframePos());
    }

    public Binding(Object name2, Type type2, TypeEnvironment tenv) {
        this.m_type = type2;
        this.m_typeEnvironment = tenv;
        this.setName(name2);
        this.m_useCount = 0;
        assert (this.initBogusStackframePos());
    }

    protected boolean initBogusStackframePos() {
        this.m_stackFramePos = -3333333;
        return true;
    }

    public Binding(Object name2, ISpecialForm origin) {
        this(name2, (Type)new TypeVariable(), origin);
    }

    public Binding(Object name2) {
        this(name2, (Type)new TypeVariable(), (ISpecialForm)null);
    }

    public Binding(Object name2, Type type2) {
        this(name2, type2, (ISpecialForm)null);
    }

    @Override
    public int compareTo(Object other2) {
        return Binding.compare(this, other2);
    }

    public static int compare(IBinding first, Object other2) {
        if (!(other2 instanceof IBinding)) {
            throw new XylemError("ERR_SYSTEM", "Can't compare a binding to a non-binding!");
        }
        Object firstName = first.getName();
        Object otherName = ((IBinding)other2).getName();
        if (firstName instanceof Integer && otherName instanceof Integer) {
            return ((Integer)firstName).compareTo((Integer)otherName);
        }
        if (firstName instanceof String && otherName instanceof String) {
            return ((String)firstName).compareTo((String)otherName);
        }
        if (firstName instanceof Integer) {
            return -1;
        }
        return 1;
    }

    public static Binding[] getBindings(Object[] vars) {
        Binding[] bb = new Binding[vars.length];
        for (int i = 0; i < bb.length; ++i) {
            bb[i] = new Binding(vars[i]);
        }
        return bb;
    }

    public static Binding[] getBindings(Type[] types2) {
        Binding[] bb = new Binding[types2.length];
        for (int i = 0; i < bb.length; ++i) {
            bb[i] = new Binding((Object)("a" + i), types2[i]);
        }
        return bb;
    }

    public static Binding[] getBindings2(Type[] types2) {
        Binding[] bb = new Binding[types2.length];
        for (int i = 0; i < bb.length; ++i) {
            bb[i] = new Binding((Object)ReductionHelper.generateIntermediateIdentifier2(), types2[i]);
        }
        return bb;
    }

    public static Binding[] cloneBindings(IBinding[] b) {
        Binding[] bb = new Binding[b.length];
        for (int i = 0; i < bb.length; ++i) {
            bb[i] = new Binding(b[i].getName(), b[i].getBindingType());
        }
        return bb;
    }

    public static Object[] getNames(IBinding[] bb) {
        Object[] names = new Object[bb.length];
        for (int i = 0; i < bb.length; ++i) {
            names[i] = bb[i].getName();
        }
        return names;
    }

    public static Instruction[] getIdentifiers(IBinding[] bb) {
        Instruction[] ii = new IdentifierInstruction[bb.length];
        for (int i = 0; i < bb.length; ++i) {
            ii[i] = new IdentifierInstruction(bb[i].getName());
        }
        return ii;
    }

    public static String generateVariableName(IBinding b, CodeGeneration cg) {
        Object name2 = b.getName();
        return cg.getSafeName(name2.toString());
    }

    public static Type resolveBindingType(IBinding b, TypeEnvironment tenv, BindingEnvironment benv) {
        Type t = b.getBindingType(tenv, benv);
        return t.resolveType(tenv);
    }

    @Override
    public Object getName() {
        return this.m_name;
    }

    @Override
    public void setName(Object name2) {
        if (name2 == null) {
            throw new XylemError("ERR_SYSTEM", "You almost certainly don't mean to make a binding with name null.");
        }
        if (!(name2 instanceof String) && !(name2 instanceof Integer)) {
            throw new XylemError("ERR_SYSTEM", "You almost certainly did not mean to make a binding name using a " + name2.getClass());
        }
        if (name2 instanceof Binding) {
            name2 = ((Binding)name2).getName();
        }
        this.m_name = name2;
    }

    @Override
    public Type getBindingType() {
        return this.m_type;
    }

    @Override
    public Type getBindingType(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_type;
    }

    public void setType(Type type2) {
        this.m_type = type2;
    }

    public TypeEnvironment getTypeEnvironment() {
        return this.m_typeEnvironment;
    }

    public void setTypeEnvironment(TypeEnvironment tenv) {
        this.m_typeEnvironment = tenv;
    }

    public Object clone() {
        return new Binding(this.m_name, this.m_type, this.m_typeEnvironment);
    }

    public String toString() {
        return "[" + this.hashCode() + "] " + this.m_name + ": " + this.m_type;
    }

    @Override
    public LetInstruction getLet() {
        return null;
    }

    @Override
    public ISpecialForm getOrigin() {
        return this.m_origin;
    }

    public static final Type[] getTypeArrayFromBindingArray(IBinding[] bindings) {
        Type[] ans = new Type[bindings.length];
        for (int i = 0; i < bindings.length; ++i) {
            ans[i] = bindings[i].getBindingType();
        }
        return ans;
    }

    @Override
    public int getVariableUse() {
        return this.m_useCount;
    }

    @Override
    public void incrementVariableUse() {
        if (this.m_useCount == 0) {
            this.m_useCount = 1;
        } else if (this.m_useCount == 1 || this.m_useCount == 2) {
            this.m_useCount = 3;
        }
    }

    @Override
    public void clearVariableUse() {
        this.m_useCount = 0;
    }

    @Override
    public void passingIterator() {
        if (this.m_useCount == 0) {
            this.m_useCount = 2;
        }
    }

    @Override
    public int getStackFramePos() {
        return this.m_stackFramePos;
    }

    @Override
    public void setStackFramePos(int pos) {
        this.m_stackFramePos = pos;
    }

    @Override
    public void setForkInformation(ForkInformation forkInformation) {
        this._forkInformation = forkInformation;
    }

    @Override
    public ForkInformation getForkInformation() {
        return this._forkInformation;
    }
}

