/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xml.ras.LoggerUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BindingEnvironment
implements Serializable {
    private static final long serialVersionUID = 4270935933497681989L;
    protected HashMap<Object, IBinding> m_variableTypes;
    public BindingEnvironment m_parent;
    private static final Logger s_logger = LoggerUtil.getLogger(BindingEnvironment.class);
    private static final String s_className = BindingEnvironment.class.getName();

    public BindingEnvironment() {
        this(null);
    }

    public BindingEnvironment(BindingEnvironment parent2) {
        this.m_parent = parent2;
    }

    public int getSize() {
        return this.m_variableTypes != null ? this.m_variableTypes.size() : 0;
    }

    public void prepareHashMap() {
        this.prepareHashMap(64);
    }

    public void prepareHashMap(int size) {
        this.m_variableTypes = new HashMap(size);
    }

    public BindingEnvironment(BindingEnvironment parent2, IBinding b) {
        this.m_parent = parent2;
        this.m_variableTypes = new HashMap(2);
        this.setVariableBinding(b);
    }

    public void setVariableBinding(IBinding binding) {
        if (this.m_variableTypes == null) {
            this.m_variableTypes = new HashMap();
        }
        this.m_variableTypes.put(binding.getName(), binding);
    }

    public IBinding getVariableBinding(Object variable2) {
        IBinding binding;
        block2: {
            BindingEnvironment benv = this;
            do {
                binding = null;
                if (benv.m_variableTypes != null) {
                    binding = benv.m_variableTypes.get(variable2);
                }
                if (binding != null || benv.m_parent == null) break block2;
            } while ((benv = benv.m_parent) != null);
            return null;
        }
        return binding;
    }

    public void accumulateAvailableBindings(Set set2) {
        if (this.m_variableTypes != null) {
            set2.addAll(this.m_variableTypes.values());
        }
        if (this.m_parent != null) {
            this.m_parent.accumulateAvailableBindings(set2);
        }
    }

    public String toString() {
        if (null == this.m_variableTypes) {
            return "#" + this.hashCode() + ": []";
        }
        return "#" + this.hashCode() + ": " + new TreeSet<Object>(this.m_variableTypes.keySet()).toString();
    }

    public void dump() {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            StringBuilder output = new StringBuilder("<BE.dump> " + this + "\n");
            for (Object key2 : this.m_variableTypes.keySet()) {
                output.append("  key=" + key2 + " value='" + this.m_variableTypes.get(key2) + "'\n");
            }
            output.append("</BE.dump>");
            s_logger.logp(Level.FINEST, s_className, "dump", output.toString());
        }
    }

    public void unregisterBinding(Object var) {
        this.m_variableTypes.remove(var);
    }
}

