/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.FunctionInstantiation;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.IContext;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.LUBConstraint;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.TypeSpecializationDerivative;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGeneration;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.PromiseType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Function
implements Serializable,
IContext {
    private static final long serialVersionUID = -7216470938089112997L;
    static final boolean FORCEXMLTYPESPECIALIZATION = false;
    public static final String XMLTYPESPECIALIZATION_OPTION = "doXMLTypeSpecialization";
    public static final boolean sDoXMLTypeSpecialization = !HiddenOptions.wasSpecified("doXMLTypeSpecialization") || !HiddenOptions.optionValueIs("doXMLTypeSpecialization", "off");
    public static long numberXMLTypeSpecializations = 0L;
    public static long numberUsefulXMLTypeSpecializations = 0L;
    private static final char ESCAPE_DELIM_CHAR = '$';
    protected String m_name;
    protected Instruction m_body;
    public Binding[] m_parameters;
    public String[] m_defaultValues;
    private TypeEnvironment m_typeEnvironment;
    public BindingEnvironment m_bindingEnvironment;
    protected Type m_returnType;
    private HashSet m_constraints;
    public String m_comment;
    public HashMap m_resolvedConstraintTypes = new HashMap();
    protected HashMap<Object, Function> m_derivatives;
    protected Function m_original = null;
    protected Object m_derivationKey = null;
    protected boolean m_memoizeResult = false;
    protected boolean m_inlineHint = false;
    protected boolean m_impure = false;
    protected TypeEnvironment m_inProgressTypeEnvironment;
    public boolean m_supportsStreamOptimization = false;
    public boolean m_checkedStreamOptimization = false;
    public boolean m_inSupportsStreamCall = false;
    public boolean m_supportsStreamInADTOptimization = false;
    public boolean m_supportsStreamInObjectlessADT = false;
    public boolean m_checkedStreamInADTOptimization = false;
    public boolean m_inSupportsStreamInADTCall = false;
    public int m_definitionLineNumber;
    public URL m_definitionURL;
    public boolean m_isClassMethod = false;
    public int m_stackFrameSize;
    public boolean m_justInlined = false;
    public boolean m_isXMLTypeSpecialized = false;
    public Instruction.TraceBackObject m_creationTraceException;
    public Module m_module;
    int m_foundForkCount = 0;
    private static final Logger s_logger = LoggerUtil.getLogger(Function.class);
    private static final String s_className = Function.class.getName();
    private boolean m_checkedRecursiveness = false;
    private boolean m_isRecursiveF = false;
    private static int s_fixups = 0;
    public static final boolean diagnoseXMLSubtypeSpecialization = false;
    private static final boolean diagnoseXMLSubtypeSpecializationCycles = false;
    private static Vector<Function> processedFunctions = null;
    private static boolean throwOnCloneUniquenessProblem = true;
    static int debugCounter = 0;
    protected String m_memoizedVarName;
    protected String m_memoizedCheckVarName;

    public Module getModule() {
        return this.m_module;
    }

    public void setModule(Module module) {
        this.m_module = module;
    }

    public Function() {
        if (Instruction.USEINSTRUCTIONCREATIONTRACE) {
            this.m_creationTraceException = new Instruction.TraceBackObject("Creation Trace");
        }
        this.m_derivatives = new HashMap();
    }

    @Override
    public URL getDefinitionURL() {
        return this.m_definitionURL;
    }

    @Override
    public int getDefinitionLineNumber() {
        return this.m_definitionLineNumber;
    }

    public static void pushFunction(Function f2, LinkedList<Function> functionStack) {
        functionStack.add(f2);
    }

    public static LinkedList<Function> isInCycle(Function f2, LinkedList<Function> functionStack) {
        LinkedList<Function> list = null;
        for (Function f22 : functionStack) {
            if (f22 == f2) {
                list = new LinkedList<Function>();
                continue;
            }
            if (list == null) continue;
            list.add(f22);
        }
        return list;
    }

    public boolean isRecursive() {
        if (this.m_checkedRecursiveness) {
            return this.m_isRecursiveF;
        }
        HashSet<String> calledFunctions = new HashSet<String>();
        this.getBody().accumulateFunctionsCalled(calledFunctions);
        this.m_isRecursiveF = calledFunctions.contains(this.getName());
        this.m_checkedRecursiveness = true;
        return this.m_isRecursiveF;
    }

    public static Function getCurrentFunction(LinkedList functionStack) {
        if (functionStack.isEmpty()) {
            return null;
        }
        return (Function)functionStack.getLast();
    }

    public static void popFunction(Function f2, LinkedList functionStack) {
        if (functionStack.removeLast() != f2) {
            throw new RuntimeException("Error: function stack is inconsistent");
        }
    }

    private void init(String name2, Binding[] parameters, Instruction body, URL definitionURL, int definitionLineNumber, HashMap<Object, Function> derivatives) {
        this.m_name = name2;
        this.m_parameters = parameters;
        this.m_body = body;
        this.m_returnType = new TypeVariable();
        this.m_constraints = new HashSet();
        this.m_definitionURL = definitionURL;
        this.m_definitionLineNumber = definitionLineNumber;
        this.m_derivatives = derivatives == null ? new HashMap() : derivatives;
        assert (this.m_derivatives != null);
    }

    public Function(String name2, Binding[] parameters, Instruction body, HashMap<Object, Function> derivatives) {
        if (Instruction.USEINSTRUCTIONCREATIONTRACE) {
            this.m_creationTraceException = new Instruction.TraceBackObject("Creation Trace");
        }
        this.init(name2, parameters, body, null, 0, derivatives);
    }

    public Function(String name2, Binding[] parameters, Instruction body) {
        if (Instruction.USEINSTRUCTIONCREATIONTRACE) {
            this.m_creationTraceException = new Instruction.TraceBackObject("Creation Trace");
        }
        this.init(name2, parameters, body, null, 0, null);
    }

    public Function(String name2, Binding[] parameters, Instruction body, URL definitionURL, int definitionLineNumber) {
        if (Instruction.USEINSTRUCTIONCREATIONTRACE) {
            this.m_creationTraceException = new Instruction.TraceBackObject("Creation Trace");
        }
        this.init(name2, parameters, body, definitionURL, definitionLineNumber, null);
    }

    public void setMemoizeResult(boolean b) {
        this.m_memoizeResult = b;
    }

    public boolean getMemoizeResult() {
        return this.m_memoizeResult;
    }

    public void setImpurity(boolean b) {
        this.m_impure = b;
    }

    public boolean isImpure() {
        return this.m_impure;
    }

    public void setInlineHint(boolean b) {
        this.m_inlineHint = b;
    }

    public boolean getInlineHint() {
        return this.m_inlineHint;
    }

    public Function cloneFunctionForFixup(Object derivationKey) {
        return this.cloneFunctionForFixup(derivationKey, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateNewFixupName() {
        Class<Function> clazz = Function.class;
        synchronized (Function.class) {
            int n2 = s_fixups++;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return "$fixup$" + n2 + "$" + this.m_name;
        }
    }

    public Function cloneFunctionForFixup(Object derivationKey, boolean renameTypeVars, boolean cloneBody, boolean reduced) {
        String newName = this.generateNewFixupName();
        Binding[] params = new Binding[this.m_parameters.length];
        for (int i = 0; i < params.length; ++i) {
            Binding b = this.m_parameters[i];
            params[i] = new Binding(b.m_name, b.m_type, b.m_typeEnvironment);
        }
        Instruction body = this.m_body;
        if (cloneBody) {
            body = reduced ? body.cloneReduced() : body.cloneWithoutTypeInformation();
        }
        Function f2 = new Function(newName, params, body, this.m_derivatives);
        f2.m_comment = this.m_comment;
        this.registerDerivative(derivationKey, f2);
        f2.setImpurity(this.isImpure());
        f2.m_constraints = new HashSet();
        HashMap map2 = new HashMap();
        if (this.m_constraints != null && !this.m_constraints.isEmpty()) {
            for (LUBConstraint lubc : this.m_constraints) {
                Iterator j = lubc.m_set.iterator();
                HashSet<Type> set2 = new HashSet<Type>();
                while (j.hasNext()) {
                    Type t = (Type)j.next();
                    set2.add(renameTypeVars ? t.duplicateType(map2) : t);
                }
                f2.m_constraints.add(new LUBConstraint(renameTypeVars ? lubc.m_t.duplicateType(map2) : lubc.m_t, set2));
            }
        }
        if (!this.m_resolvedConstraintTypes.isEmpty()) {
            for (Type t : this.m_resolvedConstraintTypes.keySet()) {
                f2.m_resolvedConstraintTypes.put(renameTypeVars ? t.duplicateType(map2) : t, this.m_resolvedConstraintTypes.get(t));
            }
        }
        if (!map2.isEmpty() && renameTypeVars) {
            if (!cloneBody) {
                throw new XylemError("ERR_SYSTEM", "not compatible renameTypeVars && !cloneBody");
            }
            f2.m_body.replaceTypeVariables(map2);
        }
        return f2;
    }

    public void setComment(String comment2) {
        this.m_comment = comment2;
    }

    public String getComment() {
        return this.m_comment;
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction n2) {
        this.m_body = n2;
    }

    public boolean hasBeenTypeChecked() {
        return this.m_typeEnvironment != null;
    }

    public boolean ensureGoodTypes() {
        assert (this.hasBeenTypeChecked());
        return this.m_body.ensureGoodTypes(this.m_typeEnvironment, this.m_bindingEnvironment);
    }

    /*
     * Unable to fully structure code
     */
    public void typeCheck(final Module prog, Instruction fci, LinkedList<Function> functionStack) throws TypeCheckException {
        if (this.m_typeEnvironment != null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Function " + this.m_name + " has already been type checked"), fci);
        }
        functionCycle = Function.isInCycle(this, functionStack);
        if (functionCycle != null) {
            if (this.m_returnType == null) {
                this.m_returnType = new TypeVariable();
            }
            for (Function f : functionCycle) {
                this.m_inProgressTypeEnvironment.incorporate(f.m_inProgressTypeEnvironment);
                f.m_inProgressTypeEnvironment.redirectFrom(this.m_inProgressTypeEnvironment);
            }
        } else {
            if (!this.m_body.typeAliasesExpanded) {
                this.m_body.expandTypeAliases(prog);
            }
            if (LoggerUtil.isAnyTracingEnabled() && Function.s_logger.isLoggable(Level.FINEST)) {
                Function.s_logger.logp(Level.FINEST, Function.s_className, "typeCheck", "type checking function " + this.m_name + " with " + this.m_parameters.length + " parameters.");
            }
            if ((fs = prog.getFunctionSignature(this.m_name)) != null) {
                fs.m_parameterTypes = Type.map(new Type.Mapping(){

                    @Override
                    public Type apply(Type t) {
                        return t.expandTypeAliases(prog);
                    }
                }, fs.m_parameterTypes);
                fs.m_returnType = fs.m_returnType.expandTypeAliases(prog);
            }
            benv = new BindingEnvironment();
            this.m_inProgressTypeEnvironment = new TypeEnvironment(prog);
            for (i = 0; i < this.m_parameters.length; ++i) {
                this.m_parameters[i].m_type = this.m_parameters[i].m_type.expandTypeAliases(prog);
                this.m_parameters[i].m_typeEnvironment = this.m_inProgressTypeEnvironment;
                if (benv.getVariableBinding(this.m_parameters[i].getName()) != null) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Parameter name " + this.m_parameters[i].getName() + " is used more than once"), fci);
                }
                benv.setVariableBinding(this.m_parameters[i]);
                if (fs == null) continue;
                try {
                    this.m_inProgressTypeEnvironment.unify(this.m_parameters[i].getBindingType(), fs.getParameterTypes()[i], null);
                    continue;
                }
                catch (TypeCheckException tce) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Parameter " + this.m_parameters[i].getName() + "@" + this.m_parameters[i].getBindingType() + " of function " + this.m_name + " does not match the type@" + fs.getParameterTypes()[i] + " given in the module signature " + fs.getFunctionName()), null);
                }
            }
            Function.pushFunction(this, functionStack);
            this.m_body.typeCheck(this.m_inProgressTypeEnvironment, benv, functionStack);
            if (this.m_body != null) {
                if (!Function.$assertionsDisabled && this.m_body.getCachedType() == null) {
                    throw new AssertionError();
                }
                if (this.m_returnType != null) {
                    try {
                        this.m_inProgressTypeEnvironment.unify(this.m_returnType, this.m_body.getCachedType(), null);
                        if (this.m_returnType instanceof JavaObjectType) ** GOTO lbl48
                        this.m_returnType = this.m_body.getCachedType();
                    }
                    catch (TypeCheckException tce) {
                        throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "The return type " + this.m_body.getCachedType().resolveType(this.m_inProgressTypeEnvironment) + " of function " + this.m_name + " does not match the type " + this.m_returnType + " given in the module signature"), null);
                    }
                } else {
                    this.m_returnType = this.m_body.getCachedType();
                }
            }
lbl48:
            // 5 sources

            if (fs != null && fs.getReturnType() != null) {
                try {
                    this.m_inProgressTypeEnvironment.unify(this.m_returnType, fs.getReturnType(), null);
                }
                catch (TypeCheckException tce) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "The return type " + this.m_returnType + " of function " + this.m_name + " does not match the type " + fs.getReturnType() + " given in the module signature"), null);
                }
            }
            Function.popFunction(this, functionStack);
            this.m_typeEnvironment = this.m_inProgressTypeEnvironment;
            this.m_bindingEnvironment = benv;
            for (Type t : this.m_resolvedConstraintTypes.keySet()) {
                t2 = (Type)this.m_resolvedConstraintTypes.get(t);
                this.m_typeEnvironment.unify(t, t2, null);
            }
            if (this.m_constraints != null) {
                this.m_typeEnvironment.resolveLUBConstraints(this.m_constraints, prog.m_lubResolver, true);
                this.recordLUBConstraintResults(this.m_typeEnvironment);
                this.m_constraints = null;
            }
            this.standardizeTypes(false);
        }
    }

    public void standardizeTypes(boolean doBody) {
        HashSet typeVars = new HashSet();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Type t = this.m_parameters[i].getBindingType().resolveTypeAsMuchAsPossible(this.m_typeEnvironment, typeVars);
            this.m_parameters[i].setType(t);
        }
        this.m_returnType = this.m_returnType.resolveTypeAsMuchAsPossible(this.m_typeEnvironment, typeVars);
        if (doBody) {
            this.m_body.standardizeTypes(typeVars, this.m_typeEnvironment);
        }
    }

    public void typeCheckReduced(Module prog, LinkedList functionStack) throws TypeCheckException {
        LinkedList<Function> functionCycle = Function.isInCycle(this, functionStack);
        if (functionCycle != null) {
            if (this.m_returnType == null) {
                this.m_returnType = new TypeVariable();
            }
            for (Function f2 : functionCycle) {
                this.m_inProgressTypeEnvironment.incorporate(f2.m_inProgressTypeEnvironment);
                f2.m_inProgressTypeEnvironment.redirectFrom(this.m_inProgressTypeEnvironment);
            }
        } else {
            FunctionSignature fs = prog.getFunctionSignature(this.m_name);
            BindingEnvironment benv = new BindingEnvironment();
            benv.prepareHashMap();
            this.m_inProgressTypeEnvironment = new TypeEnvironment(prog);
            for (int i = 0; i < this.m_parameters.length; ++i) {
                this.m_parameters[i].m_typeEnvironment = this.m_inProgressTypeEnvironment;
                benv.setVariableBinding(this.m_parameters[i]);
                if (fs == null) continue;
                try {
                    this.m_inProgressTypeEnvironment.unify(this.m_parameters[i].getBindingType(), fs.getParameterTypes()[i], null);
                    continue;
                }
                catch (TypeCheckException tce) {
                    FFDCUtil.log(tce, this);
                    String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Parameter '" + this.m_parameters[i].getName() + "' of function '" + this.m_name + "' does not match the type given in the module signature"});
                    s_logger.logp(Level.SEVERE, s_className, "typeCheckReduced", message, tce);
                    throw new TypeCheckException(message, null);
                }
            }
            Function.pushFunction(this, functionStack);
            this.m_body.typeCheckReduced(this.m_inProgressTypeEnvironment, benv, functionStack);
            TypeEnvironment tenv = this.m_inProgressTypeEnvironment;
            if (this.m_returnType != null) {
                try {
                    Type bodyType = this.m_body.getType(tenv, benv);
                    this.m_inProgressTypeEnvironment.unify(this.m_returnType, bodyType, null);
                }
                catch (TypeCheckException tce) {
                    String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"The return type " + this.m_body.getType(tenv, benv).resolveType(this.m_inProgressTypeEnvironment) + " of function " + this.m_name + " does not match the type " + this.m_returnType + " given in the module signature"});
                    s_logger.logp(Level.SEVERE, s_className, "typeCheckReduced", message, tce);
                    throw new TypeCheckException(message, null);
                }
            } else {
                this.m_returnType = this.m_body.getType(tenv, benv);
            }
            if (fs != null && fs.getReturnType() != null) {
                this.m_inProgressTypeEnvironment.unify(this.m_returnType, fs.getReturnType(), null);
            }
            Function.popFunction(this, functionStack);
            this.m_typeEnvironment = this.m_inProgressTypeEnvironment;
            this.m_bindingEnvironment = benv;
            this.standardizeTypes(false);
        }
    }

    public Type getReturnType() {
        return this.m_returnType;
    }

    public void setReturnType(Type t) {
        this.m_returnType = t;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String name2) {
        this.m_name = name2;
    }

    public Binding[] getParameters() {
        return this.m_parameters;
    }

    public void unifyParameter(TypeEnvironment tenv, BindingEnvironment benv, Type calledType, Instruction[] parameters, int i, FunctionCallInstruction fci, boolean reduced) throws TypeCheckException {
        Type expectedType = this.m_parameters[i].getBindingType();
        this.unifyParameter(tenv, benv, calledType, expectedType, parameters, i, fci, reduced);
    }

    public void unifyParameter(TypeEnvironment tenv, BindingEnvironment benv, Type calledType, Type expectedType, Instruction[] parameters, int i, FunctionCallInstruction fci, boolean reduced) throws TypeCheckException {
        if (calledType == null) {
            throw new RuntimeException();
        }
        Type[] types2 = new Type[parameters.length];
        for (int j = 0; j < parameters.length; ++j) {
            Type t0 = (reduced ? parameters[j].getType(tenv, benv) : parameters[j].getCachedType()).resolveType(tenv);
            if (t0 == null) continue;
            types2[j] = t0;
        }
        tenv.unify(calledType, expectedType, fci);
    }

    private boolean ensureCloneUniqueIdentity(Function f2) {
        if (this == f2) {
            RuntimeException e = new RuntimeException("Identities not unique! " + this.m_name);
            if (throwOnCloneUniquenessProblem) {
                throw e;
            }
            return false;
        }
        return this.getBody().ensureCloneUniqueIdentity(f2.getBody(), throwOnCloneUniquenessProblem);
    }

    public FunctionInstantiation instantiate(TypeEnvironment tenv, BindingEnvironment benv, Instruction[] parameters, FunctionCallInstruction fci, LinkedList functionStack, boolean reduced) throws TypeCheckException {
        Type retType;
        Type t2;
        if (parameters.length != this.m_parameters.length) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Incorrect number of parameters to " + this.m_name + "\n  expected " + this.m_parameters.length + ", found " + parameters.length), fci);
        }
        Function toCheck = this;
        HashMap map2 = new HashMap();
        Type[] types2 = new Type[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Type t1;
            Type calledType = reduced ? parameters[i].getType(tenv, benv) : parameters[i].getCachedType();
            Type expectedType = toCheck.m_parameters[i].m_type;
            Type type2 = t1 = toCheck.m_parameters[i].m_typeEnvironment == null ? null : expectedType.resolveType(toCheck.m_parameters[i].m_typeEnvironment);
            if (t1 != null) {
                expectedType = t1;
            }
            if (reduced) continue;
            expectedType = expectedType.duplicateType(map2);
            this.unifyParameter(tenv, benv, calledType, expectedType, parameters, i, fci, reduced);
            types2[i] = reduced ? parameters[i].getType(tenv, benv) : parameters[i].getCachedType();
            for (Type t2 : toCheck.m_resolvedConstraintTypes.keySet()) {
                Type t22 = (Type)toCheck.m_resolvedConstraintTypes.get(t2);
                tenv.unify(t2.duplicateType(map2), t22, null);
            }
        }
        Function xmlSuptypeSpecializedFunc = toCheck;
        if (this.isPolymorphic()) {
            toCheck = this.maybeSpecializeFunction(tenv, benv, parameters, fci, reduced, toCheck, false);
        }
        Function currentFunction = Function.getCurrentFunction(functionStack);
        if (toCheck.isPolymorphic()) {
            if (currentFunction == null) {
                tenv.getModule().addToFixupList(fci, currentFunction);
            } else if (!currentFunction.isPolymorphic()) {
                tenv.getModule().addToFixupList(fci, currentFunction);
            }
        }
        toCheck.ensureTypechecked(tenv, fci, functionStack, reduced);
        boolean didXMLTypeSpecialization = false;
        if (sDoXMLTypeSpecialization && !this.isPolymorphic() && toCheck.shouldBeXMLTypeSpecialized(tenv)) {
            xmlSuptypeSpecializedFunc = this.maybeSpecializeFunction(tenv, benv, parameters, fci, reduced, toCheck, true);
            if (!currentFunction.shouldBeXMLTypeSpecialized(tenv)) {
                tenv.getModule().addToFixupList(fci, currentFunction);
            }
            if (toCheck != xmlSuptypeSpecializedFunc) {
                Type xxmlSuptypeSpecializedType;
                tenv.getModule().addFunction(xmlSuptypeSpecializedFunc, false);
                if (xmlSuptypeSpecializedFunc.getBody() != null) {
                    xmlSuptypeSpecializedFunc.ensureTypechecked(tenv, fci, functionStack, reduced);
                }
                if (!(xxmlSuptypeSpecializedType = xmlSuptypeSpecializedFunc.m_returnType).isFullySpecified()) {
                    this.restoreAfterXMLTypeSpecialization(tenv, fci, toCheck, xmlSuptypeSpecializedFunc, !functionStack.contains(currentFunction));
                    xmlSuptypeSpecializedFunc = toCheck;
                } else {
                    didXMLTypeSpecialization = true;
                }
            }
        }
        if (!didXMLTypeSpecialization) {
            xmlSuptypeSpecializedFunc = null;
        }
        HashMap map3 = new HashMap();
        Type[] types3 = this.instantiateUnifyTypes(tenv, benv, parameters, fci, reduced, toCheck, map3);
        if (didXMLTypeSpecialization) {
            Type[] xmlSuptypeSpecializedTypes = null;
            HashMap xmlSuptypeSpecializedMap = new HashMap();
            xmlSuptypeSpecializedTypes = this.instantiateUnifyTypes(tenv, benv, parameters, fci, reduced, xmlSuptypeSpecializedFunc, xmlSuptypeSpecializedMap);
        }
        Type genericType = toCheck.m_returnType;
        Type type3 = retType = didXMLTypeSpecialization ? xmlSuptypeSpecializedFunc.m_returnType : genericType;
        if (toCheck.m_typeEnvironment != null && (t2 = retType.resolveType(toCheck.m_typeEnvironment)) != null) {
            retType = t2;
        }
        if (!reduced) {
            retType = retType.duplicateType(map3);
        }
        if (!retType.isFullySpecified()) {
            tenv.getModule().addToFixupList(fci, currentFunction);
        } else if (didXMLTypeSpecialization && genericType != xmlSuptypeSpecializedFunc.m_returnType && !xmlSuptypeSpecializedFunc.m_returnType.isFullySpecified()) {
            tenv.getModule().addToFixupList(fci, currentFunction);
        }
        if (didXMLTypeSpecialization) {
            this.restoreAfterXMLTypeSpecialization(tenv, fci, toCheck, xmlSuptypeSpecializedFunc, true);
        }
        return new FunctionInstantiation(toCheck, types3, retType, map3, tenv, fci, benv);
    }

    private void restoreAfterXMLTypeSpecialization(TypeEnvironment tenv, FunctionCallInstruction fci, Function toCheck, Function xmlSuptypeSpecializedFunc, boolean removeFromModule) {
        String originalName = toCheck.getName();
        fci.setFunction(originalName);
        if (xmlSuptypeSpecializedFunc.m_isXMLTypeSpecialized && removeFromModule) {
            tenv.getModule().removeFunction(xmlSuptypeSpecializedFunc);
        }
        xmlSuptypeSpecializedFunc.setBody(null);
    }

    private Function maybeSpecializeFunction(TypeEnvironment tenv, BindingEnvironment benv, Instruction[] parameters, FunctionCallInstruction fci, boolean reduced, Function toCheck, boolean isXMLTypeSpecialization) {
        Type[] types2 = new Type[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Type t;
            if (reduced) {
                t = parameters[i].getType(tenv, benv);
            } else {
                Type cachedType = parameters[i].getCachedType();
                t = cachedType.resolveType(tenv);
            }
            types2[i] = t;
        }
        TypeSpecializationDerivative tsd = new TypeSpecializationDerivative(types2);
        if (!tsd.equals(this.m_derivationKey)) {
            Function promotedFunc = TypeSpecializationDerivative.specializeTypes(toCheck, types2, tenv);
            if (promotedFunc != toCheck) {
                promotedFunc.m_isXMLTypeSpecialized = isXMLTypeSpecialization;
                if (isXMLTypeSpecialization) {
                    this.m_module.addToListOfXMLTypeSpecializedStubs(promotedFunc);
                }
            }
            fci.setFunction(promotedFunc.getName());
            toCheck = promotedFunc;
            tenv.getModule().addFunction(toCheck);
        }
        return toCheck;
    }

    private void ensureTypechecked(TypeEnvironment tenv, FunctionCallInstruction fci, LinkedList functionStack, boolean reduced) throws TypeCheckException {
        if (!this.hasBeenTypeChecked()) {
            Module m = tenv.getModule();
            if (reduced) {
                this.typeCheckReduced(m, functionStack);
            } else {
                this.typeCheck(m, fci, functionStack);
            }
        }
    }

    private Type[] instantiateUnifyTypes(TypeEnvironment tenv, BindingEnvironment benv, Instruction[] parameters, FunctionCallInstruction fci, boolean reduced, Function toCheck, HashMap map2) throws TypeCheckException {
        Type[] types2 = new Type[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Type t1;
            Type calledType = reduced ? parameters[i].getType(tenv, benv) : parameters[i].getCachedType();
            Type expectedType = toCheck.m_parameters[i].m_type;
            Type type2 = t1 = toCheck.m_parameters[i].m_typeEnvironment == null ? null : expectedType.resolveType(toCheck.m_parameters[i].m_typeEnvironment);
            if (t1 != null) {
                expectedType = t1;
            }
            if (reduced) continue;
            expectedType = expectedType.duplicateType(map2);
            this.unifyParameter(tenv, benv, calledType, expectedType, parameters, i, fci, reduced);
            types2[i] = reduced ? parameters[i].getType(tenv, benv) : parameters[i].getCachedType();
            for (Type t : toCheck.m_resolvedConstraintTypes.keySet()) {
                Type t2 = (Type)toCheck.m_resolvedConstraintTypes.get(t);
                tenv.unify(t.duplicateType(map2), t2, null);
            }
        }
        return types2;
    }

    public boolean needsTypecheckReduced() {
        return !this.hasBeenTypeChecked() || this.m_body != null && this.m_body.m_bindingEnvironment != null;
    }

    public Type instantiateReduced(TypeEnvironment tenv, BindingEnvironment benv, FunctionCallInstruction fci, LinkedList functionStack) throws TypeCheckException {
        Function toCheck = this;
        if (this.needsTypecheckReduced()) {
            toCheck.typeCheckReduced(tenv.getModule(), functionStack);
        }
        if (toCheck.isPolymorphic()) {
            HashMap typeMap = new HashMap();
            Instruction[] params = fci.m_parameters;
            for (int i = 0; i < toCheck.m_parameters.length; ++i) {
                Binding b = toCheck.m_parameters[i];
                Type t = b.getBindingType();
                Type t2 = t.duplicateType(typeMap);
                tenv.unify(params[i].getType(tenv, benv), t2, fci);
            }
            return toCheck.m_returnType.duplicateType(typeMap);
        }
        return toCheck.m_returnType;
    }

    public Type instantiateReduced(TypeEnvironment tenv, BindingEnvironment benv, Instruction[] parameters, FunctionCallInstruction fci, Set newFunctions, Set stack, Set done) {
        Function toUse = this;
        if (this.isPolymorphic()) {
            Type retType;
            Type t;
            int i;
            Type[] types2 = new Type[parameters.length];
            TypeEnvironment tenv2 = (TypeEnvironment)this.m_typeEnvironment.clone();
            for (i = 0; i < parameters.length; ++i) {
                Type t2 = parameters[i].getType(tenv, benv).resolveTypeAsMuchAsPossible(tenv, new HashSet());
                try {
                    Type t22 = this.m_parameters[i].getBindingType();
                    tenv2.unify(t2, t22, fci);
                }
                catch (TypeCheckException e) {
                    throw new RuntimeException(e);
                }
                types2[i] = t2;
            }
            for (i = 0; i < parameters.length; ++i) {
                types2[i] = types2[i].resolveType(tenv2);
                if (types2[i] == null) {
                    throw new XylemError("ERR_SYSTEM", "Some type could not be inferred in " + this);
                }
                try {
                    tenv.unify(types2[i], parameters[i].getType(tenv, benv), fci);
                    continue;
                }
                catch (TypeCheckException e) {
                    e.printStackTrace();
                    throw new RuntimeException();
                }
            }
            Function promotedFunc = TypeSpecializationDerivative.specializeTypes(this, types2, tenv);
            fci.setFunction(promotedFunc.getName());
            tenv.getModule().addFunction(promotedFunc);
            if (!promotedFunc.hasBeenTypeChecked()) {
                try {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                        s_logger.logp(Level.FINEST, s_className, "instantiateReduced", "Type-checking new function '" + promotedFunc.getName() + "'");
                    }
                    promotedFunc.typeCheckReduced(tenv.getModule(), new LinkedList());
                    newFunctions.add(promotedFunc);
                    for (int i2 = 0; i2 < parameters.length; ++i2) {
                        Type t1 = this.m_parameters[i2].getBindingType();
                        promotedFunc.m_typeEnvironment.unify(t1, types2[i2], fci);
                    }
                    promotedFunc.standardizeTypes(true);
                    promotedFunc.instantiateReducedPolymorphicFunctions(newFunctions, stack, done);
                }
                catch (Exception e) {
                    FFDCUtil.log(e, this);
                    s_logger.logrb(Level.SEVERE, s_className, "instantiateReduced", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "ERR_SYSTEM_EXCEPTION", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            if ((t = (retType = promotedFunc.m_returnType).resolveType(tenv2)) == null) {
                throw new XylemError("ERR_SYSTEM", "An error occurred trying to process function " + promotedFunc.getName());
            }
            return t;
        }
        if (!stack.contains(toUse)) {
            toUse.instantiateReducedPolymorphicFunctions(newFunctions, stack, done);
        }
        Type retType = toUse.m_returnType;
        return retType.resolveType(toUse.m_typeEnvironment);
    }

    public TypeEnvironment getTypeEnvironment() {
        return this.m_typeEnvironment;
    }

    public BindingEnvironment getBindingEnvironment() {
        return this.m_bindingEnvironment;
    }

    public String toString() {
        PrettyPrinter pw = new PrettyPrinter();
        this.toString(pw, 0);
        return pw.toString();
    }

    public void toString(PrettyPrinter pw, int indent) {
        pw.printComment("============================================", indent);
        if (null != this.m_comment) {
            pw.printComment(this.m_comment, indent);
        }
        pw.printFormOpen("function", indent);
        if (this.m_memoizeResult) {
            pw.printToken("memoize", indent);
        }
        if (this.m_impure) {
            pw.printToken("impure", indent);
        }
        if (this.m_inlineHint) {
            pw.printToken("inline", indent);
        }
        pw.printToken("(" + this.m_name, indent + 1);
        if (!(this.m_returnType == null || this.m_typeEnvironment == null && this.m_returnType instanceof TypeVariable)) {
            Type t = this.m_returnType;
            if (this.m_typeEnvironment != null) {
                t = this.m_returnType.resolveTypeAsMuchAsPossible(this.m_typeEnvironment, new HashSet());
            }
            pw.print("@");
            pw.print(t.prettyPrint());
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            pw.println("");
            pw.print("      ");
            pw.printIdentifier(this.m_parameters[i], indent + 2);
            Type t = this.m_parameters[i].getBindingType();
            if (t == null) continue;
            if (this.m_typeEnvironment != null) {
                t = t.resolveTypeAsMuchAsPossible(this.m_typeEnvironment, new HashSet());
            }
            pw.print("@");
            pw.print(t.prettyPrint());
        }
        pw.printFormClose(indent + 1);
        if (null == this.m_body) {
            pw.print("  %%STUB-NO-BODY%%: " + this.getName());
        } else {
            this.m_body.toString(pw, indent + 1);
        }
        pw.printFormClose(indent);
    }

    public String generateFunctionName(CodeGeneration cg) {
        return Function.generateFunctionName(cg, this.getName());
    }

    public static final String generateFunctionName(CodeGeneration cg, String name2) {
        if (cg.getSettings().isObfuscateFunctionNames()) {
            String s = cg.getObfuscatedFunctionName(name2);
            return s;
        }
        return Function.generateFunctionName(name2);
    }

    public static final String generateFunctionName(String name2) {
        return Util.toJavaInternalName(name2);
    }

    public void clearTypeInformation() {
        this.clearTypeInformation(true);
    }

    public void clearTypeInformation(boolean resetReturnType) {
        this.m_bindingEnvironment = null;
        this.m_typeEnvironment = null;
        this.m_body.clearTypeInformation();
        if (resetReturnType && this.m_returnType != null && this.m_returnType instanceof TypeVariable) {
            this.m_returnType = null;
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            this.m_parameters[i].m_typeEnvironment = null;
        }
        this.m_inProgressTypeEnvironment = null;
    }

    public void clearReducedTypeInformation() {
        this.m_bindingEnvironment = null;
        this.m_typeEnvironment = null;
        if (this.m_returnType != null && this.m_returnType instanceof TypeVariable) {
            this.m_returnType = null;
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            this.m_parameters[i].m_typeEnvironment = null;
        }
        this.m_inProgressTypeEnvironment = null;
    }

    public void reduce(boolean rereduce) {
        if (this.m_typeEnvironment == null && !rereduce) {
            return;
        }
        this.m_bindingEnvironment = new BindingEnvironment();
        this.m_bindingEnvironment.prepareHashMap();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            this.m_parameters[i].m_typeEnvironment = null;
            this.m_bindingEnvironment.setVariableBinding(this.m_parameters[i]);
        }
        ReductionHelper rh = new ReductionHelper(this.m_typeEnvironment);
        this.m_body = rh.reduce(this.m_body, this.m_bindingEnvironment);
    }

    public void reduce() {
        this.reduce(false);
    }

    public void rereduce() {
        this.reduce(true);
    }

    public void determineDataDependencies(Binding[] specificBindings, HashMap collectedBindings) {
        this.determineDataDependencies(specificBindings, collectedBindings, this.getBindingEnvironment());
    }

    public void determineDataDependencies(Binding[] specificBindings, HashMap collectedBindings, BindingEnvironment benv) {
        try {
            this.m_body.determineDataDependencies(specificBindings, collectedBindings, null, -1, benv);
        }
        catch (RuntimeException e) {
            FFDCUtil.log(e, this);
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"error encountering getting data dependancies for " + this.getName()});
            s_logger.logp(Level.SEVERE, s_className, "determineDataDependencies", message, e);
            throw e;
        }
    }

    public void recordLUBConstraintResults(TypeEnvironment tenv) {
        Iterator i = this.m_constraints.iterator();
        while (i.hasNext()) {
            LUBConstraint lubc = (LUBConstraint)i.next();
            Type t = lubc.m_t.resolveType(tenv);
            if (t == null) continue;
            this.m_resolvedConstraintTypes.put(lubc.m_t, t);
            i.remove();
        }
    }

    public Function lookupDerivative(Object key2) {
        return this.m_derivatives.get(key2);
    }

    public void registerDerivative(Object key2, Function f2) {
        f2.m_derivationKey = key2;
        f2.m_original = this;
        this.m_derivatives.put(key2, f2);
    }

    public boolean isDerivative() {
        return this.m_derivationKey != null;
    }

    public Object getDerivationKey() {
        return this.m_derivationKey;
    }

    public Function getOriginalFunction() {
        return this.m_original;
    }

    public boolean isPolymorphic() {
        for (int i = 0; i < this.m_parameters.length; ++i) {
            if (this.m_parameters[i].m_type.isFullySpecified()) continue;
            return true;
        }
        return false;
    }

    public boolean shouldBeXMLTypeSpecialized(TypeEnvironment te) {
        if (null != this.m_returnType && this.m_returnType.hasXMLSubtype()) {
            for (int i = 0; i < this.m_parameters.length; ++i) {
                if (!this.isDangeriousTypeForXMLSpecialization(this.m_parameters[i].m_type)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isDangeriousTypeForXMLSpecialization(Type t) {
        return t instanceof TypeVariable || t instanceof PromiseType;
    }

    public void setConstraints(HashSet m_constraints) {
        this.m_constraints = m_constraints;
    }

    public HashSet getConstraints() {
        return this.m_constraints;
    }

    public boolean resolveConstraints(boolean force) throws TypeCheckException {
        if (!this.isPolymorphic() && this.m_constraints != null) {
            if (this.m_typeEnvironment.resolveLUBConstraints(this.m_constraints, this.m_typeEnvironment.getModule().m_lubResolver, force)) {
                this.recordLUBConstraintResults(this.m_typeEnvironment);
                return true;
            }
            return false;
        }
        return true;
    }

    public String getMemoVarName(FcgCodeGenHelper cgh) {
        if (this.m_memoizedVarName == null) {
            Type t = this.m_returnType.resolveType(this.m_typeEnvironment);
            FcgType fcgType = t.getFCGType(cgh);
            this.m_memoizedVarName = cgh.generateNewMemberVariableName();
            this.m_memoizedVarName = this.m_memoizedVarName + "_memo_cached_value";
            cgh.allocateThreadLocalVariable(this.m_memoizedVarName, fcgType);
        }
        return cgh.generateThreadLocalVarReference(this.m_memoizedVarName);
    }

    public String getMemoCheckVarName(FcgCodeGenHelper cgh) {
        if (this.m_memoizedCheckVarName == null) {
            this.m_memoizedCheckVarName = cgh.generateNewMemberVariableName();
            this.m_memoizedCheckVarName = this.m_memoizedCheckVarName + "_memo_cached_guard";
            cgh.allocateThreadLocalVariable(this.m_memoizedCheckVarName, FcgType.BOOLEAN);
        }
        return cgh.generateThreadLocalVarReference(this.m_memoizedCheckVarName);
    }

    public void switchOverTypeEnvironment(TypeEnvironment tenv) {
        this.m_typeEnvironment = tenv;
    }

    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeString(this.m_name);
        wofh.writeTypeSpecificBindingSet(this.m_parameters);
        wofh.writeBoolean(this.m_memoizeResult);
        wofh.writeBoolean(this.m_impure);
        wofh.writeBoolean(this.m_inlineHint);
        wofh.writeInstruction(this.m_body);
        wofh.writeType(this.m_returnType);
        wofh.writeBoolean(this.m_isClassMethod);
        wofh.writeInt(this.m_defaultValues == null ? 0 : this.m_defaultValues.length);
        if (this.m_defaultValues != null) {
            for (int i = 0; i < this.m_defaultValues.length; ++i) {
                wofh.writeBoolean(this.m_defaultValues[i] != null);
                if (this.m_defaultValues[i] == null) continue;
                wofh.writeString(this.m_defaultValues[i]);
            }
        }
    }

    public void read(ReadObjectFileHelper rofh) throws Exception {
        this.m_name = rofh.readString();
        this.m_parameters = rofh.readTypeSpecificBindingSet();
        this.m_memoizeResult = rofh.readBoolean();
        this.m_impure = rofh.readBoolean();
        this.m_inlineHint = rofh.readBoolean();
        this.m_body = rofh.readInstruction(null);
        this.m_returnType = rofh.readType();
        this.m_isClassMethod = rofh.readBoolean();
        int c = rofh.readInt();
        if (c > 0) {
            this.m_defaultValues = new String[c];
            for (int i = 0; i < this.m_defaultValues.length; ++i) {
                if (!rofh.readBoolean()) continue;
                this.m_defaultValues[i] = rofh.readString();
            }
        }
    }

    public void instantiateReducedPolymorphicFunctions(Set newFunctions, Set stack, Set done) {
        if (done.contains(this)) {
            return;
        }
        done.add(this);
        stack.add(this);
        this.m_body.instantiateReducedPolymorphicFunctions(newFunctions, this.m_typeEnvironment, this.m_bindingEnvironment, stack, done);
        stack.remove(this);
    }

    public void removeDerivativeInformation(boolean removeXMLSpecializedFuncs) {
        if (removeXMLSpecializedFuncs || !this.m_isXMLTypeSpecialized) {
            this.m_derivationKey = null;
            this.m_original = null;
        }
        ArrayList<Object> toRemove = new ArrayList<Object>();
        for (Object key2 : this.m_derivatives.keySet()) {
            Function valFunction = this.m_derivatives.get(key2);
            if (!removeXMLSpecializedFuncs && valFunction.m_isXMLTypeSpecialized) continue;
            toRemove.add(key2);
        }
        for (Object key2 : toRemove) {
            this.m_derivatives.remove(key2);
        }
    }

    public Function cloneFunction() {
        Function tmpFunc = new Function();
        tmpFunc.setName(this.m_name);
        tmpFunc.setBody(this.m_body.cloneWithoutTypeInformation());
        tmpFunc.setReturnType(this.m_returnType);
        tmpFunc.m_parameters = Binding.cloneBindings(this.m_parameters);
        tmpFunc.m_memoizeResult = this.m_memoizeResult;
        tmpFunc.m_impure = this.m_impure;
        tmpFunc.m_inlineHint = this.m_inlineHint;
        tmpFunc.m_isClassMethod = this.m_isClassMethod;
        tmpFunc.m_defaultValues = this.m_defaultValues;
        return tmpFunc;
    }

    public int getStackFrameSize() {
        return this.m_stackFrameSize;
    }

    public void setStackFrameSize(int stackFrameSize) {
        this.m_stackFrameSize = stackFrameSize;
    }

    public int getFoundForkCount() {
        return this.m_foundForkCount;
    }

    public void setFoundForkCount(int mFoundForkCount) {
        this.m_foundForkCount = mFoundForkCount;
    }
}

