/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class FunctionInstantiation
implements Serializable {
    private static final long serialVersionUID = -209181267043783730L;
    public Type m_returnType;
    public Type[] m_parameterTypes;
    public Function m_function;
    public Map m_templateToInstantiation;
    public TypeEnvironment m_targetTypeEnvironment;
    public Type[] m_resolvedParameterTypes;
    public BindingEnvironment m_targetBindingEnvironment;
    FunctionInstantiation m_original;
    protected FunctionCallInstruction m_fci;
    public static final boolean s_enableProfiling = false;
    private static final HashMap s_profileData = new HashMap();

    public static void profileHit(String s) {
        Integer x = (Integer)s_profileData.get(s);
        int y = x == null ? 0 : x;
        s_profileData.put(s, new Integer(y + 1));
    }

    public FunctionInstantiation(Function function2, Type[] parameterTypes, Type returnType, Map templateToInstantiation, TypeEnvironment targetTypeEnv, FunctionCallInstruction fci, BindingEnvironment targetBindingEnv) {
        this.m_function = function2;
        this.m_parameterTypes = parameterTypes;
        this.m_returnType = returnType;
        this.m_templateToInstantiation = templateToInstantiation;
        this.m_targetTypeEnvironment = targetTypeEnv;
        this.m_original = this;
        this.m_fci = fci;
        this.m_targetBindingEnvironment = targetBindingEnv;
    }

    public FunctionInstantiation(FunctionInstantiation fi) {
        this.m_function = fi.m_function;
        this.m_returnType = fi.m_returnType;
        this.m_parameterTypes = fi.m_parameterTypes;
        this.m_original = fi;
        this.m_resolvedParameterTypes = new Type[fi.m_parameterTypes.length];
        for (int i = 0; i < fi.m_parameterTypes.length; ++i) {
            Type t = fi.m_parameterTypes[i].resolveType(fi.m_targetTypeEnvironment);
            if (t == null) {
                throw new RuntimeException();
            }
            this.m_resolvedParameterTypes[i] = t;
        }
    }

    public int hashCode() {
        return this.m_parameterTypes.length + this.m_function.getName().hashCode();
    }

    public boolean equals(Object arg0) {
        if (this.m_resolvedParameterTypes == null) {
            return this == arg0;
        }
        if (arg0 == null || !(arg0 instanceof FunctionInstantiation)) {
            return false;
        }
        FunctionInstantiation fi = (FunctionInstantiation)arg0;
        if (fi.m_function != this.m_function) {
            return false;
        }
        return this.toString().equals(fi.toString());
    }

    public void doFinalTypeCheck() throws TypeCheckException {
        this.makeTypeEnvironment();
    }

    protected TypeEnvironment makeTypeEnvironment() throws TypeCheckException {
        TypeEnvironment typeEnvironment = (TypeEnvironment)this.m_function.getTypeEnvironment().clone();
        for (int i = 0; i < this.m_parameterTypes.length; ++i) {
            Type calledType = this.m_parameterTypes[i];
            this.m_function.unifyParameter(typeEnvironment, this.m_targetBindingEnvironment, calledType, this.m_fci.m_parameters, i, this.m_fci, true);
        }
        if (this.m_templateToInstantiation != null) {
            Type reportedReturnType = this.m_function.getReturnType().duplicateType(this.m_templateToInstantiation);
            Type returnType = this.m_function.getReturnType().resolveType(typeEnvironment);
            if (returnType != null) {
                this.m_targetTypeEnvironment.unify(returnType, reportedReturnType, null);
            }
        }
        return typeEnvironment;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.m_function.getName());
        sb.append('(');
        for (int i = 0; i < this.m_resolvedParameterTypes.length; ++i) {
            sb.append(this.m_resolvedParameterTypes[i]);
            if (i == this.m_resolvedParameterTypes.length - 1) continue;
            sb.append(',');
        }
        sb.append(')');
        return sb.toString();
    }
}

