/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import java.io.IOException;

public class FunctionSignature {
    protected String m_functionName;
    protected Type m_returnType;
    protected Type[] m_parameterTypes;
    protected Object[] m_parameterNames;
    public String[] m_defaultValues;

    public FunctionSignature() {
    }

    public FunctionSignature(String functionName, Object[] parameterNames, Type[] parameterTypes, Type returnType) {
        this.m_functionName = functionName;
        if (this.m_functionName == null) {
            throw new NullPointerException();
        }
        this.m_parameterTypes = parameterTypes;
        this.m_parameterNames = parameterNames;
        this.m_returnType = returnType;
    }

    public FunctionSignature(Function f2) {
        this.m_functionName = f2.getName();
        if (this.m_functionName == null) {
            throw new RuntimeException();
        }
        this.m_returnType = f2.getReturnType();
        Binding[] params = f2.m_parameters;
        this.m_parameterTypes = new Type[params.length];
        this.m_parameterNames = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            this.m_parameterTypes[i] = params[i].getBindingType();
            this.m_parameterNames[i] = params[i].getName();
        }
        if (f2.m_defaultValues != null) {
            this.m_defaultValues = (String[])f2.m_defaultValues.clone();
        }
    }

    public String getFunctionName() {
        return this.m_functionName;
    }

    public void setFunctionName(String s) {
        this.m_functionName = s;
        if (this.m_functionName == null) {
            throw new RuntimeException();
        }
    }

    public Type getReturnType() {
        return this.m_returnType;
    }

    public void setReturnType(Type t) {
        this.m_returnType = t;
    }

    public Type[] getParameterTypes() {
        return this.m_parameterTypes;
    }

    public Object[] getParameterNames() {
        return this.m_parameterNames;
    }

    public void setParameterType(int i, Type t) {
        this.m_parameterTypes[i] = t;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        sb.append(this.m_functionName);
        if (this.m_returnType != null) {
            sb.append("@");
            sb.append(this.m_returnType.prettyPrint());
        }
        int c = this.m_parameterTypes.length;
        for (int i = 0; i < c; ++i) {
            sb.append(' ');
            sb.append(PrettyPrinter.prettyPrintIdentifier(this.m_parameterNames[i]));
            sb.append('@');
            sb.append(this.m_parameterTypes[i].prettyPrint());
        }
        sb.append(')');
        return sb.toString();
    }

    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen("declare-function", indent);
        pw.printToken(this.m_functionName, indent + 1);
        if (this.m_returnType != null) {
            pw.print("@");
            pw.print(this.m_returnType.prettyPrint());
        }
        for (int i = 0; i < this.m_parameterTypes.length; ++i) {
            pw.printIdentifier(this.m_parameterNames[i], indent + 1);
            Type t = this.m_parameterTypes[i];
            pw.print("@");
            pw.print(t.prettyPrint());
        }
        pw.printFormClose(indent);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FunctionSignature)) {
            return false;
        }
        FunctionSignature fs = (FunctionSignature)obj;
        if (!fs.m_functionName.equals(this.m_functionName) || fs.m_parameterTypes.length != this.m_parameterTypes.length) {
            return false;
        }
        if (this.m_returnType == null && fs.m_returnType != null || fs.m_returnType == null && this.m_returnType != null) {
            return false;
        }
        if (this.m_returnType != fs.m_returnType && !this.m_returnType.equals(fs.m_returnType)) {
            return false;
        }
        for (int i = 0; i < this.m_parameterTypes.length; ++i) {
            if (this.m_parameterTypes[i].equals(fs.m_parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.m_functionName.hashCode() + this.m_parameterTypes.length;
    }

    public void write(WriteObjectFileHelper wofh) throws IOException {
        if (this.m_functionName == null) {
            throw new RuntimeException();
        }
        wofh.writeString(this.m_functionName);
        wofh.writeBindingNames(this.m_parameterNames);
        wofh.writeTypes(this.m_parameterTypes);
        wofh.writeType(this.m_returnType);
        wofh.writeInt(this.m_defaultValues == null ? 0 : this.m_defaultValues.length);
        if (this.m_defaultValues != null) {
            for (int i = 0; i < this.m_defaultValues.length; ++i) {
                wofh.writeBoolean(this.m_defaultValues[i] != null);
                if (this.m_defaultValues[i] == null) continue;
                wofh.writeString(this.m_defaultValues[i]);
            }
        }
    }

    public void read(ReadObjectFileHelper rofh) throws Exception {
        this.m_functionName = rofh.readString();
        if (this.m_functionName == null) {
            throw new RuntimeException();
        }
        this.m_parameterNames = rofh.readBindingNames();
        this.m_parameterTypes = rofh.readTypes();
        this.m_returnType = rofh.readType();
        int c = rofh.readInt();
        if (c > 0) {
            this.m_defaultValues = new String[c];
            for (int i = 0; i < this.m_defaultValues.length; ++i) {
                if (!rofh.readBoolean()) continue;
                this.m_defaultValues[i] = rofh.readString();
            }
        }
    }
}

