/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xml.ras.LoggerUtil;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Functor
implements Serializable {
    private static final long serialVersionUID = 3253739645996929876L;
    private static final Logger s_logger = LoggerUtil.getLogger(Functor.class);
    private static final String s_className = Functor.class.getName();
    protected ModuleSignature[] m_parameters;
    protected String[] m_parameterNames;
    protected Module m_body;
    protected String m_name;
    protected ModuleSignature m_signature;

    public Functor(String name2, Module body, ModuleSignature[] parameters, String[] parameterNames, ModuleSignature ms) {
        this.m_name = name2;
        this.m_body = body;
        this.m_parameters = parameters;
        this.m_signature = ms;
        this.m_parameterNames = parameterNames;
        for (int i = 0; i < parameterNames.length; ++i) {
            this.m_body.addModuleImportDirective(new FunctorParameterDirective(parameterNames[i], parameters[i]));
        }
    }

    public String getName() {
        return this.m_name;
    }

    public Module getBody() {
        return this.m_body;
    }

    public ModuleSignature[] getParameters() {
        return this.m_parameters;
    }

    public String[] getParameterNames() {
        return this.m_parameterNames;
    }

    public ModuleSignature getSignature() {
        return this.m_signature;
    }

    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen("functor", indent);
        pw.printToken("(" + this.m_name, indent + 1);
        pw.print("@");
        pw.print(this.m_signature);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            pw.printToken(this.m_parameterNames[i], indent + 2);
            pw.print("@");
            pw.print(this.m_parameters[i]);
        }
        pw.printFormClose(indent + 1);
        this.m_body.prettyPrintModuleInternals(pw, indent);
        pw.printFormClose(indent);
    }

    public void typeCheck() throws TypeCheckException {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "typeCheck", "Type checking functor " + this.m_name);
        }
        this.m_body.typeCheck();
    }

    public void clearTypeInformation() {
        this.m_body.clearTypeInformation(true);
    }

    public void reduce() {
        this.m_body.reduce();
    }

    public class FunctorParameterDirective
    extends ModuleImportDirective {
        private static final long serialVersionUID = 1617730064793711035L;

        FunctorParameterDirective(String name2, ModuleSignature ms) {
            super(name2, ms);
        }

        @Override
        public Instruction translateFunctionCall(ModuleFunctionCallInstruction mfci, Module context2) {
            Instruction[] oldParams = mfci.m_parameters;
            Instruction[] params = new Instruction[oldParams.length + 1];
            System.arraycopy(oldParams, 0, params, 0, oldParams.length);
            params[oldParams.length] = new IdentifierInstruction("__functorinstance__");
            return new FunctionCallInstruction(Functor.this.m_name + "$functor$" + this.m_localName + "$" + mfci.getFunction(), params);
        }

        @Override
        public void toString(PrettyPrinter pp, int level) {
        }
    }
}

