/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import java.io.IOException;

public class FunctorApplicationDirective
extends ModuleImportDirective {
    private static final long serialVersionUID = -6949170961858987141L;
    protected String m_functorName;
    protected Object[] m_modulesToApply;
    private static int s_applications = 0;
    protected int m_index = s_applications++;

    public FunctorApplicationDirective() {
    }

    @Override
    public void read(ReadObjectFileHelper rofh) throws Exception {
        this.m_functorName = rofh.readString();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeString(this.m_functorName);
    }

    public FunctorApplicationDirective(String localName2, ModuleSignature ms, String functorName, Object[] modulesToApply) {
        super(localName2, ms);
        this.m_functorName = functorName;
        this.m_modulesToApply = modulesToApply;
    }

    @Override
    public Instruction translateFunctionCall(ModuleFunctionCallInstruction mfci, Module context2) {
        Instruction[] oldParams = mfci.m_parameters;
        Instruction[] params = new Instruction[oldParams.length + 1];
        System.arraycopy(oldParams, 0, params, 0, oldParams.length);
        params[oldParams.length] = LiteralInstruction.integerLiteral(this.m_index);
        return new FunctionCallInstruction(FunctorApplicationDirective.translateFunctionName(mfci.getFunction(), this.m_functorName), params);
    }

    @Override
    public void toString(PrettyPrinter pp, int level) {
        pp.printFormOpen("apply-functor", level);
        pp.print(" " + this.getLocalName() + "@");
        pp.print(this.m_signature);
        pp.print(" " + this.m_functorName);
        for (int i = 0; i < this.m_modulesToApply.length; ++i) {
            pp.print(" " + this.m_modulesToApply[i]);
        }
        pp.printFormClose(level);
    }
}

