/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IdentifierConsolidator {
    private static final Logger s_logger = LoggerUtil.getLogger(IdentifierConsolidator.class);
    private static final String s_className = IdentifierConsolidator.class.getName();
    protected ArrayList<Object> m_objects = new ArrayList();
    protected ArrayList<Instruction> m_instructions = new ArrayList();
    protected ArrayList<Object> m_lambdaObjects = new ArrayList();
    protected ArrayList<IdentifierInstruction> m_lambdaInstructions = new ArrayList();
    protected HashMap<Object, Instruction> m_paramInstructions = new HashMap();
    protected int m_counter = 0;
    protected int m_lambdaCounter = 0;

    public void reset() {
        this.m_counter = 0;
        this.m_lambdaCounter = 0;
    }

    public int nextIdentifier() {
        if (this.m_counter == this.m_objects.size()) {
            Integer x = new Integer(this.m_counter);
            this.m_objects.add(x);
            this.m_instructions.add(new IdentifierInstruction(x));
        }
        return this.m_counter++;
    }

    public int nextLambdaIdentifier() {
        if (this.m_lambdaCounter == this.m_lambdaObjects.size()) {
            String x = "lambda_param_" + this.m_lambdaCounter;
            this.m_lambdaObjects.add(x);
            this.m_lambdaInstructions.add(new IdentifierInstruction(x));
        }
        return this.m_lambdaCounter++;
    }

    public Object getIdentifierName(int n2) {
        return this.m_objects.get(n2);
    }

    public Object getLambdaIdentifierName(int n2) {
        return this.m_lambdaObjects.get(n2);
    }

    public IdentifierInstruction getIdentifierInstruction(int n2) {
        return (IdentifierInstruction)this.m_instructions.get(n2);
    }

    public IdentifierInstruction getLambdaIdentifierInstruction(int n2) {
        return this.m_lambdaInstructions.get(n2);
    }

    public void processModule(Module m) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "processModule", "Starting consolidation");
        }
        Iterator<Function> i = m.getFunctions().iterator();
        while (i.hasNext()) {
            this.processFunction(i.next());
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "processModule", "Finished with consolidation");
        }
    }

    public void processFunction(Function f2) {
        this.reset();
        Module module = f2.getTypeEnvironment().getModule();
        HashMap<Object, IdentifierInstruction> mappings = new HashMap<Object, IdentifierInstruction>(64);
        HashSet<Object> constantNames = new HashSet<Object>();
        for (int i = 0; i < f2.m_parameters.length; ++i) {
            Object name2 = f2.m_parameters[i].getName();
            if (name2 instanceof Integer) {
                int newIndex = this.nextIdentifier();
                IdentifierInstruction newII = this.getIdentifierInstruction(newIndex);
                Object newVar = this.getIdentifierName(newIndex);
                mappings.put(name2, newII);
                name2 = newVar;
                f2.m_parameters[i].setName(name2);
                continue;
            }
            constantNames.add(name2);
        }
        f2.clearReducedTypeInformation();
        f2.setBody(this.process(f2.getBody(), constantNames, mappings));
        try {
            f2.typeCheckReduced(module, new LinkedList());
        }
        catch (TypeCheckException e) {
            throw new RuntimeException(e);
        }
    }

    public Instruction processLambda(LambdaInstruction lambda2, BindingEnvironment benv) {
        this.reset();
        HashSet set2 = new HashSet();
        lambda2.accumulateFreeBindings(set2, benv);
        HashMap<Object, IdentifierInstruction> mappings = new HashMap<Object, IdentifierInstruction>(64);
        HashSet<Object> constantNames = new HashSet<Object>();
        for (IBinding binding : set2) {
            constantNames.add(binding.getName());
        }
        for (int i = 0; i < lambda2.getParameters().length; ++i) {
            Object name2 = lambda2.getParameters()[i].getName();
            int newIndex = this.nextLambdaIdentifier();
            IdentifierInstruction newII = this.getLambdaIdentifierInstruction(newIndex);
            Object newVar = this.getLambdaIdentifierName(newIndex);
            mappings.put(name2, newII);
            name2 = newVar;
            lambda2.getParameters()[i].setName(name2);
            benv.setVariableBinding(lambda2.getParameters()[i]);
        }
        LambdaInstruction newLambda = lambda2;
        newLambda.setBody(this.process(newLambda.getBody(), constantNames, mappings));
        return newLambda;
    }

    protected Instruction processLetChain(LetInstruction leti, Set constantNames, HashMap map2) {
        LetInstruction outer = new LetInstruction("", null, null);
        Instruction.propagateInfo(leti, outer);
        LetInstruction inner2 = outer;
        while (true) {
            int newIndex = this.nextIdentifier();
            Object oldVar = leti.getVariable();
            IdentifierInstruction newII = this.getIdentifierInstruction(newIndex);
            Object newVar = this.getIdentifierName(newIndex);
            Instruction newValue = this.process(leti.getValue(), constantNames, map2);
            Instruction.propagateInfo(leti.getValue(), newValue);
            inner2.setValue(newValue);
            map2.put(oldVar, newII);
            inner2.setName(newVar);
            if (!(leti.getBody() instanceof LetInstruction)) break;
            leti = (LetInstruction)leti.getBody();
            LetInstruction newInner = new LetInstruction("", null, null);
            Instruction.propagateInfo(leti, newInner);
            inner2.setBody(newInner);
            inner2 = newInner;
        }
        Instruction oldBody = leti.getBody();
        Instruction newBody = this.process(oldBody, constantNames, map2);
        inner2.setBody(newBody);
        Instruction.propagateInfo(oldBody, newBody);
        return outer;
    }

    public Instruction process(Instruction x, Set constantNames, HashMap map2) {
        if (x instanceof StreamInstruction && ((StreamInstruction)x).isStoredAsString()) {
            return x;
        }
        if (x instanceof LetInstruction) {
            return this.processLetChain((LetInstruction)x, constantNames, map2);
        }
        if (x instanceof IdentifierInstruction) {
            return this.processIdentifier((IdentifierInstruction)x, constantNames, map2);
        }
        int c = x.getChildInstructionCount();
        if (c == 0) {
            return x;
        }
        Instruction y = null;
        if (x instanceof ISpecialForm) {
            y = x.cloneShallow();
            ISpecialForm sf = (ISpecialForm)((Object)x);
            ISpecialForm sfNew = (ISpecialForm)((Object)y);
            for (int i = 0; i < c; ++i) {
                IBinding[] bindings = sf.getChildInstructionBindings(i);
                IBinding[] newBindings = sfNew.getChildInstructionBindings(i);
                if (bindings == null) continue;
                for (int j = 0; j < bindings.length; ++j) {
                    Object oldVar = bindings[j].getName();
                    if (sf.getClass().getName().endsWith("MatchXDMItemInstruction") && "_".equals(oldVar)) continue;
                    int newIndex = this.nextIdentifier();
                    IdentifierInstruction newII = this.getIdentifierInstruction(newIndex);
                    Object newVar = this.getIdentifierName(newIndex);
                    map2.put(oldVar, newII);
                    newBindings[j].setName(newVar);
                }
            }
        }
        for (int i = c - 1; i >= 0; --i) {
            Instruction child2 = x.getChildInstruction(i);
            Instruction replacement = this.process(child2, constantNames, map2);
            if (replacement == child2) continue;
            if (y == null) {
                y = x.cloneShallow();
            }
            y.setChildInstruction(i, replacement);
        }
        if (y != null) {
            return y;
        }
        return x;
    }

    protected Instruction processIdentifier(IdentifierInstruction x, Set constantNames, HashMap map2) {
        Object var = x.getVariable();
        if (constantNames.contains(var)) {
            Instruction replacement = this.m_paramInstructions.get(var);
            if (replacement == null) {
                this.m_paramInstructions.put(var, x);
                replacement = x;
            }
            return replacement.cloneReduced();
        }
        Instruction replacement = (Instruction)map2.get(var);
        if (replacement == null) {
            throw new XylemError("ERR_SYSTEM", "unbound(?):" + x);
        }
        return replacement.cloneReduced();
    }
}

