/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class IdentityHashMap
implements Map {
    private static final int CHAIN_SIZE = 3;
    private static final int INITIAL_SIZE = 17;
    private static final float MAX_LOAD = 2.0f;
    private int m_numEntries = 0;
    private MapEntry[][] m_buckets;

    public IdentityHashMap() {
        this.clear();
    }

    private void rehash() {
        MapEntry[][] newBuckets = new MapEntry[this.m_buckets.length * 2][];
        for (int i = 0; i < this.m_buckets.length; ++i) {
            if (this.m_buckets[i] == null) continue;
            for (int j = 0; j < this.m_buckets[i].length; ++j) {
                if (this.m_buckets[i][j] == null) continue;
                this.put(this.m_buckets[i][j].getKey(), this.m_buckets[i][j].getValue(), newBuckets, true);
            }
        }
        this.m_buckets = newBuckets;
    }

    private int whichBucket(int h, int length2) {
        int c = Math.abs(h % length2);
        return c;
    }

    @Override
    public int size() {
        return this.m_numEntries;
    }

    @Override
    public boolean isEmpty() {
        return this.m_numEntries == 0;
    }

    @Override
    public boolean containsKey(Object key2) {
        int hash = System.identityHashCode(key2);
        MapEntry[] chain = this.m_buckets[this.whichBucket(hash, this.m_buckets.length)];
        if (chain == null) {
            return false;
        }
        for (int i = 0; i < chain.length; ++i) {
            if (chain[i] == null || chain[i].getKey() != key2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value2) {
        for (int i = 0; i < this.m_buckets.length; ++i) {
            if (this.m_buckets[i] == null) continue;
            for (int j = 0; j < this.m_buckets[i].length; ++j) {
                if (this.m_buckets[i][j] == null || value2 != this.m_buckets[i][j].getValue()) continue;
                return true;
            }
        }
        return false;
    }

    public Object get(Object key2) {
        int hash = System.identityHashCode(key2);
        MapEntry[] chain = this.m_buckets[this.whichBucket(hash, this.m_buckets.length)];
        if (chain == null) {
            return null;
        }
        for (int i = 0; i < chain.length; ++i) {
            if (chain[i] == null || chain[i].getKey() != key2) continue;
            return chain[i].getValue();
        }
        return null;
    }

    public Object put(Object key2, Object value2) {
        if ((float)(this.m_numEntries + 1) >= 2.0f * (float)this.m_buckets.length) {
            this.rehash();
        }
        return this.put(key2, value2, this.m_buckets, false);
    }

    private Object put(Object key2, Object value2, MapEntry[][] buckets, boolean rehashOperation) {
        int hash = System.identityHashCode(key2);
        int b = this.whichBucket(hash, buckets.length);
        MapEntry[] chain = buckets[b];
        if (chain == null) {
            MapEntry[] c = new MapEntry[3];
            buckets[b] = c;
            chain = c;
        }
        int openSlotIndex = -1;
        for (int i = 0; i < chain.length; ++i) {
            if (chain[i] == null) {
                if (openSlotIndex != -1) continue;
                openSlotIndex = i;
                continue;
            }
            if (chain[i].getKey() != key2) continue;
            Object oldValue = chain[i].getValue();
            chain[i].setValue(value2);
            return oldValue;
        }
        if (openSlotIndex == -1) {
            MapEntry[] c = new MapEntry[chain.length * 2];
            openSlotIndex = chain.length;
            System.arraycopy(chain, 0, c, 0, openSlotIndex);
            buckets[b] = c;
            chain = c;
        }
        chain[openSlotIndex] = new MapEntry(key2, value2);
        if (!rehashOperation) {
            ++this.m_numEntries;
        }
        return null;
    }

    private void remove(int i, int j) {
        if (this.m_buckets[i][j] != null) {
            this.m_buckets[i][j] = null;
            --this.m_numEntries;
        }
    }

    public Object remove(Object key2) {
        int hash = System.identityHashCode(key2);
        MapEntry[] chain = this.m_buckets[this.whichBucket(hash, this.m_buckets.length)];
        if (chain == null) {
            return null;
        }
        for (int i = 0; i < chain.length; ++i) {
            if (chain[i] == null || chain[i].getKey() != key2) continue;
            Object value2 = chain[i].getValue();
            chain[i] = null;
            --this.m_numEntries;
            return value2;
        }
        return null;
    }

    private void removeValue(Object value2) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            MapEntry me = (MapEntry)i.next();
            Object v = me.getValue();
            if (v != value2) continue;
            i.remove();
            return;
        }
    }

    public void putAll(Map t) {
        for (Object k : t.keySet()) {
            this.put(k, t.get(k));
        }
    }

    public Object clone() {
        IdentityHashMap ihm = new IdentityHashMap();
        ihm.putAll((Map)this);
        return ihm;
    }

    @Override
    public void clear() {
        this.m_buckets = new MapEntry[17][];
        this.m_numEntries = 0;
    }

    public Set keySet() {
        return new IdentityKeySet(this);
    }

    public Collection values() {
        return new IdentityValueSet(this);
    }

    public Set entrySet() {
        return new IdentityEntrySet(this);
    }

    private Iterator iterator() {
        return new IdentityEntryIterator(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append("NumEntries:" + this.m_numEntries + "\n");
        for (int i = 0; i < this.m_buckets.length; ++i) {
            sb.append("\n" + i + ": ");
            MapEntry[] chain = this.m_buckets[i];
            if (chain == null) {
                sb.append("NULL");
                continue;
            }
            sb.append("[");
            for (int j = 0; j < chain.length; ++j) {
                if (chain[j] == null) {
                    sb.append(" (NULL) ");
                    continue;
                }
                sb.append(" (" + chain[j].getKey() + "," + chain[j].getValue() + ") ");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public void dump() {
        System.out.println("NumEntries:" + this.m_numEntries);
        for (int i = 0; i < this.m_buckets.length; ++i) {
            System.out.print(i + ": ");
            MapEntry[] chain = this.m_buckets[i];
            if (chain == null) {
                System.out.println("NULL");
                continue;
            }
            System.out.print("[");
            for (int j = 0; j < chain.length; ++j) {
                if (chain[j] == null) {
                    System.out.print(" (NULL) ");
                    continue;
                }
                System.out.print(" (" + chain[j].getKey() + "," + chain[j].getValue() + ") ");
            }
            System.out.println("]");
        }
    }

    public static void main(String[] args) {
        Integer a;
        int ii;
        IdentityHashMap i = new IdentityHashMap();
        IdentityHashMap k = new IdentityHashMap();
        for (ii = 0; ii < 50; ++ii) {
            a = new Integer(ii);
            i.put(a, new Integer(ii + 1));
            i.dump();
            System.out.println("----------------------");
        }
        i.clear();
        for (ii = 0; ii < 50; ++ii) {
            a = new Integer(ii);
            i.put(a, a);
            k.put(a, a);
            i.dump();
            System.out.println("----------------------");
        }
        IdentityHashMap j = new IdentityHashMap();
        j.putAll((Map)i);
        Iterator kk = j.entrySet().iterator();
        while (kk.hasNext()) {
            System.out.print(":" + kk.next() + ":");
        }
        System.out.println();
        kk = j.keySet().iterator();
        while (kk.hasNext()) {
            System.out.print(":" + kk.next() + ":");
        }
        System.out.println();
        kk = j.values().iterator();
        while (kk.hasNext()) {
            System.out.print(":" + kk.next() + ":");
        }
        System.out.println();
        System.out.println();
        Collection mm = i.values();
        mm.retainAll(j.values());
        mm.removeAll(j.keySet());
        kk = mm.iterator();
        while (kk.hasNext()) {
            System.out.print(":" + kk.next() + ":");
        }
        System.out.println();
    }

    private class IdentityEntrySet
    extends IdentitySet {
        public IdentityEntrySet(IdentityHashMap i) {
            super(i);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof MapEntry)) {
                return false;
            }
            Object k = ((MapEntry)o).getKey();
            return this.store.containsKey(k);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof MapEntry)) {
                return false;
            }
            Object k = ((MapEntry)o).getKey();
            if (!this.store.containsKey(k)) {
                return false;
            }
            this.store.remove(k);
            return true;
        }

        @Override
        public Iterator iterator() {
            return new IdentityEntryIterator(this.store);
        }
    }

    private class IdentityValueSet
    extends IdentitySet {
        public IdentityValueSet(IdentityHashMap i) {
            super(i);
        }

        @Override
        public boolean contains(Object o) {
            return this.store.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            if (!this.store.containsValue(o)) {
                return false;
            }
            this.store.removeValue(o);
            return true;
        }

        @Override
        public Iterator iterator() {
            return new IdentityValueIterator(this.store);
        }
    }

    private class IdentityKeySet
    extends IdentitySet {
        public IdentityKeySet(IdentityHashMap i) {
            super(i);
        }

        @Override
        public boolean contains(Object o) {
            return this.store.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            if (!this.store.containsKey(o)) {
                return false;
            }
            this.store.remove(o);
            return true;
        }

        @Override
        public Iterator iterator() {
            return new IdentityKeyIterator(this.store);
        }
    }

    private abstract class IdentitySet
    implements Set {
        protected IdentityHashMap store;

        public IdentitySet(IdentityHashMap i) {
            this.store = i;
        }

        @Override
        public int size() {
            return this.store.size();
        }

        @Override
        public boolean isEmpty() {
            return this.store.isEmpty();
        }

        @Override
        public abstract boolean contains(Object var1);

        @Override
        public abstract Iterator iterator();

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length < this.store.size()) {
                Class<?> b = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(b, this.store.size());
            }
            Iterator i = this.iterator();
            int x = 0;
            while (i.hasNext()) {
                a[x] = i.next();
                ++x;
            }
            return a;
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public abstract boolean remove(Object var1);

        @Override
        public boolean containsAll(Collection c) {
            for (Object o : c) {
                if (!this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection c) {
            boolean b = false;
            for (Object o : this) {
                if (c.contains(o)) continue;
                boolean result2 = this.remove(o);
                b = b || result2;
            }
            return b;
        }

        @Override
        public boolean removeAll(Collection c) {
            boolean b = false;
            for (Object o : c) {
                boolean result2 = this.remove(o);
                b = b || result2;
            }
            return b;
        }

        @Override
        public void clear() {
            this.store.clear();
        }
    }

    private class IdentityValueIterator
    extends IdentityEntryIterator
    implements Iterator {
        public IdentityValueIterator(IdentityHashMap ihm) {
            super(ihm);
        }

        @Override
        public Object next() {
            MapEntry me = (MapEntry)super.next();
            return me.getValue();
        }
    }

    private class IdentityKeyIterator
    extends IdentityEntryIterator
    implements Iterator {
        public IdentityKeyIterator(IdentityHashMap ihm) {
            super(ihm);
        }

        @Override
        public Object next() {
            MapEntry me = (MapEntry)super.next();
            return me.getKey();
        }
    }

    private class IdentityEntryIterator
    implements Iterator {
        private int i = 0;
        private int j = 0;
        private int numSeen = 0;
        protected IdentityHashMap store;

        public IdentityEntryIterator(IdentityHashMap s) {
            this.store = s;
        }

        @Override
        public boolean hasNext() {
            return this.numSeen < this.store.size();
        }

        public Object next() {
            MapEntry o = null;
            block0: while (o == null) {
                if (this.i >= IdentityHashMap.this.m_buckets.length) {
                    throw new NoSuchElementException();
                }
                MapEntry[] chain = this.store.m_buckets[this.i];
                while (chain == null) {
                    ++this.i;
                    if (this.i >= IdentityHashMap.this.m_buckets.length) {
                        throw new NoSuchElementException();
                    }
                    chain = this.store.m_buckets[this.i];
                }
                o = this.j >= chain.length ? null : chain[this.j];
                while (o == null) {
                    ++this.j;
                    if (this.j >= chain.length) {
                        this.j = 0;
                        ++this.i;
                        continue block0;
                    }
                    o = chain[this.j];
                }
            }
            ++this.numSeen;
            ++this.j;
            return o;
        }

        @Override
        public void remove() {
            this.store.remove(this.i, this.j - 1);
            --this.numSeen;
        }
    }

    public class MapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        public MapEntry(Object k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value2) {
            Object v = this.value;
            this.value = value2;
            return v;
        }
    }
}

