/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgCodeGen;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.OrderedSet;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.RepeatingNameGenerator;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PureInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.ForkStack;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.Releasable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public abstract class Instruction {
    public static final boolean SOURCELINEINFO = !HiddenOptions.wasSpecified("sourceLineInfo") || !"off".equals(HiddenOptions.getStringValue("sourceLineInfo"));
    private Type m_cachedType = null;
    protected BindingEnvironment m_bindingEnvironment = null;
    protected boolean m_hasBeenTypechecked = false;
    protected URL m_sourceFilename = null;
    protected int m_sourceLineNumber = -1;
    private SourceLocation m_sourceLocation = null;
    public TraceBackObject m_creationTraceException;
    public static final boolean USEINSTRUCTIONCREATIONTRACE = HiddenOptions.wasSpecified("il_gen_traceback") && HiddenOptions.optionValueIs("il_gen_traceback", "on");
    static final INewNameGenerator s_defaultGenerator = new INewNameGenerator(){

        @Override
        public Object getNewName() {
            return ReductionHelper.generateIntermediateIdentifier2();
        }
    };
    public static boolean CLONEREDUCEDSHALLOW = false;
    static final boolean s_sanityCheck = false;
    boolean typeAliasesExpanded = false;
    public static final boolean s_propagateInfo = true;

    public Instruction() {
        if (USEINSTRUCTIONCREATIONTRACE) {
            this.m_creationTraceException = new TraceBackObject("Creation Trace");
        }
    }

    public final void setSourceFilename(URL s) {
        this.m_sourceFilename = s;
    }

    public final void setSourceLineNumber(int n2) {
        this.m_sourceLineNumber = n2;
    }

    public final URL getSourceFilename() {
        return this.m_sourceFilename;
    }

    public final int getSourceLineNumber() {
        return this.m_sourceLineNumber;
    }

    public final void setSourceLocation(SourceLocation location) {
        this.m_sourceLocation = location;
    }

    public final SourceLocation getSourceLocation() {
        return this.m_sourceLocation;
    }

    public final boolean hasBeenTypeChecked() {
        return this.m_hasBeenTypechecked;
    }

    public void setBindingEnvironment(BindingEnvironment benv) {
        this.m_bindingEnvironment = benv;
    }

    public abstract Type typeCheck(TypeEnvironment var1, BindingEnvironment var2, LinkedList var3) throws TypeCheckException;

    protected final void doDefaultTypeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        if (this.m_hasBeenTypechecked) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Instruction " + this.getClass() + ":'" + this + "' has already been type checked"), this);
        }
        this.m_bindingEnvironment = benv;
        this.m_hasBeenTypechecked = true;
    }

    public final Type getCachedType() {
        return this.m_cachedType;
    }

    public Type getPreTypecheckType(ModuleSignature msig) {
        return this.getTypeForTypeAnnotationPrettyPrint();
    }

    public final Type getType(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.getTypeInternal(tenv, benv);
    }

    protected abstract Type getTypeInternal(TypeEnvironment var1, BindingEnvironment var2);

    public boolean isPure() {
        if (this instanceof PureInstruction) {
            return true;
        }
        if (this instanceof IImperativeInstruction) {
            return false;
        }
        int c = this.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            Instruction child2 = this.getChildInstruction(i);
            if (child2.isPure()) continue;
            return false;
        }
        return true;
    }

    public final BindingEnvironment getBindingEnvironment() {
        return this.m_bindingEnvironment;
    }

    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        UnsupportedOperationException e = new UnsupportedOperationException(this.getClass() + " does not implement generateCode(FcgInstructionList...)  " + "Instruction:  " + this);
        throw e;
    }

    public final boolean supportsCodeGenerationOptimization(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        boolean b = this.supportsCodeGenerationOptimizationInternal(cgos, tenv, benv);
        return b;
    }

    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        return false;
    }

    public int getChildInstructionCount() {
        return 0;
    }

    public Instruction getChildInstruction(int i) {
        return null;
    }

    public void setChildInstruction(int i, Instruction n2) {
        throw new ArrayIndexOutOfBoundsException("" + i);
    }

    public int getTypeParameterCount() {
        return 0;
    }

    public Type getTypeParameter(int i) {
        return null;
    }

    public void setTypeParameter(int i, Type n2) {
    }

    public abstract Instruction cloneWithoutTypeInformation();

    public abstract Instruction cloneShallow();

    public abstract void generateReducedForm(ReductionHelper var1, Instruction[] var2, BindingEnvironment var3);

    public final boolean isBasicExpression() {
        return this instanceof LiteralInstruction || this instanceof IdentifierInstruction;
    }

    public void determineDataDependencies(Binding[] specificBindings, HashMap collectedBindings, Instruction parent2, int index2, BindingEnvironment benv) {
        int c = this.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            this.getChildInstruction(i).determineDataDependencies(specificBindings, collectedBindings, this, i, benv);
        }
    }

    public void determineDataDependencies(Set bindingNames) {
        int c = this.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            this.getChildInstruction(i).determineDataDependencies(bindingNames);
        }
    }

    public int byteCodeSize() {
        return 1;
    }

    public int accumulateByteCodeSize() {
        int total_size = this.byteCodeSize();
        int c = this.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            total_size += this.getChildInstruction(i).accumulateByteCodeSize();
        }
        return total_size;
    }

    public void accumulateFunctionsCalled(Set<String> set2) {
        int c = this.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            Instruction n2 = this.getChildInstruction(i);
            n2.accumulateFunctionsCalled(set2);
        }
    }

    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        int c = this.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            this.getChildInstruction(i).accumulateNonLiteralFreeBindings(set2, benv);
        }
    }

    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        int c = this.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            this.getChildInstruction(i).accumulateFreeBindings(set2, benv);
        }
    }

    public void replaceTypeVariables(Map typeMap) {
        int c = this.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            this.getChildInstruction(i).replaceTypeVariables(typeMap);
        }
    }

    public boolean isStatic(BindingEnvironment benv) {
        return false;
    }

    public String toString() {
        PrettyPrinter pw = new PrettyPrinter();
        this.toString(pw, 0);
        return pw.toString();
    }

    public String innerToString() {
        return this.getClass().toString();
    }

    public void toString(PrettyPrinter pw, int indent) {
        String extraArgsLast;
        String com = this.getLocationComment();
        if (com != null) {
            pw.comment(com, indent);
        }
        pw.printFormOpen(this.innerToString(), indent, this.getTypeForTypeAnnotationPrettyPrint());
        String extraArg = this.toStringInnerNonChildParam();
        if (null != extraArg) {
            pw.printToken(extraArg, indent + 1);
        }
        if (this.getChildInstructionCount() > 0) {
            for (int i = 0; i < this.getChildInstructionCount(); ++i) {
                Instruction n2 = this.getChildInstruction(i);
                if (n2 != null) {
                    n2.toString(pw, indent + 1);
                    continue;
                }
                pw.printToken("null", indent + 1);
            }
        }
        if (null != (extraArgsLast = this.toStringInnerNonChildParamsLast())) {
            pw.printToken(extraArgsLast, indent + 1);
        }
        pw.printFormClose(indent);
    }

    protected Type getTypeForTypeAnnotationPrettyPrint() {
        return this.getCachedType();
    }

    protected String toStringInnerNonChildParam() {
        return null;
    }

    protected String toStringInnerNonChildParamsLast() {
        return null;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        int c = this.getChildInstructionCount();
        Instruction n2 = (Instruction)arg0;
        if (n2.getChildInstructionCount() != c) {
            return false;
        }
        for (int i = 0; i < c; ++i) {
            if (this.getChildInstruction(i).equals(n2.getChildInstruction(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int c = this.getChildInstructionCount();
        return c;
    }

    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        throw new UnsupportedOperationException(this.getClass() + " does not implement evaluate.  Instruction:" + this + " function:" + f2);
    }

    public void evaluate(IAppendableStream as, Environment e, Function f2, IDebuggerInterceptor di) {
        Object o = this.evaluate(e, f2, di, false);
        as.append(o, this.evaluateType(f2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object evaluateToOwnForkReleaseable(Environment e, Function f2, IDebuggerInterceptor di) {
        Releasable cursor2;
        boolean didTakeOwnership;
        Object val = null;
        e.pushForkScope();
        try {
            val = this.evaluate(e, f2, di, false);
            e.popForkScope(val);
        }
        catch (Throwable throwable) {
            e.popForkScope(val);
            throw throwable;
        }
        ForkStack forkStack = e.getForkStack();
        if (val instanceof Releasable && !(didTakeOwnership = forkStack.popTopForkIfMatch(cursor2 = (Releasable)val))) {
            Type t = this.evaluateType(f2);
            val = t.evaluateVariableFork(cursor2);
        }
        return val;
    }

    public BindingEnvironment evaluateBindingEnvironment(Function f2) {
        boolean reduced = this.getBindingEnvironment() == null;
        BindingEnvironment benv = reduced ? f2.getBindingEnvironment() : this.getBindingEnvironment();
        return benv;
    }

    public Type evaluateType(Function f2) {
        boolean reduced = this.getBindingEnvironment() == null;
        BindingEnvironment benv = this.evaluateBindingEnvironment(f2);
        TypeEnvironment tenv = f2.getTypeEnvironment();
        Type t = reduced ? this.getType(tenv, benv).resolveType(tenv) : this.getTypeForTypeAnnotationPrettyPrint().resolveType(tenv);
        return t;
    }

    public final void debugDump(PrettyPrinter pw, int indent) {
        pw.printFormOpen(this.innerToString(), indent);
        pw.print(" : " + this.m_cachedType);
        if (this.getChildInstructionCount() > 0) {
            for (int i = 0; i < this.getChildInstructionCount(); ++i) {
                Instruction n2 = this.getChildInstruction(i);
                if (n2 != null) {
                    n2.debugDump(pw, indent + 1);
                    continue;
                }
                pw.printToken("null", indent + 1);
            }
        }
        pw.printFormClose(indent);
    }

    public void clearTypeInformation() {
        this.m_hasBeenTypechecked = false;
        this.m_bindingEnvironment = null;
        this.m_cachedType = null;
        int c = this.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            if (this.getChildInstruction(i) == null) {
                throw new RuntimeException();
            }
            this.getChildInstruction(i).clearTypeInformation();
        }
    }

    public Instruction replaceBindings(Map bindings) {
        int c = this.getChildInstructionCount();
        Instruction x = null;
        for (int i = 0; i < c; ++i) {
            Instruction y1;
            Instruction y0 = this.getChildInstruction(i);
            if (y0 == (y1 = y0.replaceBindings(bindings))) continue;
            if (x == null) {
                x = this.cloneShallow();
            }
            x.setChildInstruction(i, y1);
        }
        return x == null ? this : x;
    }

    protected void clearLocalForTypecheckReduced() {
        this.m_bindingEnvironment = null;
    }

    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        int c = this.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            this.getChildInstruction(i).typeCheckReduced(tenv, benv, functionStack);
        }
        this.clearLocalForTypecheckReduced();
    }

    public Instruction removeAliases(HashMap aliases) {
        int c = this.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            Instruction y1;
            Instruction y0 = this.getChildInstruction(i);
            if (y0 == (y1 = y0.removeAliases(aliases))) continue;
            this.setChildInstruction(i, y1);
        }
        return this;
    }

    public Instruction cloneReduced() {
        int c = this.getChildInstructionCount();
        Instruction x = this.cloneShallow();
        for (int i = 0; i < c; ++i) {
            Instruction y1;
            Instruction y0 = this.getChildInstruction(i);
            if (y0 == (y1 = y0.cloneReduced())) continue;
            x.setChildInstruction(i, y1);
        }
        Instruction.propagateInfo(this, x);
        Type cachedType = this.getCachedType();
        if (cachedType != null) {
            x.setCachedType(cachedType);
        }
        return x;
    }

    public final Instruction assignNewNames(Map names) {
        return this.assignNewNames(names, s_defaultGenerator);
    }

    public final Instruction cloneWithNewNames() {
        return this.assignNewNames(new HashMap());
    }

    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        int c = this.getChildInstructionCount();
        Instruction x = this.cloneShallow();
        for (int i = 0; i < c; ++i) {
            Instruction y1;
            Instruction y0 = this.getChildInstruction(i);
            if (y0 == (y1 = y0.assignNewNames(names, ing))) continue;
            x.setChildInstruction(i, y1);
        }
        return x;
    }

    public final Set accumulateFreeBindingsInOrder(BindingEnvironment benv) {
        OrderedSet s = new OrderedSet();
        this.accumulateFreeBindings(s, benv);
        return s;
    }

    public final IBinding[] accumulateFreeBindingsAsArray(BindingEnvironment benv) {
        Set s = this.accumulateFreeBindingsInOrder(benv);
        IBinding[] ans = new IBinding[s.size()];
        s.toArray(ans);
        return ans;
    }

    public final Instruction generateCanonicalForm(BindingEnvironment benv) {
        Set s = this.accumulateFreeBindingsInOrder(benv);
        if (s == null) {
            throw new XylemError("ERR_SYSTEM", "a-" + this.getClass().getName());
        }
        RepeatingNameGenerator rng = new RepeatingNameGenerator("free");
        HashMap<Object, IdentifierInstruction> h = new HashMap<Object, IdentifierInstruction>();
        for (IBinding b : s) {
            if (b == null) {
                throw new XylemError("ERR_SYSTEM", "b-" + this.getClass().getName());
            }
            Object name2 = b.getName();
            if (name2 == null) {
                throw new XylemError("ERR_SYSTEM", "c-" + this.getClass().getName());
            }
            h.put(name2, new IdentifierInstruction(rng.getNewName()));
        }
        return this.assignNewNames(h, new RepeatingNameGenerator());
    }

    public static final Instruction shouldNeverReach(Type t) {
        return new ChooseInstruction(LiteralInstruction.booleanFalseLiteral(), (Instruction)LiteralInstruction.nullLiteral(t), null);
    }

    public static final Instruction shouldNeverReach(Instruction i, Function f2) {
        if (f2.getTypeEnvironment() == null) {
            throw new Error("Expected type-checked function: " + f2.getName());
        }
        return Instruction.shouldNeverReach(i.getType(f2.getTypeEnvironment(), f2.getBindingEnvironment()).resolveType(f2.getTypeEnvironment()));
    }

    public final int getChildInstructionIndex(Instruction n2) {
        int c = this.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            if (this.getChildInstruction(i) != n2) continue;
            return i;
        }
        return -1;
    }

    public void clearCachedType() {
        this.m_cachedType = null;
    }

    public Type setCachedType(Type m_type) {
        assert (m_type != null);
        this.m_cachedType = m_type;
        return this.m_cachedType;
    }

    public void write(WriteObjectFileHelper wofh) throws IOException {
        int c = this.getChildInstructionCount();
        wofh.writeInt(c);
        for (int i = 0; i < c; ++i) {
            wofh.writeInstruction(this.getChildInstruction(i));
        }
    }

    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        int c = this.getChildInstructionCount();
        if (rofh.readInt() != c) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < c; ++i) {
            this.setChildInstruction(i, rofh.readInstruction(benv));
        }
    }

    public boolean isDescendentInstruction(Instruction n2) {
        Instruction base2 = this;
        while (base2 != n2) {
            int c = base2.getChildInstructionCount();
            if (c == 0) {
                return false;
            }
            for (int i = 0; i < c - 1; ++i) {
                Instruction x = base2.getChildInstruction(i);
                if (x == n2) {
                    return true;
                }
                if (!x.isDescendentInstruction(n2)) continue;
                return true;
            }
            base2 = base2.getChildInstruction(c - 1);
        }
        return true;
    }

    public void standardizeTypes(Set knownTypeVars, TypeEnvironment tenv) {
        Instruction base2 = this;
        while (true) {
            int c;
            int c0 = base2.getTypeParameterCount();
            for (int i = 0; i < c0; ++i) {
                Type t = base2.getTypeParameter(i).resolveTypeAsMuchAsPossible(tenv, knownTypeVars);
                base2.setTypeParameter(i, t);
            }
            if (base2.m_cachedType != null) {
                Type t;
                base2.m_cachedType = t = base2.m_cachedType.resolveTypeAsMuchAsPossible(tenv, knownTypeVars);
            }
            if ((c = base2.getChildInstructionCount()) == 0) {
                return;
            }
            for (int i = 0; i < c - 1; ++i) {
                Instruction x = base2.getChildInstruction(i);
                x.standardizeTypes(knownTypeVars, tenv);
            }
            base2 = base2.getChildInstruction(c - 1);
        }
    }

    public void instantiateReducedPolymorphicFunctions(Set newFunctions, TypeEnvironment tenv, BindingEnvironment benv, Set stack, Set done) {
        int c = this.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            Instruction x = this.getChildInstruction(i);
            x.instantiateReducedPolymorphicFunctions(newFunctions, tenv, benv, stack, done);
        }
    }

    public final boolean doesDescendentCountExceedThreshold(int threshold) {
        return this.doesDescendentCountExceedThresholdHelper(threshold) < 0;
    }

    protected int doesDescendentCountExceedThresholdHelper(int threshold) {
        int c = this.getChildInstructionCount();
        if ((threshold -= c) < 0) {
            return threshold;
        }
        for (int i = 0; i < c && (threshold = this.getChildInstruction(i).doesDescendentCountExceedThresholdHelper(threshold)) >= 0; ++i) {
        }
        return threshold;
    }

    public final void expandTypeAliases(Module m) {
        if (this.typeAliasesExpanded) {
            throw new XylemError("ERR_SYSTEM", "Internal compiler error: type aliases already expanded.");
        }
        ArrayList<Instruction> stack = new ArrayList<Instruction>();
        stack.add(this);
        while (!stack.isEmpty()) {
            int stackSize = stack.size() - 1;
            Instruction inst = (Instruction)stack.get(stackSize);
            int count2 = inst.getChildInstructionCount();
            if (count2 == 0 || inst.typeAliasesExpanded) {
                stack.remove(stackSize);
                int typeCount = inst.getTypeParameterCount();
                for (int i = 0; i < typeCount; ++i) {
                    Type t = inst.getTypeParameter(i);
                    if (t == null) continue;
                    inst.setTypeParameter(i, t.expandTypeAliases(m));
                }
            } else {
                for (int i = count2 - 1; i >= 0; --i) {
                    Instruction child2 = inst.getChildInstruction(i);
                    if (child2.typeAliasesExpanded) continue;
                    if (child2.getChildInstructionCount() == 0 && child2.getTypeParameterCount() == 0) {
                        child2.typeAliasesExpanded = true;
                        continue;
                    }
                    stack.add(child2);
                }
            }
            inst.typeAliasesExpanded = true;
        }
    }

    public static void propagateInfo(Instruction from2, Instruction to2) {
        to2.doPropagateInfo(from2);
    }

    public void doPropagateInfo(Instruction from2) {
        try {
            if (null == this.getSourceFilename() && null == this.getSourceLocation()) {
                this.setSourceFilename(from2.getSourceFilename());
                this.setSourceLineNumber(from2.getSourceLineNumber());
                this.setSourceLocation(from2.getSourceLocation());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void propagateLocInfo(String urlString, int line, Instruction to2) {
        try {
            URL url = new URL(urlString);
            to2.doPropagateLocInfo(url, line);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
    }

    public void doPropagateLocInfo(URL url, int line) {
        this.setSourceFilename(url);
        this.setSourceLineNumber(line);
        int count2 = this.getChildInstructionCount();
        for (int i = 0; i < count2; ++i) {
            this.getChildInstruction(i).doPropagateLocInfo(url, line);
        }
    }

    public String getLocationComment() {
        if (this.m_sourceFilename != null) {
            return "; from line " + this.m_sourceLineNumber + " of " + this.m_sourceFilename.toString();
        }
        return null;
    }

    public Cursor.Profile getMinimalUsageForEvaluate(int argumentIndex, Function f2) {
        return Cursor.Profile.NONE;
    }

    public Cursor.Profile getMinimalUsageForEvaluateWithStreamOptimization(int argumentIndex, Function f2) {
        return this.getMinimalUsageForEvaluate(argumentIndex, f2);
    }

    public Cursor.Profile getMinimalUsageForGenerateCode(int argumentIndex, Function f2) {
        return this.getMinimalUsageForEvaluate(argumentIndex, f2);
    }

    public Cursor.Profile getMinimalUsageForGenerateCodeWithStreamOptimization(int argumentIndex, Function f2) {
        return this.getMinimalUsageForEvaluate(argumentIndex, f2);
    }

    public boolean constructsCursor() {
        return false;
    }

    public FcgType generateSourceLocation(FcgCodeGen cg, FcgInstructionList il) {
        FcgClassReferenceType clazz = cg.getClassReferenceType(SourceLocation.class.getName());
        if (this.m_sourceLocation == null) {
            il.loadNull();
        } else {
            if (this.m_sourceLocation.getSystemId() == null) {
                il.loadNull();
            } else {
                il.loadLiteral(this.m_sourceLocation.getSystemId());
            }
            if (this.m_sourceLocation.getPublicId() == null) {
                il.loadNull();
            } else {
                il.loadLiteral(this.m_sourceLocation.getPublicId());
            }
            il.loadLiteral(this.m_sourceLocation.getLineNumber());
            il.loadLiteral(this.m_sourceLocation.getColumnNumber());
            il.loadLiteral(this.m_sourceLocation.getEndLine());
            il.loadLiteral(this.m_sourceLocation.getEndColumn());
            FcgType[] paramTypes = new FcgType[]{FcgType.STRING, FcgType.STRING, FcgType.INT, FcgType.INT, FcgType.INT, FcgType.INT};
            il.createObjectExpr((FcgType)clazz, paramTypes);
        }
        return clazz;
    }

    public boolean ensureCloneUniqueIdentity(Instruction i2, boolean throwOnCloneUniquenessProblem) {
        return this.ensureCloneUniqueIdentity(i2, throwOnCloneUniquenessProblem, 0, new Stack<Instruction>(), new Stack<Instruction>());
    }

    protected boolean ensureCloneUniqueIdentity(Instruction clone, boolean throwOnCloneUniquenessProblem, int depth, Stack<Instruction> sourceInstructionStack, Stack<Instruction> cloneInstructionStack) {
        if (this instanceof LiteralInstruction && this == clone) {
            return true;
        }
        if (this == clone) {
            return this.handleEnsureCloneUniquenessError("Clone Identities not unique!", throwOnCloneUniquenessProblem);
        }
        if (sourceInstructionStack.contains(this)) {
            return this.handleEnsureCloneUniquenessError("Cycle detected in source!", throwOnCloneUniquenessProblem);
        }
        if (cloneInstructionStack.contains(clone)) {
            return this.handleEnsureCloneUniquenessError("Cycle detected in clone!", throwOnCloneUniquenessProblem);
        }
        if (sourceInstructionStack.contains(clone)) {
            return this.handleEnsureCloneUniquenessError("Clone instruction is contained in source tree!", throwOnCloneUniquenessProblem);
        }
        if (cloneInstructionStack.contains(this)) {
            return this.handleEnsureCloneUniquenessError("Source instruction is contained in clone tree!", throwOnCloneUniquenessProblem);
        }
        if (this.getClass() != clone.getClass()) {
            return this.handleEnsureCloneUniquenessError("Clone and source instructions are different, but classes are different also!", throwOnCloneUniquenessProblem);
        }
        sourceInstructionStack.push(this);
        cloneInstructionStack.push(clone);
        int childCount1 = this.getChildInstructionCount();
        int childCount2 = clone.getChildInstructionCount();
        if (childCount1 != childCount2) {
            return this.handleEnsureCloneUniquenessError("Identities are unique but child counts do not match!", throwOnCloneUniquenessProblem);
        }
        for (int i = 0; i < childCount1; ++i) {
            Instruction child1 = this.getChildInstruction(i);
            Instruction child2 = clone.getChildInstruction(i);
            if (child1 == this || child2 == this || child1 == clone || child2 == clone) {
                return this.handleEnsureCloneUniquenessError("Parent contains itself!", throwOnCloneUniquenessProblem);
            }
            if (depth > 1500) {
                System.err.println("Stack is getting ridiculously deep in ensureCloneUniqueIdentity!: " + this.getClass().getName() + " depth = " + depth + " for " + this.getClass().getSimpleName());
                break;
            }
            try {
                boolean isOK = child1.ensureCloneUniqueIdentity(child2, throwOnCloneUniquenessProblem, depth + 1, sourceInstructionStack, cloneInstructionStack);
                if (isOK) continue;
                return false;
            }
            catch (StackOverflowError err) {
                System.err.println("Stack stack overflow error in ensureCloneUniqueIdentity!! (attempting to recover): " + this.getClass().getName() + " depth = " + depth + " for " + this.getClass().getSimpleName());
                return false;
            }
        }
        sourceInstructionStack.pop();
        cloneInstructionStack.pop();
        return true;
    }

    private boolean handleEnsureCloneUniquenessError(String errorMsg, boolean throwOnCloneUniquenessProblem) {
        RuntimeException e = new RuntimeException(errorMsg);
        if (throwOnCloneUniquenessProblem) {
            throw e;
        }
        System.err.println(errorMsg);
        return false;
    }

    public final boolean ensureGoodTypes(TypeEnvironment tenv, BindingEnvironment benv) {
        try {
            return this._ensureGoodTypesInternal(tenv, benv, 0);
        }
        catch (StackOverflowError err) {
            System.err.println("WARNING: Stack overflow error in ensureGoodTypes!! (attempting to recover): " + this.getClass().getName());
            return true;
        }
        catch (TypeCheckException e) {
            System.err.println("Inferred type and get reduced type do not match!!!");
            e.printStackTrace();
            return false;
        }
    }

    private final boolean _ensureGoodTypesInternal(TypeEnvironment tenv, BindingEnvironment benv, int depth) throws TypeCheckException {
        if (depth > 100) {
            return true;
        }
        if (this.m_cachedType == null) {
            System.out.println("DEBUG: " + this.getClass().getName());
        }
        assert (this.m_cachedType != null);
        Type t2 = this.getTypeInternal(tenv, benv);
        if (!(t2 instanceof NamedType) || !(this.m_cachedType instanceof TupleType)) {
            tenv.unify(this.m_cachedType, t2, this);
        }
        int childCount1 = this.getChildInstructionCount();
        for (int i = 0; i < childCount1; ++i) {
            Instruction child1 = this.getChildInstruction(i);
            boolean isGood = child1._ensureGoodTypesInternal(tenv, benv, depth + 1);
            if (isGood) continue;
            return isGood;
        }
        return true;
    }

    public static class TraceBackObject
    extends Exception {
        private static final long serialVersionUID = -3341577468361002854L;
        boolean guard = false;

        public TraceBackObject(String message) {
            super(message);
        }

        @Override
        public String toString() {
            if (!this.guard) {
                this.guard = true;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                this.printStackTrace(pw);
                pw.flush();
                String dump = sw.toString();
                pw.close();
                this.guard = false;
                return dump;
            }
            return super.toString();
        }
    }
}

