/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ObjectFactory;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.ByteType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.DecimalType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.FloatType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.JavaArrayType;
import com.ibm.xltxe.rnm1.xylem.types.JavaClassInformation;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import com.ibm.xltxe.rnm1.xylem.types.ShortType;
import com.ibm.xltxe.rnm1.xylem.types.UnitType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;

public class JavaClassImporter {
    private static HashMap s_cachedInformation = new HashMap();

    public static Type classToAdrenalineType(Class c, Module prog) {
        String s = c.getName();
        if (s.equals("void")) {
            return UnitType.s_unitType;
        }
        Type t = null;
        boolean isArray = c.isArray();
        if (isArray) {
            Class<?> componentClass = c.getComponentType();
            if (!componentClass.isArray()) {
                c = componentClass;
                t = JavaClassImporter.classToAdrenalineType(c, prog);
                s = c.getName();
            } else {
                int depth = 2;
                componentClass = componentClass.getComponentType();
                while (componentClass.isArray()) {
                    ++depth;
                    componentClass = componentClass.getComponentType();
                }
                return new JavaArrayType(JavaClassImporter.classToAdrenalineType(componentClass, prog), depth);
            }
        }
        if (!c.isPrimitive()) {
            t = c == BigDecimal.class ? DecimalType.s_decimalType : (c == BigInteger.class ? BigIntegerType.s_bigIntegerType : new JavaObjectType(s));
        } else {
            String typeName = c.getName();
            if (typeName.equals("int")) {
                t = IntType.s_intType;
            } else if (typeName.equals("unit")) {
                t = UnitType.s_unitType;
            } else if (typeName.equals("char")) {
                t = CharType.s_charType;
            } else if (typeName.equals("byte")) {
                t = ByteType.s_byteType;
            } else if (typeName.equals("short")) {
                t = ShortType.s_shortType;
            } else if (typeName.equals("double")) {
                t = DoubleType.s_doubleType;
            } else if (typeName.equals("float")) {
                t = FloatType.s_floatType;
            } else if (typeName.equals("long")) {
                t = LongType.s_longType;
            } else if (typeName.equals("boolean")) {
                t = BooleanType.s_booleanType;
            }
        }
        if (isArray) {
            t = t.getStreamType();
        }
        return t;
    }

    public static final synchronized JavaClassInformation retrieveJavaClassInformation(String className, Module prog, boolean isUserClass) throws Exception {
        JavaClassInformation jot = (JavaClassInformation)s_cachedInformation.get(className);
        if (jot == null) {
            jot = new JavaClassInformation();
            Class c = null;
            try {
                c = isUserClass ? ObjectFactory.findProviderClass(className, ObjectFactory.findClassLoader(), true) : ObjectFactory.findProviderClass(className, Module.class.getClassLoader(), true);
            }
            catch (ClassNotFoundException ex) {
                throw new XylemError("ERR_SYSTEM", "Could not find class for " + className);
            }
            jot.setInterface(c.isInterface());
            Class<?>[] interfaces = c.getInterfaces();
            for (int j = 0; j < interfaces.length; ++j) {
                jot.addBaseClassName(interfaces[j].getName());
            }
            Class base2 = c.getSuperclass();
            if (base2 != null) {
                jot.addBaseClassName(base2.getName());
            }
            Constructor<?>[] constructors = c.getConstructors();
            for (int j = 0; j < constructors.length; ++j) {
                Constructor<?> m = constructors[j];
                Class<?>[] paramTypes = m.getParameterTypes();
                Type[] convertedParamTypes = new Type[paramTypes.length];
                for (int k = 0; k < paramTypes.length; ++k) {
                    Class<?> param = paramTypes[k];
                    convertedParamTypes[k] = JavaClassImporter.classToAdrenalineType(param, prog);
                }
                JavaClassInformation.Method jotm = new JavaClassInformation.Method(m.getName(), convertedParamTypes, null);
                jot.addConstructor(jotm);
            }
            Field[] fields = c.getFields();
            for (int j = 0; j < fields.length; ++j) {
                Field m = fields[j];
                boolean isStatic = (m.getModifiers() & 8) != 0;
                boolean isFinal = (m.getModifiers() & 0x10) != 0;
                boolean isPublic = (m.getModifiers() & 1) != 0;
                boolean isConstant = isStatic && isFinal && isPublic;
                Object constantObject = null;
                if (isConstant) {
                    constantObject = m.get(null);
                }
                Class<?> k = m.getType();
                jot.addField(new JavaClassInformation.Field(m.getName(), JavaClassImporter.classToAdrenalineType(k, prog), constantObject));
            }
            Method[] methods = c.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                Method m = methods[j];
                Class<?>[] paramTypes = m.getParameterTypes();
                Type[] convertedParamTypes = new Type[paramTypes.length];
                for (int k = 0; k < paramTypes.length; ++k) {
                    Class<?> param = paramTypes[k];
                    convertedParamTypes[k] = JavaClassImporter.classToAdrenalineType(param, prog);
                }
                Class<?> ret = m.getReturnType();
                JavaClassInformation.Method jotm = new JavaClassInformation.Method(m.getName(), convertedParamTypes, JavaClassImporter.classToAdrenalineType(ret, prog));
                if ((m.getModifiers() & 8) != 0) {
                    jot.addStaticMethod(jotm);
                    continue;
                }
                jot.addMethod(jotm);
            }
            s_cachedInformation.put(className, jot);
        }
        return jot;
    }
}

