/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.AbstractTypeStore;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Functor;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.ILUBResolver;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.LocalModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.ObjectFactory;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.TopLevelModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeSpecializationDerivative;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataTypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.ClassType;
import com.ibm.xltxe.rnm1.xylem.types.CompoundType;
import com.ibm.xltxe.rnm1.xylem.types.TypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.types.VirtualDataTypeMap;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.exec.DynamicContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Module
extends AbstractTypeStore
implements Serializable {
    private static final long serialVersionUID = 3362968532062637990L;
    private static final Logger s_logger = LoggerUtil.getLogger(Module.class);
    private static final String s_className = Module.class.getName();
    protected HashMap<String, Function> m_functions = new HashMap();
    protected HashMap<String, Module> m_modules = new HashMap();
    protected ArrayList<String> m_moduleDefinitions = new ArrayList();
    protected ArrayList m_fixup = new ArrayList();
    public ILUBResolver m_lubResolver;
    public ModuleSignature m_signature;
    protected Module m_parent;
    protected HashMap m_moduleImportDirectives = new HashMap();
    protected HashMap<String, Functor> m_functors = new HashMap();
    protected VirtualDataTypeMap m_vdtmap = new VirtualDataTypeMap();
    public boolean m_flatTypeNamespace;
    private boolean m_stripInputTypeAnnotationsSpecified = false;
    private boolean m_preserveInputTypeAnnotationsSpecified = false;
    private long m_numberXMLTypeSpecializations = 0L;
    private HashMap m_partialInformation = new HashMap();
    public static final String TYPEROUNDTRIP_OPTION = "typeroundtrip";
    public static final boolean sTypeRoundTrip = HiddenOptions.wasSpecified("typeroundtrip") && !HiddenOptions.optionValueIs("typeroundtrip", "off");
    public static final String TYPEROUNDTRIPKIND_OPTION = "typeroundtripkind";
    public static final boolean sTypeRoundTripKind = HiddenOptions.wasSpecified("typeroundtripkind");
    private ArrayList<Function> m_xmlTypeSpecializedFunctions;
    boolean typeAliasesExpanded = true;

    public long getNumberXMLTypeSpecializations() {
        return this.m_numberXMLTypeSpecializations;
    }

    public void setNumberXMLTypeSpecializations(long mNumberXMLTypeSpecializations) {
        this.m_numberXMLTypeSpecializations = mNumberXMLTypeSpecializations;
    }

    public void setPartialInformation(String functionName, Set partialInfo) {
        this.m_partialInformation.put(functionName, partialInfo);
    }

    public Set getPartialInformation(String functionName) {
        return (Set)this.m_partialInformation.get(functionName);
    }

    public Module() {
    }

    public Module(String name2, Module parent2) {
        this(name2, parent2, new ModuleSignature(""));
    }

    public Module(String name2, Module parent2, ModuleSignature ms) {
        this.m_name = name2;
        this.m_signature = ms;
        this.m_parent = parent2;
    }

    public void addModule(Module m) {
        if (m == this) {
            throw new XylemError("ERR_SYSTEM", "can't add '" + this.getName() + "' to self");
        }
        this.m_moduleDefinitions.add(m.getName());
        this.m_modules.put(m.getName(), m);
        m.m_parent = this;
        this.addModuleImportDirective(new LocalModuleImportDirective(m.getName(), m.m_signature));
    }

    public void addModules(Collection<Module> modules) {
        Iterator<Module> iterator = modules.iterator();
        while (iterator.hasNext()) {
            this.addModule(iterator.next());
        }
    }

    public void addModuleImportDirective(ModuleImportDirective mid) {
        this.m_moduleImportDirectives.put(mid.getLocalName(), mid);
    }

    public void addModuleImports(Collection<ModuleImportDirective> moduleImports) {
        Iterator<ModuleImportDirective> iterator = moduleImports.iterator();
        while (iterator.hasNext()) {
            this.addModuleImportDirective(iterator.next());
        }
    }

    public Object evaluate(DynamicContext dynamicContext) {
        Environment e = new Environment(dynamicContext);
        Object result2 = this.evaluate(e, null);
        e.release(result2);
        return result2;
    }

    public Object debug(IDebuggerInterceptor di, DynamicContext dynamicContext) {
        Environment e = new Environment(dynamicContext);
        Object result2 = this.evaluate(e, di);
        e.release(result2);
        return result2;
    }

    public Object evaluate(Environment e, IDebuggerInterceptor di) {
        Function f2 = this.getFunction("main");
        if (f2 == null) {
            throw new XylemError("ERR_SYSTEM", "not found 'main'");
        }
        return f2.getBody().evaluate(e, f2, di, false);
    }

    public void addFunctor(Functor f2) {
        this.m_functors.put(f2.getName(), f2);
    }

    public Collection getFunctors() {
        return this.m_functors.values();
    }

    public Functor getFunctor(String name2) {
        return this.m_functors.get(name2);
    }

    public VirtualDataTypeMap getVDTMap() {
        return this.m_vdtmap;
    }

    public void setVDTMap(VirtualDataTypeMap vdtm) {
        this.m_vdtmap = vdtm;
    }

    public void addFunction(Function f2, boolean errorIfDuplicate) {
        Function o;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "addFunction", "adding function " + f2.getName());
        }
        if ((o = this.m_functions.get(f2.getName())) == f2) {
            return;
        }
        if (o != null && errorIfDuplicate) {
            s_logger.logrb(Level.WARNING, s_className, "addFunction", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "ERR_SYSTEM", new Object[]{"function with name " + f2.getName() + " already exists"});
        }
        this.m_functions.put(f2.getName(), f2);
        f2.setModule(this);
    }

    public void removeFunction(Function f2) {
        String name2 = f2.getName();
        Function o = this.m_functions.get(name2);
        if (o == f2) {
            this.m_functions.remove(name2);
            return;
        }
    }

    public void addFunction(Function f2) {
        this.addFunction(f2, true);
    }

    public Function getFunction(String name2) {
        return this.m_functions.get(name2);
    }

    public void addToListOfXMLTypeSpecializedStubs(Function f2) {
        if (this.m_xmlTypeSpecializedFunctions == null) {
            this.m_xmlTypeSpecializedFunctions = new ArrayList();
        }
        this.m_xmlTypeSpecializedFunctions.add(f2);
    }

    public Function getPublicFunction(String name2) {
        if (this.m_signature.containsFunction(name2)) {
            return this.getFunction(name2);
        }
        return null;
    }

    public FunctionSignature getFunctionSignature(String name2) {
        return this.m_signature.getFunctionSignature(name2);
    }

    public Module getModule(String path2) {
        return this.m_modules.get(path2);
    }

    public Collection<Module> getModules() {
        return this.m_modules.values();
    }

    public ModuleImportDirective getModuleImportDirective(String name2) {
        return (ModuleImportDirective)this.m_moduleImportDirectives.get(name2);
    }

    public Collection getModuleImportDirectives() {
        return this.m_moduleImportDirectives.values();
    }

    public ModuleSignature getModuleSignature(String name2) {
        Module m = this.getModule(name2);
        if (m != null) {
            return m.m_signature;
        }
        ModuleImportDirective mid = (ModuleImportDirective)this.m_moduleImportDirectives.get(name2);
        if (mid == null) {
            for (ModuleImportDirective dir : this.m_moduleImportDirectives.values()) {
                ModuleSignature sig = dir.getSignature();
                ModuleSignature indirect = sig.getModuleSignature(name2);
                if (indirect == null) continue;
                return indirect;
            }
            return null;
        }
        return mid.getSignature();
    }

    public Module getParent() {
        return this.m_parent;
    }

    public Program getProgram() {
        for (Module m = this; m != null; m = m.getParent()) {
            if (!(m instanceof Program)) continue;
            return (Program)m;
        }
        throw new XylemError("ERR_SYSTEM", "modules must be descended from a program");
    }

    public Function[] getSimilarFunctions(String name2) {
        LinkedList<Function> funcs = new LinkedList<Function>();
        for (String funcName : this.m_functions.keySet()) {
            if (-1 == funcName.indexOf(name2) || -1 != funcName.indexOf(name2 + "s")) continue;
            funcs.add(this.m_functions.get(funcName));
        }
        Function[] ans = new Function[funcs.size()];
        funcs.toArray(ans);
        return ans;
    }

    public void renameFunction(Function f2, String newName) {
        this.m_functions.remove(f2.getName());
        f2.m_name = newName;
        this.addFunction(f2, false);
    }

    public Collection<Function> getFunctions() {
        return this.m_functions.values();
    }

    public Set<String> getFunctionNames() {
        return this.m_functions.keySet();
    }

    public void forceFunctionGeneration(Function f2) {
        if (f2.isPolymorphic()) {
            throw new IllegalArgumentException("Cannot force function " + f2.getName() + " to be generated because it is polymorphic");
        }
        this.m_signature.addFunctionSignature(new FunctionSignature(f2));
    }

    public void reduce() {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "reduce", "Reducing module " + this.m_name);
        }
        Iterator<String> i = this.m_moduleDefinitions.iterator();
        while (i.hasNext()) {
            Module m = this.m_modules.get(i.next());
            m.reduce();
        }
        for (Functor f2 : this.m_functors.values()) {
            f2.reduce();
        }
        ArrayList<Function> functions = new ArrayList<Function>(this.m_functions.values());
        Module.sortFunctionList(functions);
        for (Function f3 : functions) {
            f3.reduce();
        }
    }

    public void clearTypeInformation() {
        this.clearTypeInformation(true);
    }

    public void reTypeReduceRoundTrip(String location, boolean force) throws TypeCheckException {
        if (sTypeRoundTrip || force) {
            if (HiddenOptions.getStringValue(TYPEROUNDTRIP_OPTION) == null || force || HiddenOptions.optionValueIs(TYPEROUNDTRIP_OPTION, location)) {
                this.clearTypeInformation();
                this.typeCheck();
                if (HiddenOptions.getStringValue(TYPEROUNDTRIPKIND_OPTION) != null && HiddenOptions.optionValueIs(TYPEROUNDTRIPKIND_OPTION, "reduce")) {
                    this.reduce();
                } else {
                    this.typeCheckReduced();
                }
            }
            assert (this.ensureGoodTypes());
        }
    }

    public boolean ensureGoodTypes() {
        Iterator<String> i = this.m_moduleDefinitions.iterator();
        while (i.hasNext()) {
            Module m = this.m_modules.get(i.next());
            boolean b = m.ensureGoodTypes();
            if (b) continue;
            return false;
        }
        for (Function f2 : this.m_functions.values()) {
            boolean b;
            if (f2.m_isXMLTypeSpecialized || (b = f2.ensureGoodTypes())) continue;
            return false;
        }
        return true;
    }

    public void clearTypeInformation(boolean resetReturnTypes) {
        Iterator<Object> i = this.m_moduleDefinitions.iterator();
        while (i.hasNext()) {
            Module m = this.m_modules.get(i.next());
            m.clearTypeInformation(resetReturnTypes);
        }
        for (Functor f2 : this.m_functors.values()) {
            f2.clearTypeInformation();
        }
        for (Function f3 : this.m_functions.values()) {
            f3.clearTypeInformation(resetReturnTypes);
        }
    }

    public void addToFixupList(FunctionCallInstruction fci, Function f2) {
        this.m_fixup.add(new Object[]{fci, f2});
    }

    public void typeCheck() throws TypeCheckException {
        this.typeCheck(true);
    }

    public void typeCheck(boolean removeDeadFunctions) throws TypeCheckException {
        Function f2;
        FunctionCallInstruction fci;
        int count2;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "typeCheck", "Started type checking module " + this.m_name);
        }
        Iterator<Object> i = this.m_moduleDefinitions.iterator();
        while (i.hasNext()) {
            Module m = this.m_modules.get(i.next());
            m.typeCheck(removeDeadFunctions);
        }
        for (Functor f3 : this.m_functors.values()) {
            f3.typeCheck();
        }
        this.m_fixup.clear();
        LinkedList<Function> functionStack = new LinkedList<Function>();
        i = this.exportedFunctionsIterator();
        while (i.hasNext()) {
            Object x = i.next();
            if (x instanceof String) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Function " + x + " in module " + this.m_name + " is required by the module signature but was not defined"), null);
            }
            Function f4 = (Function)x;
            if (f4.hasBeenTypeChecked()) continue;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "typeCheck", "pre type checking function " + f4.getName());
            }
            f4.typeCheck(this, null, functionStack);
            if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINEST)) continue;
            s_logger.logp(Level.FINEST, s_className, "typeCheck", "post type checking function " + f4.getName());
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "typeCheck", "Finished type checking functions for module " + this.m_name + ", going on to fixup");
        }
        for (count2 = 0; !this.m_fixup.isEmpty() && count2 < 100; ++count2) {
            ArrayList list = new ArrayList(this.m_fixup);
            this.m_fixup.clear();
            i = list.iterator();
            while (i.hasNext()) {
                Object[] x = (Object[])i.next();
                fci = (FunctionCallInstruction)x[0];
                f2 = (Function)x[1];
                Function.pushFunction(f2, functionStack);
                if (fci.fixupPartiallySpecializedFunctions(f2) || f2.isPolymorphic()) {
                    i.remove();
                }
                Function.popFunction(f2, functionStack);
            }
            this.m_fixup.addAll(list);
        }
        if ((long)count2 >= 100L + this.m_numberXMLTypeSpecializations) {
            StringBuffer sb = new StringBuffer();
            for (Object[] x : this.m_fixup) {
                fci = (FunctionCallInstruction)x[0];
                f2 = (Function)x[1];
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(fci);
                sb.append(" in function ");
                sb.append(f2.getName() + " : " + new FunctionSignature(f2));
            }
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Unable to infer types for function calls: " + sb), null);
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "typeCheck", "Finished fixing up functions for module " + this.m_name + ", going on to remove unused functions");
        }
        if (removeDeadFunctions) {
            this.removeDeadFunctions();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "typeCheck", "Finished removing unused and un-type-specialized functions for module " + this.m_name);
            }
        }
        Iterator<Function> functions = this.m_functions.values().iterator();
        ArrayList<Function> xmlStubList = new ArrayList<Function>();
        while (functions.hasNext()) {
            Function f5 = functions.next();
            if (f5.m_isXMLTypeSpecialized) {
                xmlStubList.add(f5);
                continue;
            }
            if (!f5.hasBeenTypeChecked()) continue;
            f5.standardizeTypes(true);
        }
        for (Function function2 : xmlStubList) {
            this.removeFunction(function2);
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "typeCheck", "Finished type checking module " + this.m_name);
        }
    }

    public void cleanXMLStubs() {
        if (this.m_xmlTypeSpecializedFunctions != null) {
            for (Function function2 : this.m_xmlTypeSpecializedFunctions) {
                this.removeFunction(function2);
            }
            this.m_xmlTypeSpecializedFunctions.clear();
        }
    }

    public void cleanInlineStubs() {
        Iterator<Function> functions = this.m_functions.values().iterator();
        ArrayList<Function> stubList = new ArrayList<Function>();
        while (functions.hasNext()) {
            Function f2 = functions.next();
            if (!f2.getName().contains("%%Inline%%")) continue;
            stubList.add(f2);
        }
        for (Function function2 : stubList) {
            this.removeFunction(function2);
        }
    }

    public void typeCheckReduced() throws TypeCheckException {
        if (this.m_name != null && this.m_name.length() > 0 && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "typeCheckReduced", "Started type checking reduced module " + this.m_name);
        }
        Iterator<Object> i = this.m_moduleDefinitions.iterator();
        while (i.hasNext()) {
            Module m = this.m_modules.get(i.next());
            m.typeCheckReduced();
        }
        LinkedList functionStack = new LinkedList();
        i = this.exportedFunctionsIterator();
        while (i.hasNext()) {
            Object x = i.next();
            if (!(x instanceof Function)) {
                s_logger.logrb(Level.WARNING, s_className, "typeCheckReduced", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "ERR_SYSTEM", new Object[]{"unimplemented exported function " + x});
                Program.dumpXylemFile(this, new File("."), this.getName());
                continue;
            }
            Function f2 = (Function)x;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "typeCheckReduced", "typeChecking function " + f2.getName() + " (" + x.getClass() + ")");
            }
            if (!f2.needsTypecheckReduced()) continue;
            f2.typeCheckReduced(this, functionStack);
        }
        if (this.m_name != null && this.m_name.length() > 0 && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "typeCheckReduced", "Finished type checking reduced module " + this.m_name);
        }
    }

    public void instantiateReducedPolymorphicFunctions() {
        Iterator<Object> i = this.m_moduleDefinitions.iterator();
        while (i.hasNext()) {
            Module m = this.m_modules.get(i.next());
            m.instantiateReducedPolymorphicFunctions();
        }
        HashSet done = new HashSet();
        i = this.exportedFunctionsIterator();
        boolean needTypeCheck = false;
        while (true) {
            HashSet newFunctions = new HashSet();
            while (i.hasNext()) {
                Function f2 = (Function)i.next();
                if (needTypeCheck) {
                    try {
                        f2.typeCheckReduced(this, new LinkedList());
                    }
                    catch (TypeCheckException e) {
                        throw new RuntimeException(e);
                    }
                }
                f2.instantiateReducedPolymorphicFunctions(newFunctions, new HashSet(), done);
                f2.m_returnType = f2.getBody().getType(f2.getTypeEnvironment(), f2.getBindingEnvironment());
                if (needTypeCheck) {
                    TypeSpecializationDerivative tsd = (TypeSpecializationDerivative)f2.getDerivationKey();
                    for (int j = 0; j < f2.m_parameters.length; ++j) {
                        try {
                            f2.getTypeEnvironment().unify(f2.m_parameters[j].getBindingType(), tsd.m_originalTypeVariables[j], null);
                            continue;
                        }
                        catch (TypeCheckException e1) {
                            throw new RuntimeException(e1);
                        }
                    }
                }
                f2.standardizeTypes(true);
            }
            if (newFunctions.isEmpty()) {
                return;
            }
            i = newFunctions.iterator();
            needTypeCheck = true;
        }
    }

    public void removeDeadFunctions() {
        HashSet<String> processedFunctions = new HashSet<String>();
        Iterator<Function> exportedFunctions = this.exportedFunctionsIterator();
        while (exportedFunctions.hasNext()) {
            Function f2 = exportedFunctions.next();
            processedFunctions.add(f2.getName());
            this.accumulateCalledFunctions(processedFunctions, f2.getBody());
        }
        Iterator<Function> functions = this.m_functions.values().iterator();
        while (functions.hasNext()) {
            Function f3 = functions.next();
            if (processedFunctions.contains(f3.getName())) continue;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "removeDeadFunctions", "function " + f3.getName() + " is not being called; removing");
            }
            functions.remove();
            if (f3.getOriginalFunction() == null) continue;
            f3.getOriginalFunction().m_derivatives.remove(f3.getDerivationKey());
        }
    }

    protected void accumulateCalledFunctions(HashSet<String> processedFunctions, Instruction body) {
        HashSet<String> set2 = new HashSet<String>();
        body.accumulateFunctionsCalled(set2);
        for (String funcName : set2) {
            if (processedFunctions.contains(funcName)) continue;
            processedFunctions.add(funcName);
            this.accumulateCalledFunctions(processedFunctions, this.m_functions.get(funcName).getBody());
        }
    }

    public void removeFunctionDerivativeInformation(boolean removeXMLSpecializedFuncs) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "removeFunctionDerivativeInformation", "removing function derivative information from program");
        }
        for (Function f2 : this.m_functions.values()) {
            f2.removeDerivativeInformation(removeXMLSpecializedFuncs);
            assert (!removeXMLSpecializedFuncs || f2.m_derivatives.size() == 0);
        }
    }

    protected String innerToString() {
        return "module";
    }

    public void dump(PrintWriter w) {
        PrettyPrinter pw = new PrettyPrinter(w);
        this.toString(pw, 0);
        w.println(pw.dumpModuleSignatures());
        w.flush();
    }

    public void toString(PrettyPrinter pw, int level) {
        pw.printFormOpen(this.innerToString(), level + 0);
        if (this.getName() != null && this.getName().length() > 0) {
            pw.print(" " + this.getName());
        }
        if (this.m_signature != null && this.m_signature.m_name.length() != 0) {
            pw.m_moduleSignatures.add(this.m_signature);
            pw.print("@" + this.m_signature.m_name);
        }
        this.prettyPrintModuleInternals(pw, level);
        pw.printFormClose(level + 0);
    }

    public void prettyPrintModuleInternals(PrettyPrinter pw, int level) {
        Iterator<Object> i = this.m_moduleDefinitions.iterator();
        while (i.hasNext()) {
            Module m = this.m_modules.get(i.next());
            m.toString(pw, level + 1);
        }
        for (Functor f2 : this.m_functors.values()) {
            f2.toString(pw, level + 1);
        }
        for (ModuleImportDirective mid : this.m_moduleImportDirectives.values()) {
            mid.toString(pw, level + 1);
        }
        i = this.getAbstractDataTypesIterator();
        while (i.hasNext()) {
            ((AbstractDataType)i.next()).toString(pw, level + 1);
        }
        if (this.m_signature != null) {
            i = this.m_signature.getAbstractDataTypesIterator();
            while (i.hasNext()) {
                AbstractDataType adt = (AbstractDataType)i.next();
                adt.toString(pw, level + 1);
            }
        }
        Function[] valuesArray = this.m_functions.values().toArray(new Function[0]);
        Arrays.sort(valuesArray, new Comparator<Function>(){

            @Override
            public int compare(Function o1, Function o2) {
                String s1 = o1.getName();
                String s2 = o2.getName();
                return s1.compareTo(s2);
            }
        });
        for (int index2 = 0; index2 < valuesArray.length; ++index2) {
            Function func = valuesArray[index2];
            if (func.getName().equals("main")) continue;
            func.toString(pw, level + 1);
        }
        if (this.m_functions.containsKey("main")) {
            this.m_functions.get("main").toString(pw, level + 1);
        }
    }

    public String toString() {
        PrettyPrinter pw = new PrettyPrinter();
        this.toString(pw, 0);
        return pw.toString();
    }

    public Iterator<Function> exportedFunctionsIterator() {
        ArrayList<Function> list = new ArrayList<Function>();
        for (String s : this.m_signature.m_functionSignatures.keySet()) {
            Function f2 = this.m_functions.get(s);
            assert (f2 != null);
            list.add(f2);
        }
        Module.sortFunctionList(list);
        return list.iterator();
    }

    public void exportAllFunctions() {
        for (Function f2 : this.m_functions.values()) {
            this.m_signature.addFunctionSignature(new FunctionSignature(f2));
        }
    }

    public void exportAllSymbols() {
        this.exportAllFunctions();
        Iterator<Object> i = this.getAbstractDataTypesIterator();
        while (i.hasNext()) {
            CompoundType adt = (AbstractDataType)i.next();
            this.m_signature.addAbstractDataType((AbstractDataType)adt);
        }
        this.clearADTs();
        for (CompoundType adt : this.m_classes.values()) {
            this.m_signature.addClass((ClassType)adt);
        }
        this.m_classes.clear();
        for (String name2 : this.m_genericADTs.keySet()) {
            AbstractDataTypeLambda gen = (AbstractDataTypeLambda)this.m_genericADTs.get(name2);
            this.m_signature.addGenericAbstractDataType(name2, gen.getTypeParameters(), gen.m_constructors);
        }
        this.m_genericADTs.clear();
        for (String name2 : this.m_typeLambdas.keySet()) {
            this.m_signature.addTypeLambda(name2, (TypeLambda)this.m_typeLambdas.get(name2));
        }
        this.m_typeLambdas.clear();
        for (ModuleImportDirective dir : this.m_moduleImportDirectives.values()) {
            this.m_signature.addModuleImportDirective(dir);
        }
    }

    public void optimize(Optimizer optimizer) {
        if (!this.typeAliasesExpanded) {
            throw new XylemError("ERR_SYSTEM", "Internal compiler error: type aliases must be expanded before transforming code");
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "optimize", "running optimizer " + optimizer);
        }
        for (Module mod2 : this.m_modules.values()) {
            mod2.optimize(optimizer);
        }
        TreeSet<String> functions = new TreeSet<String>();
        functions.addAll(this.m_functions.keySet());
        int c = 0;
        HashSet<String> done = new HashSet<String>();
        while (true) {
            for (String key2 : functions) {
                Function f2 = this.m_functions.get(key2);
                optimizer.optimizeFunction(f2);
                done.add(key2);
                ++c;
            }
            TreeSet<String> set2 = new TreeSet<String>();
            set2.addAll(this.m_functions.keySet());
            set2.removeAll(done);
            if (set2.isEmpty()) break;
            functions = set2;
        }
    }

    public void formalizeSignature(String name2) {
        this.m_signature.setName(name2);
        for (FunctionSignature fs : this.m_signature.m_functionSignatures.values()) {
            Function f2 = this.getFunction(fs.getFunctionName());
            fs.m_returnType = f2.getReturnType().resolveType(f2.getTypeEnvironment());
        }
    }

    public static void sortFunctionList(List<Function> list) {
        Collections.sort(list, new Comparator<Function>(){

            @Override
            public int compare(Function arg0, Function arg1) {
                String x = arg0.getName();
                String y = arg1.getName();
                return x.compareTo(y);
            }
        });
    }

    protected void write(ObjectOutput out) throws IOException {
        WriteObjectFileHelper wofh = new WriteObjectFileHelper(this, out);
        wofh.writeString(this.m_name);
        Module.writeTypes(this, wofh);
        wofh.writeInt(this.m_moduleImportDirectives.size());
        for (ModuleImportDirective mid : this.m_moduleImportDirectives.values()) {
            mid.write(wofh);
        }
        Collection<Function> functions = this.getFunctions();
        wofh.writeInt(functions.size());
        for (Function f2 : functions) {
            f2.write(wofh);
        }
        Collection typeAliases = this.getTypeAliases();
        wofh.writeInt(typeAliases.size());
        Iterator<Object> i = typeAliases.iterator();
        Set typeAliasNames = this.getTypeAliasNames();
        Iterator j = typeAliasNames.iterator();
        while (i.hasNext()) {
            String typeName = (String)j.next();
            wofh.writeString(typeName);
            Type f3 = (Type)i.next();
            wofh.writeType(f3);
        }
    }

    public static Module loadCompiled(File dir, String name2, ModuleSignatureStore mss) throws Exception {
        if (mss == null) {
            mss = new ModuleSignatureStore(new ArrayList<URL>());
        }
        File cxi = new File(dir, name2 + ".cxi");
        FileInputStream fis = new FileInputStream(cxi);
        ObjectInputStream ois = new ObjectInputStream(fis);
        ModuleSignature ms = new ModuleSignature();
        ms.read(ois, mss);
        fis.close();
        mss.registerModuleSignature(name2, ms);
        File cxo = new File(dir, name2 + ".cxo");
        fis = new FileInputStream(cxo);
        ois = new ObjectInputStream(fis);
        Module m = Module.readModule(ois, mss);
        m.m_signature = ms;
        fis.close();
        m.typeCheckReduced();
        return m;
    }

    public static Module loadCompiled(URL file, ModuleSignatureStore mss) throws Exception {
        File dir = new File(file.getPath());
        String name2 = dir.getName();
        name2 = name2.substring(0, name2.lastIndexOf(".cxo"));
        dir = dir.getParentFile();
        return Module.loadCompiled(dir, name2, mss);
    }

    public static void saveCompiled(Module m, URL file) throws Exception {
        File dir = new File(file.getPath());
        String name2 = dir.getName();
        name2 = name2.substring(0, name2.lastIndexOf(".cxo"));
        dir = dir.getParentFile();
        Module.saveCompiled(m, dir, name2);
    }

    public static void saveCompiled(Module m, File dir, String name2) throws Exception {
        File cxoFile = new File(dir, name2 + ".cxo");
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(cxoFile));
        Module.writeModule(oos, m);
        oos.flush();
        oos.close();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "saveCompiled", "wrote:" + cxoFile);
        }
        File cxiFile = new File(dir, name2 + ".cxi");
        oos = new ObjectOutputStream(new FileOutputStream(cxiFile));
        m.m_signature.write(oos);
        oos.flush();
        oos.close();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "saveCompiled", "wrote:" + cxiFile);
        }
    }

    public static Module readModule(ObjectInput in2, ModuleSignatureStore mss) throws Exception {
        String cName = in2.readUTF();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "readModule", "reading module or program class = " + cName);
        }
        Module m = (Module)ObjectFactory.newInstance(cName, Module.class.getClassLoader(), true);
        m.read(in2, mss);
        return m;
    }

    public static void writeModule(ObjectOutput out, Module m) throws IOException {
        out.writeUTF(m.getClass().getName());
        m.write(out);
    }

    protected void read(ObjectInput in2, ModuleSignatureStore mss) throws Exception {
        int i;
        ReadObjectFileHelper rofh = new ReadObjectFileHelper(this, in2, mss);
        this.m_name = rofh.readString();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "read", "reading module m_name=" + this.m_name);
        }
        this.m_signature = mss.resolveModuleSignature(this.getName());
        Module.readTypes(this, rofh);
        int c = rofh.readInt();
        for (i = 0; i < c; ++i) {
            TopLevelModuleImportDirective tlmid = new TopLevelModuleImportDirective();
            tlmid.read(rofh);
            this.addModuleImportDirective(tlmid);
        }
        c = rofh.readInt();
        for (i = 0; i < c; ++i) {
            Function f2 = new Function();
            f2.read(rofh);
            this.addFunction(f2);
        }
        c = rofh.readInt();
        for (int i2 = 0; i2 < c; ++i2) {
            String typeAliasName = rofh.readString();
            Type f3 = rofh.readType();
            this.addTypeAlias(typeAliasName, f3);
        }
    }

    @Override
    public AbstractDataType getAbstractDataType(String name2) {
        AbstractDataType result2;
        block2: {
            ModuleImportDirective mid;
            result2 = super.getAbstractDataType(name2);
            if (result2 == null) {
                result2 = this.m_signature.getAbstractDataType(name2);
            }
            if (result2 != null) break block2;
            Iterator i$ = this.getModuleImportDirectives().iterator();
            while (i$.hasNext() && (result2 = (mid = (ModuleImportDirective)i$.next()).getSignature().getAbstractDataType(name2)) == null) {
            }
        }
        return result2;
    }

    @Override
    public AbstractDataType.Constructor getConstructor(String name2) {
        if (this.m_constructors.containsKey(name2)) {
            return (AbstractDataType.Constructor)this.m_constructors.get(name2);
        }
        AbstractDataType.Constructor adtc = this.m_signature.getConstructor(name2);
        if (adtc != null) {
            return adtc;
        }
        for (ModuleImportDirective mid : this.getModuleImportDirectives()) {
            adtc = mid.getSignature().getConstructor(name2);
            if (adtc == null) continue;
            return adtc;
        }
        for (int ix = 0; ix < this.m_moduleDefinitions.size(); ++ix) {
            Module x = this.m_modules.get(this.m_moduleDefinitions.get(ix));
            adtc = x.getConstructor(name2);
            if (adtc == null) continue;
            return adtc;
        }
        return null;
    }

    public CompoundType lookupCompoundType(String moduleName, String typeName) {
        return this.matchesName(moduleName) ? this.lookupCompoundType(typeName) : this.getModuleSignature(moduleName).lookupCompoundType(typeName);
    }

    @Override
    public CompoundType lookupCompoundType(String typeName) {
        CompoundType ct = super.lookupCompoundType(typeName);
        if (ct != null) {
            return ct;
        }
        ct = this.m_signature.lookupCompoundType(typeName);
        if (ct != null) {
            return ct;
        }
        for (ModuleImportDirective mid : this.getModuleImportDirectives()) {
            if (mid == null) {
                throw new XylemError("ERR_SYSTEM", "Internal compiler error");
            }
            ModuleSignature sig = mid.getSignature();
            if (sig == null && !this.m_flatTypeNamespace) continue;
            if (sig == null) {
                throw new XylemError("ERR_SYSTEM", "Internal compiler error: null signature for module-import directive " + mid.getLocalName() + " while looking for compound type " + typeName);
            }
            ct = mid.getSignature().lookupCompoundType(typeName);
            if (ct == null) continue;
            return ct;
        }
        return null;
    }

    @Override
    public Type lookupTypeAlias(String aliasName) {
        if (this.m_typeAliases.containsKey(aliasName)) {
            return (Type)this.m_typeAliases.get(aliasName);
        }
        Type aliasType = this.m_signature.lookupTypeAlias(aliasName);
        if (aliasType != null) {
            return aliasType;
        }
        for (ModuleImportDirective mid : this.getModuleImportDirectives()) {
            if (mid.getSignature() == null && !this.m_flatTypeNamespace) continue;
            if (mid.getSignature() == null) {
                throw new XylemError("ERR_SYSTEM", "signature not found for module import " + mid.getLocalName());
            }
            aliasType = mid.getSignature().lookupTypeAlias(aliasName);
            if (aliasType == null) continue;
            return aliasType;
        }
        return null;
    }

    @Override
    public void addGenericAbstractDataType(String name2, TypeVariable[] parms, AbstractDataType.Constructor[] constructors) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "addGenericAbstractDataType", "adding generic ADT " + name2 + " to module " + this.m_name);
        }
        super.addGenericAbstractDataType(name2, parms, constructors);
        this.m_signature.addGenericAbstractDataType(name2, parms, constructors);
    }

    @Override
    public AbstractDataType instantiateGenericADT(String name2, Type[] args) {
        return this.instantiateGenericADT(null, name2, args);
    }

    public AbstractDataType instantiateGenericADT(String module, String name2, Type[] args) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "instantiateGenericADT", "instantiating generic ADT " + module + "." + name2 + " in module " + this.m_name);
        }
        AbstractDataTypeLambda genericADT = this.matchesName(module) ? this.getGenericADT(name2) : this.getModuleSignature(module).getGenericADT(name2);
        return this.instantiateGenericADT(genericADT, args);
    }

    @Override
    public AbstractDataTypeLambda getGenericADT(String name2) {
        AbstractDataTypeLambda lam;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "getGenericADT", "getting generic ADT " + name2 + " from module " + this.m_name);
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            for (AbstractDataTypeLambda adt : this.m_genericADTs.values()) {
                s_logger.logp(Level.FINEST, s_className, "getGenericADT", "generic ADT " + adt.getName() + " is in module " + this.m_name);
            }
            for (AbstractDataTypeLambda adt : this.m_signature.m_genericADTs.values()) {
                s_logger.logp(Level.FINEST, s_className, "getGenericADT", "generic ADT " + adt.getName() + " is in module signature " + this.m_signature.getName());
            }
        }
        if ((lam = super.getGenericADT(name2)) != null) {
            return lam;
        }
        lam = this.m_signature.getGenericADT(name2);
        if (lam != null) {
            return lam;
        }
        Iterator<Module> it = this.m_modules.values().iterator();
        while (it.hasNext()) {
            lam = it.next().getGenericADT(name2);
            if (lam == null) continue;
            return lam;
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "getGenericADT", "did not find generic ADT " + name2 + " in module " + this.m_name);
        }
        return null;
    }

    public TypeLambda lookupTypeLambda(String module, String name2) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "lookupTypeLambda", "looking for type-lambda " + module + "." + name2 + " in module " + this.m_name);
        }
        TypeLambda tl = this.matchesName(module) ? this.lookupTypeLambda(name2) : this.lookupTypeLambdaInSig(module, name2);
        return tl;
    }

    TypeLambda lookupTypeLambdaInSig(String module, String name2) {
        ModuleSignature sig = this.getModuleSignature(module);
        if (sig == null) {
            throw new XylemError("ERR_SYSTEM", "Module signature " + module + " was null when looking for type-lambda " + name2 + " in " + this.getName());
        }
        return sig.lookupTypeLambda(name2);
    }

    @Override
    public TypeLambda lookupTypeLambda(String name2) {
        TypeLambda tl = super.lookupTypeLambda(name2);
        return tl == null ? this.m_signature.lookupTypeLambda(name2) : tl;
    }

    public void expandTypeAliases() {
        Iterator<Module> modules = this.m_modules.values().iterator();
        while (modules.hasNext()) {
            modules.next().expandTypeAliases();
        }
        for (AbstractDataTypeLambda adt : this.m_genericADTs.values()) {
            for (int i = 0; i < adt.m_constructors.length; ++i) {
                Binding[] parms = adt.m_constructors[i].m_parameters;
                for (int j = 0; j < parms.length; ++j) {
                    parms[j].m_type = parms[j].m_type.expandTypeAliases(this);
                }
            }
        }
        this.typeAliasesExpanded = true;
    }

    public boolean getStripInputTypeAnnotationsSpecified() {
        return this.m_stripInputTypeAnnotationsSpecified;
    }

    public void setStripInputTypeAnnotationsSpecified() {
        this.m_stripInputTypeAnnotationsSpecified = true;
    }

    public boolean getPreserveInputTypeAnnotationsSpecified() {
        return this.m_preserveInputTypeAnnotationsSpecified;
    }

    public void setPreserveInputTypeAnnotationsSpecified() {
        this.m_preserveInputTypeAnnotationsSpecified = true;
    }

    public Module cloneModule() {
        Module tmpModule = new Module(this.m_name, this.m_parent == null ? null : this.m_parent.cloneModule(), this.m_signature == null ? null : this.m_signature.cloneModule());
        Iterator<String> itr = this.m_functions.keySet().iterator();
        String key2 = null;
        while (itr.hasNext()) {
            key2 = itr.next();
            tmpModule.m_functions.put(key2, this.m_functions.get(key2).cloneFunction());
        }
        tmpModule.m_adtDefinitions = (ArrayList)this.m_adtDefinitions.clone();
        tmpModule.m_adts = (HashMap)this.m_adts.clone();
        tmpModule.m_compoundTypes = (HashMap)this.m_compoundTypes.clone();
        tmpModule.m_constructors = (HashMap)this.m_constructors.clone();
        tmpModule.m_moduleImportDirectives = (HashMap)this.m_moduleImportDirectives.clone();
        tmpModule.m_typeAliases = (HashMap)this.m_typeAliases.clone();
        tmpModule.m_genericADTs = (HashMap)this.m_genericADTs.clone();
        tmpModule.m_typeLambdas = (HashMap)this.m_typeLambdas.clone();
        return tmpModule;
    }
}

