/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.IObjectFilePersistence;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import java.io.IOException;
import java.io.Serializable;

public abstract class ModuleImportDirective
implements Serializable,
IObjectFilePersistence {
    protected String m_localName;
    protected ModuleSignature m_signature;
    private static final long serialVersionUID = 7739421991906694781L;

    protected ModuleImportDirective(String localName2, ModuleSignature ms) {
        this.m_localName = localName2;
        this.m_signature = ms;
    }

    protected ModuleImportDirective() {
    }

    public String getLocalName() {
        return this.m_localName;
    }

    public ModuleSignature getSignature() {
        return this.m_signature;
    }

    public static String translateFunctionName(String n2, ModuleImportDirective base2) {
        return ModuleImportDirective.translateFunctionName(n2, base2.getLocalName());
    }

    public static String translateFunctionName(String n2, Module base2) {
        return ModuleImportDirective.translateFunctionName(n2, base2.getName());
    }

    public static String translateFunctionName(String n2, String base2) {
        if (base2.length() == 0) {
            return n2;
        }
        return base2 + "$" + n2;
    }

    public abstract Instruction translateFunctionCall(ModuleFunctionCallInstruction var1, Module var2);

    public abstract void toString(PrettyPrinter var1, int var2);

    @Override
    public void read(ReadObjectFileHelper rofh) throws Exception {
        this.m_localName = rofh.readString();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeString(this.m_localName);
    }
}

