/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Functor;
import com.ibm.xltxe.rnm1.xylem.FunctorApplicationDirective;
import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.IdentityHashMap;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.TailRecursiveOptimizer;
import com.ibm.xltxe.rnm1.xylem.TopLevelModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.ClassType;
import com.ibm.xltxe.rnm1.xylem.types.CompoundType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class ModuleLinker {
    protected static void flattenADTs(Program p, ITypeStore ts, String base2, IdentityHashMap alreadyConverted) {
        CompoundType adt;
        Iterator i = ts.getAbstractDataTypesIterator();
        while (i.hasNext()) {
            adt = (AbstractDataType)i.next();
            if (alreadyConverted.containsKey(adt)) continue;
            alreadyConverted.put(adt, adt);
            p.addAbstractDataType((AbstractDataType)adt);
        }
        i = ts.getClassesIterator();
        while (i.hasNext()) {
            adt = (ClassType)i.next();
            if (alreadyConverted.containsKey(adt)) continue;
            alreadyConverted.put(adt, adt);
            for (ClassType.Method m : ((ClassType)adt).m_methods.values()) {
                m.setFunction(ModuleImportDirective.translateFunctionName(m.getFunction(), base2));
            }
            p.addClass((ClassType)adt);
        }
    }

    protected static void flattenModule(Program p, Module m, ArrayList functorApplications, HashSet functors, Collection functionsToAdd, IdentityHashMap alreadyConverted, final boolean flattened) {
        if (!flattened) {
            ModuleLinker.flattenADTs(p, m, m.getName(), alreadyConverted);
            ModuleLinker.flattenADTs(p, m.m_signature, m.getName(), alreadyConverted);
        }
        Iterator<Object> i = m.m_moduleDefinitions.iterator();
        while (i.hasNext()) {
            Module m2 = m.m_modules.get(i.next());
            ModuleLinker.flattenModule(p, m2, functorApplications, functors, functionsToAdd, alreadyConverted, false);
            i.remove();
        }
        for (Functor f2 : m.getFunctors()) {
            ModuleLinker.convertFunctor(p, f2);
        }
        for (ModuleImportDirective x : m.getModuleImportDirectives()) {
            if (x instanceof FunctorApplicationDirective) {
                FunctorApplicationDirective fad = (FunctorApplicationDirective)x;
                functorApplications.add(fad);
                functors.add(m.getFunctor(fad.m_functorName));
            } else if (x instanceof TopLevelModuleImportDirective) {
                ModuleLinker.flattenADTs(p, x.getSignature(), ((TopLevelModuleImportDirective)x).getModuleName(), alreadyConverted);
                continue;
            }
            ModuleLinker.flattenADTs(p, x.getSignature(), "", alreadyConverted);
        }
        m.getFunctors().clear();
        i = m.getFunctions().iterator();
        final IdentityHashMap convertedFCIs = new IdentityHashMap();
        while (i.hasNext()) {
            Function f3 = (Function)i.next();
            f3.m_name = ModuleImportDirective.translateFunctionName(f3.getName(), m);
            new TailRecursiveOptimizer(){
                Module m_m;

                @Override
                protected boolean ensureGoodTypes(Function f2) {
                    return true;
                }

                @Override
                public boolean doTypeCheck(Function f2) {
                    return true;
                }

                @Override
                protected Instruction optimizeStep2(Instruction n2) {
                    if (!flattened && n2 instanceof FunctionCallInstruction) {
                        if (convertedFCIs.containsKey(n2)) {
                            return n2;
                        }
                        FunctionCallInstruction fci = (FunctionCallInstruction)n2;
                        fci.setFunction(ModuleImportDirective.translateFunctionName(fci.getFunction(), this.m_m));
                        convertedFCIs.put(fci, fci);
                    } else if (n2 instanceof ModuleFunctionCallInstruction) {
                        ModuleFunctionCallInstruction mfci = (ModuleFunctionCallInstruction)n2;
                        ModuleImportDirective mid = this.m_m.getModuleImportDirective(mfci.getModule());
                        if (mid == null) {
                            throw new XylemError("ERR_SYSTEM", "module import not found for moulde '" + mfci.getModule() + "' in " + mfci);
                        }
                        Instruction i = mid.translateFunctionCall(mfci, this.m_m);
                        Instruction.propagateInfo(n2, i);
                        return i;
                    }
                    return n2;
                }

                Optimizer init(Module m) {
                    this.m_m = m;
                    return this;
                }
            }.init(m).optimizeFunction(f3);
            i.remove();
            functionsToAdd.add(f3);
        }
        m.m_moduleDefinitions.clear();
        m.m_functors.clear();
    }

    public static void flattenModules(Program p) {
        ModuleLinker.flattenModules(p, false);
    }

    public static void reflattenModules(Program p) {
        ModuleLinker.flattenModules(p, true);
    }

    private static void flattenModules(Program p, boolean flattened) {
        ArrayList functorApplications = new ArrayList();
        HashSet functors = new HashSet();
        ArrayList funcsToAdd = new ArrayList();
        IdentityHashMap alreadyFlattened = new IdentityHashMap();
        ModuleLinker.flattenModule(p, p, functorApplications, functors, funcsToAdd, alreadyFlattened, flattened);
        Iterator i = funcsToAdd.iterator();
        while (i.hasNext()) {
            p.addFunction((Function)i.next());
        }
        for (Functor f2 : functors) {
            ModuleSignature[] ms = f2.getParameters();
            String[] paramNames = f2.getParameterNames();
            HashSet<FunctorApplicationDirective> set2 = new HashSet<FunctorApplicationDirective>();
            for (FunctorApplicationDirective fad : functorApplications) {
                if (!fad.m_functorName.equals(f2.getName())) continue;
                set2.add(fad);
            }
            for (int j = 0; j < ms.length; ++j) {
                for (FunctionSignature fs : ms[j].m_functionSignatures.values()) {
                    Binding[] params = new Binding[fs.m_parameterTypes.length + 1];
                    Instruction[] args = new Instruction[fs.m_parameterTypes.length];
                    for (int m = 0; m < args.length; ++m) {
                        params[m] = new Binding((Object)("param" + m), fs.m_parameterTypes[m]);
                        args[m] = new IdentifierInstruction(params[m].getName());
                    }
                    params[fs.m_parameterTypes.length] = new Binding((Object)"__functorinstance__", IntType.s_intType);
                    String name2 = f2.getName() + "$functor$" + paramNames[j] + "$" + fs.getFunctionName();
                    Iterator l = set2.iterator();
                    int m = 0;
                    MatchInstruction.Match[] cases = new MatchInstruction.Match[set2.size()];
                    while (l.hasNext()) {
                        FunctorApplicationDirective fad = (FunctorApplicationDirective)l.next();
                        cases[m++] = new MatchInstruction.LiteralMatch(LiteralInstruction.integerLiteral(fad.m_index), new FunctionCallInstruction(fad.m_modulesToApply[j] + "$" + fs.getFunctionName(), args).cloneWithoutTypeInformation());
                    }
                    p.addFunction(new Function(name2, params, new MatchInstruction((Instruction)new IdentifierInstruction("__functorinstance__"), cases, null)));
                }
            }
        }
        i = p.getClassesIterator();
        while (i.hasNext()) {
            ClassType adt = (ClassType)i.next();
            for (ClassType.Method m : adt.m_methods.values()) {
                p.forceFunctionGeneration(p.getFunction(m.getFunction()));
            }
            p.addClass(adt);
        }
        p.clearTypeInformation(false);
    }

    protected static void convertFunctor(Program p, Functor functor) {
        Module m = functor.getBody();
        Iterator<Function> i = m.getFunctions().iterator();
        while (i.hasNext()) {
            Function f2 = i.next();
            f2.m_name = ModuleImportDirective.translateFunctionName(f2.getName(), m);
            Binding[] b = new Binding[f2.m_parameters.length + 1];
            System.arraycopy(f2.m_parameters, 0, b, 0, f2.m_parameters.length);
            b[f2.m_parameters.length] = new Binding((Object)"__functorinstance__", IntType.s_intType);
            f2.m_parameters = b;
            new TailRecursiveOptimizer(){
                Module m_m;

                @Override
                protected boolean ensureGoodTypes(Function f2) {
                    return true;
                }

                @Override
                public boolean doTypeCheck(Function f2) {
                    return true;
                }

                @Override
                protected Instruction optimizeStep2(Instruction n2) {
                    if (n2 instanceof FunctionCallInstruction) {
                        FunctionCallInstruction fci = (FunctionCallInstruction)n2;
                        Instruction[] parameters = new Instruction[fci.m_parameters.length + 1];
                        System.arraycopy(fci.m_parameters, 0, parameters, 0, fci.m_parameters.length);
                        parameters[fci.m_parameters.length] = new IdentifierInstruction("__functorinstance__");
                        return new FunctionCallInstruction(ModuleImportDirective.translateFunctionName(fci.getFunction(), this.m_m), parameters);
                    }
                    if (n2 instanceof ModuleFunctionCallInstruction) {
                        ModuleFunctionCallInstruction mfci = (ModuleFunctionCallInstruction)n2;
                        ModuleImportDirective mid = this.m_m.getModuleImportDirective(mfci.getModule());
                        return mid.translateFunctionCall(mfci, this.m_m);
                    }
                    return n2;
                }

                Optimizer init(Module m) {
                    this.m_m = m;
                    return this;
                }
            }.init(m).optimizeFunction(f2);
            p.addFunction(f2);
            i.remove();
        }
    }
}

