/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.AbstractTypeStore;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.IObjectFilePersistence;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.TopLevelModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ModuleSignature
extends AbstractTypeStore
implements Serializable,
IObjectFilePersistence {
    private static final long serialVersionUID = -497906467738812098L;
    public HashMap<String, FunctionSignature> m_functionSignatures = new HashMap();
    protected HashMap<String, ModuleImportDirective> m_moduleImportDirectives = new HashMap();

    public ModuleSignature(String name2) {
        this.m_name = name2;
    }

    public ModuleSignature() {
    }

    public void addModuleImportDirective(ModuleImportDirective mid) {
        this.m_moduleImportDirectives.put(mid.getLocalName(), mid);
    }

    public ModuleSignature getModuleSignature(String name2) {
        ModuleImportDirective mid = this.m_moduleImportDirectives.get(name2);
        if (mid == null) {
            for (ModuleImportDirective dir : this.m_moduleImportDirectives.values()) {
                ModuleSignature sig = dir.getSignature();
                ModuleSignature indirect = sig.getModuleSignature(name2);
                if (indirect == null) continue;
                return indirect;
            }
            return null;
        }
        return mid.getSignature();
    }

    public void addFunctionSignature(FunctionSignature fs) {
        this.m_functionSignatures.put(fs.getFunctionName(), fs);
    }

    public void removeFunctionSignature(String name2) {
        this.m_functionSignatures.remove(name2);
    }

    public boolean containsFunction(String name2) {
        return this.m_functionSignatures.containsKey(name2);
    }

    public FunctionSignature getFunctionSignature(String name2) {
        return this.m_functionSignatures.get(name2);
    }

    public Map<String, FunctionSignature> getFunctionSignatureMap() {
        return this.m_functionSignatures;
    }

    public String prettyPrint() {
        return this.m_name;
    }

    public void toString(PrettyPrinter pp, int level) {
        pp.printFormOpen("module-signature", level + 0);
        pp.printToken(this.m_name, level);
        Iterator i = this.getAbstractDataTypesIterator();
        while (i.hasNext()) {
            AbstractDataType adt = (AbstractDataType)i.next();
            pp.printFormOpen("declare-datatype", level + 1);
            pp.printToken(adt.getName(), level + 1);
            pp.printFormClose(level + 1);
        }
        i = this.getAbstractDataTypesIterator();
        while (i.hasNext()) {
            ((AbstractDataType)i.next()).toString(pp, level + 1);
        }
        for (FunctionSignature fs : this.m_functionSignatures.values()) {
            fs.toString(pp, 1);
        }
        pp.printFormClose(level + 0);
    }

    public void write(ObjectOutput oo) throws IOException {
        this.write(new WriteObjectFileHelper(this, oo));
    }

    public void read(ObjectInput oi, ModuleSignatureStore mss) throws Exception {
        this.read(new ReadObjectFileHelper(this, oi, mss));
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeString(this.m_name);
        wofh.writeInt(this.m_moduleImportDirectives.size());
        for (ModuleImportDirective mid : this.m_moduleImportDirectives.values()) {
            mid.write(wofh);
        }
        ModuleSignature.writeTypes(this, wofh);
        Collection<FunctionSignature> functions = this.m_functionSignatures.values();
        wofh.writeInt(functions.size());
        for (FunctionSignature f2 : functions) {
            f2.write(wofh);
        }
    }

    @Override
    public void read(ReadObjectFileHelper rofh) throws Exception {
        this.m_name = rofh.readString();
        int numdirs = rofh.readInt();
        for (int i = 0; i < numdirs; ++i) {
            TopLevelModuleImportDirective tlmid = new TopLevelModuleImportDirective();
            tlmid.read(rofh);
            this.addModuleImportDirective(tlmid);
        }
        ModuleSignature.readTypes(this, rofh);
        int c = rofh.readInt();
        for (int i = 0; i < c; ++i) {
            FunctionSignature fs = new FunctionSignature();
            fs.read(rofh);
            this.addFunctionSignature(fs);
        }
    }

    public String toString() {
        PrettyPrinter pw = new PrettyPrinter();
        this.toString(pw, 0);
        return pw.toString();
    }

    public ModuleSignature cloneModule() {
        ModuleSignature tmpMS = new ModuleSignature(this.m_name);
        tmpMS.m_adtDefinitions = (ArrayList)this.m_adtDefinitions.clone();
        tmpMS.m_adts = (HashMap)this.m_adts.clone();
        tmpMS.m_compoundTypes = (HashMap)this.m_compoundTypes.clone();
        tmpMS.m_constructors = (HashMap)this.m_constructors.clone();
        tmpMS.m_functionSignatures = (HashMap)this.m_functionSignatures.clone();
        return tmpMS;
    }
}

