/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.parser.SourceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ModuleSignatureStore {
    protected HashMap<String, ModuleSignature> m_cache = new HashMap();
    protected SourceResolver m_sourceResolver;
    protected List<URL> m_searchPath;

    public ModuleSignatureStore(List<URL> searchPath) {
        this.m_searchPath = searchPath;
    }

    public void registerModuleSignature(String name2, ModuleSignature ms) {
        this.m_cache.put(name2, ms);
    }

    public ModuleSignature lookupModuleSignature(String name2) {
        return this.m_cache.get(name2);
    }

    public static final String makeFilename(String name2) {
        return name2.replace('-', '_').replace('/', '_').replace(':', '_').replace('.', '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleSignature resolveModuleSignature(String name2) throws Exception {
        boolean first = true;
        ModuleSignature ms = this.lookupModuleSignature(name2);
        while (ms == null) {
            if (!first) {
                return null;
            }
            first = false;
            InputStream is2 = null;
            URL cxiURL = null;
            Iterator<URL> i = this.m_searchPath.iterator();
            while (is2 == null && i.hasNext()) {
                URL base2 = i.next();
                cxiURL = new URL(base2, ModuleSignatureStore.makeFilename(name2) + ".cxi");
                try {
                    URLConnection urlc = cxiURL.openConnection();
                    urlc.connect();
                    is2 = urlc.getInputStream();
                }
                catch (Exception e) {}
            }
            if (is2 == null) continue;
            try {
                ObjectInputStream ois = new ObjectInputStream(is2);
                ms = new ModuleSignature();
                ms.read(ois, this);
                this.m_cache.put(name2, ms);
                continue;
            }
            finally {
                try {
                    is2.close();
                }
                catch (IOException e1) {}
                continue;
            }
            break;
        }
        return ms;
    }

    public void clearCache() {
        this.m_cache.clear();
    }

    public String toString() {
        StringBuffer b = new StringBuffer("(ModuleSignatureStore \n");
        for (String k : this.m_cache.keySet()) {
            ModuleSignature ms = this.lookupModuleSignature(k);
            b.append(" (cached ");
            b.append(k);
            b.append(' ');
            b.append(ms);
            b.append(")\n");
        }
        Iterator<URL> i2 = this.m_searchPath.iterator();
        while (i2.hasNext()) {
            String k = i2.next().toString();
            b.append(" (search ");
            b.append(k);
            b.append(")\n");
        }
        b.append(")\n");
        return b.toString();
    }
}

