/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class NavigationUtilities {
    public static Instruction skipLets(Instruction n2) {
        while (n2 instanceof LetInstruction) {
            n2 = ((LetInstruction)n2).getBody();
        }
        return n2;
    }

    public static Instruction resolveReducedIdentifierAsMuchAsPossibleWithoutExceptions(Instruction n2, BindingEnvironment benv) {
        while (n2 instanceof IdentifierInstruction) {
            IdentifierInstruction ii = (IdentifierInstruction)n2;
            IBinding b = ii.getBinding(benv);
            if (b == null) {
                return ii;
            }
            if (b.getLet() != null) {
                Instruction x;
                n2 = x = b.getLet().getValue();
                if (x instanceof IdentifierInstruction) continue;
            }
            return n2;
        }
        return n2;
    }

    public static Instruction resolveIdentifierAliases(Instruction n2, BindingEnvironment benv) {
        while (n2 instanceof IdentifierInstruction) {
            IdentifierInstruction ii = (IdentifierInstruction)n2;
            IBinding b = ii.getBinding(benv);
            if (b == null) {
                throw new XylemError("ERR_SYSTEM", "binding not found! " + ii.getVariable());
            }
            if (b.getLet() != null) {
                Instruction x = b.getLet().getValue();
                if (x instanceof IdentifierInstruction) {
                    n2 = x;
                    continue;
                }
                if (x instanceof LiteralInstruction) {
                    return x;
                }
            }
            return ii;
        }
        return n2;
    }

    public static Instruction resolveReducedIdentifier(Instruction n2, BindingEnvironment benv) {
        if (n2 instanceof IdentifierInstruction) {
            IdentifierInstruction ii = (IdentifierInstruction)n2;
            IBinding b = ii.getBinding(benv);
            if (b == null) {
                throw new XylemError("ERR_SYSTEM", "binding not found! " + ii.getVariable());
            }
            if (b.getLet() != null) {
                Instruction x = b.getLet().getValue();
                return NavigationUtilities.resolveReducedIdentifier(x, benv);
            }
            return null;
        }
        return n2;
    }

    public static Set resolveFreeBindingsForReducedExpression(Instruction expr, Instruction letChain, BindingEnvironment benv) {
        return NavigationUtilities.resolveFreeBindingsForReducedExpression(expr, letChain, benv, null);
    }

    public static Set resolveFreeBindingsForReducedExpression(Instruction expr, Instruction letChain, BindingEnvironment benv, List bindingsUsed) {
        HashSet<IBinding> result2 = new HashSet<IBinding>();
        HashMap<IBinding, Instruction> letChainBindings = new HashMap<IBinding, Instruction>();
        HashSet exprFreeBindings = new HashSet();
        ArrayList<LetInstruction> letList = new ArrayList<LetInstruction>();
        OptimizerUtilities.skipLets(letChain, letList);
        for (LetInstruction li : letList) {
            letChainBindings.put(li.getBinding(), li.getValue());
        }
        LinkedList<Instruction> exprStack = new LinkedList<Instruction>();
        exprStack.add(expr);
        do {
            expr = (Instruction)exprStack.removeLast();
            exprFreeBindings.clear();
            expr.accumulateNonLiteralFreeBindings(exprFreeBindings, benv);
            for (IBinding b : exprFreeBindings) {
                Instruction n2 = (Instruction)letChainBindings.get(b);
                if (n2 == null) {
                    result2.add(b);
                    continue;
                }
                exprStack.add(n2);
                if (bindingsUsed == null) continue;
                bindingsUsed.add(b);
            }
        } while (!exprStack.isEmpty());
        return result2;
    }
}

