/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Optimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(Optimizer.class);
    private static final String s_className = Optimizer.class.getName();
    protected Function m_currentFunction = null;
    protected boolean m_skipStringStreams = true;
    protected boolean isTypeReparing = false;
    private boolean functionNeedsTypecheck = false;

    public boolean isFunctionNeedsTypecheck() {
        return this.functionNeedsTypecheck;
    }

    public void setFunctionNeedsTypecheck(boolean functionNeedsTypecheck) {
        this.functionNeedsTypecheck = functionNeedsTypecheck;
    }

    protected Instruction optimizeStep(Instruction n2) {
        return n2;
    }

    protected Instruction optimizeStep(Instruction n2, Instruction parent2, int parentIndex) {
        return this.optimizeStep(n2);
    }

    public Instruction optimize(Instruction n2) {
        Instruction n22 = this.optimizeStep(n2, null, -1);
        if (n22 == null) {
            return n2;
        }
        if (n22 != n2) {
            Type t;
            Type t2 = n22.getCachedType();
            if (t2 == null && (t = n2.getCachedType()) != null) {
                n22.setCachedType(t);
            }
            return n22;
        }
        this.optimizeChildren(n2);
        return n2;
    }

    public void optimizeFunction(Function f2) {
        Function outer = this.m_currentFunction;
        this.m_currentFunction = f2;
        try {
            f2.m_body = this.optimize(f2.getBody());
            if (this.isTypeReparing && (this.isFunctionNeedsTypecheck() || !f2.hasBeenTypeChecked() || f2.getBody().getCachedType() == null)) {
                this.doTypeCheck(f2);
            }
        }
        catch (StackOverflowError soe) {
            FFDCUtil.log(soe, this);
            try {
                String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Stack Overflow caught optimizing " + f2.getName()});
                s_logger.logp(Level.SEVERE, s_className, "optimizeFunction", message, soe);
                File trace2 = new File("stacktrace.txt");
                soe.printStackTrace(new PrintStream(new FileOutputStream(trace2)));
                s_logger.logrb(Level.INFO, s_className, "optimizeFunction", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "DUMPED_INFO_LOCATION", new Object[]{trace2.getCanonicalPath()});
                Program.dumpXylemFunctions(new Function[]{f2}, null, "stackoverflow");
                throw new Error(message);
            }
            catch (IOException ioe) {
                String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"I/O error"});
                s_logger.logp(Level.SEVERE, s_className, "optimizeFunction", message, ioe);
                throw new Error(message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FFDCUtil.log(e, this);
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{e.getClass().getName() + " encountered in " + this.getClass().getName() + " in function " + f2.getName()});
            s_logger.logp(Level.SEVERE, s_className, "optimizeFunction", message, e);
            throw new RuntimeException(message);
        }
        this.m_currentFunction = outer;
    }

    protected boolean ensureGoodTypes(Function f2) {
        return f2.ensureGoodTypes();
    }

    protected void optimizeChildren(Instruction n2) {
        if (this.m_skipStringStreams && n2 instanceof StreamInstruction && ((StreamInstruction)n2).isString()) {
            return;
        }
        ArrayList<OptimizationStep> stack = new ArrayList<OptimizationStep>();
        int count2 = n2.getChildInstructionCount();
        for (int i = count2 - 1; i >= 0; --i) {
            stack.add(new OptimizationStep(n2, n2.getChildInstruction(i), i));
        }
        while (!stack.isEmpty()) {
            int index2;
            int stackSize = stack.size() - 1;
            OptimizationStep tuple = (OptimizationStep)stack.remove(stackSize);
            Instruction parent2 = tuple.getParent();
            Instruction child2 = tuple.getCurrent();
            Instruction optimized = this.optimizeStep(child2, parent2, index2 = tuple.getPosition());
            if (optimized == null) continue;
            if (optimized != child2) {
                parent2.setChildInstruction(index2, optimized);
                child2.m_bindingEnvironment = null;
                this.setFunctionNeedsTypecheck(true);
                continue;
            }
            if (this.m_skipStringStreams && child2 instanceof StreamInstruction && ((StreamInstruction)child2).isString()) continue;
            int childCount = child2.getChildInstructionCount();
            stack.ensureCapacity(stackSize + childCount);
            for (int i = childCount - 1; i >= 0; --i) {
                stack.add(new OptimizationStep(child2, child2.getChildInstruction(i), i));
            }
        }
    }

    public Instruction doTypeCheck(Instruction toReplace, Instruction replacement, BindingEnvironment benv) {
        try {
            LinkedList<Function> functionStack = new LinkedList<Function>();
            functionStack.add(this.m_currentFunction);
            replacement.typeCheck(this.m_currentFunction.getTypeEnvironment(), benv, functionStack);
        }
        catch (TypeCheckException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return replacement;
    }

    public boolean doTypeCheck(Function called, Function f2) {
        Module m = called.getTypeEnvironment().getModule();
        boolean didTypecheck = this.doTypeCheck(m, f2);
        return didTypecheck;
    }

    public boolean doTypeCheck(Function f2) {
        return this.doTypeCheck(this.getCurrentModule(), f2);
    }

    public boolean doTypeCheck(Module module, Function f2) {
        boolean didTypecheck;
        try {
            f2.clearTypeInformation();
            f2.typeCheck(module, null, new LinkedList<Function>());
            f2.typeCheckReduced(module, new LinkedList());
            module.cleanXMLStubs();
            this.setFunctionNeedsTypecheck(false);
            assert (f2.ensureGoodTypes());
            didTypecheck = true;
        }
        catch (TypeCheckException e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1);
        }
        return didTypecheck;
    }

    public Type resolveType(Instruction n2) {
        TypeEnvironment tenv = this.m_currentFunction.getTypeEnvironment();
        BindingEnvironment benv = n2.getBindingEnvironment();
        if (benv == null) {
            return n2.getType(tenv, this.m_currentFunction.getBindingEnvironment()).resolveType(tenv);
        }
        return n2.getCachedType().resolveType(tenv);
    }

    public Module getCurrentModule() {
        Module m = this.m_currentFunction.getModule();
        if (m == null) {
            m = this.m_currentFunction.getTypeEnvironment().getModule();
        }
        return m;
    }

    public Function getCurrentFunction() {
        return this.m_currentFunction;
    }

    static class OptimizationStep {
        private Instruction m_parent;
        private Instruction m_current;
        private int m_position;

        public OptimizationStep(Instruction parent2, Instruction current2, int pos) {
            this.m_parent = parent2;
            this.m_current = current2;
            this.m_position = pos;
        }

        public Instruction getParent() {
            return this.m_parent;
        }

        public Instruction getCurrent() {
            return this.m_current;
        }

        public int getPosition() {
            return this.m_position;
        }
    }
}

