/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.BaseDesugarer;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ParallelForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ProcessStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleMatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.UnionInjectInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.UnionMatchInstruction;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.types.UnionType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.LinkedList;

public class PolymorphicADTDesugarer
extends BaseDesugarer {
    public PolymorphicADTDesugarer(Module prog) {
        super(prog);
    }

    @Override
    public Type convertType(Type type2) {
        if (type2 == null) {
            throw new RuntimeException();
        }
        Type origType = type2;
        if (this.getCurrentFunction() != null) {
            type2 = type2.resolveType(this.getCurrentFunction().getTypeEnvironment());
        }
        if (type2 instanceof TupleType) {
            TupleType tt = (TupleType)type2;
            Type[] originalTypes = tt.getElementTypes();
            Type[] newTypes = new Type[originalTypes.length];
            for (int i = 0; i < newTypes.length; ++i) {
                newTypes[i] = this.convertType(originalTypes[i]);
            }
            return PolymorphicADTDesugarer.generateType(this.m_prog, newTypes, "tuple");
        }
        if (type2 instanceof UnionType) {
            UnionType ut = (UnionType)type2;
            Type[] originalTypes = ut.getElementTypes();
            Type[] newTypes = new Type[originalTypes.length];
            for (int i = 0; i < newTypes.length; ++i) {
                newTypes[i] = this.convertType(originalTypes[i]);
            }
            return PolymorphicADTDesugarer.generateUnionType(this.m_prog, newTypes, "union");
        }
        return super.convertType(origType);
    }

    @Override
    public Instruction optimizeStep2(Instruction n2) {
        if (n2 instanceof TupleInstruction) {
            TupleInstruction ti = (TupleInstruction)n2;
            AbstractDataType adt = ((NamedType)this.convertType(this.resolveType(ti))).resolveNameToADT(this.getCurrentFunction().getTypeEnvironment());
            n2 = new ConstructorInstantiationInstruction(adt.getName(), ti.m_parameters);
            n2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList<Function>());
        } else if (n2 instanceof TupleMatchInstruction) {
            TupleMatchInstruction tmi = (TupleMatchInstruction)n2;
            Instruction toMatch = tmi.getToMatch();
            AbstractDataType adt = ((NamedType)this.convertType(this.resolveType(toMatch))).resolveNameToADT(this.getCurrentFunction().getTypeEnvironment());
            MatchInstruction.DeconstructionMatch dm = new MatchInstruction.DeconstructionMatch(adt.m_constructors[0], tmi.getVariableNames(), (Instruction)LiteralInstruction.booleanFalseLiteral());
            n2 = new MatchInstruction(toMatch, new MatchInstruction.Match[]{dm}, null);
            n2.setSourceFilename(tmi.getSourceFilename());
            n2.setSourceLineNumber(tmi.getSourceLineNumber());
            n2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList<Function>());
            dm.setHandler(tmi.getBody());
            n2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList<Function>());
        } else if (n2 instanceof UnionInjectInstruction) {
            UnionInjectInstruction uii = (UnionInjectInstruction)n2;
            AbstractDataType adt = ((NamedType)this.convertType(this.resolveType(uii))).resolveNameToADT(this.getCurrentFunction().getTypeEnvironment());
            AbstractDataType.Constructor ctor = adt.getConstructor(uii.getIndex());
            n2 = new ConstructorInstantiationInstruction(ctor, new Instruction[]{uii.getOperand()});
        } else if (n2 instanceof UnionMatchInstruction) {
            int i;
            UnionMatchInstruction umi = (UnionMatchInstruction)n2;
            Instruction toMatch = umi.getToMatch();
            AbstractDataType adt = ((NamedType)this.convertType(this.resolveType(toMatch))).resolveNameToADT(this.getCurrentFunction().getTypeEnvironment());
            boolean[] used = new boolean[adt.getConstructorCount()];
            MatchInstruction.Match[] dm = new MatchInstruction.DeconstructionMatch[umi.getChildInstructionCount() - 1];
            for (i = 0; i < dm.length; ++i) {
                IBinding[] b = umi.getChildInstructionBindings(i + 1);
                Type t = this.convertType(b[0].getBindingType());
                AbstractDataType.Constructor ctor = null;
                for (int j = 0; j < used.length; ++j) {
                    if (used[j] || !t.equals(adt.getConstructor(j).getParameterTypes()[0])) continue;
                    ctor = adt.getConstructor(j);
                    used[j] = true;
                    break;
                }
                if (ctor == null) {
                    new XylemError("ERR_SYSTEM", "UnionMatchInstruction has a type not in a UnionType: " + b[0].getBindingType().prettyPrint());
                }
                dm[i] = new MatchInstruction.DeconstructionMatch(ctor, new Object[]{b[0].getName()}, (Instruction)LiteralInstruction.booleanFalseLiteral());
            }
            n2 = new MatchInstruction(toMatch, dm, null);
            n2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList<Function>());
            for (i = 0; i < dm.length; ++i) {
                dm[i].setHandler(umi.getChildInstruction(i + 1));
            }
            n2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList<Function>());
        } else if (n2 instanceof ProcessStreamInstruction) {
            ProcessStreamInstruction psi = (ProcessStreamInstruction)n2;
            psi.setStateADTType(this.convertType(this.resolveType(psi.getBody())));
            n2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList<Function>());
        } else if (n2 instanceof ParallelForEachInstruction) {
            ParallelForEachInstruction psi = (ParallelForEachInstruction)n2;
            psi.setBodyADTType(this.convertType(this.resolveType(psi.getBody())));
            n2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList<Function>());
        } else if (n2 instanceof MatchInstruction) {
            MatchInstruction mi = (MatchInstruction)n2;
            mi.desugarADTLambdas(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), this);
        } else if (n2 instanceof ConstructorInstantiationInstruction) {
            ConstructorInstantiationInstruction cii = (ConstructorInstantiationInstruction)n2;
            cii.desugarADTLambdas(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), this);
        } else {
            return super.optimizeStep2(n2);
        }
        return n2;
    }
}

