/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.dataflow.ForkInformation;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.xci.Cursor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;

public class PrettyPrinter {
    protected StringWriter m_sw;
    protected PrintWriter m_pw;
    protected int m_pos = 0;
    protected int m_lineWidth = 150;
    protected boolean m_lastIndent = false;
    protected boolean m_lastNewline = false;
    protected HashSet m_moduleSignatures = new HashSet();
    public static final boolean PRINTANNOTATIONS = HiddenOptions.optionValueIs("printAnnotations", "on");
    public static boolean printType = true;

    public PrettyPrinter() {
        this.m_sw = new StringWriter();
        this.m_pw = new PrintWriter(this.m_sw);
    }

    public PrettyPrinter(Writer w) {
        this.m_pw = new PrintWriter(w);
    }

    public void addModuleSignature(ModuleSignature ms) {
        this.m_moduleSignatures.add(ms);
    }

    public String dumpModuleSignatures() {
        this.m_pw.flush();
        this.m_sw = new StringWriter();
        this.m_pw = new PrintWriter(this.m_sw);
        for (ModuleSignature ms : this.m_moduleSignatures) {
            ms.toString(this, 0);
        }
        this.m_pw.flush();
        return this.m_sw.toString();
    }

    public void printIdentifier(IBinding binding, int indent) {
        String identString = PrettyPrinter.prettyPrintIdentifier(binding.getName());
        identString = this.getAnnotations(binding, identString);
        this.printToken(identString, indent);
    }

    public String getAnnotations(IBinding binding, String identString) {
        if (PRINTANNOTATIONS) {
            Cursor.Profile futureProfile;
            Cursor.Profile profile;
            ForkInformation forkInfo = binding.getForkInformation();
            if (forkInfo == null) {
                profile = Cursor.Profile.NONE;
                futureProfile = Cursor.Profile.NONE;
            } else {
                profile = forkInfo._profile;
                if (profile == null) {
                    profile = Cursor.Profile.NONE;
                }
                if ((futureProfile = forkInfo._profile) == null) {
                    futureProfile = Cursor.Profile.NONE;
                }
            }
            identString = identString + "%" + profile + "%" + futureProfile + "%" + binding.getVariableUse();
        }
        return identString;
    }

    public void printIdentifier(Object s, int indent) {
        this.printToken(PrettyPrinter.prettyPrintIdentifier(s), indent);
    }

    public void printAnnotatedIdentifier(Object s, int usecount, int indent) {
        this.printToken(PrettyPrinter.prettyPrintAnnotatedIdentifier(s, usecount), indent);
    }

    public static String prettyPrintIdentifier(Object s) {
        String result2 = s instanceof Number ? "#" + s : s.toString();
        return result2;
    }

    public static String prettyPrintAnnotatedIdentifier(Object s, int usecount) {
        return s instanceof Number ? "#" + s + "#(" + usecount + ")" : s.toString() + "#(" + usecount + ")";
    }

    public void printToken(String s, int indent) {
        if (s.length() + this.m_pos > this.m_lineWidth) {
            this.newline();
            this.indent(indent);
        } else if (!this.m_lastIndent && !s.equals(")")) {
            this.space();
        }
        this.print(s);
    }

    public void printToken(int n2, int indent) {
        String s = Integer.toString(n2);
        if (s.length() + this.m_pos > this.m_lineWidth) {
            this.newline();
            this.indent(indent);
        } else if (!this.m_lastIndent && !s.equals(")")) {
            this.space();
        }
        this.print(s);
    }

    public void indent(int n2) {
        if (!this.m_lastNewline) {
            this.newline();
        }
        for (int i = 0; i < n2; ++i) {
            this.m_pw.print("  ");
        }
        this.m_pos += 2 * n2;
        this.m_lastIndent = true;
    }

    public void print(Object s) {
        this.print(s.toString());
    }

    public void print(String s) {
        this.m_lastIndent = false;
        this.m_lastNewline = false;
        this.m_pos += s == null ? 0 : s.length();
        this.m_pw.print(s);
    }

    public void printlnFormOpen(String formName, int indent) {
        this.printFormOpen(formName, indent);
        this.newline();
    }

    public void printlnFormOpen(String formName, int indent, Type type2) {
        this.printFormOpen(formName, indent, type2);
        this.newline();
    }

    public void printFormOpenIdentifier(Object formName, int indent) {
        this.printFormOpen(formName == null ? "!null!" : (formName instanceof Number ? "#" + formName : formName.toString()), indent);
    }

    public void printFormOpenIdentifier(IBinding binding, int indent) {
        Object formName = binding.getName();
        String formString = formName == null ? "!null!" : (formName instanceof Number ? "#" + formName : formName.toString());
        formString = this.getAnnotations(binding, formString);
        this.printFormOpen(formString, indent);
    }

    public void printFormOpen(String formName, int indent, Type type2) {
        this.indent(indent);
        this.print("(");
        this.print(formName);
        if (type2 != null && printType) {
            this.print("@");
            this.print(type2.prettyPrint());
        }
    }

    public void printFormOpen(String formName, int indent) {
        this.indent(indent);
        this.print("(");
        this.print(formName);
    }

    public void printFormClose(int indent) {
        this.printToken(")", indent);
    }

    public void println(String s) {
        this.m_pw.println(s);
        this.m_pos = 0;
        this.m_lastIndent = false;
    }

    public void space() {
        this.m_pw.print(' ');
        ++this.m_pos;
        this.m_lastIndent = false;
        this.m_lastNewline = false;
    }

    public void newline() {
        this.m_pw.println();
        this.m_pos = 0;
        this.m_lastIndent = false;
        this.m_lastNewline = true;
    }

    public String toString() {
        this.m_pw.flush();
        return this.m_sw.toString();
    }

    public void close() {
        this.m_pw.close();
    }

    public void flush() {
        this.m_pw.flush();
    }

    public void comment(String comment2, int indent) {
        this.newline();
        this.indent(indent);
        this.println(comment2);
    }

    public void print(ModuleSignature ms) {
        if (ms == null) {
            this.println("!NULL-SIG!:");
        } else {
            this.m_moduleSignatures.add(ms);
            this.print(ms.prettyPrint());
        }
    }

    public void printComment(String cc, int indent) {
        cc = cc.replace('\r', ' ');
        int i = 0;
        while (i < cc.length()) {
            int j = cc.indexOf(10, i);
            if (j < 0) {
                j = cc.length();
            }
            this.println("");
            this.printToken(";; " + cc.substring(i, j), indent);
            i = j + 1;
        }
    }
}

