/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.fcg.bcel.FcgClassGenBCEL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleLinker;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ConventionalFunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.FunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.MixedModeFunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.commandline.SearchPathSourceResolver;
import com.ibm.xltxe.rnm1.xylem.optimizers.SplitFunctions;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xltxe.rnm1.xylem.parser.ParserException;
import com.ibm.xltxe.rnm1.xylem.parser.ParserSource;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.ClassType;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Program
extends Module {
    private static final long serialVersionUID = 6499428922689211647L;
    protected HashSet m_baseParameters = new HashSet();
    protected String m_generatedBaseClass = null;
    protected String m_className = "";
    private static final Logger s_logger = LoggerUtil.getLogger(Program.class);
    private static final String s_className = Program.class.getName();
    public static final boolean TIMESTAMPED_DUMPS = HiddenOptions.wasSpecified("timestamped-dumps");

    public Program(ModuleSignature ms) {
        super(ms.getName(), null, ms);
    }

    public Program() {
    }

    protected void generateRequiredFunctions(FcgCodeGenHelper cgh) {
        CodeGenerationOptimizationStyle[] cgos = cgh.getSettings().getCodeGenOptimizationStyles();
        Iterator<Function> i = this.exportedFunctionsIterator();
        block2: while (i.hasNext()) {
            Function f2 = i.next();
            if (f2.m_isClassMethod) continue;
            Type[] types2 = new Type[f2.m_parameters.length];
            for (int j = 0; j < types2.length; ++j) {
                types2[j] = f2.m_parameters[j].getBindingType();
            }
            TypeEnvironment tenv = f2.getTypeEnvironment();
            Type returnType = f2.getReturnType().resolveType(tenv);
            cgh.requestFunctionGeneration(new ConventionalFunctionGenerationStyle(f2));
            if (cgh.getSettings().isMixedModeModuleCompilation()) {
                cgh.requestFunctionGeneration(new MixedModeFunctionGenerationStyle(f2));
            }
            try {
                BindingEnvironment benv = f2.getBindingEnvironment();
                Instruction body = f2.getBody();
                for (int styleIdx = 0; styleIdx < cgos.length; ++styleIdx) {
                    CodeGenerationOptimizationStyle genStyle = cgos[styleIdx];
                    FunctionGenerationStyle fgs = genStyle.getSupportedFunctionGenerationStyle(f2);
                    if (fgs == null) continue;
                    cgh.requestFunctionGeneration(fgs);
                    continue block2;
                }
            }
            catch (Exception e) {
                FFDCUtil.log(e, this);
                String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"could not codegen for '" + f2.getName() + "' "});
                s_logger.logp(Level.WARNING, s_className, "generateRequiredFunctions", message, e);
            }
        }
    }

    public void setGeneratedBaseClass(String baseClass) {
        this.m_generatedBaseClass = baseClass;
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    @Override
    protected String innerToString() {
        return "program";
    }

    public static final void dumpXylemFile(Module prog, File dir, String className, String extraDescription, boolean doParseValidation) {
        Program.dumpXylemFile(prog, dir, className + "-" + extraDescription, doParseValidation);
    }

    public static final void dumpXylemFile(Module prog, File dir, String className, String extraDescription) {
        Program.dumpXylemFile(prog, dir, className + "-" + extraDescription);
    }

    public static final void dumpXylemFile(Module prog, URL file, String extraDescription, boolean NOTUSED) {
        File dir = new File(file.getPath());
        String name2 = dir.getName();
        name2 = name2.substring(0, name2.lastIndexOf(".cxo"));
        dir = dir.getParentFile();
        Program.dumpXylemFile(prog, dir, name2 + "-" + extraDescription);
    }

    public static final void dumpXylemFile(Module prog, File dir, String className) {
        Program.dumpXylemFile(prog, dir, className, false);
    }

    public static final void dumpXylemFile(Module prog, File dir, String className, boolean doParseValidation) {
        try {
            dir = dir.getAbsoluteFile();
            File xylemfile = new File(dir, className + (TIMESTAMPED_DUMPS ? "." + System.currentTimeMillis() : "") + ".xylem");
            File parent2 = xylemfile.getParentFile();
            if (!parent2.exists()) {
                parent2.mkdirs();
            }
            FileWriter xw = new FileWriter(xylemfile);
            PrintWriter xylem_writer = new PrintWriter(xw);
            xylem_writer.println(";;;; Xylem code; roughly follows -*- Scheme -*- syntax.");
            prog.dump(xylem_writer);
            xylem_writer.close();
            if (doParseValidation) {
                try {
                    if (prog instanceof Program) {
                        FileReader inputReader = new FileReader(xylemfile);
                        PushbackReader pbreader = new PushbackReader(inputReader);
                        ParserSource parserSource = new ParserSource(pbreader);
                        SearchPathSourceResolver sourceResolver = new SearchPathSourceResolver(null);
                        Parser parser = new Parser(sourceResolver, parserSource);
                        Program.invokeTXEMethod(parser, "com.ibm.xltxe.rnm1.xtq.xslt.xylem.parser.TypeHandler", "registerTypes");
                        Program.invokeTXEMethod(parser, "com.ibm.xltxe.rnm1.xtq.xslt.xylem.parser.FormHandler", "registerForms");
                        Program program = parser.parseProgram();
                        program.exportAllFunctions();
                        program.typeCheck(false);
                        program.typeCheckReduced();
                        System.out.println("PrettyPrint/Parse round-trip successful: " + xylemfile.getName());
                    }
                }
                catch (ParserException e) {
                    System.out.println("ParserException on prettyPrint/parse round trip!!");
                    System.out.println(e.getMessage());
                }
                catch (TypeCheckException e) {
                    System.out.println("TypeCheckException on prettyPrint/parse round trip!!");
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                }
            }
            s_logger.logrb(Level.INFO, s_className, "dumpXylemFile " + className, "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "DUMPED_INFO_LOCATION", new Object[]{xylemfile.getCanonicalPath()});
        }
        catch (IOException e2) {
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"I/O error"});
            s_logger.logp(Level.WARNING, s_className, "dumpXylemFile", message, e2);
        }
    }

    private static void invokeTXEMethod(Parser parser, String className, String methodName) {
        try {
            Class<?> clazz = Class.forName(className);
            Method registerFormsMeth = clazz.getMethod(methodName, Parser.class);
            registerFormsMeth.invoke(clazz.newInstance(), parser);
        }
        catch (ClassNotFoundException e) {
            System.out.println("WARNING: " + className + " not registered: " + e.getMessage());
        }
        catch (SecurityException e) {
            System.out.println("WARNING: " + className + " not registered: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            System.out.println("WARNING: " + className + " not registered: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.out.println("WARNING: " + className + " not registered: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            System.out.println("WARNING: " + className + " not registered: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            System.out.println("WARNING: " + className + " not registered: " + e.getMessage());
        }
        catch (InstantiationException e) {
            System.out.println("WARNING: " + className + " not registered: " + e.getMessage());
        }
    }

    public void generateCode(FcgCodeGenHelper cgh, SessionContext session) throws IOException {
        ArrayList adtsInOrder = new ArrayList(this.m_adts.values());
        Collections.sort(adtsInOrder, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((AbstractDataType)arg0).getName().compareTo(((AbstractDataType)arg1).getName());
            }
        });
        ArrayList classesInOrder = new ArrayList(this.m_classes.values());
        Collections.sort(classesInOrder, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((ClassType)arg0).getName().compareTo(((ClassType)arg1).getName());
            }
        });
        this.generateRequiredFunctions(cgh);
        HashSet<String> doneFIs = new HashSet<String>();
        HashMap map2 = new HashMap(63);
        block8: while (!cgh.functionGenerationRequestsIsEmpty()) {
            Iterator i = cgh.functionGenerationRequestsIterator();
            FunctionGenerationStyle fgs = (FunctionGenerationStyle)i.next();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "generateCode", "generating f=" + fgs.getSignature() + " using fgs=" + fgs.getClass());
            }
            i.remove();
            if (doneFIs.contains(fgs.getSignature())) continue;
            doneFIs.add(fgs.getSignature());
            Function f2 = fgs.getFunction();
            while (true) {
                CodeGenerationSettings cgs;
                cgh.startFunction(fgs);
                if (!map2.isEmpty()) {
                    map2 = new HashMap(63);
                }
                CodeGenerationTracker cgt = new CodeGenerationTracker(map2, f2, cgh.getSettings().getCodeGenOptimizationStyles(), session);
                try {
                    fgs.generateFunction(cgh, cgt);
                    continue block8;
                }
                catch (FcgClassGenBCEL.FcgMethodSizeException e) {
                    cgs = cgh.getSettings();
                    if (cgs.getBCELAutoSplitFunctions()) {
                        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                            s_logger.logp(Level.FINE, s_className, "generateCode", "Automatically splitting function " + f2.getName() + " with bcel size " + e.size);
                        }
                        cgh.setAutosplitterInvoked(true);
                        new SplitFunctions((Module)this, cgs.getOrderSafeSplit()).splitOnce(f2);
                        try {
                            this.reTypeReduceRoundTrip("post-split typecheck", true);
                        }
                        catch (TypeCheckException e1) {
                            throw new RuntimeException(e1);
                        }
                        assert (this.ensureGoodTypes());
                        continue;
                    }
                    throw e;
                }
                catch (ClassGenException cge) {
                    cgs = cgh.getSettings();
                    if (cgs.getBCELAutoSplitFunctions()) {
                        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                            s_logger.logp(Level.FINE, s_className, "generateCode", "Automatically splitting function " + f2.getName() + " due to bcel error " + cge);
                        }
                        cgh.setAutosplitterInvoked(true);
                        new SplitFunctions((Module)this, cgs.getOrderSafeSplit()).splitOnce(f2);
                        try {
                            this.reTypeReduceRoundTrip("post-split typecheck", true);
                        }
                        catch (TypeCheckException e1) {
                            throw new RuntimeException(e1);
                        }
                        assert (this.ensureGoodTypes());
                        continue;
                    }
                    throw cge;
                }
                catch (FcgClassGenBCEL.FcgConstantPoolSizeException e) {
                    cgs = cgh.getSettings();
                    if (cgs.getBCELAutoSplitFunctions()) {
                        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                            s_logger.logp(Level.FINE, s_className, "generateCode", "Creating a new partition ");
                        }
                        cgh.setAutosplitterInvoked(true);
                        cgh.generateCTorWithSessionContextParam(cgh.startFunctionGeneration());
                        cgh.completeClassGeneration(cgh.startFunctionGeneration());
                        cgh.startFunctionGenerationInNewPartition();
                        continue;
                    }
                    throw new RuntimeException(XylemMsg.createXylemMessage("ERR_SYSTEM", e.getMessage()));
                }
                break;
            }
        }
        for (AbstractDataType s : adtsInOrder) {
            s.generateCode(cgh);
        }
        cgh.generateLambdaTypes();
        cgh.finish();
    }

    public static final void dumpXylemFunctions(Function[] funcs, File dir, String className, String extraDescription) {
        Program.dumpXylemFunctions(funcs, dir, className + "-" + extraDescription);
    }

    public static final void dumpXylemFunctions(Function[] funcs, File dir, String className) {
        try {
            File xylemfile = new File(dir, className + ".xylem");
            FileWriter xw = new FileWriter(xylemfile);
            PrintWriter xylem_writer = new PrintWriter(xw);
            PrettyPrinter pp = new PrettyPrinter(xylem_writer);
            for (int i = 0; i < funcs.length; ++i) {
                funcs[i].toString(pp, 0);
            }
            xylem_writer.close();
            s_logger.logrb(Level.INFO, s_className, "dumpXylemFunctions", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "DUMPED_INFO_LOCATION", new Object[]{xylemfile.getCanonicalPath()});
        }
        catch (IOException e2) {
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"I/O error"});
            s_logger.logp(Level.SEVERE, s_className, "dumpXylemFunctions", message, e2);
        }
    }

    @Override
    protected void write(ObjectOutput out) throws IOException {
        WriteObjectFileHelper wofh = new WriteObjectFileHelper(this, out);
        wofh.writeString(this.m_name);
        this.m_signature.write(wofh);
        Program.writeTypes(this, wofh);
        wofh.writeInt(this.m_modules.size());
        for (Module m : this.m_modules.values()) {
            wofh.writeString(m.m_signature.getName());
            m.m_signature.write(wofh);
        }
        for (Module m : this.m_modules.values()) {
            Module.writeModule(out, m);
        }
        Collection<Function> functions = this.getFunctions();
        wofh.writeInt(functions.size());
        for (Function f2 : functions) {
            f2.write(wofh);
        }
        Collection typeAliases = this.getTypeAliases();
        wofh.writeInt(typeAliases.size());
        Iterator<Object> i = typeAliases.iterator();
        Set typeAliasNames = this.getTypeAliasNames();
        Iterator j = typeAliasNames.iterator();
        while (i.hasNext()) {
            String typeName = (String)j.next();
            wofh.writeString(typeName);
            Type f3 = (Type)i.next();
            wofh.writeType(f3);
        }
    }

    @Override
    protected void read(ObjectInput in2, ModuleSignatureStore mss) throws Exception {
        int i;
        ReadObjectFileHelper rofh = new ReadObjectFileHelper(this, in2, mss);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "read", "reading program");
        }
        this.m_name = rofh.readString();
        this.m_signature = new ModuleSignature();
        this.m_signature.read(rofh);
        mss.registerModuleSignature(this.m_name, this.m_signature);
        Program.readTypes(this, rofh);
        int c = rofh.readInt();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "read", "reading " + c + " signatures");
        }
        for (i = 0; i < c; ++i) {
            ModuleSignature ms = new ModuleSignature();
            String name2 = rofh.readString();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "read", "reading " + name2 + " signature");
            }
            ms.read(rofh);
            mss.registerModuleSignature(name2, ms);
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "read", "reading " + c + " modules");
        }
        for (i = 0; i < c; ++i) {
            Module m = Module.readModule(in2, mss);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "read", "read " + m.getName() + " signature");
            }
            this.addModule(m);
        }
        c = rofh.readInt();
        for (i = 0; i < c; ++i) {
            Function f2 = new Function();
            f2.read(rofh);
            this.addFunction(f2);
        }
        c = rofh.readInt();
        for (int i2 = 0; i2 < c; ++i2) {
            String typeAliasName = rofh.readString();
            Type f3 = rofh.readType();
            this.addTypeAlias(typeAliasName, f3);
        }
        ModuleLinker.reflattenModules(this);
    }
}

