/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.ObjectFactory;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.ByteType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.DecimalType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.FloatType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.ShortType;
import com.ibm.xltxe.rnm1.xylem.types.SlotType;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.types.TypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.types.UnitType;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.HashMap;

public class ReadObjectFileHelper {
    protected ObjectInput m_in;
    protected ITypeStore m_typeStore;
    protected ModuleSignatureStore m_mss;
    private HashMap m_instructionClasses = new HashMap();

    public ReadObjectFileHelper(ITypeStore ts, ObjectInput in2, ModuleSignatureStore mss) {
        this.m_in = in2;
        this.m_typeStore = ts;
        this.m_mss = mss;
    }

    public String readString() throws IOException {
        return this.m_in.readUTF();
    }

    public Object readBindingName() throws Exception {
        switch (this.m_in.readByte()) {
            case 1: {
                return this.readString();
            }
            case 2: {
                return ReductionHelper.newIdentifier(this.m_in.readInt());
            }
        }
        return this.m_in.readObject();
    }

    public int readInt() throws IOException {
        return this.m_in.readInt();
    }

    public int readByte() throws IOException {
        return this.m_in.readByte();
    }

    public boolean readBoolean() throws IOException {
        return this.m_in.readBoolean();
    }

    public Instruction readInstruction(BindingEnvironment benv) throws Exception {
        String s = this.readString();
        Class c = (Class)this.m_instructionClasses.get(s);
        if (c == null) {
            c = ObjectFactory.findProviderClass(s, Module.class.getClassLoader(), true);
            this.m_instructionClasses.put(s, c);
        }
        Instruction n2 = (Instruction)c.newInstance();
        n2.read(this, benv);
        return n2;
    }

    public Type readType() throws Exception {
        byte n2 = this.m_in.readByte();
        switch (n2) {
            case 1: {
                return this.readType().getStreamType();
            }
            case 2: {
                return new SlotType(this.readType());
            }
            case 3: {
                int c = this.m_in.readInt();
                Type[] types2 = new Type[c];
                for (int i = 0; i < c; ++i) {
                    types2[i] = this.readType();
                }
                return new TupleType(types2);
            }
            case 4: {
                boolean isPure = this.readBoolean();
                Type ret = this.readType();
                int c = this.m_in.readInt();
                Type[] types3 = new Type[c];
                for (int i = 0; i < c; ++i) {
                    types3[i] = this.readType();
                }
                return new LambdaType(types3, ret, isPure);
            }
            case 5: {
                return IntType.s_intType;
            }
            case 6: {
                return ShortType.s_shortType;
            }
            case 7: {
                return LongType.s_longType;
            }
            case 8: {
                return FloatType.s_floatType;
            }
            case 9: {
                return DoubleType.s_doubleType;
            }
            case 10: {
                return CharType.s_charType;
            }
            case 11: {
                return ByteType.s_byteType;
            }
            case 12: {
                return BigIntegerType.s_bigIntegerType;
            }
            case 13: {
                return DecimalType.s_decimalType;
            }
            case 14: {
                return UnitType.s_unitType;
            }
            case 15: {
                return JavaObjectType.s_javaStringType;
            }
            case 16: {
                return (TypeVariable)this.m_in.readObject();
            }
            case 17: {
                String name2 = this.readString();
                String module = this.readBoolean() ? this.readString() : null;
                Type[] parms = this.readTypes();
                return new NamedType(name2, module, (Type[])(parms.length > 0 ? parms : null));
            }
            case 18: {
                String name3 = this.readString();
                return new JavaObjectType(name3);
            }
            case 19: {
                return (Type)this.m_in.readObject();
            }
        }
        throw new UnsupportedOperationException("" + n2);
    }

    public Binding[] readTypeSpecificBindingSet() throws Exception {
        return this.readTypeSpecificBindingSet(null);
    }

    public Binding[] readTypeSpecificBindingSet(ISpecialForm origin) throws Exception {
        int c2 = this.readInt();
        Binding[] bindings = new Binding[c2];
        for (int j = 0; j < c2; ++j) {
            bindings[j] = new Binding(this.readBindingName(), this.readType(), origin);
        }
        return bindings;
    }

    public Type[] readTypes() throws Exception {
        int c2 = this.readInt();
        Type[] bindings = new Type[c2];
        for (int j = 0; j < c2; ++j) {
            bindings[j] = this.readType();
        }
        return bindings;
    }

    public Object readObject() throws Exception {
        return this.m_in.readObject();
    }

    public Object[] readBindingNames() throws Exception {
        int c2 = this.readInt();
        Object[] bindings = new Object[c2];
        for (int j = 0; j < c2; ++j) {
            bindings[j] = this.readBindingName();
        }
        return bindings;
    }

    public void close() throws IOException {
        this.m_in.close();
        this.m_in = null;
    }

    public TypeLambda readTypeLambda() throws Exception {
        return (TypeLambda)this.m_in.readObject();
    }
}

