/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IdentityHashMap;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.HashMap;
import java.util.LinkedList;

public final class ReductionHelper {
    protected IdentityHashMap m_convertedBindings;
    protected HashMap m_subexpressions;
    protected HashMap m_postConversionSubexpressions;
    public TypeEnvironment m_typeEnvironment;
    public Type m_type;
    private static ThreadLocal tLocal = new ThreadLocal();

    public static Instruction oneTimeReduceAndTypeCheck(TypeEnvironment tenv, Instruction n2, LinkedList functionStack) {
        Instruction out = new ReductionHelper(tenv).reduce(n2, n2.getBindingEnvironment());
        try {
            out.typeCheck(tenv, n2.getBindingEnvironment(), functionStack);
        }
        catch (TypeCheckException e) {
            throw new XylemError("ERR_SYSTEM", "Should not happen--reduction should be type preserving");
        }
        return out;
    }

    public ReductionHelper(TypeEnvironment tenv) {
        this.m_convertedBindings = new IdentityHashMap();
        this.m_subexpressions = new HashMap(64);
        this.m_postConversionSubexpressions = new HashMap(64);
        this.m_typeEnvironment = tenv;
    }

    public IBinding lookupConvertedBinding(IBinding b) {
        if (b == null) {
            throw new RuntimeException();
        }
        IBinding n2 = (IBinding)this.m_convertedBindings.get(b);
        if (n2 != null) {
            return n2;
        }
        return b;
    }

    public void registerConvertedBinding(IBinding oldBinding, IBinding newBindingName) {
        if (newBindingName == null) {
            throw new RuntimeException();
        }
        this.m_convertedBindings.put(oldBinding, newBindingName);
    }

    public Object upgradeBinding(IBinding oldBinding) {
        Object varName = this.generateReducedIdentifier(oldBinding.getName());
        this.m_convertedBindings.put(oldBinding, oldBinding);
        oldBinding.setName(varName);
        return varName;
    }

    public Object generateReducedIdentifier(Object prefix0) {
        return ReductionHelper.generateIntermediateIdentifier2();
    }

    public static void resetIntermediateIdentifierCounter(int i) {
        Counter n2 = new Counter();
        n2.set(i);
        tLocal.set(n2);
    }

    public static int getIntermediateIdentifierCount() {
        Counter n2 = (Counter)tLocal.get();
        if (n2 == null) {
            return 0;
        }
        return n2.get();
    }

    public static Integer generateIntermediateIdentifier2() {
        Counter n2 = (Counter)tLocal.get();
        if (n2 == null) {
            n2 = new Counter();
            tLocal.set(n2);
        } else {
            n2.add();
        }
        return new Integer(n2.get());
    }

    public static Object newIdentifier(int i) {
        Counter n2 = (Counter)tLocal.get();
        if (n2 == null) {
            n2 = new Counter();
            tLocal.set(n2);
        }
        if (n2.get() < i) {
            n2.set(i);
        }
        return new Integer(i);
    }

    public IBinding lookupSubexpression(Instruction n2) {
        return (IBinding)this.m_subexpressions.get(n2);
    }

    public void registerSubexpression(IBinding b, Instruction n2, Instruction n22) {
        this.m_subexpressions.put(n2, b);
        this.m_postConversionSubexpressions.put(n22, b);
    }

    public Object clone() {
        return new ReductionHelper(this);
    }

    protected ReductionHelper(ReductionHelper rh) {
        this.m_convertedBindings = (IdentityHashMap)rh.m_convertedBindings.clone();
        this.m_subexpressions = (HashMap)rh.m_subexpressions.clone();
        this.m_postConversionSubexpressions = (HashMap)rh.m_postConversionSubexpressions.clone();
        this.m_typeEnvironment = rh.m_typeEnvironment;
        if (this.m_typeEnvironment == null) {
            throw new RuntimeException();
        }
    }

    public Instruction reduceToBasicInstruction(Instruction[] state, Instruction n2, BindingEnvironment benv) {
        if (n2 instanceof LiteralInstruction) {
            return n2;
        }
        IBinding b = this.reduceToIdentifier(state, n2, "", benv);
        IdentifierInstruction ii = new IdentifierInstruction(b.getName());
        ii.m_hasBeenTypechecked = true;
        if (b instanceof Instruction) {
            Type t = ((Instruction)((Object)b)).getCachedType();
            if (t != null) {
                ii.setCachedType(t);
            }
        } else {
            ii.setCachedType(b.getBindingType());
        }
        return ii;
    }

    public IBinding reduceToIdentifier(Instruction[] state, Instruction n2, Object prefix2, BindingEnvironment benv) {
        return this.reduceToIdentifier(state, n2, prefix2, benv, null);
    }

    public IBinding reduceToIdentifier(Instruction[] state, Instruction n2, Object prefix2, BindingEnvironment benv, LetInstruction letToReuse) {
        LetInstruction li;
        if (n2 instanceof IdentifierInstruction) {
            return this.lookupConvertedBinding(((IdentifierInstruction)n2).getBinding());
        }
        IBinding b0 = this.lookupSubexpression(n2);
        if (b0 != null) {
            return b0;
        }
        n2.generateReducedForm(this, state, benv);
        n2.m_hasBeenTypechecked = false;
        Instruction value2 = state[0];
        if (value2 instanceof IdentifierInstruction) {
            return benv.getVariableBinding(((IdentifierInstruction)value2).getVariable());
        }
        b0 = (IBinding)this.m_postConversionSubexpressions.get(value2);
        if (b0 != null) {
            return b0;
        }
        Object varName = this.generateReducedIdentifier(prefix2);
        if (letToReuse != null) {
            li = letToReuse;
            li.m_bindingEnvironment = null;
            li.getBinding().setName(varName);
            li.resetCachedValueType();
            benv.setVariableBinding(li.getBinding());
            li.setValue(value2);
            li.setBody(null);
        } else {
            li = new LetInstruction(varName, value2, null);
            IBinding binding = li.getBinding();
            benv.setVariableBinding(binding);
            if (this.m_type != null) {
                li.setCachedType(this.m_type);
            }
            li.m_hasBeenTypechecked = true;
        }
        if (state[2] != null) {
            ((LetInstruction)state[2]).setBody(li);
            Type t = li.getCachedType();
            if (t != null) {
                ((LetInstruction)state[2]).setCachedType(t);
            }
        } else {
            state[1] = li;
        }
        state[2] = li;
        this.registerSubexpression(li.getBinding(), n2, value2);
        return li.getBinding();
    }

    public Instruction reduce(Instruction n2, BindingEnvironment benv) {
        Instruction[] state = new Instruction[3];
        assert (n2.getCachedType() != null);
        this.m_type = n2.getCachedType();
        n2.generateReducedForm(this, state, benv);
        n2.m_hasBeenTypechecked = false;
        if (state[2] != null) {
            ((LetInstruction)state[2]).setBody(state[0]);
        } else {
            state[1] = state[0];
        }
        return state[1];
    }

    private static class Counter {
        private int num = 1;

        private Counter() {
        }

        public int get() {
            return this.num;
        }

        public void add() {
            ++this.num;
        }

        public void set(int i) {
            this.num = i;
        }
    }
}

