/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;

public class TopLevelModuleImportDirective
extends ModuleImportDirective {
    private static final long serialVersionUID = -7849431194450199173L;
    protected String m_moduleName;

    public TopLevelModuleImportDirective() {
    }

    public TopLevelModuleImportDirective(String localName2, ModuleSignature ms, String moduleName) {
        super(localName2, ms);
        this.m_moduleName = moduleName;
    }

    public String getModuleName() {
        return this.m_moduleName;
    }

    @Override
    public Instruction translateFunctionCall(ModuleFunctionCallInstruction mfci, Module context2) {
        return new FunctionCallInstruction(TopLevelModuleImportDirective.translateFunctionName(mfci.getFunction(), context2.getModuleImportDirective(mfci.getModule())), mfci.m_parameters);
    }

    @Override
    public void toString(PrettyPrinter pp, int level) {
        pp.printFormOpen("import-module", level);
        pp.print(" " + this.getLocalName());
        pp.print(this.m_signature);
        pp.printFormClose(level);
    }

    public void setSignature(ModuleSignature sig) {
        this.m_signature = sig;
    }

    @Override
    public void read(ReadObjectFileHelper rofh) throws Exception {
        super.read(rofh);
        this.m_moduleName = rofh.readString();
        this.m_signature = rofh.m_mss.resolveModuleSignature(this.m_moduleName);
        if (this.m_signature == null) {
            throw new XylemError("ERR_SYSTEM", " no sig for '" + this.m_moduleName + "'");
        }
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeString(this.m_moduleName);
    }
}

