/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.ILUBResolver;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.LUBConstraint;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.ForwardTypeReference;
import com.ibm.xltxe.rnm1.xylem.types.JavaArrayType;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class TypeEnvironment
implements Serializable {
    private static final long serialVersionUID = 6412426351623830994L;
    protected HashMap m_typeVariableAssignments;
    protected HashMap m_typeVariableEquivalenceClasses;
    public TypeEnvironment m_original;
    protected Module m_program;
    public Instruction m_parseInstruction;

    public String toString() {
        return this.m_typeVariableAssignments.toString();
    }

    public TypeEnvironment(Module program) {
        this.m_program = program;
        this.m_typeVariableAssignments = new HashMap(5, 10.0f);
        this.m_typeVariableEquivalenceClasses = new HashMap(5, 10.0f);
        this.m_original = this;
    }

    public Module getModule() {
        return this.m_program;
    }

    public Object clone() {
        TypeEnvironment tenv = new TypeEnvironment(this.m_program, this);
        return tenv;
    }

    public TypeEnvironment copy() {
        TypeEnvironment tenv = new TypeEnvironment(this.m_program);
        try {
            tenv.incorporate(this);
        }
        catch (TypeCheckException te) {
            throw new RuntimeException(te);
        }
        return tenv;
    }

    protected TypeEnvironment(Module p, TypeEnvironment toCopy) {
        this.m_original = toCopy.m_original;
        this.m_program = p;
        this.m_typeVariableAssignments = (HashMap)toCopy.m_typeVariableAssignments.clone();
        this.m_typeVariableEquivalenceClasses = (HashMap)toCopy.m_typeVariableEquivalenceClasses.clone();
    }

    public Type resolveTypeVariable(TypeVariable tv) {
        Type t = (Type)this.m_typeVariableAssignments.get(tv);
        if (t == null && this.m_original != this && this.m_original != null) {
            t = this.m_original.resolveTypeVariable(tv);
        }
        return t;
    }

    public boolean areTypeVariablesInSameEquivalenceClass(TypeVariable tv1, TypeVariable tv2) {
        Type t1 = (Type)this.m_typeVariableAssignments.get(tv1);
        Type t2 = (Type)this.m_typeVariableAssignments.get(tv2);
        if (t1 == null && t2 == null) {
            Set set1 = (Set)this.m_typeVariableEquivalenceClasses.get(tv1);
            Set set2 = (Set)this.m_typeVariableEquivalenceClasses.get(tv2);
            if (set1 == null || set2 == null) {
                return false;
            }
            return set1.contains(tv2);
        }
        return false;
    }

    protected final void markTypeVariablesAsEquivalent(TypeVariable tv1, TypeVariable tv2, Instruction errorBase) throws TypeCheckException {
        Type t1 = (Type)this.m_typeVariableAssignments.get(tv1);
        Type t2 = (Type)this.m_typeVariableAssignments.get(tv2);
        if (t1 == null && t2 == null) {
            HashSet<TypeVariable> set1 = (HashSet<TypeVariable>)this.m_typeVariableEquivalenceClasses.get(tv1);
            Set set2 = (Set)this.m_typeVariableEquivalenceClasses.get(tv2);
            if (set1 == null) {
                if (set2 == null) {
                    set1 = new HashSet<TypeVariable>();
                    set1.add(tv1);
                    set1.add(tv2);
                    this.m_typeVariableEquivalenceClasses.put(tv1, set1);
                    this.m_typeVariableEquivalenceClasses.put(tv2, set1);
                    return;
                }
                set2.add(tv1);
                this.m_typeVariableEquivalenceClasses.put(tv1, set2);
                return;
            }
            if (set2 == null) {
                set1.add(tv2);
                this.m_typeVariableEquivalenceClasses.put(tv2, set1);
                return;
            }
            set1.addAll(set2);
            Iterator i = set2.iterator();
            while (i.hasNext()) {
                this.m_typeVariableEquivalenceClasses.put(i.next(), set1);
            }
            return;
        }
        if (t1 != null && t2 != null) {
            this.unify(t1, t2, errorBase);
            return;
        }
        if (t1 == null && t2 != null) {
            Set set1 = (Set)this.m_typeVariableEquivalenceClasses.get(tv1);
            if (set1 == null) {
                this.assignTypeVariable(tv1, t2);
                return;
            }
            this.assignTypeToEquivalenceClass(set1, t2);
            return;
        }
        if (t1 != null && t2 == null) {
            Set set2 = (Set)this.m_typeVariableEquivalenceClasses.get(tv2);
            if (set2 == null) {
                this.assignTypeVariable(tv2, t1);
                return;
            }
            this.assignTypeToEquivalenceClass(set2, t1);
            return;
        }
    }

    protected final void assignTypeToEquivalenceClass(Set set2, Type t) {
        for (Object x : set2) {
            if (!(t instanceof StreamType) || ((StreamType)t).getElementType().equals(x)) {
                // empty if block
            }
            this.assignTypeVariable((TypeVariable)x, t);
            this.m_typeVariableEquivalenceClasses.remove(x);
        }
    }

    final void assignTypeVariable(TypeVariable tv, Type t) {
        if (TypeEnvironment.contains(t, tv)) {
            throw new XylemError("ERR_SYSTEM", "One type contains another: " + t + " contains " + tv);
        }
        this.m_typeVariableAssignments.put(tv, t);
    }

    static final boolean contains(Type t, TypeVariable tv) {
        if (t.equals(tv)) {
            return true;
        }
        int n2 = t.getChildTypeCount();
        for (int i = 0; i < n2; ++i) {
            if (!TypeEnvironment.contains(t.getChildType(i), tv)) continue;
            return true;
        }
        return false;
    }

    public boolean resolveLUBConstraints(Set lubConstraints, ILUBResolver lubr, boolean force) throws TypeCheckException {
        if (lubConstraints.isEmpty()) {
            return true;
        }
        HashSet x = new HashSet();
        x.addAll(lubConstraints);
        lubConstraints = x;
        Set tops = lubr.getTops();
        do {
            LUBConstraint lubc;
            int todo = lubConstraints.size();
            Iterator i = lubConstraints.iterator();
            while (i.hasNext()) {
                lubc = (LUBConstraint)i.next();
                HashSet unresolved = new HashSet();
                Type current2 = null;
                for (Object n2 : lubc.m_set) {
                    Type t = ((Type)n2).resolveType(this);
                    if (t != null) {
                        if (!tops.contains(current2 = current2 != null ? lubr.lub(current2, t) : t)) continue;
                        break;
                    }
                    Object o1 = this.m_typeVariableEquivalenceClasses.get(lubc.m_t);
                    Object o2 = this.m_typeVariableEquivalenceClasses.get(n2);
                    if (o1 != null && o2 != null && o1.equals(o2)) continue;
                    unresolved.add(n2);
                }
                if (current2 != null && (tops.contains(current2) || unresolved.isEmpty())) {
                    this.unify(lubc.m_t, current2, null);
                    i.remove();
                    continue;
                }
                lubc.m_set = unresolved;
                if (unresolved.isEmpty()) {
                    i.remove();
                    continue;
                }
                if (current2 == null) continue;
                unresolved.add(current2);
            }
            if (todo != lubConstraints.size() || todo <= 0) continue;
            if (force) {
                i = lubConstraints.iterator();
                while (i.hasNext()) {
                    lubc = (LUBConstraint)i.next();
                    if (lubc.m_t.resolveType(this) == null) {
                        this.unify(lubc.m_t, lubr.getDefaultTop(), null);
                    }
                    i.remove();
                }
                return true;
            }
            return false;
        } while (!lubConstraints.isEmpty());
        this.sanityCheck();
        return true;
    }

    public void unify(Type actualType, Type expectedType, Instruction errorBase) throws TypeCheckException {
        if (!this.unifyQuietly(actualType, expectedType, errorBase)) {
            StringBuilder problem = new StringBuilder();
            this.unifyQuietly(actualType, expectedType, errorBase, problem);
            throw new TypeCheckException(problem.toString(), errorBase);
        }
    }

    public boolean unifyQuietly(Type actualType, Type expectedType, Instruction errorBase) throws TypeCheckException {
        return this.unifyQuietly(actualType, expectedType, errorBase, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean unifyQuietly(Type actualType, Type expectedType, Instruction errorBase, StringBuilder error2) throws TypeCheckException {
        if (actualType == null || expectedType == null) {
            if (error2 == null) return false;
            error2.append(XylemMsg.createXylemMessage("ERR_SYSTEM", errorBase.getClass().getSimpleName() + " null-valued type in unification of '" + actualType + "','" + expectedType + "'"));
            return false;
        }
        if (actualType instanceof TypeVariable) {
            if (expectedType instanceof TypeVariable) {
                this.markTypeVariablesAsEquivalent((TypeVariable)actualType, (TypeVariable)expectedType, errorBase);
                return true;
            }
            Type ta1 = (Type)this.m_typeVariableAssignments.get(actualType);
            if (ta1 != null) {
                return this.unifyQuietly(ta1, expectedType, errorBase, error2);
            }
            Set set1 = (Set)this.m_typeVariableEquivalenceClasses.get(actualType);
            if (set1 == null) {
                this.assignTypeVariable((TypeVariable)actualType, expectedType);
                return true;
            }
            this.assignTypeToEquivalenceClass(set1, expectedType);
            return true;
        }
        if (expectedType instanceof TypeVariable) {
            Type ta2 = (Type)this.m_typeVariableAssignments.get(expectedType);
            if (ta2 != null) {
                return this.unifyQuietly(actualType, ta2, errorBase, error2);
            }
            Set set2 = (Set)this.m_typeVariableEquivalenceClasses.get(expectedType);
            if (set2 == null) {
                this.assignTypeVariable((TypeVariable)expectedType, actualType);
                return true;
            }
            this.assignTypeToEquivalenceClass(set2, actualType);
            return true;
        }
        if (actualType.getClass() == expectedType.getClass()) {
            return actualType.unifyQuietly(this, expectedType, errorBase, error2);
        }
        if (actualType.equals(expectedType)) return true;
        if (actualType instanceof ForwardTypeReference) {
            if (error2 == null) return false;
            error2.append(XylemMsg.createXylemMessage("ERR_SYSTEM", errorBase.getClass().getSimpleName() + " unresolved forward referenced type " + actualType + "."));
            return false;
        }
        if (expectedType instanceof ForwardTypeReference) {
            if (error2 == null) return false;
            error2.append(XylemMsg.createXylemMessage("ERR_SYSTEM", errorBase.getClass().getSimpleName() + " unresolved forward referenced type " + expectedType + "."));
            return false;
        }
        if (actualType instanceof JavaArrayType && expectedType instanceof JavaObjectType && ((JavaObjectType)expectedType).getClassName().equals("java.lang.Object")) {
            return true;
        }
        if (error2 == null) return false;
        String funcName = errorBase instanceof FunctionCallInstruction ? "(" + ((FunctionCallInstruction)errorBase).getFunction() + ")" : "";
        String lineNo = errorBase != null ? "(" + errorBase.getSourceLineNumber() + ")" : "";
        String instrName = errorBase != null ? errorBase.getClass().getSimpleName() : "";
        error2.append(XylemMsg.createXylemMessage("ERR_SYSTEM", "\n" + instrName + funcName + lineNo + " expected value of type " + expectedType.prettyPrint() + " but found type " + actualType.prettyPrint() + " instead"));
        return false;
    }

    protected void sanityCheck() {
    }

    public void redirectFrom(TypeEnvironment tenv) {
        this.m_typeVariableAssignments = tenv.m_typeVariableAssignments;
        this.m_typeVariableEquivalenceClasses = tenv.m_typeVariableEquivalenceClasses;
    }

    public void incorporate(TypeEnvironment tenv) throws TypeCheckException {
        if (tenv.m_typeVariableAssignments == this.m_typeVariableAssignments) {
            return;
        }
        for (Type t : tenv.m_typeVariableAssignments.keySet()) {
            Type t2 = (Type)tenv.m_typeVariableAssignments.get(t);
            this.unify(t, t2, null);
        }
        for (Set s : tenv.m_typeVariableEquivalenceClasses.values()) {
            Type t = null;
            for (Type t2 : s) {
                if (t == null) {
                    t = t2;
                    continue;
                }
                this.unify(t, t2, null);
            }
        }
    }
}

